/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.ActionUtils;
import org.openide.awt.Actions;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public class MaximizeWindowAction
extends AbstractAction {
    private final PropertyChangeListener propListener;
    private TopComponent topComponent;
    private boolean isPopup;

    public MaximizeWindowAction() {
        this.propListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String propName = evt.getPropertyName();
                if ("maximizedMode".equals(propName) || "editorAreaState".equals(evt.getPropertyName()) || "activeMode".equals(evt.getPropertyName())) {
                    MaximizeWindowAction.this.updateState();
                }
                if ("activated".equals(propName)) {
                    MaximizeWindowAction.this.updateState();
                }
            }
        };
        TopComponent.Registry registry = TopComponent.getRegistry();
        registry.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propListener, (Object)registry));
        WindowManagerImpl wm = WindowManagerImpl.getInstance();
        wm.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propListener, (Object)((Object)wm)));
        this.updateState();
    }

    public MaximizeWindowAction(TopComponent tc) {
        this.topComponent = tc;
        this.propListener = null;
        this.isPopup = true;
        this.updateState();
    }

    public void actionPerformed(ActionEvent ev) {
        TopComponent curTC;
        WindowManagerImpl wm = WindowManagerImpl.getInstance();
        if (wm.isDocked(curTC = this.getTCToWorkWith())) {
            ModeImpl mode = (ModeImpl)wm.findMode(curTC);
            String tcID = wm.findTopComponentID(curTC);
            if (mode.getKind() == 2) {
                wm.userToggledTopComponentSlideInMaximize(tcID);
            } else if (null != mode) {
                ModeImpl previousMax = wm.getCurrentMaximizedMode();
                if (null != previousMax) {
                    if (previousMax.getKind() == 1 && mode.getKind() == 0) {
                        wm.switchMaximizedMode(mode);
                    } else {
                        wm.switchMaximizedMode(null);
                    }
                } else {
                    wm.switchMaximizedMode(mode);
                }
            } else {
                wm.switchMaximizedMode(null);
            }
        } else {
            ModeImpl curMax = (ModeImpl)wm.findMode(curTC);
            if (curMax != null) {
                if (curMax.getFrameState() == 0) {
                    curMax.setFrameState(6);
                } else {
                    curMax.setFrameState(0);
                }
            }
        }
        this.updateState();
    }

    private void updateState() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doUpdateState();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MaximizeWindowAction.this.doUpdateState();
                }
            });
        }
    }

    private void doUpdateState() {
        boolean maximize;
        WindowManagerImpl wm = WindowManagerImpl.getInstance();
        TopComponent active = this.getTCToWorkWith();
        String param = active == null ? "" : active.getName();
        ModeImpl activeMode = (ModeImpl)wm.findMode(active);
        if (activeMode == null) {
            return;
        }
        if (wm.isDocked(active)) {
            maximize = wm.getCurrentMaximizedMode() != activeMode;
        } else {
            boolean bl = maximize = activeMode.getFrameState() == 0;
        }
        if (activeMode != null && activeMode.getKind() == 2) {
            maximize = null != active && !wm.isTopComponentMaximizedWhenSlidedIn(wm.findTopComponentID(active));
        }
        String label = maximize ? NbBundle.getMessage(MaximizeWindowAction.class, (String)"CTL_MaximizeWindowAction", (Object)param) : NbBundle.getMessage(MaximizeWindowAction.class, (String)"CTL_UnmaximizeWindowAction", (Object)param);
        this.putValue("Name", this.isPopup ? Actions.cutAmpersand((String)label) : label);
        this.setEnabled(activeMode != null);
    }

    private TopComponent getTCToWorkWith() {
        if (this.topComponent != null) {
            return this.topComponent;
        }
        return TopComponent.getRegistry().getActivated();
    }

    public void putValue(String key, Object newValue) {
        if ("AcceleratorKey".equals(key)) {
            ActionUtils.putSharedAccelerator("MaximizeWindow", newValue);
        } else {
            super.putValue(key, newValue);
        }
    }

    public Object getValue(String key) {
        if ("AcceleratorKey".equals(key)) {
            return ActionUtils.getSharedAccelerator("MaximizeWindow");
        }
        return super.getValue(key);
    }
}

