/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.netbeans.core.NbTopManager;
import org.netbeans.core.windows.PersistenceHandler;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.CloneDocumentAction;
import org.netbeans.core.windows.persistence.PersistenceManager;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class ResetWindowsAction
extends AbstractAction {
    public ResetWindowsAction() {
        this.putValue("Name", NbBundle.getMessage(CloneDocumentAction.class, (String)"CTL_ResetWindows"));
    }

    public void actionPerformed(ActionEvent e) {
        final NbTopManager.WindowSystem ws = (NbTopManager.WindowSystem)Lookup.getDefault().lookup(NbTopManager.WindowSystem.class);
        if (null == ws) {
            return;
        }
        WindowManagerImpl wm = WindowManagerImpl.getInstance();
        wm.getMainWindow().setExtendedState(0);
        final TopComponent[] editors = wm.getEditorTopComponents();
        wm.closeNonEditorViews();
        wm.getMainWindow().setVisible(false);
        final TopComponent activeEditor = wm.getArbitrarySelectedEditorTopComponent();
        wm.deselectEditorTopComponents();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FileSystem fs = Repository.getDefault().getDefaultFileSystem();
                FileObject rootFolder = fs.getRoot().getFileObject("Windows2Local");
                if (null != rootFolder) {
                    try {
                        for (FileObject fo : rootFolder.getChildren()) {
                            if ("Components".equals(fo.getName())) continue;
                            fo.delete();
                        }
                    }
                    catch (IOException ioE) {
                        ErrorManager.getDefault().notify(1, (Throwable)ioE);
                    }
                }
                ws.hide();
                WindowManagerImpl.getInstance().resetModel();
                PersistenceManager.getDefault().reset();
                PersistenceHandler.getDefault().clear();
                ws.load();
                ws.show();
                for (int i = 0; i < editors.length; ++i) {
                    editors[i].open();
                }
                if (null != activeEditor) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            activeEditor.requestActive();
                        }
                    });
                }
            }
        });
    }
}

