/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.services;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.netbeans.core.DataSystem;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class FileSelector
extends JPanel
implements PropertyChangeListener,
ExplorerManager.Provider {
    static final long serialVersionUID = 6524404012203099065L;
    private final ExplorerManager manager = new ExplorerManager();
    private BeanTreeView tree;
    private JButton okButton;
    private JButton cancelButton;
    private JButton[] buttons;
    private NodeAcceptor acceptor;

    public FileSelector(String rootLabel, Node root, NodeAcceptor acceptor, Component top) {
        this.acceptor = acceptor;
        ResourceBundle bundle = NbBundle.getBundle(FileSelector.class);
        this.okButton = new JButton(bundle.getString("CTL_FileSelectorOkButton"));
        this.cancelButton = new JButton(bundle.getString("CTL_FileSelectorCancelButton"));
        this.okButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_FileSelectorOkButton"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_FileSelectorCancelButton"));
        this.buttons = new JButton[]{this.okButton, this.cancelButton};
        this.manager.setRootContext(root);
        this.tree = new BeanTreeView();
        this.tree.setPopupAllowed(false);
        this.tree.setDefaultActionAllowed(false);
        this.tree.setBorder((Border)UIManager.get("Nb.ScrollPane.border"));
        this.tree.getAccessibleContext().setAccessibleName(NbBundle.getBundle(FileSelector.class).getString("ACSN_FileSelectorTreeView"));
        this.tree.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(FileSelector.class).getString("ACSD_FileSelectorTreeView"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(FileSelector.class).getString("ACSD_FileSelectorDialog"));
        this.setLayout(new BorderLayout());
        this.add((Component)this.tree, "Center");
        try {
            Node[] roots;
            if (root instanceof DataSystem && (roots = root.getChildren().getNodes()).length > 0) {
                final JComboBox<Node> combo = new JComboBox<Node>(roots);
                combo.setRenderer(new FileSelectRenderer());
                combo.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        Node o = (Node)combo.getSelectedItem();
                        FileSelector.this.manager.setRootContext(o);
                    }
                });
                combo.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_FileSelectorComboBox"));
                this.manager.setSelectedNodes(new Node[]{roots[0]});
                JPanel comboPanel = new JPanel();
                comboPanel.setLayout(new BorderLayout(5, 0));
                JLabel label = new JLabel();
                Mnemonics.setLocalizedText((JLabel)label, (String)rootLabel);
                label.setLabelFor(combo);
                comboPanel.add((Component)label, "West");
                comboPanel.add(combo, "Center");
                this.add((Component)comboPanel, "North");
            } else {
                this.manager.setSelectedNodes(new Node[]{root});
                JLabel label = new JLabel(rootLabel.replace('&', ' '));
                label.setLabelFor((Component)this.tree);
                this.add((Component)label, "North");
            }
        }
        catch (PropertyVetoException pve) {
            throw new IllegalStateException(pve.getMessage());
        }
        if (top != null) {
            this.add(top, "South");
        }
        this.manager.addPropertyChangeListener((PropertyChangeListener)this);
        if (acceptor.acceptNodes(this.manager.getSelectedNodes())) {
            this.enableButton();
        } else {
            this.disableButton();
        }
    }

    Object[] getOptions() {
        return this.buttons;
    }

    Object getSelectOption() {
        return this.okButton;
    }

    public void propertyChange(PropertyChangeEvent ev) {
        if (ev.getPropertyName().equals("selectedNodes")) {
            if (this.acceptor.acceptNodes(this.manager.getSelectedNodes())) {
                this.enableButton();
            } else {
                this.disableButton();
            }
        }
    }

    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        dim.height = Math.max(dim.height, Utilities.getUsableScreenBounds().height / 2);
        return dim;
    }

    public Node[] getNodes() {
        return this.manager.getSelectedNodes();
    }

    void enableButton() {
        this.okButton.setEnabled(true);
    }

    void disableButton() {
        this.okButton.setEnabled(false);
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private static class FileSelectRenderer
    extends JLabel
    implements ListCellRenderer {
        static final long serialVersionUID = -7071698027341621636L;
        protected static Border hasFocusBorder;
        protected static Border noFocusBorder;

        public FileSelectRenderer() {
            this.setOpaque(true);
            this.setBorder(noFocusBorder);
            hasFocusBorder = new LineBorder(UIManager.getColor("List.focusCellHighlight"));
            noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (!(value instanceof Node)) {
                return this;
            }
            Node node = (Node)value;
            ImageIcon icon = new ImageIcon(node.getIcon(1));
            this.setIcon(icon);
            this.setText(node.getDisplayName());
            if (isSelected) {
                super.setBackground(UIManager.getColor("List.selectionBackground"));
                super.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                super.setBackground(list.getBackground());
                super.setForeground(list.getForeground());
            }
            this.setBorder(cellHasFocus ? hasFocusBorder : noFocusBorder);
            return this;
        }
    }
}

