/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.services;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.List;
import javax.swing.JSeparator;
import org.netbeans.core.NbPlaces;
import org.netbeans.core.windows.services.ActionPasteType;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.FileSystemAction;
import org.openide.actions.MoveDownAction;
import org.openide.actions.MoveUpAction;
import org.openide.actions.NewAction;
import org.openide.actions.PasteAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.RenameAction;
import org.openide.actions.ReorderAction;
import org.openide.actions.ToolsAction;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.InstanceDataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MenuFolderNode
extends DataFolder.FolderNode {
    static SystemAction[] staticActions;
    static SystemAction[] topStaticActions;
    private static final Node.PropertySet[] NO_PROPERTIES;
    private DataFolder folder;

    public MenuFolderNode() {
        this(NbPlaces.getDefault().menus());
    }

    MenuFolderNode(DataFolder folder) {
        DataFolder dataFolder = folder;
        dataFolder.getClass();
        super(dataFolder, (Children)new MenuFolderChildren(folder));
        this.folder = folder;
        this.setShortDescription(NbBundle.getMessage(MenuFolderNode.class, (String)"CTL_Menu_hint"));
        this.setIconBaseWithExtension("org/netbeans/core/resources/menu.gif");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(MenuFolderNode.class);
    }

    protected void createPasteTypes(Transferable t, List<PasteType> s) {
        PasteType pType = ActionPasteType.getPasteType((DataFolder)this.getDataObject(), t);
        if (pType != null) {
            s.add(pType);
        }
    }

    public NewType[] getNewTypes() {
        NewType newMenu = new NewType(){

            public String getName() {
                return NbBundle.getMessage(MenuFolderNode.class, (String)"CTL_newMenuName");
            }

            public void create() throws IOException {
                MenuFolderNode.this.newMenu();
            }
        };
        if (this.getParentNode() instanceof MenuFolderNode) {
            return new NewType[]{newMenu, new NewType(){

                public String getName() {
                    return NbBundle.getMessage(MenuFolderNode.class, (String)"CTL_newMenuSeparator");
                }

                public void create() throws IOException {
                    MenuFolderNode.this.newSeparator();
                }
            }};
        }
        return new NewType[]{newMenu};
    }

    void newMenu() {
        String s;
        NotifyDescriptor.InputLine il = new NotifyDescriptor.InputLine(NbBundle.getMessage(MenuFolderNode.class, (String)"CTL_newMenuLabel"), NbBundle.getMessage(MenuFolderNode.class, (String)"CTL_newMenuDialog"));
        il.setInputText(NbBundle.getMessage(MenuFolderNode.class, (String)"CTL_newMenu"));
        Object ok = DialogDisplayer.getDefault().notify((NotifyDescriptor)il);
        if (ok == NotifyDescriptor.OK_OPTION && !(s = il.getInputText()).equals("")) {
            FileObject mnFO = this.folder.getPrimaryFile();
            try {
                FileObject newFO = mnFO.getFileObject(s);
                if (newFO == null) {
                    String lastName = this.getLastName();
                    newFO = mnFO.createFolder(s);
                    if (lastName != null) {
                        mnFO.setAttribute(lastName + "/" + newFO.getNameExt(), (Object)Boolean.TRUE);
                    }
                }
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    void newSeparator() {
        try {
            InstanceDataObject instData = InstanceDataObject.find((DataFolder)this.folder, null, (String)"javax.swing.JSeparator");
            String lastName = this.getLastName();
            Object d = instData == null ? InstanceDataObject.create((DataFolder)this.folder, null, (String)"javax.swing.JSeparator") : instData.copy(this.folder);
            if (lastName != null) {
                this.folder.getPrimaryFile().setAttribute(lastName + "/" + d.getPrimaryFile().getNameExt(), (Object)Boolean.TRUE);
            }
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    private String getLastName() {
        Node last;
        DataObject d;
        String lastName = null;
        Node[] ch = this.getChildren().getNodes();
        if (ch.length > 0 && (d = (DataObject)(last = ch[ch.length - 1]).getCookie(DataObject.class)) != null) {
            lastName = d.getPrimaryFile().getNameExt();
        }
        return lastName;
    }

    protected SystemAction[] createActions() {
        if (this.isTopLevel()) {
            if (topStaticActions == null) {
                topStaticActions = new SystemAction[]{SystemAction.get(FileSystemAction.class), null, SystemAction.get(ReorderAction.class), null, SystemAction.get(PasteAction.class), null, SystemAction.get(NewAction.class), null, SystemAction.get(ToolsAction.class), SystemAction.get(PropertiesAction.class)};
            }
            return topStaticActions;
        }
        if (staticActions == null) {
            staticActions = new SystemAction[]{SystemAction.get(FileSystemAction.class), null, SystemAction.get(MoveUpAction.class), SystemAction.get(MoveDownAction.class), SystemAction.get(ReorderAction.class), null, SystemAction.get(CutAction.class), SystemAction.get(CopyAction.class), SystemAction.get(PasteAction.class), null, SystemAction.get(DeleteAction.class), SystemAction.get(RenameAction.class), null, SystemAction.get(NewAction.class), null, SystemAction.get(ToolsAction.class), SystemAction.get(PropertiesAction.class)};
        }
        return staticActions;
    }

    public Node.PropertySet[] getPropertySets() {
        if (this.isTopLevel()) {
            return NO_PROPERTIES;
        }
        Sheet sheet = Sheet.createDefault();
        sheet.get("properties").put((Node.Property)new PropertySupport.Name((Node)this, NbBundle.getMessage(MenuFolderNode.class, (String)"PROP_MenuName"), NbBundle.getMessage(MenuFolderNode.class, (String)"HINT_MenuName")));
        return sheet.toArray();
    }

    boolean isTopLevel() {
        Node n = this.getParentNode();
        return n == null || !(n instanceof MenuFolderNode);
    }

    public boolean canDestroy() {
        if (this.isTopLevel()) {
            return false;
        }
        return super.canDestroy();
    }

    public boolean canCut() {
        if (this.isTopLevel()) {
            return false;
        }
        return super.canCut();
    }

    public boolean canRename() {
        if (this.isTopLevel()) {
            return false;
        }
        return super.canRename();
    }

    static {
        NO_PROPERTIES = new Node.PropertySet[0];
    }

    static final class MenuFolderChildren
    extends FilterNode.Children {
        public MenuFolderChildren(DataFolder folder) {
            super(folder.getNodeDelegate());
        }

        protected Node copyNode(Node node) {
            DataFolder df = (DataFolder)node.getCookie(DataFolder.class);
            if (df != null) {
                return new MenuFolderNode(df);
            }
            return new MenuItemNode(node);
        }
    }

    static final class MenuItemNode
    extends FilterNode {
        static SystemAction[] staticActions;
        static SystemAction[] separatorStaticActions;

        MenuItemNode(Node filter) {
            super(filter, FilterNode.Children.LEAF);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            return this == o || this.getOriginal().equals(o) || o.equals(this.getOriginal());
        }

        public SystemAction[] getActions() {
            InstanceCookie.Of ic = (InstanceCookie.Of)this.getCookie(InstanceCookie.Of.class);
            if (ic != null && ic.instanceOf(JSeparator.class)) {
                if (null == separatorStaticActions) {
                    separatorStaticActions = new SystemAction[]{SystemAction.get(MoveUpAction.class), SystemAction.get(MoveDownAction.class), null, SystemAction.get(DeleteAction.class), null, SystemAction.get(ToolsAction.class), SystemAction.get(PropertiesAction.class)};
                }
                return separatorStaticActions;
            }
            if (staticActions == null) {
                staticActions = new SystemAction[]{SystemAction.get(MoveUpAction.class), SystemAction.get(MoveDownAction.class), null, SystemAction.get(CutAction.class), SystemAction.get(CopyAction.class), null, SystemAction.get(DeleteAction.class), null, SystemAction.get(ToolsAction.class), SystemAction.get(PropertiesAction.class)};
            }
            return staticActions;
        }

        public boolean canRename() {
            return false;
        }

        public Node.PropertySet[] getPropertySets() {
            return new Node.PropertySet[0];
        }
    }
}

