/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.dnd;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.Constants;
import org.netbeans.core.windows.Debug;
import org.netbeans.core.windows.view.dnd.TopComponentDroppable;
import org.netbeans.core.windows.view.dnd.WindowDnDManager;
import org.netbeans.core.windows.view.ui.Tabbed;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakSet;
import org.openide.windows.TopComponent;

final class TopComponentDragSupport
implements AWTEventListener,
DragSourceListener {
    public static final String MIME_TOP_COMPONENT = "application/x-java-jvm-local-objectref; class=org.openide.windows.TopComponent";
    public static final String MIME_TOP_COMPONENT_CLONEABLE = "application/x-java-jvm-local-objectref; class=org.openide.windows.TopComponent$Cloneable";
    public static final String MIME_TOP_COMPONENT_ARRAY = "application/x-java-jvm-local-objectref; class=org.netbeans.core.windows.view.dnd.TopComponentDragSupport$TopComponentArray";
    private static final int CURSOR_COPY = 0;
    private static final int CURSOR_COPY_NO = 1;
    private static final int CURSOR_MOVE = 2;
    private static final int CURSOR_MOVE_NO = 3;
    private static final int CURSOR_COPY_NO_MOVE = 4;
    private static final int CURSOR_MOVE_FREE = 5;
    private static final String NAME_CURSOR_COPY = "CursorTopComponentCopy";
    private static final String NAME_CURSOR_COPY_NO = "CursorTopComponentCopyNo";
    private static final String NAME_CURSOR_MOVE = "CursorTopComponentMove";
    private static final String NAME_CURSOR_MOVE_NO = "CursorTopComponentMoveNo";
    private static final String NAME_CURSOR_COPY_NO_MOVE = "CursorTopComponentCopyNoMove";
    private static final String NAME_CURSOR_MOVE_FREE = "CursorTopComponentMoveFree";
    private static final boolean DEBUG = Debug.isLoggable(TopComponentDragSupport.class);
    private final WindowDnDManager windowDnDManager;
    private Reference<DragSourceContext> dragContextWRef = new WeakReference<Object>(null);
    private boolean canCopy;
    private int hackUserDropAction;
    private boolean hackESC;
    private final Set keyObservers = new WeakSet(4);
    private Point startingPoint;
    private Component startingComponent;
    private long startingTime;
    private AWTEventListener keyListener = new AWTEventListener(){

        public void eventDispatched(AWTEvent event) {
            KeyEvent keyevent = (KeyEvent)event;
            if (keyevent.getID() == 402 && keyevent.getKeyCode() == 27) {
                TopComponentDragSupport.this.hackESC = true;
            }
        }
    };

    TopComponentDragSupport(WindowDnDManager windowDnDManager) {
        this.windowDnDManager = windowDnDManager;
    }

    public boolean isCopyOperationPossible() {
        return this.canCopy;
    }

    public void eventDispatched(AWTEvent evt) {
        Point startPoint;
        MouseEvent me = (MouseEvent)evt;
        if (me.getID() == 501 && SwingUtilities.isLeftMouseButton(me)) {
            this.startingPoint = me.getPoint();
            this.startingComponent = me.getComponent();
            this.startingTime = me.getWhen();
        } else if (me.getID() == 502) {
            this.startingPoint = null;
            this.startingComponent = null;
        }
        if (evt.getID() != 506) {
            return;
        }
        if (this.windowDnDManager.isDragging()) {
            return;
        }
        if (this.startingPoint == null) {
            return;
        }
        if (evt.getSource() instanceof JButton) {
            return;
        }
        Component srcComp = this.startingComponent;
        if (srcComp == null) {
            return;
        }
        Point point = new Point(this.startingPoint);
        Point currentPoint = me.getPoint();
        Component currentComponent = me.getComponent();
        if (currentComponent == null) {
            return;
        }
        currentPoint = SwingUtilities.convertPoint(currentComponent, currentPoint, srcComp);
        if (Math.abs(currentPoint.x - point.x) <= 10 && Math.abs(currentPoint.y - point.y) <= 10) {
            return;
        }
        if (me.getWhen() - this.startingTime <= 200L) {
            return;
        }
        this.startingPoint = null;
        this.startingComponent = null;
        if (DEBUG) {
            TopComponentDragSupport.debugLog("");
            TopComponentDragSupport.debugLog("eventDispatched (MOUSE_DRAGGED)");
        }
        if (srcComp instanceof JTree && ((JTree)srcComp).getPathForLocation(me.getX(), me.getY()) != null) {
            return;
        }
        srcComp = SwingUtilities.getDeepestComponentAt(srcComp, point.x, point.y);
        boolean ctrlDown = me.isControlDown();
        TopComponent tc = null;
        Tabbed tabbed = srcComp instanceof Tabbed ? (Tabbed)((Object)srcComp) : (Tabbed)((Object)SwingUtilities.getAncestorOfClass(Tabbed.class, srcComp));
        if (tabbed == null) {
            if (srcComp instanceof Tabbed.Accessor) {
                tabbed = ((Tabbed.Accessor)((Object)srcComp)).getTabbed();
            } else {
                Tabbed.Accessor acc = (Tabbed.Accessor)((Object)SwingUtilities.getAncestorOfClass(Tabbed.Accessor.class, srcComp));
                Tabbed tabbed2 = tabbed = acc != null ? acc.getTabbed() : null;
            }
        }
        if (tabbed == null) {
            return;
        }
        Point ppp = new Point(point);
        Point p = SwingUtilities.convertPoint(srcComp, ppp, tabbed.getComponent());
        tc = tabbed.getTopComponentAt(tabbed.tabForCoordinate(p));
        if (tc == null) {
            return;
        }
        this.hackUserDropAction = ctrlDown ? 1 : 2;
        ArrayList<MouseEvent> list = new ArrayList<MouseEvent>();
        list.add(me);
        TopComponentDroppable startDroppable = (TopComponentDroppable)((Object)SwingUtilities.getAncestorOfClass(TopComponentDroppable.class, (Component)tc));
        if (startDroppable == null) {
            startDroppable = (TopComponentDroppable)((Object)SwingUtilities.getAncestorOfClass(TopComponentDroppable.class, tabbed.getComponent()));
        }
        if (startDroppable != null) {
            startPoint = point;
            Point pp = new Point(point);
            startPoint = SwingUtilities.convertPoint(srcComp, pp, (Component)((Object)startDroppable));
        } else {
            startPoint = null;
        }
        this.doStartDrag(srcComp, tc, new DragGestureEvent(new FakeDragGestureRecognizer(this.windowDnDManager, me), this.hackUserDropAction, point, list), startDroppable, startPoint);
    }

    private void doStartDrag(Component startingComp, Object transfer, DragGestureEvent evt, TopComponentDroppable startingDroppable, Point startingPoint) {
        TopComponent firstTC;
        Dialog dlg;
        if (DEBUG) {
            TopComponentDragSupport.debugLog("");
            TopComponentDragSupport.debugLog("doStartDrag");
        }
        if ((dlg = (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, (Component)(firstTC = transfer instanceof TopComponent ? (TopComponent)transfer : ((TopComponent[])transfer)[0]))) != null && dlg.isModal()) {
            return;
        }
        this.canCopy = firstTC instanceof TopComponent.Cloneable;
        this.windowDnDManager.dragStarting(startingDroppable, startingPoint, firstTC);
        Cursor cursor = this.hackUserDropAction == 2 ? TopComponentDragSupport.getDragCursor(startingComp, 2) : (this.canCopy ? TopComponentDragSupport.getDragCursor(startingComp, 0) : TopComponentDragSupport.getDragCursor(startingComp, 4));
        this.addListening();
        this.hackESC = false;
        Tabbed tabbed = (Tabbed)((Object)SwingUtilities.getAncestorOfClass(Tabbed.class, startingComp));
        if (tabbed == null) {
            Tabbed.Accessor acc = (Tabbed.Accessor)((Object)SwingUtilities.getAncestorOfClass(Tabbed.Accessor.class, startingComp));
            tabbed = acc != null ? acc.getTabbed() : null;
        }
        Image img = null;
        if (tabbed != null && Constants.SWITCH_USE_DRAG_IMAGES) {
            int idx = tabbed.indexOf((Component)firstTC);
            img = tabbed.createImageOfTab(idx);
        }
        try {
            evt.startDrag(cursor, img, new Point(0, 0), transfer instanceof TopComponent ? new TopComponentTransferable((TopComponent)transfer) : new TopComponentArrayTransferable((TopComponent[])transfer), this);
        }
        catch (InvalidDnDOperationException idoe) {
            Logger.getLogger(TopComponentDragSupport.class.getName()).log(Level.WARNING, null, idoe);
            this.removeListening();
            this.windowDnDManager.resetDragSource();
        }
    }

    private void addListening() {
        Toolkit.getDefaultToolkit().addAWTEventListener(this.keyListener, 8L);
    }

    private void removeListening() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.keyListener);
    }

    public void dragEnter(DragSourceDragEvent evt) {
        if (DEBUG) {
            TopComponentDragSupport.debugLog("");
            TopComponentDragSupport.debugLog("dragEnter");
        }
        if (this.dragContextWRef.get() == null) {
            this.dragContextWRef = new WeakReference<DragSourceContext>(evt.getDragSourceContext());
        }
    }

    public void dragOver(DragSourceDragEvent evt) {
        if (DEBUG) {
            TopComponentDragSupport.debugLog("");
            TopComponentDragSupport.debugLog("dragOver");
        }
    }

    public void dragExit(DragSourceEvent evt) {
        if (DEBUG) {
            TopComponentDragSupport.debugLog("");
            TopComponentDragSupport.debugLog("dragExit");
        }
        if (this.dragContextWRef.get() == null) {
            this.dragContextWRef = new WeakReference<DragSourceContext>(evt.getDragSourceContext());
        }
    }

    public void dropActionChanged(DragSourceDragEvent evt) {
        int type;
        String name;
        if (DEBUG) {
            TopComponentDragSupport.debugLog("");
            TopComponentDragSupport.debugLog("dropActionChanged");
        }
        if ((name = evt.getDragSourceContext().getCursor().getName()) == null) {
            return;
        }
        int userAction = evt.getUserAction();
        if (userAction == 0) {
            userAction = 2;
        }
        this.hackUserDropAction = userAction;
        if ((NAME_CURSOR_COPY.equals(name) || NAME_CURSOR_COPY_NO_MOVE.equals(name)) && userAction == 2) {
            type = 2;
        } else if (NAME_CURSOR_COPY_NO.equals(name) && userAction == 2) {
            type = 3;
        } else if (NAME_CURSOR_MOVE.equals(name) && userAction == 1) {
            type = 0;
        } else if (NAME_CURSOR_MOVE_NO.equals(name) && userAction == 1) {
            type = 1;
        } else {
            return;
        }
        if (type == 0 && !this.canCopy) {
            type = 4;
        }
        if (TopComponentDragSupport.getDragCursorName(type).equals(evt.getDragSourceContext().getCursor().getName())) {
            return;
        }
        evt.getDragSourceContext().setCursor(TopComponentDragSupport.getDragCursor(evt.getDragSourceContext().getComponent(), type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dragDropEnd(final DragSourceDropEvent evt) {
        if (DEBUG) {
            TopComponentDragSupport.debugLog("");
            TopComponentDragSupport.debugLog("dragDropEnd");
        }
        this.windowDnDManager.dragFinished();
        try {
            if (this.checkDropSuccess(evt)) {
                this.removeListening();
                return;
            }
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    SwingUtilities.invokeLater(TopComponentDragSupport.this.createDropIntoFreeAreaTask(evt, evt.getLocation()));
                }
            }, 250);
        }
        finally {
            this.windowDnDManager.dragFinishedEx();
        }
    }

    private boolean checkDropSuccess(DragSourceDropEvent evt) {
        if (this.windowDnDManager.isDropSuccess()) {
            return true;
        }
        Point location = evt.getLocation();
        if (location == null) {
            return true;
        }
        if (WindowDnDManager.isInMainWindow(location) || this.windowDnDManager.isInFloatingFrame(location) || WindowDnDManager.isAroundCenterPanel(location)) {
            return false;
        }
        return false;
    }

    private Runnable createDropIntoFreeAreaTask(final DragSourceDropEvent evt, final Point location) {
        return new Runnable(){

            public void run() {
                if (TopComponentDragSupport.this.hackESC) {
                    TopComponentDragSupport.this.removeListening();
                    return;
                }
                TopComponent[] tcArray = WindowDnDManager.extractTopComponent(false, evt.getDragSourceContext().getTransferable());
                if (tcArray != null) {
                    TopComponentDragSupport.this.windowDnDManager.tryPerformDrop(TopComponentDragSupport.this.windowDnDManager.getController(), TopComponentDragSupport.this.windowDnDManager.getFloatingFrames(), location, 2, evt.getDragSourceContext().getTransferable());
                }
            }
        };
    }

    private static Rectangle getBoundsForNewMode(TopComponent tc, Point location) {
        int width = tc.getWidth();
        int height = tc.getHeight();
        Window window = SwingUtilities.getWindowAncestor((Component)tc);
        if (window != null) {
            Insets ins = window.getInsets();
            width += ins.left + ins.right;
            height += ins.top + ins.bottom;
        }
        Rectangle tcBounds = tc.getBounds();
        Rectangle initBounds = new Rectangle(location.x, location.y, width, height);
        return initBounds;
    }

    void setSuccessCursor(boolean freeArea) {
        int type;
        int dropAction = this.hackUserDropAction;
        DragSourceContext ctx = this.dragContextWRef.get();
        if (ctx == null) {
            return;
        }
        if (dropAction == 2) {
            type = freeArea ? 5 : 2;
        } else if (dropAction == 1) {
            type = this.canCopy ? 0 : 4;
        } else {
            Logger.getLogger(TopComponentDragSupport.class.getName()).log(Level.WARNING, null, new IllegalStateException("Invalid action type->" + dropAction));
            return;
        }
        if (TopComponentDragSupport.getDragCursorName(type).equals(ctx.getCursor().getName())) {
            return;
        }
        ctx.setCursor(TopComponentDragSupport.getDragCursor(ctx.getComponent(), type));
    }

    void setUnsuccessCursor() {
        int type;
        DragSourceContext ctx = this.dragContextWRef.get();
        if (ctx == null) {
            return;
        }
        String name = ctx.getCursor().getName();
        if (NAME_CURSOR_COPY.equals(name) || NAME_CURSOR_COPY_NO_MOVE.equals(name)) {
            type = 1;
        } else if (NAME_CURSOR_MOVE.equals(name) || NAME_CURSOR_MOVE_NO.equals(name)) {
            type = 3;
        } else {
            return;
        }
        ctx.setCursor(TopComponentDragSupport.getDragCursor(ctx.getComponent(), type));
    }

    void dragFinished() {
        this.dragContextWRef = new WeakReference<Object>(null);
    }

    private static void debugLog(String message) {
        Debug.log(TopComponentDragSupport.class, message);
    }

    private static String getDragCursorName(int type) {
        if (type == 0) {
            return NAME_CURSOR_COPY;
        }
        if (type == 1) {
            return NAME_CURSOR_COPY_NO;
        }
        if (type == 2) {
            return NAME_CURSOR_MOVE;
        }
        if (type == 3) {
            return NAME_CURSOR_MOVE_NO;
        }
        if (type == 4) {
            return NAME_CURSOR_COPY_NO_MOVE;
        }
        if (type == 5) {
            return NAME_CURSOR_MOVE_FREE;
        }
        return null;
    }

    private static Cursor getDragCursor(Component comp, int type) {
        Image image = null;
        String name = null;
        if (type == 0) {
            image = Utilities.loadImage((String)"org/netbeans/core/resources/topComponentDragCopy.gif");
            name = NAME_CURSOR_COPY;
        } else if (type == 1) {
            image = Utilities.loadImage((String)"org/netbeans/core/resources/topComponentDragCopyNo.gif");
            name = NAME_CURSOR_COPY_NO;
        } else if (type == 2) {
            image = Utilities.loadImage((String)"org/netbeans/core/resources/topComponentDragMove.gif");
            name = NAME_CURSOR_MOVE;
        } else if (type == 3) {
            image = Utilities.loadImage((String)"org/netbeans/core/resources/topComponentDragMoveNo.gif");
            name = NAME_CURSOR_MOVE_NO;
        } else if (type == 4) {
            image = Utilities.loadImage((String)"org/netbeans/core/resources/topComponentDragCopyNo.gif");
            name = NAME_CURSOR_COPY_NO_MOVE;
        } else if (type == 5) {
            image = Utilities.loadImage((String)"org/netbeans/core/windows/resources/topComponentDragMoveFreeArea.gif");
            name = NAME_CURSOR_MOVE_FREE;
        } else {
            throw new IllegalArgumentException("Unknown cursor type=" + type);
        }
        return Utilities.createCustomCursor((Component)comp, (Image)image, (String)name);
    }

    private static class FakeDragGestureRecognizer
    extends DragGestureRecognizer {
        public FakeDragGestureRecognizer(WindowDnDManager windowDnDManager, MouseEvent evt) {
            super(windowDnDManager.getWindowDragSource(), (Component)evt.getSource(), 3, null);
            this.appendEvent(evt);
        }

        public void registerListeners() {
        }

        public void unregisterListeners() {
        }
    }

    static class TopComponentArray {
        TopComponentArray() {
        }
    }

    private static class TopComponentArrayTransferable
    implements Transferable {
        private TopComponent[] tcArray;

        public TopComponentArrayTransferable(TopComponent[] tcArray) {
            this.tcArray = tcArray;
        }

        public Object getTransferData(DataFlavor df) {
            if (TopComponentDragSupport.MIME_TOP_COMPONENT_ARRAY.equals(df.getMimeType())) {
                return this.tcArray;
            }
            return null;
        }

        public DataFlavor[] getTransferDataFlavors() {
            try {
                return new DataFlavor[]{new DataFlavor(TopComponentDragSupport.MIME_TOP_COMPONENT_ARRAY, null, TopComponent.class.getClassLoader())};
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(TopComponentDragSupport.class.getName()).log(Level.WARNING, ex.getMessage(), ex);
                return new DataFlavor[0];
            }
        }

        public boolean isDataFlavorSupported(DataFlavor df) {
            return TopComponentDragSupport.MIME_TOP_COMPONENT_ARRAY.equals(df.getMimeType());
        }
    }

    private static class TopComponentTransferable
    implements Transferable {
        private TopComponent tc;

        public TopComponentTransferable(TopComponent tc) {
            this.tc = tc;
        }

        public Object getTransferData(DataFlavor df) {
            if (TopComponentDragSupport.MIME_TOP_COMPONENT.equals(df.getMimeType())) {
                return this.tc;
            }
            if (TopComponentDragSupport.MIME_TOP_COMPONENT_CLONEABLE.equals(df.getMimeType()) && this.tc instanceof TopComponent.Cloneable) {
                return this.tc;
            }
            return null;
        }

        public DataFlavor[] getTransferDataFlavors() {
            try {
                if (this.tc instanceof TopComponent.Cloneable) {
                    return new DataFlavor[]{new DataFlavor(TopComponentDragSupport.MIME_TOP_COMPONENT, null, TopComponent.class.getClassLoader()), new DataFlavor(TopComponentDragSupport.MIME_TOP_COMPONENT_CLONEABLE, null, TopComponent.Cloneable.class.getClassLoader())};
                }
                return new DataFlavor[]{new DataFlavor(TopComponentDragSupport.MIME_TOP_COMPONENT, null, TopComponent.class.getClassLoader())};
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(TopComponentDragSupport.class.getName()).log(Level.WARNING, ex.getMessage(), ex);
                return new DataFlavor[0];
            }
        }

        public boolean isDataFlavorSupported(DataFlavor df) {
            if (TopComponentDragSupport.MIME_TOP_COMPONENT.equals(df.getMimeType())) {
                return true;
            }
            return TopComponentDragSupport.MIME_TOP_COMPONENT_CLONEABLE.equals(df.getMimeType()) && this.tc instanceof TopComponent.Cloneable;
        }
    }
}

