/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.cookies.SaveCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.ListView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentsDlg
extends JPanel
implements PropertyChangeListener,
ExplorerManager.Provider {
    private static DocumentsDlg defaultInstance;
    private final ExplorerManager explorer = new ExplorerManager();
    private JButton closeButton;
    private JTextArea descriptionArea;
    private JLabel descriptionLabel;
    private JLabel explorerLabel;
    private JPanel explorerPanel;
    private JButton jButtonActivate;
    private JButton jButtonClose;
    private JButton jButtonSave;
    private JScrollPane jScrollPane1;
    private ListView listView;
    private static final Collator COLLATOR;

    private DocumentsDlg() {
        this.initComponents();
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonActivate, (String)NbBundle.getMessage(DocumentsDlg.class, (String)"LBL_Activate"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonClose, (String)NbBundle.getMessage(DocumentsDlg.class, (String)"LBL_CloseDocuments"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonSave, (String)NbBundle.getMessage(DocumentsDlg.class, (String)"LBL_SaveDocuments"));
        Mnemonics.setLocalizedText((JLabel)this.explorerLabel, (String)NbBundle.getMessage(DocumentsDlg.class, (String)"LBL_Documents"));
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getMessage(DocumentsDlg.class, (String)"LBL_Description"));
        Mnemonics.setLocalizedText((AbstractButton)this.closeButton, (String)NbBundle.getMessage(DocumentsDlg.class, (String)"LBL_Close"));
        this.explorerLabel.setLabelFor((Component)this.listView);
        this.descriptionLabel.setLabelFor(this.descriptionArea);
        this.jButtonActivate.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DocumentsDlg.class, (String)"ACSD_Activate"));
        this.jButtonClose.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DocumentsDlg.class, (String)"ACSD_CloseDocuments"));
        this.jButtonSave.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DocumentsDlg.class, (String)"ACSD_SaveDocuments"));
        this.closeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DocumentsDlg.class, (String)"ACSD_Close"));
        this.descriptionArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DocumentsDlg.class, (String)"ACSD_DescriptionArea"));
    }

    private static DocumentsDlg getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new DocumentsDlg();
        }
        return defaultInstance;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(DocumentsDlg.class);
    }

    private void initComponents() {
        this.explorerLabel = new JLabel();
        this.descriptionLabel = new JLabel();
        this.explorerPanel = this.createListView();
        this.jScrollPane1 = new JScrollPane();
        this.descriptionArea = new JTextArea();
        this.jButtonActivate = new JButton();
        this.jButtonClose = new JButton();
        this.jButtonSave = new JButton();
        this.closeButton = new JButton();
        FormListener formListener = new FormListener();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 11));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.explorerLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.descriptionLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.add((Component)this.explorerPanel, gridBagConstraints);
        this.jScrollPane1.setPreferredSize(new Dimension(3, 60));
        this.descriptionArea.setEditable(false);
        this.jScrollPane1.setViewportView(this.descriptionArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jButtonActivate.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jButtonActivate, gridBagConstraints);
        this.jButtonClose.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jButtonClose, gridBagConstraints);
        this.jButtonSave.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.jButtonSave, gridBagConstraints);
        this.closeButton.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.closeButton, gridBagConstraints);
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void saveDocuments(ActionEvent evt) {
        Node[] selNodes = this.explorer.getSelectedNodes();
        if (selNodes.length == 0) {
            return;
        }
        for (int i = 0; i < selNodes.length; ++i) {
            TopComponent tc = ((TopComponentNode)selNodes[i]).getTopComponent();
            Lookup l = tc.getLookup();
            SaveCookie sc = (SaveCookie)l.lookup(SaveCookie.class);
            if (sc == null) continue;
            try {
                sc.save();
            }
            catch (IOException exc) {
                Logger.getAnonymousLogger().log(Level.WARNING, "[WinSys.DocumentsDlg.saveDocuments] Warning: Cannot save content of TopComponent: [" + WindowManagerImpl.getInstance().getTopComponentDisplayName(tc) + "]" + " [" + tc.getClass().getName() + "]", exc);
            }
            ((TopComponentNode)selNodes[i]).refresh();
        }
        this.jButtonSave.setEnabled(false);
    }

    private void closeDocuments(ActionEvent evt) {
        Node[] selNodes = this.explorer.getSelectedNodes();
        if (selNodes.length == 0) {
            return;
        }
        for (int i = 0; i < selNodes.length; ++i) {
            TopComponent tc = ((TopComponentNode)selNodes[i]).getTopComponent();
            tc.close();
        }
        List<TopComponent> tcList = DocumentsDlg.getOpenedDocuments();
        ArrayList<TopComponentNode> tcNodes = new ArrayList<TopComponentNode>(tcList.size());
        for (TopComponent tc : tcList) {
            tcNodes.add(new TopComponentNode(tc));
        }
        if (tcList.isEmpty()) {
            this.closeDialog();
        } else {
            Collections.sort(tcNodes);
            Children.Array nodeArray = new Children.Array();
            nodeArray.add((Node[])tcNodes.toArray(new TopComponentNode[0]));
            AbstractNode root = new AbstractNode((Children)nodeArray);
            this.explorer.setRootContext((Node)root);
            try {
                this.explorer.setSelectedNodes(new Node[]{root.getChildren().getNodes()[0]});
            }
            catch (PropertyVetoException exc) {
                // empty catch block
            }
            this.listView.requestFocusInWindow();
        }
    }

    private void activate(ActionEvent evt) {
        Node[] selNodes = this.explorer.getSelectedNodes();
        if (selNodes.length == 0) {
            return;
        }
        this.closeDialog();
        final TopComponent tc = ((TopComponentNode)selNodes[0]).getTopComponent();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                WindowManagerImpl wm = WindowManagerImpl.getInstance();
                ModeImpl mode = (ModeImpl)wm.findMode(tc);
                if (mode != null && mode != wm.getCurrentMaximizedMode()) {
                    wm.switchMaximizedMode(null);
                }
                tc.requestActive();
            }
        });
    }

    private void closeDialog() {
        Window w = SwingUtilities.getWindowAncestor(this);
        w.setVisible(false);
        w.dispose();
    }

    @Override
    public void addNotify() {
        this.explorer.addPropertyChangeListener((PropertyChangeListener)this);
        this.jButtonActivate.setEnabled(false);
        this.jButtonClose.setEnabled(false);
        this.jButtonSave.setEnabled(false);
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.explorer.removePropertyChangeListener((PropertyChangeListener)this);
    }

    public static void showDocumentsDialog() {
        DocumentsDlg documentsPanel = DocumentsDlg.getDefault();
        DialogDescriptor dlgDesc = new DialogDescriptor((Object)documentsPanel, NbBundle.getMessage(DocumentsDlg.class, (String)"CTL_DocumentsTitle"), true, new Object[0], (Object)DocumentsDlg.getDefault().jButtonActivate, 0, null, null);
        Dialog dlg = DialogDisplayer.getDefault().createDialog(dlgDesc);
        dlg.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DocumentsDlg.class, (String)"ACSD_DocumentsDialog"));
        DocumentsDlg.getDefault().updateNodes();
        dlg.setVisible(true);
        DocumentsDlg.getDefault().clearNodes();
    }

    public static boolean isEmpty() {
        for (Mode mode : WindowManagerImpl.getInstance().getModes()) {
            ModeImpl mode2 = (ModeImpl)mode;
            if (mode2.getKind() != 1 || mode2.getOpenedTopComponents().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private JPanel createListView() {
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(375, 232));
        panel.setLayout(new BorderLayout());
        this.listView = new ListView();
        this.listView.setBorder((Border)UIManager.get("Nb.ScrollPane.border"));
        this.listView.setPopupAllowed(false);
        this.listView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DocumentsDlg.class, (String)"ACSD_ListView"));
        panel.add((Component)this.listView, "Center");
        return panel;
    }

    private void updateNodes() {
        List<TopComponent> tcList = DocumentsDlg.getOpenedDocuments();
        TopComponent activeTC = TopComponent.getRegistry().getActivated();
        Object[] tcNodes = new TopComponentNode[tcList.size()];
        Object toSelect = null;
        for (int i = 0; i < tcNodes.length; ++i) {
            TopComponent tc = tcList.get(i);
            tcNodes[i] = new TopComponentNode(tc);
            if (tc != activeTC) continue;
            toSelect = tcNodes[i];
        }
        Arrays.sort(tcNodes);
        Children.Array nodeArray = new Children.Array();
        nodeArray.add((Node[])tcNodes);
        AbstractNode root = new AbstractNode((Children)nodeArray);
        this.explorer.setRootContext((Node)root);
        this.listView.requestFocus();
        if (tcNodes.length > 0) {
            try {
                if (null == toSelect) {
                    toSelect = tcNodes[0];
                }
                this.explorer.setSelectedNodes(new Node[]{toSelect});
            }
            catch (PropertyVetoException exc) {
                // empty catch block
            }
        }
    }

    private void clearNodes() {
        this.explorer.setRootContext(Node.EMPTY);
    }

    private static List<TopComponent> getOpenedDocuments() {
        ArrayList<TopComponent> documents = new ArrayList<TopComponent>();
        for (Mode mode : WindowManagerImpl.getInstance().getModes()) {
            ModeImpl mode2 = (ModeImpl)mode;
            if (mode2.getKind() != 1) continue;
            documents.addAll(mode2.getOpenedTopComponents());
        }
        return documents;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedNodes".equals(evt.getPropertyName())) {
            Node[] selNodes = (Node[])evt.getNewValue();
            if (selNodes.length == 1) {
                this.jButtonActivate.setEnabled(true);
            } else {
                this.jButtonActivate.setEnabled(false);
            }
            if (selNodes.length > 0) {
                this.jButtonClose.setEnabled(true);
            } else {
                this.jButtonClose.setEnabled(false);
            }
            boolean enableSave = false;
            for (int i = 0; i < selNodes.length; ++i) {
                TopComponent tc = ((TopComponentNode)selNodes[i]).getTopComponent();
                Lookup l = tc.getLookup();
                SaveCookie sc = (SaveCookie)l.lookup(SaveCookie.class);
                if (sc == null) continue;
                enableSave = true;
                break;
            }
            this.jButtonSave.setEnabled(enableSave);
            if (selNodes != null && selNodes.length == 1) {
                this.descriptionArea.setText(((TopComponentNode)selNodes[0]).getDescription());
            } else {
                this.descriptionArea.setText(null);
            }
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.explorer;
    }

    static {
        COLLATOR = Collator.getInstance();
    }

    private class FormListener
    implements ActionListener {
        private FormListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == DocumentsDlg.this.jButtonActivate) {
                DocumentsDlg.this.activate(evt);
            } else if (evt.getSource() == DocumentsDlg.this.jButtonClose) {
                DocumentsDlg.this.closeDocuments(evt);
            } else if (evt.getSource() == DocumentsDlg.this.jButtonSave) {
                DocumentsDlg.this.saveDocuments(evt);
            } else if (evt.getSource() == DocumentsDlg.this.closeButton) {
                DocumentsDlg.this.closeButtonActionPerformed(evt);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TopComponentNode
    extends AbstractNode
    implements Comparable<TopComponentNode>,
    Action,
    PropertyChangeListener {
        private TopComponent tc;

        public TopComponentNode(TopComponent tc) {
            super(Children.LEAF);
            this.tc = tc;
            tc.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)tc));
        }

        public String getName() {
            return this.tc.getName();
        }

        public String getDisplayName() {
            String result = this.tc.getDisplayName();
            return result != null ? result : this.tc.getName();
        }

        public String getHtmlDisplayName() {
            return this.tc.getHtmlDisplayName();
        }

        public Image getIcon(int type) {
            Image image = this.tc.getIcon();
            return image == null ? Utilities.loadImage((String)"org/openide/resources/actions/empty.gif") : image;
        }

        public String getDescription() {
            return this.tc.getToolTipText();
        }

        public TopComponent getTopComponent() {
            return this.tc;
        }

        void refresh() {
            this.fireNameChange(null, null);
        }

        @Override
        public int compareTo(TopComponentNode tcn) {
            String displayName1 = this.getDisplayName();
            String displayName2 = tcn.getDisplayName();
            if (displayName1 == null) {
                return displayName2 == null ? 0 : -1;
            }
            return displayName2 == null ? 1 : COLLATOR.compare(displayName1, displayName2);
        }

        public Action getPreferredAction() {
            return this;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            DocumentsDlg.this.activate(evt);
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void putValue(String key, Object value) {
        }

        @Override
        public void setEnabled(boolean b) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.fireDisplayNameChange(null, null);
        }
    }
}

