/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.windows.Constants;
import org.netbeans.core.windows.RegistryImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.view.ui.StatusLine;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarConfiguration;
import org.openide.LifecycleManager;
import org.openide.awt.MenuBar;
import org.openide.awt.StatusLineElementProvider;
import org.openide.awt.ToolbarPool;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class MainWindow
extends JFrame {
    static final long serialVersionUID = -1160791973145645501L;
    private Component desktop;
    private JPanel desktopPanel;
    private static JPanel innerIconsPanel;
    private boolean inited;
    private static Lookup.Result<StatusLineElementProvider> result;
    private static final String ICON_SMALL = "org/netbeans/core/startup/frame.gif";
    private static final String ICON_BIG = "org/netbeans/core/startup/frame32.gif";
    private Rectangle forcedBounds = null;
    private Image waitingForPaintDummyImage;
    private Graphics waitingForPaintDummyGraphic;
    boolean isOlderJDK = System.getProperty("java.version").startsWith("1.5");
    private boolean isFullScreenMode = false;
    private Rectangle restoreBounds;
    private int restoreExtendedState = 0;

    protected void setRootPane(JRootPane root) {
        super.setRootPane(root);
        if (root != null) {
            HelpCtx.setHelpIDString((JComponent)root, (String)new HelpCtx(MainWindow.class).getHelpID());
        }
        root.setOpaque(true);
        if (Utilities.isWindows()) {
            JPanel c = new JPanel(){

                public void setVisible(boolean flag) {
                    if (flag != this.isVisible()) {
                        super.setVisible(flag);
                    }
                }
            };
            c.setName(root.getName() + ".nbGlassPane");
            c.setVisible(false);
            ((JPanel)c).setOpaque(false);
            root.setGlassPane(c);
        }
    }

    public void initializeComponents() {
        if (this.inited) {
            return;
        }
        this.inited = true;
        this.setIconImage(MainWindow.createIDEImage());
        this.initListeners();
        this.setDefaultCloseOperation(0);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(MainWindow.class).getString("ACSD_MainWindow"));
        this.setJMenuBar(MainWindow.createMenuBar());
        if (!Constants.NO_TOOLBARS) {
            JComponent tb = MainWindow.getToolbarComponent();
            this.getContentPane().add((Component)tb, "North");
        }
        if (!Constants.SWITCH_STATUSLINE_IN_MENUBAR) {
            JComponent status;
            if (Constants.CUSTOM_STATUS_LINE_PATH == null) {
                status = new StatusLine();
                ((JLabel)status).setText(" ");
                status.setPreferredSize(new Dimension(0, status.getPreferredSize().height));
                status.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
                JPanel statusLinePanel = new JPanel(new BorderLayout());
                int magicConstant = 0;
                if (Utilities.isMac()) {
                    magicConstant = 12;
                }
                statusLinePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, magicConstant), statusLinePanel.getBorder()));
                statusLinePanel.add((Component)new JSeparator(), "North");
                statusLinePanel.add((Component)status, "Center");
                MainWindow.decoratePanel(statusLinePanel);
                statusLinePanel.setName("statusLine");
                this.getContentPane().add((Component)statusLinePanel, "South");
            } else {
                status = MainWindow.getCustomStatusLine();
                if (status != null) {
                    this.getContentPane().add((Component)status, "South");
                }
            }
        }
        this.desktopPanel = new JPanel();
        this.desktopPanel.setBorder(MainWindow.getDesktopBorder());
        this.desktopPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.desktopPanel, "Center");
        MenuSelectionManager.defaultManager().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                MenuElement[] elems = MenuSelectionManager.defaultManager().getSelectedPath();
                if (elems != null && elems.length > 0 && elems[0] == MainWindow.this.getJMenuBar() && !MainWindow.this.isActive()) {
                    MainWindow.this.toFront();
                }
            }
        });
        this.setTitle(NbBundle.getMessage(MainWindow.class, (String)"CTL_MainWindow_Title_No_Project", (Object)System.getProperty("netbeans.buildnumber")));
    }

    private static void decoratePanel(JPanel panel) {
        assert (SwingUtilities.isEventDispatchThread()) : "Must run in AWT queue.";
        if (innerIconsPanel != null) {
            panel.remove(innerIconsPanel);
        }
        if ((innerIconsPanel = MainWindow.getStatusLineElements(panel)) != null) {
            panel.add((Component)innerIconsPanel, "East");
        }
    }

    static JPanel getStatusLineElements(JPanel panel) {
        Collection c;
        if (result == null) {
            result = Lookup.getDefault().lookup(new Lookup.Template(StatusLineElementProvider.class));
            result.addLookupListener((LookupListener)new StatusLineElementsListener(panel));
        }
        if ((c = result.allInstances()) == null || c.isEmpty()) {
            return null;
        }
        Iterator it = c.iterator();
        JPanel icons = new JPanel(new FlowLayout(2, 0, 0));
        icons.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 2));
        boolean some = false;
        while (it.hasNext()) {
            StatusLineElementProvider o = (StatusLineElementProvider)it.next();
            Component comp = o.getStatusLineElement();
            if (comp == null) continue;
            some = true;
            icons.add(comp);
        }
        return some ? icons : null;
    }

    private static Border getDesktopBorder() {
        Border b = (Border)UIManager.get("nb.desktop.splitpane.border");
        if (b != null) {
            return b;
        }
        return new EmptyBorder(1, 1, 1, 1);
    }

    static Image createIDEImage() {
        return Utilities.loadImage((String)(Utilities.isLargeFrameIcons() ? ICON_BIG : ICON_SMALL), (boolean)true);
    }

    private void initListeners() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                LifecycleManager.getDefault().exit();
            }

            public void windowActivated(WindowEvent evt) {
                RegistryImpl.cancelMenu(MainWindow.this);
            }
        });
    }

    private static JMenuBar createMenuBar() {
        JMenuBar menu = MainWindow.getCustomMenuBar();
        if (menu == null) {
            menu = new MenuBar(null);
        }
        menu.setBorderPainted(false);
        if (menu instanceof MenuBar) {
            ((MenuBar)menu).waitFinished();
        }
        if (Constants.SWITCH_STATUSLINE_IN_MENUBAR) {
            if (Constants.CUSTOM_STATUS_LINE_PATH == null) {
                StatusLine status = new StatusLine();
                JSeparator sep = new JSeparator(1);
                Dimension d = sep.getPreferredSize();
                d.width += 6;
                sep.setPreferredSize(d);
                JPanel statusLinePanel = new JPanel(new BorderLayout());
                statusLinePanel.add((Component)sep, "West");
                statusLinePanel.add((Component)status, "Center");
                MainWindow.decoratePanel(statusLinePanel);
                statusLinePanel.setName("statusLine");
                menu.add(statusLinePanel);
            } else {
                JComponent status = MainWindow.getCustomStatusLine();
                if (status != null) {
                    menu.add(status);
                }
            }
        }
        return menu;
    }

    private static JMenuBar getCustomMenuBar() {
        try {
            DataObject dobj;
            InstanceCookie ic;
            String fileName = Constants.CUSTOM_MENU_BAR_PATH;
            if (fileName == null) {
                return null;
            }
            FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource(fileName);
            if (fo != null && (ic = (InstanceCookie)(dobj = DataObject.find((FileObject)fo)).getCookie(InstanceCookie.class)) != null) {
                return (JMenuBar)ic.instanceCreate();
            }
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return null;
    }

    private static JComponent getCustomStatusLine() {
        try {
            DataObject dobj;
            InstanceCookie ic;
            String fileName = Constants.CUSTOM_STATUS_LINE_PATH;
            if (fileName == null) {
                return null;
            }
            FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource(fileName);
            if (fo != null && (ic = (InstanceCookie)(dobj = DataObject.find((FileObject)fo)).getCookie(InstanceCookie.class)) != null) {
                return (JComponent)ic.instanceCreate();
            }
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return null;
    }

    private static JComponent getToolbarComponent() {
        ToolbarPool tp = ToolbarPool.getDefault();
        tp.waitFinished();
        return tp;
    }

    private void initializeBounds() {
        Rectangle bounds = WindowManagerImpl.getInstance().getEditorAreaState() == 0 ? WindowManagerImpl.getInstance().getMainWindowBoundsJoined() : WindowManagerImpl.getInstance().getMainWindowBoundsSeparated();
        if (null != this.forcedBounds) {
            bounds = new Rectangle(this.forcedBounds);
            this.setPreferredSize(bounds.getSize());
            this.forcedBounds = null;
        }
        if (!bounds.isEmpty()) {
            this.setBounds(bounds);
        }
    }

    public void setBounds(Rectangle rect) {
        Rectangle bounds = rect;
        if (bounds != null && bounds.height < this.getPreferredSize().height) {
            bounds = new Rectangle(bounds.x, bounds.y, bounds.width, this.getPreferredSize().height);
        }
        super.setBounds(bounds);
    }

    public void prepareWindow() {
        this.initializeBounds();
    }

    public void setDesktop(Component comp) {
        if (this.desktop == comp) {
            if (this.desktop != null && !Arrays.asList(this.desktopPanel.getComponents()).contains(this.desktop)) {
                this.desktopPanel.add(this.desktop, "Center");
            }
            return;
        }
        if (this.desktop != null) {
            this.desktopPanel.remove(this.desktop);
        }
        this.desktop = comp;
        if (this.desktop != null) {
            this.desktopPanel.add(this.desktop, "Center");
        }
        this.invalidate();
        this.validate();
        if (this.isOlderJDK && !System.getProperty("os.name").startsWith("Windows")) {
            this.releaseWaitingForPaintDummyGraphic();
        }
        this.repaint();
    }

    public Component getDesktop() {
        return this.desktop;
    }

    public boolean hasDesktop() {
        return this.desktop != null;
    }

    public Rectangle getPureMainWindowBounds() {
        Rectangle bounds = this.getBounds();
        if (this.desktop != null) {
            Dimension desktopSize = this.desktop.getSize();
            bounds.height -= desktopSize.height;
        }
        return bounds;
    }

    public void setVisible(boolean flag) {
        if (flag && this.isOlderJDK) {
            this.waitingForPaintDummyImage = new BufferedImage(1, 1, 1);
            this.waitingForPaintDummyGraphic = this.waitingForPaintDummyImage.getGraphics();
        }
        super.setVisible(flag);
    }

    public void paint(Graphics g) {
        if (this.waitingForPaintDummyGraphic != null) {
            this.releaseWaitingForPaintDummyGraphic();
            g = this.getGraphics();
        }
        super.paint(g);
    }

    public Graphics getGraphics() {
        if (this.waitingForPaintDummyGraphic != null) {
            AWTEvent event = EventQueue.getCurrentEvent();
            if (event == null || event.getID() != 800 && event.getSource() != this) {
                return this.waitingForPaintDummyGraphic;
            }
            this.releaseWaitingForPaintDummyGraphic();
        }
        return super.getGraphics();
    }

    private void releaseWaitingForPaintDummyGraphic() {
        if (this.waitingForPaintDummyGraphic != null) {
            this.waitingForPaintDummyGraphic.dispose();
            this.waitingForPaintDummyGraphic = null;
            this.waitingForPaintDummyImage = null;
        }
    }

    public void setFullScreenMode(boolean fullScreenMode) {
        boolean updateBounds;
        ToolbarConfiguration tc;
        if (this.isFullScreenMode == fullScreenMode) {
            return;
        }
        TopComponent activatedTc = WindowManager.getDefault().getRegistry().getActivated();
        if (!this.isFullScreenMode) {
            this.restoreExtendedState = this.getExtendedState();
            this.restoreBounds = this.getBounds();
        }
        this.isFullScreenMode = fullScreenMode;
        if (Utilities.isWindows()) {
            this.setVisible(false);
        } else {
            WindowManagerImpl.getInstance().setVisible(false);
        }
        this.dispose();
        this.setUndecorated(this.isFullScreenMode);
        this.setExtendedState(this.isFullScreenMode ? 6 : this.restoreExtendedState);
        String toolbarConfigName = ToolbarPool.getDefault().getConfiguration();
        if (null != toolbarConfigName && null != (tc = ToolbarConfiguration.findConfiguration(toolbarConfigName))) {
            tc.rebuildMenu();
        }
        MainWindow.getToolbarComponent().setVisible(!this.isFullScreenMode);
        boolean bl = updateBounds = !this.isFullScreenMode;
        if (updateBounds || this.isFullScreenMode() && !Utilities.isWindows()) {
            if (updateBounds) {
                this.forcedBounds = this.restoreBounds;
            } else {
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                this.forcedBounds = ge.getMaximumWindowBounds();
            }
        }
        if (Utilities.isWindows()) {
            this.setVisible(true);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainWindow.this.invalidate();
                    MainWindow.this.validate();
                    MainWindow.this.repaint();
                    if (updateBounds) {
                        MainWindow.this.setPreferredSize(MainWindow.this.restoreBounds.getSize());
                        MainWindow.this.setBounds(MainWindow.this.restoreBounds);
                    }
                }
            });
        } else {
            WindowManagerImpl.getInstance().setVisible(true);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainWindow.this.invalidate();
                    MainWindow.this.validate();
                    MainWindow.this.repaint();
                }
            });
        }
    }

    public boolean isFullScreenMode() {
        return this.isFullScreenMode;
    }

    private static class StatusLineElementsListener
    implements LookupListener {
        private JPanel decoratingPanel;

        StatusLineElementsListener(JPanel decoratingPanel) {
            this.decoratingPanel = decoratingPanel;
        }

        public void resultChanged(LookupEvent ev) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainWindow.decoratePanel(StatusLineElementsListener.this.decoratingPanel);
                }
            });
        }
    }
}

