/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.awt.StatusDisplayer;

final class StatusLine
extends JLabel
implements ChangeListener,
Runnable {
    private static int SURVIVING_TIME = Integer.getInteger("org.openide.awt.StatusDisplayer.DISPLAY_TIME", 5000);
    private StatusDisplayer d = StatusDisplayer.getDefault();
    Object clearing;

    public void addNotify() {
        super.addNotify();
        this.run();
        this.d.addChangeListener((ChangeListener)this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.d.removeChangeListener((ChangeListener)this);
    }

    public void updateUI() {
        super.updateUI();
        Font f = UIManager.getFont("controlFont");
        if (f == null) {
            f = UIManager.getFont("Tree.font");
        }
        if (f != null) {
            this.setFont(f);
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.run();
        } else {
            SwingUtilities.invokeLater(this);
        }
    }

    public void run() {
        String currentMsg = this.d.getStatusText();
        this.setForeground(UIManager.getColor("Label.foreground"));
        this.setText(currentMsg);
        if (SURVIVING_TIME != 0) {
            Object token;
            this.clearing = token = new Object();
            if (!"".equals(currentMsg)) {
                new Updater(token).schedule();
            }
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(100, 0);
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    private class Updater
    implements ActionListener {
        private Object token;
        private long startTime;
        private Timer controller;

        public Updater(Object token) {
            this.token = token;
        }

        public void schedule() {
            this.controller = new Timer(SURVIVING_TIME, this);
            this.controller.setDelay(100);
            this.controller.start();
        }

        public void actionPerformed(ActionEvent arg0) {
            if (StatusLine.this.clearing == this.token) {
                long t = System.currentTimeMillis();
                if (this.startTime != 0L) {
                    Color c = UIManager.getColor("Label.foreground");
                    if (c != null) {
                        int alpha = 256 * (int)(t - this.startTime) / 2000;
                        StatusLine.this.setForeground(new Color(c.getRed(), c.getGreen(), c.getBlue(), 255 - Math.min(255, alpha)));
                    }
                } else {
                    this.startTime = t;
                }
                if (t > this.startTime + 2000L) {
                    this.controller.stop();
                }
            } else {
                this.controller.stop();
            }
        }
    }
}

