/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.slides;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.view.ui.Tabbed;
import org.netbeans.core.windows.view.ui.slides.CommandManager;
import org.netbeans.core.windows.view.ui.slides.SlideBarController;
import org.netbeans.core.windows.view.ui.slides.SlideGestureRecognizer;
import org.netbeans.core.windows.view.ui.slides.TabbedSlideAdapter;
import org.netbeans.core.windows.view.ui.tabcontrol.TabbedAdapter;
import org.netbeans.swing.tabcontrol.SlideBarDataModel;
import org.netbeans.swing.tabcontrol.SlidingButton;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.WinsysInfoForTabbed;
import org.netbeans.swing.tabcontrol.event.ComplexListDataEvent;
import org.netbeans.swing.tabcontrol.event.ComplexListDataListener;
import org.openide.windows.TopComponent;

public final class SlideBar
extends Box
implements ComplexListDataListener,
SlideBarController,
Tabbed.Accessor,
WinsysInfoForTabbed,
ChangeListener {
    public static final String COMMAND_SLIDE_IN = "slideIn";
    public static final String COMMAND_SLIDE_OUT = "slideOut";
    public static final String COMMAND_SLIDE_RESIZE = "slideResize";
    public static final String COMMAND_POPUP_REQUEST = "popup";
    public static final String COMMAND_DISABLE_AUTO_HIDE = "disableAutoHide";
    public static final String COMMAND_MAXIMIZE = "slideMaximize";
    private final TabbedSlideAdapter tabbed;
    private final SlideBarDataModel dataModel;
    private final SingleSelectionModel selModel;
    private SlideGestureRecognizer gestureRecognizer;
    private List<SlidingButton> buttons;
    private CommandManager commandMgr;
    private boolean active = false;

    public SlideBar(TabbedSlideAdapter tabbed, SlideBarDataModel dataModel, SingleSelectionModel selModel) {
        super(dataModel.getOrientation() == 3 ? 0 : 1);
        this.tabbed = tabbed;
        this.dataModel = dataModel;
        this.selModel = selModel;
        this.commandMgr = new CommandManager(this);
        this.gestureRecognizer = new SlideGestureRecognizer(this, this.commandMgr.getResizer());
        this.buttons = new ArrayList<SlidingButton>(5);
        this.syncWithModel();
        dataModel.addComplexListDataListener((ComplexListDataListener)this);
        selModel.addChangeListener(this);
    }

    public SlideBarDataModel getModel() {
        return this.dataModel;
    }

    public SingleSelectionModel getSelectionModel() {
        return this.selModel;
    }

    public void intervalAdded(ListDataEvent e) {
        assert (SwingUtilities.isEventDispatchThread());
        int first = e.getIndex0();
        int last = e.getIndex1();
        SlideBarDataModel data = (SlideBarDataModel)e.getSource();
        for (int i = first; i <= last; ++i) {
            SlidingButton curButton = new SlidingButton(data.getTab(i), data.getOrientation());
            this.gestureRecognizer.attachButton((AbstractButton)curButton);
            this.buttons.add(i, curButton);
            this.add((Component)curButton, i * 2);
            this.add(this.createStrut(), i * 2 + 1);
            this.revalidate();
        }
    }

    public void intervalRemoved(ListDataEvent e) {
        assert (SwingUtilities.isEventDispatchThread());
        int first = e.getIndex0();
        int last = e.getIndex1();
        SlideBarDataModel data = (SlideBarDataModel)e.getSource();
        Object curButton = null;
        for (int i = last; i >= first; --i) {
            this.gestureRecognizer.detachButton((AbstractButton)this.buttons.get(i));
            this.buttons.remove(i);
            this.remove(i * 2 + 1);
            this.remove(i * 2);
        }
    }

    public void contentsChanged(ListDataEvent e) {
        this.syncWithModel();
    }

    public void indicesAdded(ComplexListDataEvent e) {
        this.syncWithModel();
    }

    public void indicesChanged(ComplexListDataEvent e) {
        this.syncWithModel();
    }

    public void indicesRemoved(ComplexListDataEvent e) {
        this.syncWithModel();
    }

    public int tabForCoordinate(int x, int y) {
        Rectangle curBounds = new Rectangle();
        int index = 0;
        Iterator<SlidingButton> iter = this.buttons.iterator();
        while (iter.hasNext()) {
            ((Component)iter.next()).getBounds(curBounds);
            if (curBounds.contains(x, y)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    int nextTabForCoordinate(int x, int y) {
        Rectangle curBounds = new Rectangle();
        int index = 0;
        for (Component component : this.buttons) {
            component.getBounds(curBounds);
            if (this.dataModel.getOrientation() == 3) {
                if (curBounds.x + curBounds.width / 2 < x) {
                    ++index;
                    continue;
                }
            } else if (curBounds.y + curBounds.height / 2 < y) {
                ++index;
                continue;
            }
            return index;
        }
        return index;
    }

    public void stateChanged(ChangeEvent e) {
        int selIndex = this.selModel.getSelectedIndex();
        this.tabbed.postSelectionEvent();
        if (this.isDisplayable() && this.isVisible()) {
            if (selIndex != -1) {
                this.commandMgr.slideIn(selIndex);
            } else {
                this.commandMgr.slideOut(true, true);
            }
        }
    }

    public void userToggledAutoHide(int tabIndex, boolean enabled) {
        this.commandMgr.slideIntoDesktop(tabIndex, true);
    }

    public void userTriggeredPopup(MouseEvent mouseEvent, Component clickedButton) {
        int index = this.getButtonIndex(clickedButton);
        this.commandMgr.showPopup(mouseEvent, index);
    }

    private SlidingButton buttonFor(TopComponent tc) {
        TabData td;
        int idx = 0;
        Iterator i = this.dataModel.getTabs().iterator();
        while (i.hasNext() && (td = (TabData)i.next()).getComponent() != tc) {
            if (!i.hasNext()) {
                idx = -1;
                continue;
            }
            ++idx;
        }
        if (idx >= 0 && idx < this.dataModel.size()) {
            return this.getButton(idx);
        }
        return null;
    }

    public void setBlinking(TopComponent tc, boolean val) {
        SlidingButton button = this.buttonFor(tc);
        if (button != null) {
            button.setBlinking(val);
        }
    }

    public void userClickedSlidingButton(Component clickedButton) {
        int index = this.getButtonIndex(clickedButton);
        SlidingButton button = this.buttons.get(index);
        button.setBlinking(false);
        if (index != this.selModel.getSelectedIndex() || !this.isActive()) {
            TopComponent tc = (TopComponent)this.dataModel.getTab(index).getComponent();
            if (tc != null) {
                tc.requestActive();
            }
        } else {
            this.selModel.setSelectedIndex(-1);
        }
    }

    public boolean userTriggeredAutoSlideIn(Component sourceButton) {
        int index = this.getButtonIndex(sourceButton);
        if (index < 0) {
            return false;
        }
        SlidingButton button = this.buttons.get(index);
        button.setBlinking(false);
        TopComponent tc = (TopComponent)this.dataModel.getTab(index).getComponent();
        if (tc == null) {
            return false;
        }
        tc.requestVisible();
        return true;
    }

    public void userTriggeredAutoSlideOut() {
        this.selModel.setSelectedIndex(-1);
    }

    public Rectangle getTabBounds(int tabIndex) {
        SlidingButton button = this.getButton(tabIndex);
        if (button == null) {
            return null;
        }
        Insets insets = this.getInsets();
        Point leftTop = new Point(insets.left, insets.top);
        Dimension strutPrefSize = this.createStrut().getPreferredSize();
        if (this.dataModel.getOrientation() == 3) {
            for (int i = 0; i < tabIndex; ++i) {
                leftTop.x += this.getButton((int)i).getPreferredSize().width;
                leftTop.x += strutPrefSize.width;
            }
        } else {
            for (int i = 0; i < tabIndex; ++i) {
                leftTop.y += this.getButton((int)i).getPreferredSize().height;
                leftTop.y += strutPrefSize.height;
            }
        }
        return new Rectangle(leftTop, button.getPreferredSize());
    }

    public Tabbed getTabbed() {
        return this.tabbed;
    }

    public Object getOrientation(Component comp) {
        if (WindowManagerImpl.getInstance().getEditorAreaState() != 0) {
            return TabDisplayer.ORIENTATION_INVISIBLE;
        }
        return TabDisplayer.ORIENTATION_CENTER;
    }

    public boolean inMaximizedMode(Component comp) {
        return TabbedAdapter.isInMaximizedMode(comp);
    }

    Component getSlidedComp() {
        return this.commandMgr.getSlidedComp();
    }

    void setActive(boolean active) {
        this.active = active;
        this.commandMgr.setActive(active);
    }

    boolean isActive() {
        return this.active;
    }

    boolean isHoveringAllowed() {
        return !this.isActive() || !this.commandMgr.isCompSlided();
    }

    int getButtonIndex(Component button) {
        return this.buttons.indexOf(button);
    }

    SlidingButton getButton(int index) {
        return this.buttons.get(index);
    }

    boolean containsComp(Component comp) {
        List tabs = this.getModel().getTabs();
        TabData curTab2 = null;
        for (TabData curTab2 : tabs) {
            if (!comp.equals(curTab2.getComponent())) continue;
            return true;
        }
        return false;
    }

    private Component createStrut() {
        return this.dataModel.getOrientation() == 3 ? SlideBar.createHorizontalStrut(5) : SlideBar.createVerticalStrut(5);
    }

    private void syncWithModel() {
        assert (SwingUtilities.isEventDispatchThread());
        HashSet<TabData> blinks = null;
        for (SlidingButton curr : this.buttons) {
            if (curr.isBlinking()) {
                if (blinks == null) {
                    blinks = new HashSet<TabData>();
                }
                blinks.add(curr.getData());
            }
            this.gestureRecognizer.detachButton((AbstractButton)curr);
        }
        this.removeAll();
        this.buttons.clear();
        List dataList = this.dataModel.getTabs();
        for (TabData td : dataList) {
            SlidingButton curButton = new SlidingButton(td, this.dataModel.getOrientation());
            if (blinks != null && blinks.contains(td)) {
                curButton.setBlinking(true);
            }
            this.gestureRecognizer.attachButton((AbstractButton)curButton);
            this.buttons.add(curButton);
            this.add((Component)curButton);
            this.add(this.createStrut());
        }
        this.commandMgr.syncWithModel();
        this.revalidate();
        this.repaint();
    }
}

