/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.tabcontrol;

import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.windows.Debug;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.ActionUtils;
import org.netbeans.core.windows.view.ui.Tabbed;
import org.netbeans.core.windows.view.ui.slides.SlideController;
import org.netbeans.swing.tabcontrol.ComponentConverter;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.TabbedContainer;
import org.netbeans.swing.tabcontrol.WinsysInfoForTabbed;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;
import org.netbeans.swing.tabcontrol.plaf.EqualPolygon;
import org.openide.util.ChangeSupport;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public class TabbedAdapter
extends TabbedContainer
implements Tabbed,
Tabbed.Accessor,
SlideController {
    public static final int DOCUMENT = 1;
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private static final boolean DEBUG = Debug.isLoggable(TabbedAdapter.class);
    private PropertyChangeListener tooltipListener;
    private PropertyChangeListener weakTooltipListener;

    public TabbedAdapter(int type) {
        super(null, type, (WinsysInfoForTabbed)new WinsysInfo());
        this.getSelectionModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                int idx = TabbedAdapter.this.getSelectionModel().getSelectedIndex();
                if (idx != -1) {
                    TabbedAdapter.this.fireStateChanged();
                }
            }
        });
    }

    public void addTopComponent(String name, Icon icon, TopComponent tc, String toolTip) {
        this.insertComponent(name, icon, (Component)tc, toolTip, this.getTabCount());
    }

    public TopComponent getTopComponentAt(int index) {
        if (index == -1) {
            return null;
        }
        return (TopComponent)this.getModel().getTab(index).getComponent();
    }

    public TopComponent getSelectedTopComponent() {
        int i = this.getSelectionModel().getSelectedIndex();
        return i == -1 ? null : this.getTopComponentAt(i);
    }

    public void requestAttention(TopComponent tc) {
        int idx = this.indexOf((Component)tc);
        if (idx >= 0) {
            this.requestAttention(idx);
        } else {
            Logger.getAnonymousLogger().fine("RequestAttention on component unknown to container: " + tc);
        }
    }

    public void cancelRequestAttention(TopComponent tc) {
        int idx = this.indexOf((Component)tc);
        if (idx < 0) {
            throw new IllegalArgumentException("TopComponent " + tc + " is not a child of this container");
        }
        this.cancelRequestAttention(idx);
    }

    public void insertComponent(String name, Icon icon, Component comp, String toolTip, int position) {
        TabData td = new TabData((Object)comp, icon, name, toolTip);
        if (DEBUG) {
            TabbedAdapter.debugLog("InsertTab: " + name + " hash:" + System.identityHashCode(comp));
        }
        this.getModel().addTab(position, td);
        comp.addPropertyChangeListener("ToolTipText", this.getTooltipListener(comp));
    }

    public void setSelectedComponent(Component comp) {
        int i = this.indexOf(comp);
        if (i == -1) {
            throw new IllegalArgumentException("Component not a child of this control: " + comp);
        }
        this.getSelectionModel().setSelectedIndex(i);
    }

    public TopComponent[] getTopComponents() {
        ComponentConverter cc = this.getComponentConverter();
        TabData[] td = this.getModel().getTabs().toArray(new TabData[0]);
        TopComponent[] result = new TopComponent[this.getModel().size()];
        for (int i = 0; i < td.length; ++i) {
            result[i] = (TopComponent)cc.getComponent(td[i]);
        }
        return result;
    }

    public void removeComponent(Component comp) {
        int i = this.indexOf(comp);
        this.getModel().removeTab(i);
        comp.removePropertyChangeListener("ToolTipText", this.getTooltipListener(comp));
        if (this.getModel().size() == 0) {
            this.revalidate();
            this.repaint();
        }
    }

    public void addComponents(Component[] comps, String[] names, Icon[] icons, String[] tips) {
        ArrayList al = new ArrayList(comps.length);
        TabData[] data = new TabData[comps.length];
        for (int i = 0; i < comps.length; ++i) {
            TabData td;
            data[i] = td = new TabData((Object)comps[i], icons[i], names[i], tips[i]);
            comps[i].addPropertyChangeListener("ToolTipText", this.getTooltipListener(comps[i]));
        }
        this.getModel().addTabs(0, data);
    }

    public void setTopComponents(TopComponent[] tcs, TopComponent selected) {
        assert (selected != null) : "Null passed as component to select";
        int sizeBefore = this.getModel().size();
        this.detachTooltipListeners(this.getModel().getTabs());
        TabData[] data = new TabData[tcs.length];
        int toSelect = -1;
        for (int i = 0; i < tcs.length; ++i) {
            TopComponent tc = tcs[i];
            Image icon = tc.getIcon();
            String displayName = WindowManagerImpl.getInstance().getTopComponentDisplayName(tc);
            data[i] = new TabData((Object)tc, (Icon)(icon == null ? null : new ImageIcon(icon)), displayName == null ? "" : displayName, tc.getToolTipText());
            if (selected == tcs[i]) {
                toSelect = i;
            }
            tc.addPropertyChangeListener("ToolTipText", this.getTooltipListener((Component)tc));
        }
        assert (toSelect != -1) : "Tried to set a selected component that was  not in the array of open components. ToSelect: " + selected + " ToSelectName=" + selected.getDisplayName() + " ToSelectClass=" + selected.getClass() + " open components: " + Arrays.asList(tcs);
        this.getModel().setTabs(data);
        if (toSelect != -1) {
            this.getSelectionModel().setSelectedIndex(toSelect);
        } else {
            Logger.getAnonymousLogger().warning("Tried toset a selected component that was not in the array of open components.  ToSelect: " + selected + " components: " + Arrays.asList(tcs));
        }
        int sizeNow = this.getModel().size();
        if (sizeBefore != 0 && sizeNow == 0) {
            this.revalidate();
            this.repaint();
        }
    }

    private void detachTooltipListeners(List tabs) {
        Iterator iter = tabs.iterator();
        while (iter.hasNext()) {
            JComponent curComp = (JComponent)((TabData)iter.next()).getComponent();
            curComp.removePropertyChangeListener("ToolTipText", this.getTooltipListener(curComp));
        }
    }

    public Object getConstraintForLocation(Point location, boolean attachingPossible) {
        String s;
        int tab = this.tabForCoordinate(location);
        if (tab != -1) {
            int index = this.dropIndexOfPoint(location);
            return index < 0 ? null : Integer.valueOf(index);
        }
        if (attachingPossible && (s = this.getSideForLocation(location)) != null) {
            return s;
        }
        int index = this.dropIndexOfPoint(location);
        return index < 0 ? null : Integer.valueOf(index);
    }

    public Shape getIndicationForLocation(Point location, TopComponent startingTransfer, Point startingPoint, boolean attachingPossible) {
        Shape s;
        Rectangle rect = this.getBounds();
        rect.setLocation(0, 0);
        int tab = this.tabForCoordinate(location);
        if (tab != -1 && (s = this.getDropIndication(startingTransfer, location)) != null) {
            return s;
        }
        String side = attachingPossible ? this.getSideForLocation(location) : null;
        double ratio = 0.25;
        if (side == "top") {
            return new Rectangle(0, 0, rect.width, (int)((double)rect.height * ratio));
        }
        if (side == "left") {
            return new Rectangle(0, 0, (int)((double)rect.width * ratio), rect.height);
        }
        if (side == "right") {
            return new Rectangle(rect.width - (int)((double)rect.width * ratio), 0, (int)((double)rect.width * ratio), rect.height);
        }
        if (side == "bottom") {
            return new Rectangle(0, rect.height - (int)((double)rect.height * ratio), rect.width, (int)((double)rect.height * ratio));
        }
        Shape s2 = this.getDropIndication(startingTransfer, location);
        if (s2 != null) {
            return s2;
        }
        if (startingPoint != null && this.indexOf((Component)startingTransfer) != -1) {
            return this.getStartingIndication(startingPoint, location);
        }
        return rect;
    }

    private String getSideForLocation(Point location) {
        Rectangle top;
        int LEFT_WIDTH;
        Rectangle bounds = this.getBounds();
        bounds.setLocation(0, 0);
        int TOP_HEIGHT = 10;
        int BOTTOM_HEIGHT = (int)(0.25 * (double)bounds.height);
        int RIGHT_WIDTH = LEFT_WIDTH = Math.max(this.getWidth() / 8, 40);
        if (DEBUG) {
            TabbedAdapter.debugLog("");
            TabbedAdapter.debugLog("TOP_HEIGHT    =10");
            TabbedAdapter.debugLog("BOTTOM_HEIGHT =" + BOTTOM_HEIGHT);
            TabbedAdapter.debugLog("LEFT_WIDTH    =" + LEFT_WIDTH);
            TabbedAdapter.debugLog("RIGHT_WIDTH   =" + RIGHT_WIDTH);
        }
        if ((top = new Rectangle(0, 0, bounds.width, BOTTOM_HEIGHT)).contains(location)) {
            return "top";
        }
        EqualPolygon left = new EqualPolygon(new int[]{0, LEFT_WIDTH, LEFT_WIDTH, 0}, new int[]{10, 10, bounds.height - BOTTOM_HEIGHT, bounds.height}, 4);
        if (left.contains(location)) {
            return "left";
        }
        EqualPolygon right = new EqualPolygon(new int[]{bounds.width - RIGHT_WIDTH, bounds.width, bounds.width, bounds.width - RIGHT_WIDTH}, new int[]{10, 10, bounds.height, bounds.height - BOTTOM_HEIGHT}, 4);
        if (right.contains(location)) {
            return "right";
        }
        EqualPolygon bottom = new EqualPolygon(new int[]{LEFT_WIDTH, bounds.width - RIGHT_WIDTH, bounds.width, 0}, new int[]{bounds.height - BOTTOM_HEIGHT, bounds.height - BOTTOM_HEIGHT, bounds.height, bounds.height}, 4);
        if (bottom.contains(location)) {
            return "bottom";
        }
        return null;
    }

    private Shape getStartingIndication(Point startingPoint, Point location) {
        Rectangle rect = this.getBounds();
        rect.setLocation(location.x - startingPoint.x, location.y - startingPoint.y);
        return rect;
    }

    public void addChangeListener(ChangeListener listener) {
        this.cs.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.cs.removeChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStateChanged() {
        if (!SwingUtilities.isEventDispatchThread()) {
            Logger.getAnonymousLogger().warning("All state changes to the tab component must happen on the event thread!");
            Exception e = new Exception();
            e.fillInStackTrace();
            Logger.getAnonymousLogger().warning(e.getStackTrace()[1].toString());
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            this.cs.fireChange();
        }
    }

    private static void debugLog(String message) {
        Debug.log(TabbedAdapter.class, message);
    }

    public Component getComponent() {
        return this;
    }

    public Action[] getPopupActions(Action[] defaultActions, int tabIndex) {
        boolean isDocked = WindowManagerImpl.getInstance().isDocked(this.getTopComponentAt(tabIndex));
        if (1 == this.getType() || !isDocked) {
            return defaultActions;
        }
        int actionCount = defaultActions.length;
        Action[] result = new Action[actionCount + 1];
        System.arraycopy(defaultActions, 0, result, 0, actionCount);
        if (actionCount > 0) {
            result[actionCount] = result[actionCount - 1];
            result[actionCount - 1] = new ActionUtils.AutoHideWindowAction(this, tabIndex, false);
        }
        return result;
    }

    public static boolean isInMaximizedMode(Component comp) {
        ModeImpl maxMode = WindowManagerImpl.getInstance().getCurrentMaximizedMode();
        if (maxMode == null) {
            return false;
        }
        return maxMode.containsTopComponent((TopComponent)comp);
    }

    public void userToggledAutoHide(int tabIndex, boolean enabled) {
        this.postActionEvent(new TabActionEvent((Object)this, "enableAutoHide", tabIndex));
    }

    public Tabbed getTabbed() {
        return this;
    }

    public Rectangle getTabBounds(int tabIndex) {
        return this.getTabRect(tabIndex, new Rectangle());
    }

    private PropertyChangeListener getTooltipListener(Component comp) {
        if (this.tooltipListener == null) {
            this.tooltipListener = new ToolTipListener();
            this.weakTooltipListener = WeakListeners.propertyChange((PropertyChangeListener)this.tooltipListener, (Object)comp);
        }
        return this.weakTooltipListener;
    }

    private class ToolTipListener
    implements PropertyChangeListener {
        private ToolTipListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("ToolTipText".equals(evt.getPropertyName())) {
                List tabs = TabbedAdapter.this.getModel().getTabs();
                int index = 0;
                Iterator iter = tabs.iterator();
                while (iter.hasNext()) {
                    JComponent curComp = (JComponent)((TabData)iter.next()).getComponent();
                    if (curComp == evt.getSource()) {
                        TabbedAdapter.this.setToolTipTextAt(index, (String)evt.getNewValue());
                        break;
                    }
                    ++index;
                }
            }
        }
    }

    static class WinsysInfo
    implements WinsysInfoForTabbed {
        WinsysInfo() {
        }

        public Object getOrientation(Component comp) {
            WindowManagerImpl wmi = WindowManagerImpl.getInstance();
            if (!wmi.isDocked((TopComponent)comp)) {
                return TabDisplayer.ORIENTATION_INVISIBLE;
            }
            String side = wmi.guessSlideSide((TopComponent)comp);
            Object result = null;
            result = side.equals("left") ? TabDisplayer.ORIENTATION_WEST : (side.equals("right") ? TabDisplayer.ORIENTATION_EAST : (side.equals("bottom") ? TabDisplayer.ORIENTATION_SOUTH : TabDisplayer.ORIENTATION_CENTER));
            return result;
        }

        public boolean inMaximizedMode(Component comp) {
            return TabbedAdapter.isInMaximizedMode(comp);
        }
    }
}

