/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.toolbars;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.services.ToolbarFolderNode;
import org.netbeans.core.windows.view.ui.toolbars.ActionsTree;
import org.netbeans.core.windows.view.ui.toolbars.ResetToolbarsAction;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarConfiguration;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;
import org.openide.awt.ToolbarPool;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.NewType;

public class ConfigureToolbarPanel
extends JPanel
implements Runnable {
    private static WeakReference<Dialog> dialogRef;
    private Node root;
    private boolean firstTimeInit = true;
    private JButton btnNewToolbar;
    private JButton btnReset;
    private JCheckBox checkSmallIcons;
    private JLabel lblHint;
    private JPanel palettePanel;

    private ConfigureToolbarPanel() {
        this.initComponents();
        this.setCursor(Cursor.getPredefinedCursor(3));
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        FileObject paletteFolder = fs.findResource("Actions");
        DataFolder df = DataFolder.findFolder((FileObject)paletteFolder);
        this.root = new FolderActionNode((Node)new AbstractNode(df.createNodeChildren((DataFilter)new ActionIconDataFilter())));
        JLabel lblWait = new JLabel(ConfigureToolbarPanel.getBundleString("LBL_PleaseWait"));
        lblWait.setHorizontalAlignment(0);
        this.palettePanel.setPreferredSize(new Dimension(440, 350));
        this.palettePanel.add(lblWait);
        this.getAccessibleContext().setAccessibleDescription(ConfigureToolbarPanel.getBundleString("ACSD_ToolbarCustomizer"));
    }

    public void run() {
        ActionsTree tree = new ActionsTree(this.root);
        tree.getAccessibleContext().setAccessibleDescription(ConfigureToolbarPanel.getBundleString("ACSD_ActionsTree"));
        tree.getAccessibleContext().setAccessibleName(ConfigureToolbarPanel.getBundleString("ACSN_ActionsTree"));
        this.palettePanel.removeAll();
        this.palettePanel.setBorder(BorderFactory.createEmptyBorder());
        JScrollPane scrollPane = new JScrollPane(tree);
        scrollPane.getVerticalScrollBar().getAccessibleContext().setAccessibleName(ConfigureToolbarPanel.getBundleString("ACSN_ActionsScrollBar"));
        scrollPane.getVerticalScrollBar().getAccessibleContext().setAccessibleDescription(ConfigureToolbarPanel.getBundleString("ACSD_ActionsScrollBar"));
        this.palettePanel.add((Component)scrollPane, "Center");
        this.lblHint.setLabelFor(tree);
        this.invalidate();
        this.validate();
        this.repaint();
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static void showConfigureDialog() {
        Dialog dialog = null;
        if (dialogRef != null) {
            dialog = (Dialog)dialogRef.get();
        }
        if (dialog == null) {
            JButton closeButton = new JButton();
            closeButton.getAccessibleContext().setAccessibleDescription(ConfigureToolbarPanel.getBundleString("ACSD_Close"));
            Mnemonics.setLocalizedText((AbstractButton)closeButton, (String)ConfigureToolbarPanel.getBundleString("CTL_Close"));
            DialogDescriptor dd = new DialogDescriptor((Object)new ConfigureToolbarPanel(), ConfigureToolbarPanel.getBundleString("CustomizerTitle"), false, new Object[]{closeButton}, (Object)closeButton, 0, null, null);
            dialog = DialogDisplayer.getDefault().createDialog(dd);
            dialogRef = new WeakReference<Dialog>(dialog);
        }
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                ConfigureToolbarPanel.endToolbarEditMode();
            }
        });
        dialog.setVisible(true);
        ConfigureToolbarPanel.startToolbarEditMode();
    }

    static void startToolbarEditMode() {
        ToolbarPool.getDefault().putClientProperty((Object)"editMode", new Object());
    }

    static void endToolbarEditMode() {
        ToolbarPool.getDefault().putClientProperty((Object)"editMode", null);
        DataFolder folder = ToolbarPool.getDefault().getFolder();
        DataObject[] children = folder.getChildren();
        for (int i = 0; i < children.length; ++i) {
            final DataFolder subFolder = (DataFolder)children[i].getCookie(DataFolder.class);
            if (null == subFolder || subFolder.getChildren().length != 0) continue;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        subFolder.delete();
                    }
                    catch (IOException e) {
                        Logger.getLogger(ConfigureToolbarPanel.class.getName()).log(Level.WARNING, null, e);
                    }
                }
            });
        }
    }

    static final String getBundleString(String bundleStr) {
        return NbBundle.getMessage(ConfigureToolbarPanel.class, (String)bundleStr);
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.firstTimeInit) {
            this.firstTimeInit = false;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Node[] categories = ConfigureToolbarPanel.this.root.getChildren().getNodes(true);
                    for (int i = 0; i < categories.length; ++i) {
                        categories[i].getChildren().getNodes(true);
                    }
                    SwingUtilities.invokeLater(ConfigureToolbarPanel.this);
                }
            });
        }
    }

    private void initComponents() {
        this.lblHint = new JLabel();
        this.palettePanel = new JPanel();
        this.checkSmallIcons = new JCheckBox();
        this.btnNewToolbar = new JButton();
        this.btnReset = new JButton();
        FormListener formListener = new FormListener();
        this.setLayout(new GridBagLayout());
        this.setMinimumSize(new Dimension(453, 68));
        Mnemonics.setLocalizedText((JLabel)this.lblHint, (String)ConfigureToolbarPanel.getBundleString("CTL_TreeLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 1, 10);
        this.add((Component)this.lblHint, gridBagConstraints);
        this.palettePanel.setLayout(new BorderLayout());
        this.palettePanel.setBorder(BorderFactory.createEtchedBorder());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 10, 5, 10);
        this.add((Component)this.palettePanel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.checkSmallIcons, (String)ConfigureToolbarPanel.getBundleString("CTL_SmallIcons"));
        this.checkSmallIcons.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.checkSmallIcons.setMargin(new Insets(0, 0, 0, 0));
        this.checkSmallIcons.setSelected(ToolbarPool.getDefault().getPreferredIconSize() == 16);
        this.checkSmallIcons.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.checkSmallIcons, gridBagConstraints);
        this.checkSmallIcons.getAccessibleContext().setAccessibleDescription(ConfigureToolbarPanel.getBundleString("ACSD_SmallIcons"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnNewToolbar, (String)ConfigureToolbarPanel.getBundleString("CTL_NewToolbar"));
        this.btnNewToolbar.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.btnNewToolbar, gridBagConstraints);
        this.btnNewToolbar.getAccessibleContext().setAccessibleDescription(ConfigureToolbarPanel.getBundleString("ACSD_NewToolbar"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnReset, (String)ConfigureToolbarPanel.getBundleString("CTL_ResetToolbarsButton"));
        this.btnReset.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.btnReset, gridBagConstraints);
    }

    private void resetToolbars(ActionEvent evt) {
        new ResetToolbarsAction().actionPerformed(evt);
    }

    private void newToolbar(ActionEvent evt) {
        ToolbarFolderNode tf = new ToolbarFolderNode();
        NewType[] newTypes = tf.getNewTypes();
        if (null != newTypes && newTypes.length > 0) {
            try {
                newTypes[0].create();
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    private void switchIconSize(ActionEvent evt) {
        boolean state = this.checkSmallIcons.isSelected();
        if (state) {
            ToolbarPool.getDefault().setPreferredIconSize(16);
        } else {
            ToolbarPool.getDefault().setPreferredIconSize(24);
        }
        String name = ToolbarPool.getDefault().getConfiguration();
        ToolbarConfiguration tbConf = ToolbarConfiguration.findConfiguration(name);
        if (tbConf != null) {
            tbConf.refresh();
        }
    }

    private static class ActionIconDataFilter
    implements DataFilter {
        private InstanceCookie instanceCookie;

        private ActionIconDataFilter() {
        }

        public boolean acceptDataObject(DataObject obj) {
            this.instanceCookie = (InstanceCookie)obj.getCookie(InstanceCookie.class);
            if (null != this.instanceCookie) {
                block12: {
                    try {
                        Object instance = this.instanceCookie.instanceCreate();
                        if (null == instance) break block12;
                        if (instance instanceof Action) {
                            Action action = (Action)instance;
                            try {
                                if (null == action.getValue("iconBase")) {
                                    return false;
                                }
                                break block12;
                            }
                            catch (AssertionError aE) {}
                            break block12;
                        }
                        if (instance instanceof JSeparator) {
                            return false;
                        }
                    }
                    catch (Throwable e) {
                        Logger.getLogger(ConfigureToolbarPanel.class.getName()).log(Level.WARNING, null, e);
                    }
                }
                return true;
            }
            FileObject fo = obj.getPrimaryFile();
            if (fo.isFolder()) {
                boolean hasChildWithIcon = false;
                FileObject[] children = fo.getChildren();
                for (int i = 0; i < children.length; ++i) {
                    DataObject child = null;
                    try {
                        child = DataObject.find((FileObject)children[i]);
                    }
                    catch (DataObjectNotFoundException e) {
                        continue;
                    }
                    if (null == child || !this.acceptDataObject(child)) continue;
                    hasChildWithIcon = true;
                    break;
                }
                return hasChildWithIcon;
            }
            return true;
        }
    }

    private static class FolderActionNode
    extends FilterNode {
        public FolderActionNode(Node original) {
            super(original, (Children)new MyChildren(original));
        }

        public String getDisplayName() {
            return Actions.cutAmpersand((String)super.getDisplayName());
        }

        public Transferable drag() throws IOException {
            return Node.EMPTY.drag();
        }

        public Transferable clipboardCut() throws IOException {
            return Node.EMPTY.clipboardCut();
        }

        public Transferable clipboardCopy() throws IOException {
            return Node.EMPTY.clipboardCopy();
        }

        private static class MyChildren
        extends FilterNode.Children {
            public MyChildren(Node original) {
                super(original);
            }

            protected Node copyNode(Node node) {
                DataFolder df = (DataFolder)node.getCookie(DataFolder.class);
                if (null == df) {
                    return new ItemActionNode(node);
                }
                return new FolderActionNode(node);
            }
        }
    }

    private class FormListener
    implements ActionListener {
        FormListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == ConfigureToolbarPanel.this.checkSmallIcons) {
                ConfigureToolbarPanel.this.switchIconSize(evt);
            } else if (evt.getSource() == ConfigureToolbarPanel.this.btnNewToolbar) {
                ConfigureToolbarPanel.this.newToolbar(evt);
            } else if (evt.getSource() == ConfigureToolbarPanel.this.btnReset) {
                ConfigureToolbarPanel.this.resetToolbars(evt);
            }
        }
    }

    private static class ItemActionNode
    extends FilterNode {
        private static DataFlavor nodeDataFlavor = new DataFlavor(Node.class, "Action Node");

        public ItemActionNode(Node original) {
            super(original, FilterNode.Children.LEAF);
        }

        public Transferable drag() throws IOException {
            return new ExTransferable.Single(nodeDataFlavor){

                public Object getData() {
                    return ItemActionNode.this;
                }
            };
        }

        public String getDisplayName() {
            return Actions.cutAmpersand((String)super.getDisplayName());
        }
    }
}

