/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.toolbars;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarConfiguration;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarConstraints;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarRow;
import org.openide.awt.Toolbar;
import org.openide.awt.ToolbarPool;
import org.openide.windows.WindowManager;

public class ToolbarLayout
implements LayoutManager2,
Serializable {
    public static final int HGAP = 1;
    public static final int VGAP = 1;
    static final long serialVersionUID = 7489472539255790677L;
    ToolbarConfiguration toolbarConfig;
    HashMap<Component, Object> componentMap;

    public ToolbarLayout(ToolbarConfiguration conf) {
        this.toolbarConfig = conf;
        this.componentMap = new HashMap();
    }

    public void addLayoutComponent(String name, Component comp) {
        throw new IllegalArgumentException();
    }

    public void addLayoutComponent(Component comp, Object constr) {
        if (!(constr instanceof ToolbarConstraints)) {
            throw new IllegalArgumentException(ToolbarConfiguration.getBundleString("EXC_wrongConstraints"));
        }
        this.componentMap.put(comp, constr);
        ToolbarConstraints tc = (ToolbarConstraints)constr;
        tc.setPreferredSize(comp.getPreferredSize());
        comp.setVisible(tc.isVisible());
    }

    public void removeLayoutComponent(Component comp) {
        this.componentMap.remove(comp);
    }

    public Dimension preferredLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        Dimension prefSize = new Dimension(insets.left + this.toolbarConfig.getPrefWidth() + insets.right, insets.top + this.toolbarConfig.getPrefHeight() + insets.bottom);
        return prefSize;
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public Dimension maximumLayoutSize(Container parent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container parent) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container parent) {
        return 0.0f;
    }

    public void invalidateLayout(Container parent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = WindowManager.getDefault().getMainWindow().getInsets();
            Frame f = WindowManager.getDefault().getMainWindow();
            int maxPosition = (f.getExtendedState() & 6) == 6 ? f.getWidth() - 1 : f.getWidth() - (insets.left + insets.right) - 1;
            Iterator<Component> it = this.componentMap.keySet().iterator();
            while (it.hasNext()) {
                Component comp = it.next();
                ToolbarConstraints constr = (ToolbarConstraints)this.componentMap.get(comp);
                constr.updatePreferredSize(comp.getPreferredSize());
            }
            HashSet<ToolbarConstraints> completed = new HashSet<ToolbarConstraints>(this.componentMap.size() * 2);
            for (int i = 0; i < this.toolbarConfig.getRowCount(); ++i) {
                ToolbarConstraints overflownTC = this.processRow(this.toolbarConfig.getRow(i), completed, maxPosition);
                Iterator<ToolbarConstraints> iter = this.toolbarConfig.getRow(i).iterator();
                while (it.hasNext()) {
                    completed.add(iter.next());
                }
            }
            parent.repaint();
        }
    }

    private ToolbarConstraints processRow(ToolbarRow row, Collection completed, int maxPosition) {
        ArrayList<ToolbarConstraints> moveDownCandidates = new ArrayList<ToolbarConstraints>(5);
        Iterator<ToolbarConstraints> it = row.iterator();
        while (it.hasNext()) {
            ToolbarConstraints constr = it.next();
            if (completed.contains(constr)) continue;
            Toolbar comp = ToolbarPool.getDefault().findToolbar(constr.getName());
            Rectangle bounds = constr.getBounds();
            if (bounds.x < maxPosition && bounds.x + bounds.width > maxPosition) {
                bounds.width = maxPosition - bounds.x;
                comp.setBounds(bounds);
                continue;
            }
            if (constr.getPosition() > maxPosition + 1) {
                if (constr.isAlone() || row.toolbarCount() - moveDownCandidates.size() <= 1) continue;
                moveDownCandidates.add(constr);
                continue;
            }
            comp.setBounds(bounds);
        }
        Iterator iter = moveDownCandidates.iterator();
        while (iter.hasNext()) {
            this.moveToolbarDown((ToolbarConstraints)iter.next());
        }
        return null;
    }

    private void moveToolbarDown(ToolbarConstraints constr) {
        int pos = constr.rowIndex() + 1;
        constr.destroy();
        for (int i = pos; i < pos + constr.getRowCount(); ++i) {
            this.toolbarConfig.getRow(i).addToolbar(constr, 0);
        }
        constr.setPosition(0);
        constr.updatePosition();
    }
}

