/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.toolbars;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.Vector;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarConfiguration;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarConstraints;
import org.openide.awt.Toolbar;
import org.openide.awt.ToolbarPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolbarRow {
    ToolbarConfiguration toolbarConfig;
    ToolbarRow prevRow;
    ToolbarRow nextRow;
    private Vector<ToolbarConstraints> toolbars;
    private PropertyChangeListener constraintsL;
    private int prefHeight;

    ToolbarRow(ToolbarConfiguration config) {
        this.toolbarConfig = config;
        this.toolbars = new Vector();
        this.nextRow = null;
        this.prevRow = null;
        this.constraintsL = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("preferredSize".equals(evt.getPropertyName())) {
                    Dimension oldTCSize = (Dimension)evt.getOldValue();
                    Dimension newTCSize = (Dimension)evt.getNewValue();
                    if (oldTCSize.height != newTCSize.height) {
                        ToolbarRow.this.updateRowsBelow();
                    }
                }
            }
        };
    }

    void addToolbar(ToolbarConstraints tc) {
        this.addToolbar2(tc, this.toolbars.size());
    }

    void addToolbar(ToolbarConstraints newTC, int pos) {
        int index = newTC.checkInitialIndexInRow();
        if (index >= 0) {
            index = Math.min(index, this.toolbars.size());
        } else {
            index = 0;
            for (ToolbarConstraints tc : this.toolbars) {
                if (pos <= tc.getPosition()) break;
                ++index;
            }
        }
        this.addToolbar2(newTC, index);
    }

    private void addToolbar2(ToolbarConstraints tc, int index) {
        if (this.toolbars.contains(tc)) {
            return;
        }
        ToolbarConstraints prev = null;
        ToolbarConstraints next = null;
        if (index != 0) {
            prev = this.toolbars.elementAt(index - 1);
            prev.addNextBar(tc);
            tc.addPrevBar(prev);
        }
        if (index < this.toolbars.size()) {
            next = this.toolbars.elementAt(index);
            tc.addNextBar(next);
            next.addPrevBar(tc);
        }
        if (prev != null && next != null) {
            prev.removeNextBar(next);
            next.removePrevBar(prev);
        }
        int oldHeight = this.getPreferredHeight();
        tc.addOwnRow(this);
        this.toolbars.insertElementAt(tc, index);
        tc.updatePosition();
        tc.addPropertyChangeListener(this.constraintsL);
    }

    void removeToolbar(ToolbarConstraints tc) {
        int index = this.toolbars.indexOf(tc);
        ToolbarConstraints prev = null;
        ToolbarConstraints next = null;
        try {
            prev = this.toolbars.elementAt(index - 1);
            prev.removeNextBar(tc);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            next = this.toolbars.elementAt(index + 1);
            next.removePrevBar(tc);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        if (prev != null && next != null) {
            prev.addNextBar(next);
            next.addPrevBar(prev);
        }
        this.toolbars.removeElement(tc);
        if (prev != null) {
            prev.updatePosition();
        } else if (next != null) {
            next.updatePosition();
        }
        tc.removePropertyChangeListener(this.constraintsL);
    }

    Iterator<ToolbarConstraints> iterator() {
        return this.toolbars.iterator();
    }

    void setPrevRow(ToolbarRow prev) {
        this.prevRow = prev;
    }

    ToolbarRow getPrevRow() {
        return this.prevRow;
    }

    void setNextRow(ToolbarRow next) {
        this.nextRow = next;
    }

    ToolbarRow getNextRow() {
        return this.nextRow;
    }

    int getPrefWidth() {
        if (this.toolbars.isEmpty()) {
            return -1;
        }
        return this.toolbars.lastElement().getPrefWidth();
    }

    boolean isEmpty() {
        return this.toolbars.isEmpty();
    }

    int toolbarCount() {
        return this.toolbars.size();
    }

    void updateBounds() {
        for (ToolbarConstraints tc : this.toolbars) {
            tc.updateBounds();
        }
    }

    private void updateRowsBelow() {
        for (int i = this.toolbarConfig.rowIndex(this) + 1; i < this.toolbarConfig.getRowCount(); ++i) {
            this.toolbarConfig.getRow(i).updateBounds();
        }
    }

    void switchBars(ToolbarConstraints left, ToolbarConstraints right) {
        int leftIndex = this.toolbars.indexOf(left);
        int rightIndex = this.toolbars.indexOf(right);
        ToolbarConstraints leftPrev = null;
        ToolbarConstraints rightNext = null;
        try {
            leftPrev = this.toolbars.elementAt(leftIndex - 1);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            rightNext = this.toolbars.elementAt(rightIndex + 1);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        if (leftPrev != null) {
            leftPrev.removeNextBar(left);
        }
        left.removePrevBar(leftPrev);
        left.removeNextBar(right);
        right.removePrevBar(left);
        right.removeNextBar(rightNext);
        if (rightNext != null) {
            rightNext.removePrevBar(right);
        }
        if (leftPrev != null) {
            leftPrev.addNextBar(right);
        }
        left.addPrevBar(right);
        left.addNextBar(rightNext);
        right.addPrevBar(leftPrev);
        right.addNextBar(left);
        if (rightNext != null) {
            rightNext.addPrevBar(left);
        }
        this.toolbars.setElementAt(left, rightIndex);
        this.toolbars.setElementAt(right, leftIndex);
    }

    void trySwitchLeft(ToolbarConstraints tc) {
        int index = this.toolbars.indexOf(tc);
        if (index == 0) {
            return;
        }
        try {
            ToolbarConstraints prev = this.toolbars.elementAt(index - 1);
            if (ToolbarConstraints.canSwitchLeft(tc.getPosition(), tc.getWidth(), prev.getPosition(), prev.getWidth())) {
                this.switchBars(prev, tc);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    void trySwitchRight(ToolbarConstraints tc) {
        int index = this.toolbars.indexOf(tc);
        try {
            ToolbarConstraints next = this.toolbars.elementAt(index + 1);
            if (ToolbarConstraints.canSwitchRight(tc.getPosition(), tc.getWidth(), next.getPosition(), next.getWidth())) {
                this.switchBars(tc, next);
                next.setPosition(tc.getPosition() - next.getWidth() - 1);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    int getPreferredHeight() {
        ToolbarConstraints curConstr2 = null;
        ToolbarPool pool = ToolbarPool.getDefault();
        this.prefHeight = 0;
        int curHeight = 0;
        for (ToolbarConstraints curConstr2 : this.toolbars) {
            Toolbar curToolbar;
            if (curConstr2.getRowCount() != 1 || (curToolbar = pool.findToolbar(curConstr2.getName())) == null || this.prefHeight >= (curHeight = curToolbar.getPreferredSize().height)) continue;
            this.prefHeight = curHeight;
        }
        this.prefHeight = this.prefHeight <= 0 ? Toolbar.getBasicHeight() : Math.min(Toolbar.getBasicHeight(), this.prefHeight);
        return this.prefHeight;
    }

    static class WritableToolbarRow {
        Vector<ToolbarConstraints.WritableToolbar> toolbars = new Vector();

        public WritableToolbarRow() {
        }

        public WritableToolbarRow(ToolbarRow row) {
            this();
            this.initToolbars(row);
        }

        void initToolbars(ToolbarRow r) {
            Iterator it = r.toolbars.iterator();
            while (it.hasNext()) {
                this.toolbars.addElement(new ToolbarConstraints.WritableToolbar((ToolbarConstraints)it.next()));
            }
        }

        void addToolbar(ToolbarConstraints newTC) {
            int index = 0;
            for (ToolbarConstraints.WritableToolbar tc : this.toolbars) {
                if (newTC.getPosition() < tc.position) break;
                ++index;
            }
            this.toolbars.insertElementAt(new ToolbarConstraints.WritableToolbar(newTC), index);
        }

        boolean isEmpty() {
            return this.toolbars.isEmpty();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("  <").append("Row").append(">\n");
            Iterator<ToolbarConstraints.WritableToolbar> it = this.toolbars.iterator();
            while (it.hasNext()) {
                sb.append(((Object)it.next()).toString());
            }
            sb.append("  </").append("Row").append(">\n");
            return sb.toString();
        }
    }
}

