/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.Component;
import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.JComponent;

public final class HelpCtx {
    private static final Logger err = Logger.getLogger("org.openide.util.HelpCtx");
    public static final HelpCtx DEFAULT_HELP = new HelpCtx(HelpCtx.class.getName() + ".DEFAULT_HELP");
    private final URL helpCtx;
    private final String helpID;

    @Deprecated
    public HelpCtx(URL helpCtx) {
        this.helpCtx = helpCtx;
        this.helpID = null;
    }

    public HelpCtx(String helpID) {
        this.helpID = helpID;
        this.helpCtx = null;
    }

    public HelpCtx(Class clazz) {
        this(clazz.getName());
    }

    public URL getHelp() {
        return this.helpCtx;
    }

    public String getHelpID() {
        return this.helpID;
    }

    public int hashCode() {
        int base = HelpCtx.class.hashCode();
        if (this.helpCtx != null) {
            base ^= this.helpCtx.hashCode();
        }
        if (this.helpID != null) {
            base ^= this.helpID.hashCode();
        }
        return base;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof HelpCtx)) {
            return false;
        }
        HelpCtx oo = (HelpCtx)o;
        return (this.helpCtx == oo.helpCtx || this.helpCtx != null && this.helpCtx.equals(oo.helpCtx)) && (this.helpID == oo.helpID || this.helpID != null && this.helpID.equals(oo.helpID));
    }

    public String toString() {
        if (this.helpID != null) {
            return "HelpCtx[" + this.helpID + "]";
        }
        return "HelpCtx[" + this.helpCtx + "]";
    }

    public static void setHelpIDString(JComponent comp, String helpID) {
        err.fine("setHelpIDString: " + helpID + " on " + comp);
        comp.putClientProperty("HelpID", helpID);
    }

    public static HelpCtx findHelp(Component comp) {
        err.fine("findHelp on " + comp);
        while (comp != null) {
            JComponent jc;
            String hid;
            if (comp instanceof Provider) {
                HelpCtx h = ((Provider)((Object)comp)).getHelpCtx();
                err.fine("found help " + h + " through HelpCtx.Provider interface");
                return h;
            }
            if (comp instanceof JComponent && (hid = (String)(jc = (JComponent)comp).getClientProperty("HelpID")) != null) {
                err.fine("found help " + hid + " by client property");
                return new HelpCtx(hid);
            }
            comp = comp.getParent();
            err.fine("no luck, trying parent " + comp);
        }
        err.fine("nothing found");
        return DEFAULT_HELP;
    }

    public static HelpCtx findHelp(Object instance) {
        if (instance instanceof Component) {
            return HelpCtx.findHelp((Component)instance);
        }
        if (instance instanceof Provider) {
            return ((Provider)instance).getHelpCtx();
        }
        try {
            BeanDescriptor d = Introspector.getBeanInfo(instance.getClass()).getBeanDescriptor();
            String v = (String)d.getValue("helpID");
            if (v != null) {
                return new HelpCtx(v);
            }
        }
        catch (IntrospectionException e) {
            err.fine("findHelp on " + instance + ": " + e);
        }
        return DEFAULT_HELP;
    }

    public static interface Provider {
        public HelpCtx getHelpCtx();
    }
}

