/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TopologicalSortException
extends Exception {
    private Collection vertexes;
    private Map edges;
    private Set[] result;
    private int counter;
    private Stack<Vertex> dualGraph = new Stack();

    TopologicalSortException(Collection vertexes, Map edges) {
        this.vertexes = vertexes;
        this.edges = edges;
    }

    public final List partialSort() {
        Set[] all = this.topologicalSets();
        ArrayList res = new ArrayList(this.vertexes.size());
        for (int i = 0; i < all.length; ++i) {
            for (Object e : all[i]) {
                res.add(e);
            }
        }
        return res;
    }

    public final Set[] unsortableSets() {
        Set[] all = this.topologicalSets();
        ArrayList<Set> unsort = new ArrayList<Set>();
        for (int i = 0; i < all.length; ++i) {
            if (all[i].size() <= 1 && all[i] instanceof HashSet) continue;
            unsort.add(all[i]);
        }
        return unsort.toArray(new Set[0]);
    }

    @Override
    public final void printStackTrace(PrintWriter w) {
        w.print("TopologicalSortException - Collection: ");
        w.print(this.vertexes);
        w.print(" with edges ");
        w.print(this.edges);
        w.println(" cannot be sorted");
        Set[] bad = this.unsortableSets();
        for (int i = 0; i < bad.length; ++i) {
            w.print(" Conflict #");
            w.print(i);
            w.print(": ");
            w.println(bad[i]);
        }
        super.printStackTrace(w);
    }

    @Override
    public final void printStackTrace(PrintStream s) {
        PrintWriter w = new PrintWriter(s);
        this.printStackTrace(w);
        w.flush();
    }

    /*
     * WARNING - void declaration
     */
    public final Set[] topologicalSets() {
        if (this.result != null) {
            return this.result;
        }
        HashMap<Object, Vertex> vertexInfo = new HashMap<Object, Vertex>();
        this.counter = 0;
        Iterator<Object> it = this.vertexes.iterator();
        while (it.hasNext()) {
            this.constructDualGraph(this.counter, it.next(), vertexInfo);
        }
        HashMap<Object, void> objectsToSets = new HashMap<Object, void>();
        ArrayList<void> sets = new ArrayList<void>();
        while (!this.dualGraph.isEmpty()) {
            void var6_6;
            Vertex v = this.dualGraph.pop();
            if (v.visited) continue;
            HashSet<Object> hashSet = new HashSet<Object>();
            this.visitDualGraph(v, hashSet);
            if (hashSet.size() == 1 && v.edgesFrom.contains(v)) {
                Set<Object> set = Collections.singleton(v.object);
            }
            sets.add(var6_6);
            it = var6_6.iterator();
            while (it.hasNext()) {
                objectsToSets.put(it.next(), var6_6);
            }
        }
        HashMap edgesBetweenSets = new HashMap();
        for (Map.Entry entry : this.edges.entrySet()) {
            Collection leadsTo = (Collection)entry.getValue();
            if (leadsTo == null || leadsTo.isEmpty()) continue;
            Set from = (Set)objectsToSets.get(entry.getKey());
            ArrayList<Set> setsTo = (ArrayList<Set>)edgesBetweenSets.get(from);
            if (setsTo == null) {
                setsTo = new ArrayList<Set>();
                edgesBetweenSets.put(from, setsTo);
            }
            Iterator convert = leadsTo.iterator();
            while (convert.hasNext()) {
                Set to = (Set)objectsToSets.get(convert.next());
                if (from == to) continue;
                setsTo.add(to);
            }
        }
        try {
            List list = Utilities.topologicalSort(sets, edgesBetweenSets);
            this.result = list.toArray(new Set[0]);
        }
        catch (TopologicalSortException topologicalSortException) {
            throw new IllegalStateException("Cannot happen");
        }
        return this.result;
    }

    private Vertex constructDualGraph(int counter, Object vertex, HashMap<Object, Vertex> vertexInfo) {
        Vertex info = vertexInfo.get(vertex);
        if (info != null) {
            return info;
        }
        info = new Vertex(vertex, counter++);
        vertexInfo.put(vertex, info);
        Collection c = (Collection)this.edges.get(vertex);
        if (c != null) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                Vertex next = this.constructDualGraph(counter, it.next(), vertexInfo);
                next.edgesFrom.add(info);
            }
        }
        info.y = counter++;
        this.dualGraph.push(info);
        return info;
    }

    private void visitDualGraph(Vertex vertex, Collection<Object> visited) {
        if (vertex.visited) {
            return;
        }
        visited.add(vertex.object);
        vertex.visited = true;
        Iterator it = vertex.edges();
        while (it.hasNext()) {
            Vertex v = (Vertex)it.next();
            this.visitDualGraph(v, visited);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Vertex
    implements Comparable<Vertex> {
        public Object object;
        public List<Vertex> edgesFrom = new ArrayList<Vertex>();
        public final int x;
        public int y;
        public boolean sorted;
        public boolean visited;

        public Vertex(Object obj, int x) {
            this.x = x;
            this.object = obj;
        }

        public Iterator edges() {
            if (!this.sorted) {
                Collections.sort(this.edgesFrom);
                this.sorted = true;
            }
            return this.edgesFrom.iterator();
        }

        @Override
        public int compareTo(Vertex o) {
            return o.y - this.y;
        }
    }
}

