/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakSet<E>
extends AbstractSet<E>
implements Cloneable,
Serializable {
    static final long serialVersionUID = 3062376055928236721L;
    private float loadFactor;
    private int size;
    private long modcount;
    private transient ReferenceQueue<E> refq;
    long nullCount;
    private transient Entry<E>[] entries;
    transient Entry<E> iterChain;

    public WeakSet() {
        this(11, 0.75f);
    }

    public WeakSet(Collection<? extends E> c) {
        this();
        this.addAll(c);
    }

    public WeakSet(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public WeakSet(int initialCapacity, float loadFactor) {
        if (initialCapacity <= 0 || loadFactor <= 0.0f) {
            throw new IllegalArgumentException();
        }
        this.size = 0;
        this.modcount = 0L;
        this.loadFactor = loadFactor;
        this.nullCount = 0L;
        this.refq = new ReferenceQueue();
        this.entries = Entry.createArray(initialCapacity);
        this.iterChain = null;
    }

    @Override
    public boolean add(E o) {
        if (o == null) {
            ++this.size;
            ++this.nullCount;
            ++this.modcount;
            return true;
        }
        Entry e = this.object2Entry(o);
        if (e != null) {
            return false;
        }
        ++this.modcount;
        ++this.size;
        int hash = this.hashIt(o);
        Entry<E> next = this.entries[hash];
        this.entries[hash] = new Entry<E>(this, o, this.refq, next, this.iterChain);
        this.iterChain = this.entries[hash];
        this.rehash();
        return true;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i] = null;
        }
        this.nullCount = 0L;
        ++this.modcount;
        this.size = 0;
        this.iterChain = null;
    }

    public Object clone() {
        WeakSet<E> nws = new WeakSet<E>(1, this.loadFactor);
        nws.size = this.size;
        nws.nullCount = this.nullCount;
        Entry<E>[] cloned = Entry.createArray(this.entries.length);
        nws.entries = cloned;
        for (int i = 0; i < cloned.length; ++i) {
            Object ref;
            if (this.entries[i] == null || (ref = this.entries[i].get()) == null) {
                cloned[i] = null;
            } else {
                cloned[i] = this.entries[i] == null ? null : this.entries[i].clone(nws.refq);
                ref = null;
            }
            Entry<E> entry = cloned[i];
            while (entry != null) {
                entry.chainIntoIter(nws.iterChain);
                nws.iterChain = entry;
                entry = entry.next;
            }
        }
        return nws;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return this.nullCount > 0L;
        }
        return this.object2Entry(o) != null;
    }

    @Override
    public boolean isEmpty() {
        return this.nullCount == 0L && this.size() == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new WeakSetIterator();
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            if (this.nullCount > 0L) {
                --this.nullCount;
                ++this.modcount;
                --this.size;
            }
            return true;
        }
        Entry e = this.object2Entry(o);
        if (e != null) {
            ++this.modcount;
            --this.size;
            e.remove();
            this.rehash();
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        this.checkRefQueue();
        return this.size;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        ArrayList<E> list = new ArrayList<E>(array.length);
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list.toArray(array);
    }

    @Override
    public Object[] toArray() {
        ArrayList<E> list = new ArrayList<E>();
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list.toArray();
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator<E> e = this.iterator();
        buf.append("[");
        while (e.hasNext()) {
            buf.append(String.valueOf(e.next()));
            if (!e.hasNext()) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    void checkRefQueue() {
        Entry entry;
        while ((entry = (Entry)Entry.class.cast(this.refq.poll())) != null) {
            entry.remove();
            --this.size;
        }
    }

    long modCount() {
        return this.modcount;
    }

    int hashIt(Object o) {
        return (o.hashCode() & Integer.MAX_VALUE) % this.entries.length;
    }

    void rehash() {
    }

    private Entry object2Entry(Object o) {
        this.checkRefQueue();
        int hash = this.hashIt(o);
        Entry<E> e = this.entries[hash];
        if (e == null) {
            return null;
        }
        while (e != null && !e.equals(o)) {
            e = e.next;
        }
        return e;
    }

    private void writeObject(ObjectOutputStream obtos) throws IOException {
        obtos.defaultWriteObject();
        obtos.writeObject(this.toArray());
    }

    private void readObject(ObjectInputStream obtis) throws IOException, ClassNotFoundException {
        obtis.defaultReadObject();
        Object[] arr = (Object[])obtis.readObject();
        this.entries = new Entry[(int)((double)this.size * 1.5)];
        this.refq = new ReferenceQueue();
        for (int i = 0; i < arr.length; ++i) {
            this.add(arr[i]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Entry<E>
    extends WeakReference<E> {
        private WeakSet<E> set;
        Entry<E> prev;
        Entry<E> next;
        private final int hashcode;
        Entry<E> iterChainNext;
        Entry<E> iterChainPrev;

        Entry(WeakSet<E> set, E referenced, ReferenceQueue<E> q, Entry<E> next, Entry<E> nextInIter) {
            super(referenced, q);
            this.set = set;
            this.next = next;
            this.prev = null;
            if (next != null) {
                next.prev = this;
            }
            this.hashcode = referenced != null ? set.hashIt(referenced) : 0;
            this.chainIntoIter(nextInIter);
        }

        static final <E> Entry<E>[] createArray(int size) {
            return new Entry[size];
        }

        void chainIntoIter(Entry<E> nextInIter) {
            this.iterChainNext = nextInIter;
            if (nextInIter != null) {
                nextInIter.iterChainPrev = this;
                Object ref = nextInIter.get();
                if (ref == null) {
                    nextInIter.remove();
                }
            }
        }

        void remove() {
            if (this.prev != null) {
                this.prev.next = this.next;
            }
            if (this.next != null) {
                this.next.prev = this.prev;
            }
            if (this.iterChainNext != null) {
                this.iterChainNext.iterChainPrev = this.iterChainPrev;
            }
            if (this.iterChainPrev != null) {
                this.iterChainPrev.iterChainNext = this.iterChainNext;
            } else {
                this.set.iterChain = this.iterChainNext;
            }
            if (((WeakSet)this.set).entries[this.hashcode] == this) {
                ((WeakSet)this.set).entries[this.hashcode] = this.next;
            }
            this.prev = null;
            this.next = null;
            this.iterChainNext = null;
            this.iterChainPrev = null;
        }

        public int hashCode() {
            return this.hashcode;
        }

        public boolean equals(Object o) {
            Object oo = this.get();
            if (oo == null) {
                return false;
            }
            return oo.equals(o);
        }

        public Entry<E> clone(ReferenceQueue<E> q) {
            return new Entry<E>(this.set, this.get(), q, this.next != null ? this.next.clone(q) : null, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WeakSetIterator
    implements Iterator<E> {
        Entry<E> current;
        Entry<E> next;
        E currentObj;
        E nextObj;
        final long myModcount;
        long myNullCount;

        WeakSetIterator() {
            this.myModcount = WeakSet.this.modCount();
            this.myNullCount = WeakSet.this.nullCount;
            this.current = null;
            this.next = null;
            Entry ee = WeakSet.this.iterChain;
            if (ee == null) {
                return;
            }
            Object o = ee.get();
            while (ee.isEnqueued()) {
                ee = ee.iterChainNext;
                if (ee == null) {
                    return;
                }
                o = ee.get();
            }
            this.nextObj = o;
            this.next = ee;
        }

        @Override
        public boolean hasNext() {
            this.checkModcount();
            return this.myNullCount > 0L || this.next != null;
        }

        @Override
        public E next() {
            this.checkModcount();
            WeakSet.this.checkRefQueue();
            if (this.myNullCount > 0L) {
                --this.myNullCount;
                return null;
            }
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.current = this.next;
            this.currentObj = this.nextObj;
            do {
                this.next = this.next.iterChainNext;
                if (this.next == null) break;
                this.nextObj = this.next.get();
            } while (this.next.isEnqueued());
            return this.currentObj;
        }

        @Override
        public void remove() {
            this.checkModcount();
            if (this.current == null) {
                throw new IllegalStateException();
            }
            this.current.remove();
            WeakSet.this.size--;
        }

        void checkModcount() {
            if (this.myModcount != WeakSet.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

