/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.EventListenerList;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.WaitableResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyLookup
extends Lookup {
    private static final Lookup[] EMPTY_ARR = new Lookup[0];
    private Object lookups;
    private HashMap<Lookup.Template<?>, Reference<R>> results;

    public ProxyLookup(Lookup ... lookups) {
        this.setLookupsNoFire(lookups);
    }

    protected ProxyLookup() {
        this(EMPTY_ARR);
    }

    public String toString() {
        return "ProxyLookup(class=" + this.getClass() + ")->" + Arrays.asList(this.getLookups(false));
    }

    protected final Lookup[] getLookups() {
        return this.getLookups(true);
    }

    private final Lookup[] getLookups(boolean clone) {
        Object l = this.lookups;
        if (l instanceof Lookup) {
            return new Lookup[]{(Lookup)l};
        }
        Lookup[] arr = (Lookup[])l;
        if (clone) {
            arr = (Lookup[])arr.clone();
        }
        return arr;
    }

    private void setLookupsNoFire(Lookup[] lookups) {
        if (lookups.length == 1) {
            this.lookups = lookups[0];
            assert (this.lookups != null) : "Cannot assign null delegate";
        } else {
            this.lookups = lookups.length == 0 ? EMPTY_ARR : lookups.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setLookups(Lookup ... lookups) {
        ArrayList<Reference<R>> arr;
        ProxyLookup proxyLookup = this;
        synchronized (proxyLookup) {
            Lookup[] old = this.getLookups(false);
            HashSet<Lookup> current = new HashSet<Lookup>(Arrays.asList(old));
            HashSet<Lookup> newL = new HashSet<Lookup>(Arrays.asList(lookups));
            this.setLookupsNoFire(lookups);
            if (this.results == null || this.results.isEmpty()) {
                return;
            }
            arr = new ArrayList<Reference<R>>(this.results.values());
            HashSet<Lookup> removed = new HashSet<Lookup>(current);
            removed.removeAll(newL);
            newL.removeAll(current);
            if (removed.isEmpty() && newL.isEmpty()) {
                return;
            }
            for (Reference reference : arr) {
                R r = (R)reference.get();
                if (r == null) continue;
                r.lookupChange(newL, removed, old, lookups);
            }
        }
        ArrayList<Object> evAndListeners = new ArrayList<Object>();
        for (Reference reference : arr) {
            R r = (R)reference.get();
            if (r == null) continue;
            r.collectFires(evAndListeners);
        }
        Iterator it = evAndListeners.iterator();
        while (it.hasNext()) {
            LookupEvent lookupEvent = (LookupEvent)it.next();
            LookupListener lookupListener = (LookupListener)it.next();
            lookupListener.resultChanged(lookupEvent);
        }
    }

    protected void beforeLookup(Lookup.Template<?> template) {
    }

    @Override
    public final <T> T lookup(Class<T> clazz) {
        this.beforeLookup(new Lookup.Template<T>(clazz));
        Lookup[] lookups = this.getLookups(false);
        for (int i = 0; i < lookups.length; ++i) {
            T o = lookups[i].lookup(clazz);
            if (o == null) continue;
            return o;
        }
        return null;
    }

    @Override
    public final <T> Lookup.Item<T> lookupItem(Lookup.Template<T> template) {
        this.beforeLookup(template);
        Lookup[] lookups = this.getLookups(false);
        for (int i = 0; i < lookups.length; ++i) {
            Lookup.Item<T> o = lookups[i].lookupItem(template);
            if (o == null) continue;
            return o;
        }
        return null;
    }

    private static <T> R<T> convertResult(R r) {
        return r;
    }

    @Override
    public final synchronized <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
        if (this.results != null) {
            R r;
            Reference<R> ref = this.results.get(template);
            R r2 = r = ref == null ? null : ref.get();
            if (r != null) {
                return ProxyLookup.convertResult(r);
            }
        } else {
            this.results = new HashMap();
        }
        R<T> newR = new R<T>(template);
        this.results.put(template, new SoftReference<R<T>>(newR));
        return newR;
    }

    private final synchronized void unregisterTemplate(Lookup.Template<?> template) {
        if (this.results == null) {
            return;
        }
        Reference<R> ref = this.results.remove(template);
        if (ref != null && ref.get() != null) {
            this.results.put(template, ref);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class R<T>
    extends WaitableResult<T> {
        private EventListenerList listeners;
        private Lookup.Template<T> template;
        private Collection[] cache;
        private WeakResult<T> weakL;

        public R(Lookup.Template<T> t) {
            this.template = t;
            this.weakL = new WeakResult(this);
        }

        protected void finalize() {
            ProxyLookup.this.unregisterTemplate(this.template);
        }

        private Lookup.Result<T>[] newResults(int len) {
            return new Lookup.Result[len];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Lookup.Result<T>[] initResults() {
            R r = this;
            synchronized (r) {
                if (((WeakResult)this.weakL).results != null) {
                    return ((WeakResult)this.weakL).results;
                }
            }
            Lookup[] myLkps = ProxyLookup.this.getLookups(false);
            Lookup.Result[] arr = this.newResults(myLkps.length);
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = myLkps[i].lookup(this.template);
            }
            R r2 = this;
            synchronized (r2) {
                if (((WeakResult)this.weakL).results != null) {
                    return ((WeakResult)this.weakL).results;
                }
                for (int i = 0; i < arr.length; ++i) {
                    arr[i].addLookupListener(this.weakL);
                }
                WeakResult.access$102(this.weakL, arr);
                return arr;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void lookupChange(Set added, Set removed, Lookup[] old, Lookup[] current) {
            R r = this;
            synchronized (r) {
                if (((WeakResult)this.weakL).results == null) {
                    return;
                }
                HashMap<Lookup, Lookup.Result> map = new HashMap<Lookup, Lookup.Result>(old.length * 2);
                for (int i = 0; i < old.length; ++i) {
                    if (removed.contains(old[i])) {
                        ((WeakResult)this.weakL).results[i].removeLookupListener(this.weakL);
                        continue;
                    }
                    map.put(old[i], ((WeakResult)this.weakL).results[i]);
                }
                Lookup.Result[] arr = this.newResults(current.length);
                for (int i = 0; i < current.length; ++i) {
                    if (added.contains(current[i])) {
                        arr[i] = current[i].lookup(this.template);
                        arr[i].addLookupListener(this.weakL);
                        continue;
                    }
                    arr[i] = (Lookup.Result)map.get(current[i]);
                    if (arr[i] != null) continue;
                    throw new IllegalStateException();
                }
                WeakResult.access$102(this.weakL, arr);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addLookupListener(LookupListener l) {
            if (this.listeners == null) {
                R r = this;
                synchronized (r) {
                    if (this.listeners == null) {
                        this.listeners = new EventListenerList();
                    }
                }
            }
            this.listeners.add(LookupListener.class, l);
        }

        @Override
        public void removeLookupListener(LookupListener l) {
            if (this.listeners != null) {
                this.listeners.remove(LookupListener.class, l);
            }
        }

        @Override
        public Collection<T> allInstances() {
            return this.computeResult(0);
        }

        @Override
        public Set<Class<? extends T>> allClasses() {
            return (Set)this.computeResult(1);
        }

        @Override
        public Collection<? extends Lookup.Item<T>> allItems() {
            return this.computeResult(2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Collection computeResult(int indexToCache) {
            Collection ret;
            AbstractCollection compute;
            Lookup.Result<T>[] arr = this.myBeforeLookup();
            R r = this;
            synchronized (r) {
                Collection result;
                if (this.cache != null && (result = this.cache[indexToCache]) != null) {
                    return result;
                }
            }
            if (indexToCache == 1) {
                HashSet s = new HashSet();
                compute = s;
                ret = Collections.unmodifiableSet(s);
            } else {
                ArrayList l = new ArrayList(arr.length * 2);
                compute = l;
                ret = Collections.unmodifiableList(l);
            }
            block11: for (int i = 0; i < arr.length; ++i) {
                switch (indexToCache) {
                    case 0: {
                        compute.addAll(arr[i].allInstances());
                        continue block11;
                    }
                    case 1: {
                        compute.addAll(arr[i].allClasses());
                        continue block11;
                    }
                    case 2: {
                        compute.addAll(arr[i].allItems());
                        continue block11;
                    }
                    default: {
                        assert (false) : "Wrong index: " + indexToCache;
                        continue block11;
                    }
                }
            }
            R r2 = this;
            synchronized (r2) {
                if (this.cache == null) {
                    this.cache = new Collection[3];
                }
                if (arr == ((WeakResult)this.weakL).results) {
                    this.cache[indexToCache] = ret;
                }
            }
            return ret;
        }

        public void resultChanged(LookupEvent ev) {
            this.collectFires(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void collectFires(Collection<Object> evAndListeners) {
            Collection<T> newInstances;
            Collection oldItems;
            Collection oldInstances;
            R r = this;
            synchronized (r) {
                if (this.cache == null) {
                    return;
                }
                oldInstances = this.cache[0];
                oldItems = this.cache[2];
                if (this.listeners == null || this.listeners.getListenerCount() == 0) {
                    this.cache = new Collection[3];
                    return;
                }
                this.cache = null;
            }
            boolean modified = true;
            if (oldItems != null) {
                Collection<Lookup.Item<T>> newItems = this.allItems();
                if (((Object)oldItems).equals(newItems)) {
                    modified = false;
                }
            } else if (oldInstances != null) {
                newInstances = this.allInstances();
                if (((Object)oldInstances).equals(newInstances)) {
                    modified = false;
                }
            } else {
                newInstances = this;
                synchronized (newInstances) {
                    if (this.cache == null) {
                        this.cache = new Collection[3];
                    }
                }
            }
            assert (this.cache != null);
            if (modified) {
                LookupEvent ev = new LookupEvent(this);
                AbstractLookup.notifyListeners(this.listeners.getListenerList(), ev, evAndListeners);
            }
        }

        private Lookup.Result<T>[] myBeforeLookup() {
            ProxyLookup.this.beforeLookup(this.template);
            Lookup.Result<T>[] arr = this.initResults();
            for (int i = 0; i < arr.length; ++i) {
                if (!(arr[i] instanceof WaitableResult)) continue;
                WaitableResult w = (WaitableResult)arr[i];
                w.beforeLookup(this.template);
            }
            return arr;
        }

        @Override
        protected void beforeLookup(Lookup.Template t) {
            if (t.getType() == this.template.getType()) {
                this.myBeforeLookup();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WeakResult<T>
    extends WaitableResult<T>
    implements LookupListener {
        private Lookup.Result<T>[] results;
        private Reference<R> result;

        public WeakResult(R r) {
            this.result = new WeakReference<R>(r);
        }

        @Override
        protected void beforeLookup(Lookup.Template t) {
            R r = this.result.get();
            if (r != null) {
                r.beforeLookup(t);
            } else {
                this.removeListeners();
            }
        }

        private void removeListeners() {
            Lookup.Result<T>[] arr = this.results;
            if (arr == null) {
                return;
            }
            for (int i = 0; i < arr.length; ++i) {
                arr[i].removeLookupListener(this);
            }
        }

        @Override
        protected void collectFires(Collection<Object> evAndListeners) {
            R r = this.result.get();
            if (r != null) {
                r.collectFires(evAndListeners);
            } else {
                this.removeListeners();
            }
        }

        @Override
        public void addLookupListener(LookupListener l) {
            assert (false);
        }

        @Override
        public void removeLookupListener(LookupListener l) {
            assert (false);
        }

        @Override
        public Collection<T> allInstances() {
            assert (false);
            return null;
        }

        @Override
        public void resultChanged(LookupEvent ev) {
            R r = this.result.get();
            if (r != null) {
                r.resultChanged(ev);
            } else {
                this.removeListeners();
            }
        }

        @Override
        public Collection<? extends Lookup.Item<T>> allItems() {
            assert (false);
            return null;
        }

        @Override
        public Set<Class<? extends T>> allClasses() {
            assert (false);
            return null;
        }

        static /* synthetic */ Lookup.Result[] access$102(WeakResult x0, Lookup.Result[] x1) {
            x0.results = x1;
            return x1;
        }
    }
}

