/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog;

import java.beans.IntrospectionException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.swing.Action;
import org.netbeans.modules.xml.catalog.CatalogEntry;
import org.netbeans.modules.xml.catalog.Util;
import org.netbeans.modules.xml.catalog.lib.URLEnvironment;
import org.netbeans.modules.xml.catalog.spi.CatalogReader;
import org.netbeans.modules.xml.catalog.spi.CatalogWriter;
import org.netbeans.modules.xml.catalog.user.UserXMLCatalog;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.DeleteAction;
import org.openide.actions.EditAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.ViewAction;
import org.openide.cookies.EditCookie;
import org.openide.cookies.ViewCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;
import org.openide.windows.CloneableOpenSupport;

final class CatalogEntryNode
extends BeanNode
implements EditCookie {
    private transient ViewCookie view;
    private boolean isCatalogWriter;
    private CatalogReader catalogReader;
    static /* synthetic */ Class class$org$netbeans$modules$xml$catalog$CatalogEntryNode$ViewCookieImpl;

    public CatalogEntryNode(CatalogEntry entry) throws IntrospectionException {
        super((Object)entry);
        this.catalogReader = entry.getCatalog();
        if (this.catalogReader instanceof CatalogWriter) {
            this.isCatalogWriter = true;
        }
    }

    public Action getPreferredAction() {
        if (this.isCatalogWriter) {
            return SystemAction.get((Class)EditAction.class);
        }
        return SystemAction.get((Class)ViewAction.class);
    }

    public void edit() {
        UserXMLCatalog catalog = (UserXMLCatalog)this.getCatalogReader();
        try {
            DataObject obj;
            EditCookie editCookie;
            URI uri = new URI(this.getSystemID());
            File file = new File(uri);
            FileObject fo = FileUtil.toFileObject((File)file);
            boolean editPossible = false;
            if (fo != null && (editCookie = (EditCookie)(obj = DataObject.find((FileObject)fo)).getCookie(EditCookie.class)) != null) {
                editPossible = true;
                editCookie.edit();
            }
            if (!editPossible) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Util.THIS.getString("MSG_CannotOpenURI", this.getSystemID()), 1));
            }
        }
        catch (Throwable ex) {
            ErrorManager.getDefault().notify(ex);
        }
    }

    private CatalogReader getCatalogReader() {
        return this.catalogReader;
    }

    public Action[] getActions(boolean context) {
        if (this.isCatalogWriter) {
            return new Action[]{SystemAction.get((Class)EditAction.class), SystemAction.get((Class)DeleteAction.class), null, SystemAction.get((Class)PropertiesAction.class)};
        }
        return new Action[]{SystemAction.get((Class)ViewAction.class), null, SystemAction.get((Class)PropertiesAction.class)};
    }

    public Node.Cookie getCookie(Class clazz) {
        if (ViewCookie.class.equals(clazz)) {
            try {
                String sys = this.getSystemID();
                if (sys == null) {
                    return null;
                }
                if (this.view == null) {
                    URL url = new URL(sys);
                    ViewEnv env = new ViewEnv(url);
                    this.view = new ViewCookieImpl(env);
                }
                return this.view;
            }
            catch (MalformedURLException ex) {
                ErrorManager emgr = ErrorManager.getDefault();
                emgr.notify(1, (Throwable)ex);
                return null;
            }
            catch (IOException ex) {
                ErrorManager emgr = ErrorManager.getDefault();
                emgr.notify(1, (Throwable)ex);
                return null;
            }
        }
        return super.getCookie(clazz);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private String getPublicID() {
        return ((CatalogEntry)this.getBean()).getPublicID();
    }

    private String getSystemID() {
        return ((CatalogEntry)this.getBean()).getSystemID();
    }

    public String getShortDescription() {
        return this.getSystemID();
    }

    public void destroy() throws IOException {
        super.destroy();
        if (this.isCatalogWriter) {
            CatalogWriter catalogWriter = (CatalogWriter)((Object)((CatalogEntry)this.getBean()).getCatalog());
            catalogWriter.registerCatalogEntry(this.getPublicID(), null);
        }
    }

    private class ViewCookieImpl
    extends CloneableEditorSupport
    implements ViewCookie {
        ViewCookieImpl(CloneableEditorSupport.Env env) {
            super(env);
        }

        protected String messageName() {
            return Util.THIS.getString("MSG_opened_entity", CatalogEntryNode.this.getPublicID());
        }

        protected String messageSave() {
            return Util.THIS.getString("MSG_ENTITY_SAVE", CatalogEntryNode.this.getPublicID());
        }

        protected String messageToolTip() {
            return Util.THIS.getString("MSG_ENTITY_TOOLTIP", CatalogEntryNode.this.getSystemID());
        }

        protected String messageOpening() {
            return Util.THIS.getString("MSG_ENTITY_OPENING", CatalogEntryNode.this.getPublicID());
        }

        protected String messageOpened() {
            return Util.THIS.getString("MSG_ENTITY_OPENED", CatalogEntryNode.this.getPublicID());
        }

        protected CloneableEditor createCloneableEditor() {
            CloneableEditor editor = super.createCloneableEditor();
            editor.setActivatedNodes(new Node[]{CatalogEntryNode.this});
            return editor;
        }

        private Object writeReplace() {
            return null;
        }
    }

    private class ViewEnv
    extends URLEnvironment {
        private static final long serialVersionUID = -5031004511063404433L;

        ViewEnv(URL url) {
            super(url);
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (ViewCookieImpl)CatalogEntryNode.this.getCookie(class$org$netbeans$modules$xml$catalog$CatalogEntryNode$ViewCookieImpl == null ? (class$org$netbeans$modules$xml$catalog$CatalogEntryNode$ViewCookieImpl = CatalogEntryNode.class$("org.netbeans.modules.xml.catalog.CatalogEntryNode$ViewCookieImpl")) : class$org$netbeans$modules$xml$catalog$CatalogEntryNode$ViewCookieImpl);
        }
    }
}

