/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.highlights;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.MarkFactory;
import org.netbeans.modules.editor.highlights.HighlightComparator;
import org.netbeans.modules.editor.highlights.spi.Highlight;
import org.openide.ErrorManager;

final class HighlightLayer
extends DrawLayer.AbstractLayer {
    private Map type2Highlights = new HashMap();
    private Highlight fakeHighlight = new FakeHighlight();
    private int fakePosition;
    public static final int VISIBILITY = 3000;
    private boolean initialized = false;

    public HighlightLayer() {
        super("highlight-layer");
    }

    private void checkDocument(Document doc) {
    }

    public boolean extendsEOL() {
        return true;
    }

    public synchronized void init(DrawContext ctx) {
        if (!this.initialized) {
            BaseDocument doc = ctx.getEditorUI().getDocument();
            this.initialized = true;
            this.checkDocument((Document)doc);
        }
        if (this.isActive()) {
            this.setNextActivityChangeOffset(0);
        }
    }

    private boolean isActive() {
        return true;
    }

    public boolean isActive(DrawContext ctx, MarkFactory.DrawMark mark) {
        if (this.isActive()) {
            int currentOffset = ctx.getFragmentOffset();
            List highlights = this.getHighlightsForOffset(currentOffset);
            int nextActivity = Integer.MAX_VALUE;
            Iterator i = highlights.iterator();
            while (i.hasNext()) {
                Highlight h = (Highlight)i.next();
                if (h.getStart() <= currentOffset) {
                    if (nextActivity <= h.getEnd()) continue;
                    nextActivity = h.getEnd();
                    continue;
                }
                if (nextActivity <= h.getStart()) continue;
                nextActivity = h.getStart();
            }
            if (nextActivity == currentOffset) {
                ++nextActivity;
            }
            this.setNextActivityChangeOffset(nextActivity);
            return true;
        }
        return false;
    }

    public void updateContext(DrawContext ctx) {
        if (!this.isActive()) {
            return;
        }
        int currentOffset = ctx.getFragmentOffset();
        List highlights = this.getHighlightsForOffset(currentOffset);
        int nextActivity = Integer.MAX_VALUE;
        int starts = Integer.MAX_VALUE;
        boolean applied = false;
        Iterator i = highlights.iterator();
        while (i.hasNext()) {
            Highlight h = (Highlight)i.next();
            if (h.getStart() <= currentOffset && currentOffset < h.getEnd()) {
                h.getColoring().apply(ctx);
                applied = true;
            }
            if (nextActivity > h.getEnd()) {
                nextActivity = h.getEnd();
            }
            if (starts <= h.getStart()) continue;
            starts = h.getStart();
        }
        if (!applied && starts < nextActivity) {
            nextActivity = starts;
        }
        this.setNextActivityChangeOffset(nextActivity);
    }

    public synchronized void setHighlights(String type, Collection highlights) {
        TreeSet<Highlight> target = (TreeSet<Highlight>)this.type2Highlights.get(type);
        if (target == null) {
            target = new TreeSet<Highlight>(new HighlightComparator());
            this.type2Highlights.put(type, target);
        } else {
            target.clear();
        }
        Iterator i = highlights.iterator();
        while (i.hasNext()) {
            Highlight h = (Highlight)i.next();
            if (h != null) {
                target.add(h);
                continue;
            }
            ErrorManager.getDefault().log(16, "Got a null highlight, type: " + type);
        }
    }

    private synchronized List getHighlightsForOffset(int offset) {
        ArrayList<Highlight> highlights = new ArrayList<Highlight>();
        this.fakePosition = offset;
        Iterator i = this.type2Highlights.keySet().iterator();
        while (i.hasNext()) {
            String type = (String)i.next();
            SortedSet<Highlight> tail = ((SortedSet)this.type2Highlights.get(type)).tailSet(this.fakeHighlight);
            if (tail.isEmpty()) continue;
            Highlight h = tail.first();
            highlights.add(h);
        }
        return highlights;
    }

    private final class FakeHighlight
    implements Highlight {
        private FakeHighlight() {
        }

        public int getStart() {
            return -1;
        }

        public int getEnd() {
            return HighlightLayer.this.fakePosition;
        }

        public Coloring getColoring() {
            return null;
        }
    }
}

