/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.highlights;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Registry;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.highlights.HighlightLayer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.WeakSet;

public final class HighlighterImpl
implements PropertyChangeListener,
ChangeListener {
    private static HighlighterImpl INSTANCE = new HighlighterImpl();
    private Map comp2FO = new WeakHashMap();
    private Map fo2Comp = new WeakHashMap();
    private Map comp2Layer = new WeakHashMap();

    public static HighlighterImpl getDefault() {
        return INSTANCE;
    }

    private HighlightLayer getLayer(JTextComponent c) {
        Reference r = (Reference)this.comp2Layer.get(c);
        if (r == null) {
            return null;
        }
        return (HighlightLayer)((Object)r.get());
    }

    synchronized void assureRegistered(JTextComponent c) {
        if (c == null || this.getLayer(c) != null) {
            return;
        }
        this.comp2FO.put(c, null);
        c.addPropertyChangeListener(this);
        this.updateFileObjectMapping(c);
        HighlightLayer layer = new HighlightLayer();
        this.comp2Layer.put(c, new WeakReference<HighlightLayer>(layer));
        EditorUI eui = Utilities.getEditorUI((JTextComponent)c);
        if (eui != null) {
            eui.addLayer((DrawLayer)layer, 3000);
        }
    }

    private synchronized void updateFileObjectMapping(JTextComponent c) {
        Collection components;
        Document doc = c.getDocument();
        Object stream = doc.getProperty("stream");
        FileObject old = this.comp2FO.put(c, null);
        if (old != null && (components = (Collection)this.fo2Comp.get(old)) != null) {
            components.remove(c);
        }
        if (stream != null && stream instanceof DataObject) {
            FileObject fo = ((DataObject)stream).getPrimaryFile();
            this.comp2FO.put(c, fo);
            this.getComponents(fo).add(c);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("document".equals(evt.getPropertyName())) {
            this.updateFileObjectMapping((JTextComponent)evt.getSource());
        }
    }

    private Collection getComponents(FileObject fo) {
        Collection components = (Collection)this.fo2Comp.get(fo);
        if (components == null) {
            components = new WeakSet();
            this.fo2Comp.put(fo, components);
        }
        return components;
    }

    public synchronized void setHighlights(FileObject fo, String type, Collection highlights) {
        Iterator i = this.getComponents(fo).iterator();
        while (i.hasNext()) {
            JTextComponent c = (JTextComponent)i.next();
            HighlightLayer layer = this.getLayer(c);
            if (layer == null) continue;
            layer.setHighlights(type, highlights);
            c.repaint();
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.assureRegistered(Registry.getMostActiveComponent());
    }
}

