/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.awt.Toolkit;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.AbstractElementVisitor6;
import javax.swing.text.Document;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.java.Utilities;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoToSupport {
    private static final Set<JavaTokenId> USABLE_TOKEN_IDS = new HashSet<JavaTokenId>(Arrays.asList(JavaTokenId.IDENTIFIER, JavaTokenId.THIS, JavaTokenId.SUPER));
    static UiUtilsCaller CALLER = new UiUtilsCaller(){

        public void open(FileObject fo, int pos) {
            UiUtils.open((FileObject)fo, (int)pos);
        }

        public void beep() {
            Toolkit.getDefaultToolkit().beep();
        }

        public void open(ClasspathInfo info, Element el) {
            UiUtils.open((ClasspathInfo)info, (Element)el);
        }
    };

    private static FileObject getFileObject(Document doc) {
        DataObject od = (DataObject)doc.getProperty("stream");
        return od != null ? od.getPrimaryFile() : null;
    }

    public static String getGoToElementTooltip(Document doc, int offset, boolean goToSource) {
        return GoToSupport.performGoTo(doc, offset, goToSource, true);
    }

    private static boolean isError(Element el) {
        return el == null || el.asType() == null || el.asType().getKind() == TypeKind.ERROR;
    }

    private static String performGoTo(final Document doc, final int offset, final boolean goToSource, final boolean tooltip) {
        try {
            final FileObject fo = GoToSupport.getFileObject(doc);
            if (fo == null) {
                return null;
            }
            JavaSource js = JavaSource.forFileObject((FileObject)fo);
            final String[] result = new String[1];
            js.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController controller) throws Exception {
                    Element el;
                    if (controller.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        return;
                    }
                    Token[] token = new Token[1];
                    int[] span = GoToSupport.getIdentifierSpan(doc, offset, token);
                    if (span == null) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    int exactOffset = span[0] + 1;
                    TreePath path = controller.getTreeUtilities().pathFor(exactOffset);
                    TreePath parent = path.getParentPath();
                    Tree parentLeaf = parent.getLeaf();
                    if (parentLeaf.getKind() == Tree.Kind.NEW_CLASS && ((NewClassTree)parentLeaf).getIdentifier() == path.getLeaf()) {
                        if (!GoToSupport.isError(controller.getTrees().getElement(path.getParentPath()))) {
                            path = path.getParentPath();
                        }
                    } else if (parentLeaf.getKind() == Tree.Kind.PARAMETERIZED_TYPE && parent.getParentPath().getLeaf().getKind() == Tree.Kind.NEW_CLASS && ((ParameterizedTypeTree)parentLeaf).getType() == path.getLeaf() && !GoToSupport.isError(controller.getTrees().getElement(parent.getParentPath()))) {
                        path = parent.getParentPath();
                    }
                    if (GoToSupport.isError(el = controller.getTrees().getElement(path))) {
                        if (!tooltip) {
                            CALLER.beep();
                        } else {
                            result[0] = null;
                        }
                        return;
                    }
                    if (goToSource) {
                        TypeMirror type = null;
                        if (el instanceof VariableElement) {
                            type = el.asType();
                        }
                        if (type != null && type.getKind() == TypeKind.DECLARED) {
                            el = ((DeclaredType)type).asElement();
                        }
                    }
                    if (GoToSupport.isError(el)) {
                        if (!tooltip) {
                            CALLER.beep();
                        } else {
                            result[0] = null;
                        }
                        return;
                    }
                    if (controller.getElementUtilities().isSynthetic(el) && el.getKind() == ElementKind.CONSTRUCTOR) {
                        el = GoToSupport.handlePossibleAnonymousInnerClass((CompilationInfo)controller, el);
                    }
                    if (GoToSupport.isError(el)) {
                        if (!tooltip) {
                            CALLER.beep();
                        } else {
                            result[0] = null;
                        }
                        return;
                    }
                    if (el.getKind() != ElementKind.CONSTRUCTOR && (token[0].id() == JavaTokenId.SUPER || token[0].id() == JavaTokenId.THIS)) {
                        if (!tooltip) {
                            CALLER.beep();
                        } else {
                            result[0] = null;
                        }
                        return;
                    }
                    if (tooltip) {
                        DisplayNameElementVisitor v = new DisplayNameElementVisitor();
                        v.visit(el, true);
                        result[0] = "<html><body>" + v.result.toString();
                    } else {
                        Tree tree;
                        TreePath elpath = controller.getTrees().getPath(el);
                        Tree tree2 = tree = elpath != null && path.getCompilationUnit() == elpath.getCompilationUnit() ? elpath.getLeaf() : null;
                        if (tree == null && (el.getKind() == ElementKind.PARAMETER || el.getKind() == ElementKind.LOCAL_VARIABLE)) {
                            while (path.getLeaf().getKind() != Tree.Kind.METHOD && path.getLeaf().getKind() != Tree.Kind.CLASS) {
                                path = path.getParentPath();
                            }
                            FindVariableDeclarationVisitor v = new FindVariableDeclarationVisitor();
                            v.info = (CompilationInfo)controller;
                            v.scan(path, el);
                            tree = v.found;
                        }
                        if (tree != null) {
                            long startPos = controller.getTrees().getSourcePositions().getStartPosition(controller.getCompilationUnit(), tree);
                            long endPos = controller.getTrees().getSourcePositions().getEndPosition(controller.getCompilationUnit(), tree);
                            if (startPos != -1L) {
                                if (startPos <= (long)offset && (long)offset <= endPos) {
                                    CALLER.beep();
                                } else {
                                    CALLER.open(fo, (int)startPos);
                                }
                            } else {
                                CALLER.beep();
                            }
                        } else {
                            CALLER.open(controller.getClasspathInfo(), el);
                        }
                    }
                }
            }, true);
            return result[0];
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }

    public static void goTo(Document doc, int offset, boolean goToSource) {
        GoToSupport.performGoTo(doc, offset, goToSource, false);
    }

    public static int[] getIdentifierSpan(Document doc, int offset, Token<JavaTokenId>[] token) {
        if (GoToSupport.getFileObject(doc) == null) {
            return null;
        }
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        TokenSequence ts = th.tokenSequence(JavaTokenId.language());
        if (ts == null) {
            return null;
        }
        ts.move(offset);
        if (!ts.moveNext()) {
            return null;
        }
        Token t = ts.token();
        if (!USABLE_TOKEN_IDS.contains(t.id())) {
            ts.move(offset - 1);
            if (!ts.moveNext()) {
                return null;
            }
            t = ts.token();
            if (!USABLE_TOKEN_IDS.contains(t.id())) {
                return null;
            }
        }
        if (token != null) {
            token[0] = t;
        }
        return new int[]{ts.offset(), ts.offset() + t.length()};
    }

    private static Element handlePossibleAnonymousInnerClass(CompilationInfo info, Element el) {
        Element doubleEncl;
        Element encl = el.getEnclosingElement();
        Element element = doubleEncl = encl != null ? encl.getEnclosingElement() : null;
        if (doubleEncl != null && !doubleEncl.getKind().isClass() && !doubleEncl.getKind().isInterface() && doubleEncl.getKind() != ElementKind.PACKAGE && encl.getKind() == ElementKind.CLASS) {
            NewClassTree nct;
            Tree enclTree;
            TreePath enclTreePath = info.getTrees().getPath(encl);
            Tree tree = enclTree = enclTreePath != null ? enclTreePath.getLeaf() : null;
            if (enclTree != null && enclTree.getKind() == Tree.Kind.CLASS && enclTreePath.getParentPath().getLeaf().getKind() == Tree.Kind.NEW_CLASS && (nct = (NewClassTree)enclTreePath.getParentPath().getLeaf()).getClassBody() != null) {
                Element parentElement = info.getTrees().getElement(new TreePath(enclTreePath, nct.getIdentifier()));
                if (parentElement == null || parentElement.getKind().isInterface()) {
                    return parentElement;
                }
                TreePath superConstructorCall = (TreePath)new FindSuperConstructorCall().scan(enclTreePath, null);
                if (superConstructorCall != null) {
                    return info.getTrees().getElement(superConstructorCall);
                }
            }
            return null;
        }
        if (encl != null) {
            return encl;
        }
        return el;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DisplayNameElementVisitor
    extends AbstractElementVisitor6<Void, Boolean> {
        private StringBuffer result = new StringBuffer();

        private DisplayNameElementVisitor() {
        }

        private void boldStartCheck(boolean highlightName) {
            if (highlightName) {
                this.result.append("<b>");
            }
        }

        private void boldStopCheck(boolean highlightName) {
            if (highlightName) {
                this.result.append("</b>");
            }
        }

        @Override
        public Void visitPackage(PackageElement e, Boolean highlightName) {
            this.boldStartCheck(highlightName);
            this.result.append(e.getQualifiedName());
            this.boldStopCheck(highlightName);
            return null;
        }

        @Override
        public Void visitType(TypeElement e, Boolean highlightName) {
            this.modifier(e.getModifiers());
            switch (e.getKind()) {
                case CLASS: {
                    this.result.append("class ");
                    break;
                }
                case INTERFACE: {
                    this.result.append("interface ");
                    break;
                }
                case ENUM: {
                    this.result.append("enum ");
                    break;
                }
                case ANNOTATION_TYPE: {
                    this.result.append("@interface ");
                }
            }
            Element enclosing = e.getEnclosingElement();
            if (enclosing == SourceUtils.getEnclosingTypeElement((Element)e)) {
                this.result.append(e.getQualifiedName());
                this.result.append('.');
                this.boldStartCheck(highlightName);
                this.result.append(e.getSimpleName());
                this.boldStopCheck(highlightName);
            } else {
                this.result.append(e.getQualifiedName());
            }
            return null;
        }

        @Override
        public Void visitVariable(VariableElement e, Boolean highlightName) {
            this.modifier(e.getModifiers());
            this.result.append(Utilities.getTypeName(e.asType(), true));
            this.result.append(' ');
            this.boldStartCheck(highlightName);
            this.result.append(e.getSimpleName());
            this.boldStopCheck(highlightName);
            if (highlightName.booleanValue()) {
                if (e.getConstantValue() != null) {
                    this.result.append(" = ");
                    this.result.append(e.getConstantValue().toString());
                }
                this.result.append(" in ");
                Element enclosing = e.getEnclosingElement();
                if (enclosing.getKind() != ElementKind.PARAMETER && enclosing.getKind() != ElementKind.LOCAL_VARIABLE) {
                    this.result.append(Utilities.getTypeName(enclosing.asType(), true));
                }
            }
            return null;
        }

        @Override
        public Void visitExecutable(ExecutableElement e, Boolean highlightName) {
            switch (e.getKind()) {
                case CONSTRUCTOR: {
                    this.modifier(e.getModifiers());
                    this.dumpTypeArguments(e.getTypeParameters());
                    this.result.append(' ');
                    this.boldStartCheck(highlightName);
                    this.result.append(e.getSimpleName());
                    this.boldStopCheck(highlightName);
                    this.dumpArguments(e.getParameters());
                    this.dumpThrows(e.getThrownTypes());
                    break;
                }
                case METHOD: {
                    this.modifier(e.getModifiers());
                    this.dumpTypeArguments(e.getTypeParameters());
                    this.result.append(Utilities.getTypeName(e.getReturnType(), true));
                    this.result.append(' ');
                    this.boldStartCheck(highlightName);
                    this.result.append(e.getSimpleName());
                    this.boldStopCheck(highlightName);
                    this.dumpArguments(e.getParameters());
                    this.dumpThrows(e.getThrownTypes());
                    break;
                }
            }
            return null;
        }

        @Override
        public Void visitTypeParameter(TypeParameterElement e, Boolean highlightName) {
            return null;
        }

        private void modifier(Set<Modifier> modifiers) {
            boolean addSpace = false;
            for (Modifier m : modifiers) {
                if (addSpace) {
                    this.result.append(' ');
                }
                addSpace = true;
                this.result.append(m.toString());
            }
            if (addSpace) {
                this.result.append(' ');
            }
        }

        private void dumpTypeArguments(List<? extends TypeParameterElement> list) {
            if (list.isEmpty()) {
                return;
            }
            boolean addSpace = false;
            this.result.append('<');
            for (TypeParameterElement typeParameterElement : list) {
                if (addSpace) {
                    this.result.append(", ");
                }
                this.result.append(Utilities.getTypeName(typeParameterElement.asType(), true));
                addSpace = true;
            }
            this.result.append('>');
        }

        private void dumpArguments(List<? extends VariableElement> list) {
            boolean addSpace = false;
            this.result.append('(');
            for (VariableElement variableElement : list) {
                if (addSpace) {
                    this.result.append(", ");
                }
                this.visit(variableElement, false);
                addSpace = true;
            }
            this.result.append(')');
        }

        private void dumpThrows(List<? extends TypeMirror> list) {
            if (list.isEmpty()) {
                return;
            }
            boolean addSpace = false;
            this.result.append(" throws ");
            for (TypeMirror typeMirror : list) {
                if (addSpace) {
                    this.result.append(", ");
                }
                this.result.append(Utilities.getTypeName(typeMirror, true));
                addSpace = true;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FindSuperConstructorCall
    extends TreePathScanner<TreePath, Void> {
        private FindSuperConstructorCall() {
        }

        @Override
        public TreePath visitMethodInvocation(MethodInvocationTree tree, Void v) {
            if (tree.getMethodSelect().getKind() == Tree.Kind.IDENTIFIER && "super".equals(((IdentifierTree)tree.getMethodSelect()).getName().toString())) {
                return this.getCurrentPath();
            }
            return null;
        }

        @Override
        public TreePath reduce(TreePath first, TreePath second) {
            if (first == null) {
                return second;
            }
            return first;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FindVariableDeclarationVisitor
    extends TreePathScanner<Void, Element> {
        private CompilationInfo info;
        private Tree found;

        private FindVariableDeclarationVisitor() {
        }

        @Override
        public Void visitClass(ClassTree node, Element p) {
            return null;
        }

        @Override
        public Void visitVariable(VariableTree node, Element p) {
            Element resolved = this.info.getTrees().getElement(this.getCurrentPath());
            if (resolved == p) {
                this.found = node;
            }
            return null;
        }
    }

    static interface UiUtilsCaller {
        public void open(FileObject var1, int var2);

        public void beep();

        public void open(ClasspathInfo var1, Element var2);
    }
}

