/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import com.sun.source.tree.Tree;
import java.awt.Toolkit;
import java.io.IOException;
import java.util.EnumSet;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateFilter;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaCodeTemplateFilter
implements CodeTemplateFilter,
CancellableTask<CompilationController> {
    private int startOffset;
    private int endOffset;
    private Tree.Kind ctx = null;

    private JavaCodeTemplateFilter(JTextComponent component, int offset) {
        this.startOffset = offset;
        this.endOffset = component.getSelectionStart() == offset ? component.getSelectionEnd() : -1;
        JavaSource js = JavaSource.forDocument((Document)component.getDocument());
        if (js != null) {
            try {
                if (SourceUtils.isScanInProgress()) {
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JavaCodeTemplateFilter.class, (String)"JCT-scanning-in-progress"));
                    Toolkit.getDefaultToolkit().beep();
                } else {
                    js.runUserActionTask((CancellableTask)this, true);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public synchronized boolean accept(CodeTemplate template) {
        return this.ctx != null && this.getTemplateContexts(template).contains((Object)this.ctx);
    }

    public void cancel() {
    }

    public synchronized void run(CompilationController controller) throws IOException {
        controller.toPhase(JavaSource.Phase.PARSED);
        Tree tree = controller.getTreeUtilities().pathFor(this.startOffset).getLeaf();
        if (this.endOffset >= 0 && this.startOffset != this.endOffset && controller.getTreeUtilities().pathFor(this.endOffset).getLeaf() != tree) {
            return;
        }
        this.ctx = tree.getKind();
    }

    private EnumSet<Tree.Kind> getTemplateContexts(CodeTemplate template) {
        String abbrev = template.getAbbreviation().toLowerCase();
        if (abbrev.equals("runn") || abbrev.startsWith("for") || abbrev.startsWith("while") || abbrev.equals("inst") || abbrev.startsWith("if") || abbrev.startsWith("do") || abbrev.startsWith("try")) {
            return EnumSet.of(Tree.Kind.BLOCK);
        }
        return EnumSet.noneOf(Tree.Kind.class);
    }

    public static final class Factory
    implements CodeTemplateFilter.Factory {
        public CodeTemplateFilter createFilter(JTextComponent component, int offset) {
            return new JavaCodeTemplateFilter(component, offset);
        }
    }
}

