/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import java.awt.Toolkit;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Types;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateInsertRequest;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateParameter;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateProcessor;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateProcessorFactory;
import org.netbeans.modules.editor.java.AutoImport;
import org.netbeans.modules.editor.java.JavaCodeTemplateFilter;
import org.netbeans.modules.editor.java.Utilities;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class JavaCodeTemplateProcessor
implements CodeTemplateProcessor {
    public static final String INSTANCE_OF = "instanceof";
    public static final String ARRAY = "array";
    public static final String ITERABLE = "iterable";
    public static final String TYPE = "type";
    public static final String ITERABLE_ELEMENT_TYPE = "iterableElementType";
    public static final String LEFT_SIDE_TYPE = "leftSideType";
    public static final String RIGHT_SIDE_TYPE = "rightSideType";
    public static final String CAST = "cast";
    public static final String NEW_VAR_NAME = "newVarName";
    public static final String NAMED = "named";
    public static final String UNCAUGHT_EXCEPTION_TYPE = "uncaughtExceptionType";
    private static final String FALSE = "false";
    private static final String NULL = "null";
    private CodeTemplateInsertRequest request;
    private CompilationInfo cInfo = null;
    private TreePath treePath = null;
    private Scope scope = null;
    private TypeElement enclClass = null;
    private Iterable<? extends Element> locals = null;
    private Map<CodeTemplateParameter, String> param2hints = new HashMap<CodeTemplateParameter, String>();
    private Map<CodeTemplateParameter, TypeMirror> param2types = new HashMap<CodeTemplateParameter, TypeMirror>();
    private ErrChecker errChecker = new ErrChecker();

    private JavaCodeTemplateProcessor(CodeTemplateInsertRequest request) {
        this.request = request;
    }

    public synchronized void updateDefaultValues() {
        boolean cont = true;
        while (cont) {
            cont = false;
            for (Object p : this.request.getMasterParameters()) {
                CodeTemplateParameter param = (CodeTemplateParameter)p;
                String value = this.getProposedValue(param);
                if (value == null || value.equals(param.getValue())) continue;
                param.setValue(value);
                cont = true;
            }
        }
        this.updateImports();
    }

    public void parameterValueChanged(CodeTemplateParameter masterParameter, boolean typingChange) {
        if (typingChange) {
            for (Object p : this.request.getMasterParameters()) {
                CodeTemplateParameter param = (CodeTemplateParameter)p;
                if (!param.isUserModified()) {
                    String value = this.getProposedValue(param);
                    if (value == null || value.equals(param.getValue())) continue;
                    param.setValue(value);
                    continue;
                }
                this.param2types.remove(param);
            }
            this.updateImports();
        }
    }

    public void release() {
    }

    private void updateImports() {
        if (!this.param2types.isEmpty()) {
            AutoImport imp = AutoImport.get(this.cInfo);
            for (Map.Entry<CodeTemplateParameter, TypeMirror> entry : this.param2types.entrySet()) {
                CodeTemplateParameter param = entry.getKey();
                TypeMirror tm = this.param2types.get(param);
                TreePath tp = this.cInfo.getTreeUtilities().pathFor(this.request.getInsertTextOffset() + param.getInsertTextOffset());
                CharSequence typeName = imp.resolveImport(tp, (DeclaredType)tm);
                if (CAST.equals(this.param2hints.get(param))) {
                    param.setValue("(" + typeName + ")");
                    continue;
                }
                if (INSTANCE_OF.equals(this.param2hints.get(param))) {
                    String value = param.getValue().substring(param.getValue().lastIndexOf(46) + 1);
                    param.setValue(typeName + "." + value);
                    continue;
                }
                param.setValue(((Object)typeName).toString());
            }
        }
    }

    private String getProposedValue(CodeTemplateParameter param) {
        this.param2hints.remove(param);
        this.param2types.remove(param);
        String name = null;
        for (Map.Entry e : param.getHints().entrySet()) {
            String value;
            TypeMirror tm;
            VariableElement ve;
            Map.Entry entry = e;
            if (INSTANCE_OF.equals(entry.getKey())) {
                ve = this.instanceOf((String)entry.getValue(), name);
                if (ve != null) {
                    this.param2hints.put(param, INSTANCE_OF);
                    return ve.getSimpleName().toString();
                }
                if (name != null) continue;
                ve = this.staticInstanceOf((String)entry.getValue(), name);
                if (ve != null) {
                    this.param2hints.put(param, INSTANCE_OF);
                    TypeMirror tm2 = ve.getEnclosingElement().asType();
                    if (tm2.getKind() == TypeKind.DECLARED) {
                        this.param2types.put(param, tm2);
                    }
                    return Utilities.getTypeName(tm2, true) + "." + ve.getSimpleName();
                }
                return this.valueOf((String)entry.getValue());
            }
            if (ARRAY.equals(entry.getKey())) {
                ve = this.array();
                if (ve == null) continue;
                this.param2hints.put(param, ARRAY);
                return ve.getSimpleName().toString();
            }
            if (ITERABLE.equals(entry.getKey())) {
                ve = this.iterable();
                if (ve == null) continue;
                this.param2hints.put(param, ITERABLE);
                return ve.getSimpleName().toString();
            }
            if (TYPE.equals(entry.getKey())) {
                tm = this.type((String)entry.getValue());
                if (tm == null || tm.getKind() == TypeKind.ERROR) continue;
                if (tm.getKind() == TypeKind.TYPEVAR) {
                    tm = ((TypeVariable)tm).getUpperBound();
                }
                if ((value = ((Object)Utilities.getTypeName(tm, true)).toString()) == null) continue;
                this.param2hints.put(param, TYPE);
                if (tm.getKind() == TypeKind.DECLARED) {
                    this.param2types.put(param, tm);
                }
                return value;
            }
            if (ITERABLE_ELEMENT_TYPE.equals(entry.getKey())) {
                tm = this.iterableElementType(param.getInsertTextOffset() + 1);
                if (tm == null || tm.getKind() == TypeKind.ERROR) continue;
                if (tm.getKind() == TypeKind.TYPEVAR) {
                    tm = ((TypeVariable)tm).getUpperBound();
                }
                if ((value = ((Object)Utilities.getTypeName(tm, true)).toString()) == null) continue;
                this.param2hints.put(param, ITERABLE_ELEMENT_TYPE);
                if (tm.getKind() == TypeKind.DECLARED) {
                    this.param2types.put(param, tm);
                }
                return value;
            }
            if (LEFT_SIDE_TYPE.equals(entry.getKey())) {
                tm = this.assignmentSideType(param.getInsertTextOffset() + 1, true);
                if (tm == null || tm.getKind() == TypeKind.ERROR) continue;
                if (tm.getKind() == TypeKind.TYPEVAR) {
                    tm = ((TypeVariable)tm).getUpperBound();
                }
                if ((value = ((Object)Utilities.getTypeName(tm, true)).toString()) == null) continue;
                this.param2hints.put(param, LEFT_SIDE_TYPE);
                if (tm.getKind() == TypeKind.DECLARED) {
                    this.param2types.put(param, tm);
                }
                return value;
            }
            if (RIGHT_SIDE_TYPE.equals(entry.getKey())) {
                tm = this.assignmentSideType(param.getInsertTextOffset() + 1, false);
                if (tm == null || tm.getKind() == TypeKind.ERROR) continue;
                if (tm.getKind() == TypeKind.TYPEVAR) {
                    tm = ((TypeVariable)tm).getUpperBound();
                }
                if ((value = ((Object)Utilities.getTypeName(tm, true)).toString()) == null) continue;
                this.param2hints.put(param, RIGHT_SIDE_TYPE);
                if (tm.getKind() == TypeKind.DECLARED) {
                    this.param2types.put(param, tm);
                }
                return value;
            }
            if (CAST.equals(entry.getKey())) {
                tm = this.cast(param.getInsertTextOffset() + 1);
                if (tm == null) {
                    this.param2hints.put(param, CAST);
                    this.param2types.remove(param);
                    return "";
                }
                if (tm.getKind() == TypeKind.ERROR || (value = ((Object)Utilities.getTypeName(tm, true)).toString()) == null) continue;
                this.param2hints.put(param, CAST);
                if (tm.getKind() == TypeKind.DECLARED) {
                    this.param2types.put(param, tm);
                }
                return "(" + value + ")";
            }
            if (NEW_VAR_NAME.equals(entry.getKey())) {
                this.param2hints.put(param, NEW_VAR_NAME);
                return this.newVarName(param.getInsertTextOffset() + 1);
            }
            if (NAMED.equals(entry.getKey())) {
                name = param.getName();
                continue;
            }
            if (!UNCAUGHT_EXCEPTION_TYPE.equals(entry.getKey()) || (tm = this.uncaughtExceptionType(param.getInsertTextOffset() + 1)) == null || tm.getKind() == TypeKind.ERROR) continue;
            if (tm.getKind() == TypeKind.TYPEVAR) {
                tm = ((TypeVariable)tm).getUpperBound();
            }
            if ((value = ((Object)Utilities.getTypeName(tm, true)).toString()) == null) continue;
            this.param2hints.put(param, UNCAUGHT_EXCEPTION_TYPE);
            if (tm.getKind() == TypeKind.DECLARED) {
                this.param2types.put(param, tm);
            }
            return value;
        }
        return null;
    }

    private VariableElement instanceOf(String typeName, String name) {
        try {
            if (this.initParsing()) {
                TypeMirror type = this.cInfo.getTreeUtilities().parseType(typeName, this.enclClass);
                VariableElement closest = null;
                int distance = Integer.MAX_VALUE;
                if (type != null) {
                    Types types = this.cInfo.getTypes();
                    for (Element element : this.locals) {
                        if (!(element instanceof VariableElement) || !types.isAssignable(element.asType(), type)) continue;
                        if (name == null) {
                            return (VariableElement)element;
                        }
                        int d = UiUtils.getDistance((String)element.getSimpleName().toString(), (String)name);
                        if (d >= distance) continue;
                        distance = d;
                        closest = (VariableElement)element;
                    }
                }
                return closest;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private VariableElement staticInstanceOf(String typeName, String name) {
        try {
            if (this.initParsing()) {
                final TreeUtilities tu = this.cInfo.getTreeUtilities();
                TypeMirror type = tu.parseType(typeName, this.enclClass);
                VariableElement closest = null;
                int distance = Integer.MAX_VALUE;
                if (type != null) {
                    final Types types = this.cInfo.getTypes();
                    if (type.getKind() == TypeKind.DECLARED) {
                        final DeclaredType dType = (DeclaredType)type;
                        TypeElement element = (TypeElement)dType.asElement();
                        final boolean isStatic = element.getKind().isClass() || element.getKind().isInterface();
                        ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

                            public boolean accept(Element e, TypeMirror t) {
                                return e.getKind().isField() && (!isStatic || e.getModifiers().contains((Object)Modifier.STATIC)) && tu.isAccessible(JavaCodeTemplateProcessor.this.scope, e, t) && (e.getKind().isField() && types.isAssignable(((VariableElement)e).asType(), dType) || e.getKind() == ElementKind.METHOD && types.isAssignable(((ExecutableElement)e).getReturnType(), dType));
                            }
                        };
                        for (Element ee : this.cInfo.getElementUtilities().getMembers((TypeMirror)dType, acceptor)) {
                            if (name == null) {
                                return (VariableElement)ee;
                            }
                            int d = UiUtils.getDistance((String)ee.getSimpleName().toString(), (String)name);
                            if (d >= distance) continue;
                            distance = d;
                            closest = (VariableElement)ee;
                        }
                    }
                }
                return closest;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String valueOf(String typeName) {
        try {
            TypeMirror type;
            if (this.initParsing() && (type = this.cInfo.getTreeUtilities().parseType(typeName, this.enclClass)) != null) {
                if (type.getKind() == TypeKind.DECLARED) {
                    return NULL;
                }
                if (type.getKind() == TypeKind.BOOLEAN) {
                    return FALSE;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private VariableElement array() {
        if (this.initParsing()) {
            for (Element element : this.locals) {
                if (!(element instanceof VariableElement) || element.asType().getKind() != TypeKind.ARRAY) continue;
                return (VariableElement)element;
            }
        }
        return null;
    }

    private VariableElement iterable() {
        if (this.initParsing()) {
            DeclaredType iterableType = this.cInfo.getTypes().getDeclaredType(this.cInfo.getElements().getTypeElement("java.lang.Iterable"), new TypeMirror[0]);
            for (Element element : this.locals) {
                if (!(element instanceof VariableElement) || element.asType().getKind() != TypeKind.ARRAY && !this.cInfo.getTypes().isAssignable(element.asType(), iterableType)) continue;
                return (VariableElement)element;
            }
        }
        return null;
    }

    private TypeMirror type(String typeName) {
        return this.initParsing() ? this.cInfo.getTreeUtilities().parseType(typeName, this.enclClass) : null;
    }

    private TypeMirror iterableElementType(int caretOffset) {
        try {
            if (this.initParsing()) {
                SourcePositions[] sourcePositions = new SourcePositions[1];
                TreeUtilities tu = this.cInfo.getTreeUtilities();
                StatementTree stmt = tu.parseStatement(this.request.getInsertText(), sourcePositions);
                if (this.errChecker.containsErrors(stmt)) {
                    return null;
                }
                TreePath path = tu.pathFor(new TreePath(this.treePath, stmt), caretOffset, sourcePositions[0]);
                TreePath loop = Utilities.getPathElementOfKind(Tree.Kind.ENHANCED_FOR_LOOP, path);
                if (loop != null) {
                    tu.attributeTree((Tree)stmt, this.scope);
                    TypeMirror type = this.cInfo.getTrees().getTypeMirror(new TreePath(loop, ((EnhancedForLoopTree)loop.getLeaf()).getExpression()));
                    switch (type.getKind()) {
                        case ARRAY: {
                            type = ((ArrayType)type).getComponentType();
                            return type;
                        }
                        case DECLARED: {
                            Iterator<? extends TypeMirror> types = ((DeclaredType)type).getTypeArguments().iterator();
                            if (types.hasNext()) {
                                return types.next();
                            }
                            return this.cInfo.getElements().getTypeElement("java.lang.Object").asType();
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private TypeMirror assignmentSideType(int caretOffset, boolean left) {
        try {
            if (this.initParsing()) {
                SourcePositions[] sourcePositions = new SourcePositions[1];
                TreeUtilities tu = this.cInfo.getTreeUtilities();
                StatementTree stmt = tu.parseStatement(this.request.getInsertText(), sourcePositions);
                if (this.errChecker.containsErrors(stmt)) {
                    return null;
                }
                TreePath path = tu.pathFor(new TreePath(this.treePath, stmt), caretOffset, sourcePositions[0]);
                TreePath tree = Utilities.getPathElementOfKind(EnumSet.of(Tree.Kind.ASSIGNMENT, Tree.Kind.VARIABLE), path);
                if (tree == null) {
                    return null;
                }
                tu.attributeTree((Tree)stmt, this.scope);
                if (tree.getLeaf().getKind() == Tree.Kind.ASSIGNMENT) {
                    AssignmentTree as = (AssignmentTree)tree.getLeaf();
                    TreePath type = new TreePath(tree, left ? as.getVariable() : as.getExpression());
                    return this.cInfo.getTrees().getTypeMirror(type);
                }
                VariableTree vd = (VariableTree)tree.getLeaf();
                TreePath type = new TreePath(tree, left ? vd.getType() : vd.getInitializer());
                return this.cInfo.getTrees().getTypeMirror(type);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private TypeMirror cast(int caretOffset) {
        try {
            if (this.initParsing()) {
                TypeMirror right;
                SourcePositions[] sourcePositions = new SourcePositions[1];
                TreeUtilities tu = this.cInfo.getTreeUtilities();
                StatementTree stmt = tu.parseStatement(this.request.getInsertText(), sourcePositions);
                if (this.errChecker.containsErrors(stmt)) {
                    return null;
                }
                TreePath path = tu.pathFor(new TreePath(this.treePath, stmt), caretOffset, sourcePositions[0]);
                TreePath tree = Utilities.getPathElementOfKind(EnumSet.of(Tree.Kind.ASSIGNMENT, Tree.Kind.VARIABLE), path);
                if (tree == null) {
                    return null;
                }
                tu.attributeTree((Tree)stmt, this.scope);
                if (tree.getLeaf().getKind() == Tree.Kind.ASSIGNMENT) {
                    TypeMirror right2;
                    AssignmentTree as = (AssignmentTree)tree.getLeaf();
                    TypeMirror left = this.cInfo.getTrees().getTypeMirror(new TreePath(tree, as.getVariable()));
                    TreePath exp = new TreePath(tree, as.getExpression());
                    if (exp.getLeaf() instanceof TypeCastTree) {
                        exp = new TreePath(exp, ((TypeCastTree)exp.getLeaf()).getExpression());
                    }
                    if ((right2 = this.cInfo.getTrees().getTypeMirror(exp)) == null || left == null) {
                        return null;
                    }
                    if (this.cInfo.getTypes().isAssignable(right2, left)) {
                        return null;
                    }
                    return left;
                }
                VariableTree vd = (VariableTree)tree.getLeaf();
                TypeMirror left = this.cInfo.getTrees().getTypeMirror(new TreePath(tree, vd.getType()));
                TreePath exp = new TreePath(tree, vd.getInitializer());
                if (exp.getLeaf() instanceof TypeCastTree) {
                    exp = new TreePath(exp, ((TypeCastTree)exp.getLeaf()).getExpression());
                }
                if ((right = this.cInfo.getTrees().getTypeMirror(exp)) == null) {
                    return null;
                }
                if (left == null) {
                    return null;
                }
                if (right.getKind() != TypeKind.ERROR && this.cInfo.getTypes().isAssignable(right, left)) {
                    return null;
                }
                return left;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String newVarName(int caretOffset) {
        try {
            if (this.initParsing()) {
                SourcePositions[] sourcePositions = new SourcePositions[1];
                TreeUtilities tu = this.cInfo.getTreeUtilities();
                StatementTree stmt = tu.parseStatement(this.request.getInsertText(), sourcePositions);
                if (this.errChecker.containsErrors(stmt)) {
                    return null;
                }
                TreePath path = tu.pathFor(new TreePath(this.treePath, stmt), caretOffset, sourcePositions[0]);
                TreePath decl = Utilities.getPathElementOfKind(Tree.Kind.VARIABLE, path);
                if (decl != null) {
                    Scope s = tu.attributeTreeTo((Tree)stmt, this.scope, decl.getLeaf());
                    TypeMirror type = this.cInfo.getTrees().getTypeMirror(decl);
                    boolean isConst = ((VariableTree)decl.getLeaf()).getModifiers().getFlags().containsAll(EnumSet.of(Modifier.FINAL, Modifier.STATIC));
                    final Name varName = ((VariableTree)decl.getLeaf()).getName();
                    ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

                        public boolean accept(Element e, TypeMirror t) {
                            switch (e.getKind()) {
                                case EXCEPTION_PARAMETER: 
                                case LOCAL_VARIABLE: 
                                case PARAMETER: {
                                    return varName != e.getSimpleName();
                                }
                            }
                            return false;
                        }
                    };
                    Iterator<String> names = Utilities.varNamesSuggestions(type, null, this.cInfo.getTypes(), this.cInfo.getElements(), this.cInfo.getElementUtilities().getLocalVars(s, acceptor), isConst).iterator();
                    if (names.hasNext()) {
                        return names.next();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private TypeMirror uncaughtExceptionType(int caretOffset) {
        try {
            if (this.initParsing()) {
                SourcePositions[] sourcePositions = new SourcePositions[1];
                TreeUtilities tu = this.cInfo.getTreeUtilities();
                StatementTree stmt = tu.parseStatement(this.request.getInsertText(), sourcePositions);
                if (this.errChecker.containsErrors(stmt)) {
                    return null;
                }
                TreePath path = tu.pathFor(new TreePath(this.treePath, stmt), caretOffset, sourcePositions[0]);
                if ((path = Utilities.getPathElementOfKind(Tree.Kind.TRY, path)) != null && ((TryTree)path.getLeaf()).getBlock() != null) {
                    tu.attributeTree((Tree)stmt, this.scope);
                    Iterator excs = tu.getUncaughtExceptions(new TreePath(path, ((TryTree)path.getLeaf()).getBlock())).iterator();
                    if (excs.hasNext()) {
                        return (TypeMirror)excs.next();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private boolean initParsing() {
        if (this.cInfo == null) {
            JTextComponent c = this.request.getComponent();
            final int caretOffset = c.getCaret().getDot();
            JavaSource js = JavaSource.forDocument((Document)c.getDocument());
            if (js != null) {
                try {
                    if (SourceUtils.isScanInProgress()) {
                        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JavaCodeTemplateFilter.class, (String)"JCT-scanning-in-progress"));
                        Toolkit.getDefaultToolkit().beep();
                    } else {
                        js.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                            public void cancel() {
                            }

                            public void run(CompilationController controller) throws IOException {
                                CompilationUnitTree cut;
                                Iterator<? extends Tree> it;
                                boolean isStatic;
                                controller.toPhase(JavaSource.Phase.RESOLVED);
                                JavaCodeTemplateProcessor.this.cInfo = (CompilationInfo)controller;
                                final TreeUtilities tu = JavaCodeTemplateProcessor.this.cInfo.getTreeUtilities();
                                JavaCodeTemplateProcessor.this.treePath = tu.pathFor(caretOffset);
                                JavaCodeTemplateProcessor.this.scope = tu.scopeFor(caretOffset);
                                JavaCodeTemplateProcessor.this.enclClass = JavaCodeTemplateProcessor.this.scope.getEnclosingClass();
                                boolean bl = isStatic = JavaCodeTemplateProcessor.this.enclClass != null ? tu.isStaticContext(JavaCodeTemplateProcessor.this.scope) : false;
                                if (JavaCodeTemplateProcessor.this.enclClass == null && (it = (cut = JavaCodeTemplateProcessor.this.treePath.getCompilationUnit()).getTypeDecls().iterator()).hasNext()) {
                                    JavaCodeTemplateProcessor.this.enclClass = (TypeElement)JavaCodeTemplateProcessor.this.cInfo.getTrees().getElement(TreePath.getPath(cut, it.next()));
                                }
                                Trees trees = controller.getTrees();
                                SourcePositions sp = trees.getSourcePositions();
                                final Collection<? extends Element> illegalForwardRefs = Utilities.getForwardReferences(JavaCodeTemplateProcessor.this.treePath, caretOffset, sp, trees);
                                final ExecutableElement method = JavaCodeTemplateProcessor.this.scope.getEnclosingMethod();
                                ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

                                    public boolean accept(Element e, TypeMirror t) {
                                        switch (e.getKind()) {
                                            case LOCAL_VARIABLE: {
                                                if (isStatic && e.getSimpleName().contentEquals("this") || e.getSimpleName().contentEquals("super")) {
                                                    return false;
                                                }
                                            }
                                            case EXCEPTION_PARAMETER: 
                                            case PARAMETER: {
                                                return (method == e.getEnclosingElement() || e.getModifiers().contains((Object)Modifier.FINAL)) && !illegalForwardRefs.contains(e);
                                            }
                                            case FIELD: {
                                                if (!illegalForwardRefs.contains(e)) break;
                                                return false;
                                            }
                                        }
                                        return (!isStatic || e.getModifiers().contains((Object)Modifier.STATIC)) && tu.isAccessible(JavaCodeTemplateProcessor.this.scope, e, t);
                                    }
                                };
                                JavaCodeTemplateProcessor.this.locals = JavaCodeTemplateProcessor.this.cInfo.getElementUtilities().getLocalMembersAndVars(JavaCodeTemplateProcessor.this.scope, acceptor);
                            }
                        }, false);
                    }
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }
        }
        return this.cInfo != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ErrChecker
    extends TreeScanner<Void, Void> {
        private boolean containsErrors;

        private ErrChecker() {
        }

        public boolean containsErrors(Tree tree) {
            this.containsErrors = false;
            this.scan(tree, null);
            return this.containsErrors;
        }

        @Override
        public Void visitErroneous(ErroneousTree node, Void p) {
            this.containsErrors = true;
            return null;
        }

        @Override
        public Void scan(Tree node, Void p) {
            if (this.containsErrors) {
                return null;
            }
            return (Void)super.scan(node, p);
        }
    }

    public static final class Factory
    implements CodeTemplateProcessorFactory {
        public CodeTemplateProcessor createProcessor(CodeTemplateInsertRequest request) {
            return new JavaCodeTemplateProcessor(request);
        }
    }
}

