/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplateManager;
import org.netbeans.modules.editor.java.AutoImport;
import org.netbeans.modules.editor.java.JavaCompletionProvider;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.xml.XMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaCompletionItem
implements CompletionItem {
    protected static int SMART_TYPE = 1000;
    public static final String COLOR_END = "</font>";
    public static final String STRIKE = "<s>";
    public static final String STRIKE_END = "</s>";
    public static final String BOLD = "<b>";
    public static final String BOLD_END = "</b>";
    protected int substitutionOffset;
    private static final int PUBLIC_LEVEL = 3;
    private static final int PROTECTED_LEVEL = 2;
    private static final int PACKAGE_LEVEL = 1;
    private static final int PRIVATE_LEVEL = 0;

    public static final JavaCompletionItem createKeywordItem(String kwd, String postfix, int substitutionOffset, boolean smartType) {
        return new KeywordItem(kwd, 0, postfix, substitutionOffset, smartType);
    }

    public static final JavaCompletionItem createPackageItem(String pkgFQN, int substitutionOffset, boolean isDeprecated) {
        return new PackageItem(pkgFQN, substitutionOffset, isDeprecated);
    }

    public static final JavaCompletionItem createTypeItem(TypeElement elem, DeclaredType type, int substitutionOffset, boolean displayPkgName, boolean isDeprecated, boolean smartType) {
        switch (elem.getKind()) {
            case CLASS: {
                return new ClassItem(elem, type, 0, substitutionOffset, displayPkgName, isDeprecated, smartType);
            }
            case INTERFACE: {
                return new InterfaceItem(elem, type, 0, substitutionOffset, displayPkgName, isDeprecated, smartType);
            }
            case ENUM: {
                return new EnumItem(elem, type, 0, substitutionOffset, displayPkgName, isDeprecated, smartType);
            }
            case ANNOTATION_TYPE: {
                return new AnnotationTypeItem(elem, type, 0, substitutionOffset, displayPkgName, isDeprecated, smartType);
            }
        }
        throw new IllegalArgumentException("kind=" + (Object)((Object)elem.getKind()));
    }

    public static final JavaCompletionItem createArrayItem(ArrayType type, int substitutionOffset, Elements elements) {
        int dim = 0;
        TypeMirror tm = type;
        while (tm.getKind() == TypeKind.ARRAY) {
            tm = tm.getComponentType();
            ++dim;
        }
        if (tm.getKind().isPrimitive()) {
            return new KeywordItem(((Object)tm).toString(), dim, null, substitutionOffset, true);
        }
        if (tm.getKind() == TypeKind.DECLARED || tm.getKind() == TypeKind.ERROR) {
            DeclaredType dt = (DeclaredType)tm;
            TypeElement elem = (TypeElement)dt.asElement();
            switch (elem.getKind()) {
                case CLASS: {
                    return new ClassItem(elem, dt, dim, substitutionOffset, true, elements.isDeprecated(elem), true);
                }
                case INTERFACE: {
                    return new InterfaceItem(elem, dt, dim, substitutionOffset, true, elements.isDeprecated(elem), true);
                }
                case ENUM: {
                    return new EnumItem(elem, dt, dim, substitutionOffset, true, elements.isDeprecated(elem), true);
                }
                case ANNOTATION_TYPE: {
                    return new AnnotationTypeItem(elem, dt, dim, substitutionOffset, true, elements.isDeprecated(elem), true);
                }
            }
        }
        throw new IllegalArgumentException("array element kind=" + (Object)((Object)tm.getKind()));
    }

    public static final JavaCompletionItem createTypeParameterItem(TypeParameterElement elem, int substitutionOffset) {
        return new TypeParameterItem(elem, substitutionOffset);
    }

    public static final JavaCompletionItem createVariableItem(VariableElement elem, TypeMirror type, int substitutionOffset, boolean isInherited, boolean isDeprecated, boolean smartType) {
        switch (elem.getKind()) {
            case LOCAL_VARIABLE: 
            case PARAMETER: 
            case EXCEPTION_PARAMETER: {
                return new VariableItem(type, elem.getSimpleName().toString(), substitutionOffset, smartType);
            }
            case ENUM_CONSTANT: 
            case FIELD: {
                return new FieldItem(elem, type, substitutionOffset, isInherited, isDeprecated, smartType);
            }
        }
        throw new IllegalArgumentException("kind=" + (Object)((Object)elem.getKind()));
    }

    public static final JavaCompletionItem createVariableItem(String varName, int substitutionOffset, boolean smartType) {
        return new VariableItem(null, varName, substitutionOffset, smartType);
    }

    public static final JavaCompletionItem createExecutableItem(ExecutableElement elem, ExecutableType type, int substitutionOffset, boolean isInherited, boolean isDeprecated, boolean inImport, boolean smartType) {
        switch (elem.getKind()) {
            case METHOD: {
                return new MethodItem(elem, type, substitutionOffset, isInherited, isDeprecated, inImport, smartType);
            }
            case CONSTRUCTOR: {
                return new ConstructorItem(elem, type, substitutionOffset, isDeprecated);
            }
        }
        throw new IllegalArgumentException("kind=" + (Object)((Object)elem.getKind()));
    }

    public static final JavaCompletionItem createOverrideMethodItem(ExecutableElement elem, ExecutableType type, int substitutionOffset, boolean implement) {
        switch (elem.getKind()) {
            case METHOD: {
                return new OverrideMethodItem(elem, type, substitutionOffset, implement);
            }
        }
        throw new IllegalArgumentException("kind=" + (Object)((Object)elem.getKind()));
    }

    public static final JavaCompletionItem createDefaultConstructorItem(TypeElement elem, int substitutionOffset) {
        return new DefaultConstructorItem(elem, substitutionOffset);
    }

    public static final JavaCompletionItem createAnnotationItem(TypeElement elem, DeclaredType type, int substitutionOffset, boolean isDeprecated) {
        return new AnnotationItem(elem, type, substitutionOffset, isDeprecated, true);
    }

    public static final JavaCompletionItem createAttributeItem(ExecutableElement elem, ExecutableType type, int substitutionOffset, boolean isDeprecated) {
        return new AttributeItem(elem, type, substitutionOffset, isDeprecated);
    }

    public static final JavaCompletionItem createStaticMemberItem(DeclaredType type, Element memberElem, TypeMirror memberType, int substitutionOffset, boolean isDeprecated) {
        switch (memberElem.getKind()) {
            case ENUM_CONSTANT: 
            case FIELD: 
            case METHOD: {
                return new StaticMemberItem(type, memberElem, memberType, substitutionOffset, isDeprecated);
            }
        }
        throw new IllegalArgumentException("kind=" + (Object)((Object)memberElem.getKind()));
    }

    public static final JavaCompletionItem createInitializeAllConstructorItem(Iterable<? extends VariableElement> fields, TypeElement parent, int substitutionOffset) {
        return new InitializeAllConstructorItem(fields, parent, substitutionOffset);
    }

    JavaCompletionItem(int substitutionOffset) {
        this.substitutionOffset = substitutionOffset;
    }

    public void defaultAction(JTextComponent component) {
        if (component != null) {
            Completion.get().hideDocumentation();
            Completion.get().hideCompletion();
            int caretOffset = component.getSelectionEnd();
            this.substituteText(component, this.substitutionOffset, caretOffset - this.substitutionOffset, null);
        }
    }

    public void processKeyEvent(KeyEvent evt) {
        if (evt.getID() == 400) {
            switch (evt.getKeyChar()) {
                case '(': 
                case ',': 
                case ';': {
                    Completion.get().hideDocumentation();
                    Completion.get().hideCompletion();
                }
                case '.': {
                    JTextComponent component = (JTextComponent)evt.getSource();
                    int caretOffset = component.getSelectionEnd();
                    this.substituteText(component, this.substitutionOffset, caretOffset - this.substitutionOffset, Character.toString(evt.getKeyChar()));
                    if (evt.getKeyChar() == '.') {
                        Completion.get().showCompletion();
                    }
                    evt.consume();
                }
            }
        }
    }

    public boolean instantSubstitution(JTextComponent component) {
        this.defaultAction(component);
        return true;
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public int getPreferredWidth(Graphics g, Font defaultFont) {
        return CompletionUtilities.getPreferredWidth((String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)g, (Font)defaultFont);
    }

    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        CompletionUtilities.renderHtml((ImageIcon)this.getIcon(), (String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)g, (Font)defaultFont, (Color)defaultColor, (int)width, (int)height, (boolean)selected);
    }

    protected ImageIcon getIcon() {
        return null;
    }

    protected String getLeftHtmlText() {
        return null;
    }

    protected String getRightHtmlText() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void substituteText(JTextComponent c, int offset, int len, String toAdd) {
        BaseDocument doc = (BaseDocument)c.getDocument();
        String text = ((Object)this.getInsertPrefix()).toString();
        if (text != null) {
            int semiPos;
            int n = semiPos = toAdd != null && toAdd.endsWith(";") ? JavaCompletionItem.findPositionForSemicolon(c) : -2;
            if (semiPos > -2) {
                String string = toAdd = toAdd.length() > 1 ? toAdd.substring(0, toAdd.length() - 1) : null;
            }
            if (toAdd != null && !toAdd.equals("\n")) {
                TokenSequence<JavaTokenId> sequence = Utilities.getJavaTokenSequence(c, offset + len);
                if (sequence == null) {
                    text = text + toAdd;
                    toAdd = null;
                }
                boolean added = false;
                while (toAdd != null && toAdd.length() > 0) {
                    String tokenText = ((Object)sequence.token().text()).toString();
                    if (tokenText.startsWith(toAdd)) {
                        len = sequence.offset() - offset + toAdd.length();
                        text = text + toAdd;
                        toAdd = null;
                        continue;
                    }
                    if (toAdd.startsWith(tokenText)) {
                        sequence.moveNext();
                        len = sequence.offset() - offset;
                        text = text + toAdd.substring(0, tokenText.length());
                        toAdd = toAdd.substring(tokenText.length());
                        added = true;
                        continue;
                    }
                    if (sequence.token().id() == JavaTokenId.WHITESPACE && ((Object)sequence.token().text()).toString().indexOf(10) < 0) {
                        if (sequence.moveNext()) continue;
                        text = text + toAdd;
                        toAdd = null;
                        continue;
                    }
                    if (!added) {
                        text = text + toAdd;
                    }
                    toAdd = null;
                }
            }
            doc.atomicLock();
            try {
                String textToReplace = doc.getText(offset, len);
                if (text.equals(textToReplace)) {
                    if (semiPos > -1) {
                        doc.insertString(semiPos, ";", null);
                    }
                    return;
                }
                Position position = doc.createPosition(offset);
                Position semiPosition = semiPos > -1 ? doc.createPosition(semiPos) : null;
                doc.remove(offset, len);
                doc.insertString(position.getOffset(), text, null);
                if (semiPosition != null) {
                    doc.insertString(semiPosition.getOffset(), ";", null);
                }
            }
            catch (BadLocationException e) {
            }
            finally {
                doc.atomicUnlock();
            }
        }
    }

    private static int getProtectionLevel(Set<Modifier> modifiers) {
        if (modifiers.contains((Object)Modifier.PUBLIC)) {
            return 3;
        }
        if (modifiers.contains((Object)Modifier.PROTECTED)) {
            return 2;
        }
        if (modifiers.contains((Object)Modifier.PRIVATE)) {
            return 0;
        }
        return 1;
    }

    private static String escape(String s) {
        if (s != null) {
            try {
                return XMLUtil.toAttributeValue((String)s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return s;
    }

    private static int findPositionForSemicolon(JTextComponent c) {
        final int[] ret = new int[]{-2};
        final int offset = c.getSelectionEnd();
        try {
            JavaSource js = JavaSource.forDocument((Document)c.getDocument());
            js.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController controller) throws Exception {
                    SourcePositions sp;
                    int endPos;
                    TokenSequence ts;
                    TreePath tp;
                    controller.toPhase(JavaSource.Phase.PARSED);
                    Tree t = null;
                    block5: for (tp = controller.getTreeUtilities().pathFor(offset); t == null && tp != null; tp = tp.getParentPath()) {
                        switch (tp.getLeaf().getKind()) {
                            case IMPORT: 
                            case EXPRESSION_STATEMENT: {
                                t = tp.getLeaf();
                                continue block5;
                            }
                            case RETURN: {
                                t = ((ReturnTree)tp.getLeaf()).getExpression();
                                continue block5;
                            }
                            case THROW: {
                                t = ((ThrowTree)tp.getLeaf()).getExpression();
                            }
                        }
                    }
                    if (t != null && (ts = JavaCompletionItem.findLastNonWhitespaceToken(controller, offset, endPos = (int)(sp = controller.getTrees().getSourcePositions()).getEndPosition(tp.getCompilationUnit(), t))) != null) {
                        ret[0] = ts.token().id() == JavaTokenId.SEMICOLON ? -1 : ts.offset() + ts.token().length();
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret[0];
    }

    private static TokenSequence<JavaTokenId> findLastNonWhitespaceToken(CompilationController controller, int startPos, int endPos) {
        TokenSequence ts = controller.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        ts.move(endPos);
        block3: while (ts.movePrevious()) {
            int offset = ts.offset();
            if (offset < startPos) {
                return null;
            }
            switch ((JavaTokenId)ts.token().id()) {
                case WHITESPACE: 
                case LINE_COMMENT: 
                case BLOCK_COMMENT: {
                    continue block3;
                }
            }
            return ts;
        }
        return null;
    }

    private static class AnnotationItem
    extends AnnotationTypeItem {
        private AnnotationItem(TypeElement elem, DeclaredType type, int substitutionOffset, boolean isDeprecated, boolean smartType) {
            super(elem, type, 0, substitutionOffset, true, isDeprecated, smartType);
        }

        public CharSequence getInsertPrefix() {
            return "@" + super.getInsertPrefix();
        }

        protected void substituteText(JTextComponent c, final int offset, int len, String toAdd) {
            int semiPos;
            final BaseDocument doc = (BaseDocument)c.getDocument();
            final StringBuilder text = new StringBuilder();
            int n = semiPos = toAdd != null && toAdd.endsWith(";") ? JavaCompletionItem.findPositionForSemicolon(c) : -2;
            if (semiPos > -2) {
                String string = toAdd = toAdd.length() > 1 ? toAdd.substring(0, toAdd.length() - 1) : null;
            }
            if (toAdd != null && !toAdd.equals("\n")) {
                TokenSequence<JavaTokenId> sequence = Utilities.getJavaTokenSequence(c, offset + len);
                if (sequence == null) {
                    text.append(toAdd);
                    toAdd = null;
                }
                boolean added = false;
                while (toAdd != null && toAdd.length() > 0) {
                    String tokenText = ((Object)sequence.token().text()).toString();
                    if (tokenText.startsWith(toAdd)) {
                        len = sequence.offset() - offset + toAdd.length();
                        text.append(toAdd);
                        toAdd = null;
                        continue;
                    }
                    if (toAdd.startsWith(tokenText)) {
                        sequence.moveNext();
                        len = sequence.offset() - offset;
                        text.append(toAdd.substring(0, tokenText.length()));
                        toAdd = toAdd.substring(tokenText.length());
                        added = true;
                        continue;
                    }
                    if (sequence.token().id() == JavaTokenId.WHITESPACE && ((Object)sequence.token().text()).toString().indexOf(10) < 0) {
                        if (sequence.moveNext()) continue;
                        text.append(toAdd);
                        toAdd = null;
                        continue;
                    }
                    if (!added) {
                        text.append(toAdd);
                    }
                    toAdd = null;
                }
            }
            final int finalLen = len;
            JavaSource js = JavaSource.forDocument((Document)doc);
            try {
                js.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run(CompilationController controller) throws IOException {
                        controller.toPhase(JavaSource.Phase.RESOLVED);
                        TypeElement elem = (TypeElement)AnnotationItem.this.elementHandle.resolve((CompilationInfo)controller);
                        doc.atomicLock();
                        try {
                            Position semiPosition = semiPos > -1 ? doc.createPosition(semiPos) : null;
                            TreePath tp = controller.getTreeUtilities().pathFor(offset);
                            text.insert(0, "@" + AutoImport.resolveImport((CompilationInfo)controller, tp, controller.getTypes().getDeclaredType(elem, new TypeMirror[0])));
                            String textToReplace = doc.getText(offset, finalLen);
                            if (textToReplace.contentEquals(text)) {
                                return;
                            }
                            doc.remove(offset, finalLen);
                            doc.insertString(offset, text.toString(), null);
                            if (semiPosition != null) {
                                doc.insertString(semiPosition.getOffset(), ";", null);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                        }
                        finally {
                            doc.atomicUnlock();
                        }
                    }
                }, true);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }

    private static class AnnotationTypeItem
    extends ClassItem {
        private static final String ANNOTATION = "org/netbeans/modules/editor/resources/completion/annotation_type.png";
        private static ImageIcon icon;

        private AnnotationTypeItem(TypeElement elem, DeclaredType type, int dim, int substitutionOffset, boolean displayPkgName, boolean isDeprecated, boolean smartType) {
            super(elem, type, dim, substitutionOffset, displayPkgName, isDeprecated, smartType);
        }

        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = new ImageIcon(org.openide.util.Utilities.loadImage((String)ANNOTATION));
            }
            return icon;
        }
    }

    private static class AttributeItem
    extends JavaCompletionItem {
        private static final String ATTRIBUTE = "org/netbeans/modules/java/editor/resources/attribute_16.png";
        private static final String ATTRIBUTE_COLOR = "<font color=#404040>";
        private static ImageIcon icon;
        private ElementHandle<ExecutableElement> elementHandle;
        private boolean isDeprecated;
        private String simpleName;
        private String typeName;
        private String defaultValue;
        private String leftText;
        private String rightText;

        private AttributeItem(ExecutableElement elem, ExecutableType type, int substitutionOffset, boolean isDeprecated) {
            super(substitutionOffset);
            this.elementHandle = ElementHandle.create((Element)elem);
            this.isDeprecated = isDeprecated;
            this.simpleName = elem.getSimpleName().toString();
            this.typeName = ((Object)Utilities.getTypeName(type.getReturnType(), false)).toString();
            AnnotationValue value = elem.getDefaultValue();
            this.defaultValue = value != null ? ((Object)value).toString() : null;
        }

        public int getSortPriority() {
            return 100;
        }

        public CharSequence getSortText() {
            return this.simpleName;
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName + "=";
        }

        public CompletionTask createDocumentationTask() {
            return JavaCompletionProvider.createDocTask(this.elementHandle);
        }

        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = new ImageIcon(org.openide.util.Utilities.loadImage((String)ATTRIBUTE));
            }
            return icon;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder sb = new StringBuilder();
                sb.append(ATTRIBUTE_COLOR);
                if (this.defaultValue == null) {
                    sb.append(JavaCompletionItem.BOLD);
                }
                if (this.isDeprecated) {
                    sb.append(JavaCompletionItem.STRIKE);
                }
                sb.append(this.simpleName);
                if (this.isDeprecated) {
                    sb.append(JavaCompletionItem.STRIKE_END);
                }
                if (this.defaultValue == null) {
                    sb.append(JavaCompletionItem.BOLD_END);
                } else {
                    sb.append(" = ");
                    sb.append(this.defaultValue);
                }
                sb.append(JavaCompletionItem.COLOR_END);
                this.leftText = sb.toString();
            }
            return this.leftText;
        }

        protected String getRightHtmlText() {
            if (this.rightText == null) {
                this.rightText = JavaCompletionItem.escape(this.typeName);
            }
            return this.rightText;
        }

        public String toString() {
            return this.simpleName;
        }
    }

    private static class ClassItem
    extends JavaCompletionItem {
        private static final String CLASS = "org/netbeans/modules/editor/resources/completion/class_16.png";
        private static final String CLASS_COLOR = "<font color=#560000>";
        private static final String PKG_COLOR = "<font color=#808080>";
        private static ImageIcon icon;
        protected ElementHandle<TypeElement> elementHandle;
        private TypeMirrorHandle<DeclaredType> typeHandle;
        private int dim;
        private boolean isDeprecated;
        private boolean smartType;
        private String simpleName;
        private String typeName;
        private String enclName;
        private CharSequence sortText;
        private String leftText;

        private ClassItem(TypeElement elem, DeclaredType type, int dim, int substitutionOffset, boolean displayPkgName, boolean isDeprecated, boolean smartType) {
            super(substitutionOffset);
            this.elementHandle = ElementHandle.create((Element)elem);
            this.typeHandle = TypeMirrorHandle.create((TypeMirror)type);
            this.dim = dim;
            this.isDeprecated = isDeprecated;
            this.smartType = smartType;
            this.simpleName = elem.getSimpleName().toString();
            this.typeName = ((Object)Utilities.getTypeName(type, false)).toString();
            if (displayPkgName) {
                this.enclName = ((Object)Utilities.getElementName(elem.getEnclosingElement(), true)).toString();
                this.sortText = new ClassSortText(this.simpleName, this.enclName);
            } else {
                this.enclName = null;
                this.sortText = this.simpleName;
            }
        }

        public int getSortPriority() {
            return this.smartType ? 800 - SMART_TYPE : 800;
        }

        public CharSequence getSortText() {
            return this.sortText;
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        public boolean instantSubstitution(JTextComponent component) {
            return false;
        }

        public CompletionTask createDocumentationTask() {
            return JavaCompletionProvider.createDocTask(this.elementHandle);
        }

        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = new ImageIcon(org.openide.util.Utilities.loadImage((String)CLASS));
            }
            return icon;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder sb = new StringBuilder();
                sb.append(this.getColor());
                if (this.isDeprecated) {
                    sb.append(JavaCompletionItem.STRIKE);
                }
                sb.append(JavaCompletionItem.escape(this.typeName));
                for (int i = 0; i < this.dim; ++i) {
                    sb.append("[]");
                }
                if (this.isDeprecated) {
                    sb.append(JavaCompletionItem.STRIKE_END);
                }
                if (this.enclName != null && this.enclName.length() > 0) {
                    sb.append(JavaCompletionItem.COLOR_END);
                    sb.append(PKG_COLOR);
                    sb.append(" (");
                    sb.append(this.enclName);
                    sb.append(")");
                }
                sb.append(JavaCompletionItem.COLOR_END);
                this.leftText = sb.toString();
            }
            return this.leftText;
        }

        protected String getColor() {
            return CLASS_COLOR;
        }

        protected void substituteText(final JTextComponent c, final int offset, int len, String toAdd) {
            int semiPos;
            if (this.enclName == null) {
                super.substituteText(c, offset, len, toAdd);
                return;
            }
            final BaseDocument doc = (BaseDocument)c.getDocument();
            final StringBuilder text = new StringBuilder();
            int n = semiPos = toAdd != null && toAdd.endsWith(";") ? JavaCompletionItem.findPositionForSemicolon(c) : -2;
            if (semiPos > -2) {
                String string = toAdd = toAdd.length() > 1 ? toAdd.substring(0, toAdd.length() - 1) : null;
            }
            if (toAdd != null && !toAdd.equals("\n")) {
                TokenSequence<JavaTokenId> sequence = Utilities.getJavaTokenSequence(c, offset + len);
                if (sequence == null) {
                    text.append(toAdd);
                    toAdd = null;
                }
                boolean added = false;
                while (toAdd != null && toAdd.length() > 0) {
                    String tokenText = ((Object)sequence.token().text()).toString();
                    if (tokenText.startsWith(toAdd)) {
                        len = sequence.offset() - offset + toAdd.length();
                        text.append(toAdd);
                        toAdd = null;
                        continue;
                    }
                    if (toAdd.startsWith(tokenText)) {
                        sequence.moveNext();
                        len = sequence.offset() - offset;
                        text.append(toAdd.substring(0, tokenText.length()));
                        toAdd = toAdd.substring(tokenText.length());
                        added = true;
                        continue;
                    }
                    if (sequence.token().id() == JavaTokenId.WHITESPACE && ((Object)sequence.token().text()).toString().indexOf(10) < 0) {
                        if (sequence.moveNext()) continue;
                        text.append(toAdd);
                        toAdd = null;
                        continue;
                    }
                    if (!added) {
                        text.append(toAdd);
                    }
                    toAdd = null;
                }
            }
            final int finalLen = len;
            JavaSource js = JavaSource.forDocument((Document)doc);
            try {
                js.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run(CompilationController controller) throws IOException {
                        controller.toPhase(JavaSource.Phase.RESOLVED);
                        TypeElement elem = (TypeElement)ClassItem.this.elementHandle.resolve((CompilationInfo)controller);
                        DeclaredType type = (DeclaredType)ClassItem.this.typeHandle.resolve((CompilationInfo)controller);
                        boolean asTemplate = false;
                        StringBuilder sb = new StringBuilder();
                        int cnt = 1;
                        sb.append("${PAR");
                        sb.append(cnt++);
                        if (type.getKind() != TypeKind.ERROR) {
                            sb.append(" type=\"");
                            sb.append(elem.getQualifiedName());
                        } else {
                            sb.append(" default=\"");
                            sb.append(elem.getQualifiedName());
                        }
                        sb.append("\" editable=false}");
                        Iterator<? extends TypeMirror> tas = type.getTypeArguments().iterator();
                        if (tas.hasNext()) {
                            sb.append('<');
                            while (tas.hasNext()) {
                                TypeMirror ta = tas.next();
                                sb.append("${PAR");
                                sb.append(cnt++);
                                if (ta.getKind() == TypeKind.TYPEVAR) {
                                    TypeVariable tv = (TypeVariable)ta;
                                    if (elem == tv.asElement().getEnclosingElement()) {
                                        sb.append(" type=\"");
                                        ta = tv.getUpperBound();
                                    } else {
                                        sb.append(" editable=false default=\"");
                                        asTemplate = true;
                                    }
                                    sb.append(Utilities.getTypeName(ta, true));
                                    sb.append("\"}");
                                } else if (ta.getKind() == TypeKind.WILDCARD) {
                                    sb.append(" type=\"");
                                    TypeMirror bound = ((WildcardType)ta).getExtendsBound();
                                    if (bound == null) {
                                        bound = ((WildcardType)ta).getSuperBound();
                                    }
                                    sb.append(bound != null ? Utilities.getTypeName(bound, true) : "java.lang.Object");
                                    sb.append("\"}");
                                    asTemplate = true;
                                } else if (ta.getKind() == TypeKind.ERROR) {
                                    sb.append(" default=\"\"}");
                                    asTemplate = true;
                                } else {
                                    sb.append(" type=\"");
                                    sb.append(Utilities.getTypeName(ta, true));
                                    sb.append("\" editable=false}");
                                    asTemplate = true;
                                }
                                if (!tas.hasNext()) continue;
                                sb.append(", ");
                            }
                            sb.append('>');
                        }
                        for (int i = 0; i < ClassItem.this.dim; ++i) {
                            sb.append("[${PAR");
                            sb.append(cnt++);
                            sb.append(" instanceof=\"int\" default=\"\"}]");
                            asTemplate = true;
                        }
                        if (asTemplate) {
                            CodeTemplateManager ctm;
                            if (finalLen > 0) {
                                doc.atomicLock();
                                try {
                                    doc.remove(offset, finalLen);
                                }
                                catch (BadLocationException e) {
                                }
                                finally {
                                    doc.atomicUnlock();
                                }
                            }
                            if ((ctm = CodeTemplateManager.get((Document)doc)) != null) {
                                ctm.createTemporary(sb.append((CharSequence)text).toString()).insert(c);
                            }
                        } else {
                            doc.atomicLock();
                            try {
                                Position semiPosition = semiPos > -1 ? doc.createPosition(semiPos) : null;
                                TreePath tp = controller.getTreeUtilities().pathFor(offset);
                                text.insert(0, AutoImport.resolveImport((CompilationInfo)controller, tp, controller.getTypes().getDeclaredType(elem, new TypeMirror[0])));
                                String textToReplace = doc.getText(offset, finalLen);
                                if (textToReplace.contentEquals(text)) {
                                    return;
                                }
                                doc.remove(offset, finalLen);
                                doc.insertString(offset, text.toString(), null);
                                if (semiPosition != null) {
                                    doc.insertString(semiPosition.getOffset(), ";", null);
                                }
                            }
                            catch (BadLocationException e) {
                            }
                            finally {
                                doc.atomicUnlock();
                            }
                        }
                    }
                }, true);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }

        public String toString() {
            return this.simpleName;
        }
    }

    static class ClassSortText
    implements CharSequence {
        private String name;
        private String pkgName;
        private String text;

        public ClassSortText(String name, String pkgName) {
            this.name = name + "#";
            this.pkgName = pkgName;
        }

        public int length() {
            return this.name.length() + this.pkgName.length() + 3;
        }

        public char charAt(int index) {
            return index < this.name.length() ? this.name.charAt(index) : this.getText().charAt(index);
        }

        public CharSequence subSequence(int start, int end) {
            return this.getText().subSequence(start, end);
        }

        private String getText() {
            if (this.text == null) {
                this.text = this.name + Utilities.getImportanceLevel(this.pkgName) + "#" + this.pkgName;
            }
            return this.text;
        }
    }

    private static class ConstructorItem
    extends JavaCompletionItem {
        private static final String CONSTRUCTOR_PUBLIC = "org/netbeans/modules/editor/resources/completion/constructor_16.png";
        private static final String CONSTRUCTOR_PROTECTED = "org/netbeans/modules/editor/resources/completion/constructor_protected_16.png";
        private static final String CONSTRUCTOR_PACKAGE = "org/netbeans/modules/editor/resources/completion/constructor_package_private_16.png";
        private static final String CONSTRUCTOR_PRIVATE = "org/netbeans/modules/editor/resources/completion/constructor_private_16.png";
        private static final String CONSTRUCTOR_COLOR = "<font color=#b28b00>";
        private static final String PARAMETER_NAME_COLOR = "<font color=#a06001>";
        private static ImageIcon[] icon = new ImageIcon[4];
        private ElementHandle<ExecutableElement> elementHandle;
        private boolean isDeprecated;
        private String simpleName;
        protected Set<Modifier> modifiers;
        private List<ParamDesc> params;
        private boolean isAbstract;
        private String sortText;
        private String leftText;

        private ConstructorItem(ExecutableElement elem, ExecutableType type, int substitutionOffset, boolean isDeprecated) {
            super(substitutionOffset);
            this.elementHandle = ElementHandle.create((Element)elem);
            this.isDeprecated = isDeprecated;
            this.simpleName = elem.getEnclosingElement().getSimpleName().toString();
            this.modifiers = elem.getModifiers();
            this.params = new ArrayList<ParamDesc>();
            Iterator<? extends VariableElement> it = elem.getParameters().iterator();
            Iterator<? extends TypeMirror> tIt = type.getParameterTypes().iterator();
            while (it.hasNext() && tIt.hasNext()) {
                TypeMirror tm = tIt.next();
                this.params.add(new ParamDesc(((Object)tm).toString(), ((Object)Utilities.getTypeName(tm, false, elem.isVarArgs() && !tIt.hasNext())).toString(), it.next().getSimpleName().toString()));
            }
            this.isAbstract = elem.getEnclosingElement().getModifiers().contains((Object)Modifier.ABSTRACT);
        }

        public int getSortPriority() {
            return 650;
        }

        public CharSequence getSortText() {
            if (this.sortText == null) {
                StringBuilder sortParams = new StringBuilder();
                sortParams.append('(');
                int cnt = 0;
                Iterator<ParamDesc> it = this.params.iterator();
                while (it.hasNext()) {
                    ParamDesc paramDesc = it.next();
                    sortParams.append(paramDesc.typeName);
                    if (it.hasNext()) {
                        sortParams.append(',');
                    }
                    ++cnt;
                }
                sortParams.append(')');
                this.sortText = this.simpleName + "#" + (cnt < 10 ? "0" : "") + cnt + "#" + sortParams.toString();
            }
            return this.sortText;
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder lText = new StringBuilder();
                lText.append(CONSTRUCTOR_COLOR);
                lText.append(JavaCompletionItem.BOLD);
                if (this.isDeprecated) {
                    lText.append(JavaCompletionItem.STRIKE);
                }
                lText.append(this.simpleName);
                if (this.isDeprecated) {
                    lText.append(JavaCompletionItem.STRIKE_END);
                }
                lText.append(JavaCompletionItem.BOLD_END);
                lText.append(JavaCompletionItem.COLOR_END);
                lText.append('(');
                Iterator<ParamDesc> it = this.params.iterator();
                while (it.hasNext()) {
                    ParamDesc paramDesc = it.next();
                    lText.append(JavaCompletionItem.escape(paramDesc.typeName));
                    lText.append(' ');
                    lText.append(PARAMETER_NAME_COLOR);
                    lText.append(paramDesc.name);
                    lText.append(JavaCompletionItem.COLOR_END);
                    if (!it.hasNext()) continue;
                    lText.append(", ");
                }
                lText.append(')');
                this.leftText = lText.toString();
            }
            return this.leftText;
        }

        public CompletionTask createDocumentationTask() {
            return JavaCompletionProvider.createDocTask(this.elementHandle);
        }

        protected ImageIcon getIcon() {
            ImageIcon newIcon;
            int level = JavaCompletionItem.getProtectionLevel(this.modifiers);
            ImageIcon cachedIcon = icon[level];
            if (cachedIcon != null) {
                return cachedIcon;
            }
            String iconPath = CONSTRUCTOR_PUBLIC;
            switch (level) {
                case 0: {
                    iconPath = CONSTRUCTOR_PRIVATE;
                    break;
                }
                case 1: {
                    iconPath = CONSTRUCTOR_PACKAGE;
                    break;
                }
                case 2: {
                    iconPath = CONSTRUCTOR_PROTECTED;
                    break;
                }
                case 3: {
                    iconPath = CONSTRUCTOR_PUBLIC;
                }
            }
            ConstructorItem.icon[level] = newIcon = new ImageIcon(org.openide.util.Utilities.loadImage((String)iconPath));
            return newIcon;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void substituteText(JTextComponent c, int offset, int len, String toAdd) {
            CodeTemplateManager ctm;
            Position position;
            String add;
            int semiPos;
            offset += len;
            len = 0;
            int n = semiPos = toAdd != null && toAdd.endsWith(";") ? JavaCompletionItem.findPositionForSemicolon(c) : -2;
            if (semiPos > -2) {
                toAdd = toAdd.length() > 1 ? toAdd.substring(0, toAdd.length() - 1) : null;
            }
            BaseDocument doc = (BaseDocument)c.getDocument();
            TokenSequence<JavaTokenId> sequence = Utilities.getJavaTokenSequence(c, offset);
            if (sequence != null) {
                sequence.movePrevious();
                if (sequence.token().id() == JavaTokenId.THIS || sequence.token().id() == JavaTokenId.SUPER) {
                    this.isAbstract = false;
                    if (toAdd == null) {
                        toAdd = ";";
                    }
                }
                sequence.moveNext();
            }
            String string = add = this.isAbstract ? "() {}" : "()";
            if (toAdd != null && !add.startsWith(toAdd)) {
                add = add + toAdd;
            }
            String text = "";
            if (sequence == null) {
                text = text + add;
                add = null;
            }
            boolean added = false;
            while (add != null && add.length() > 0) {
                String tokenText = ((Object)sequence.token().text()).toString();
                if (tokenText.startsWith(add)) {
                    len = sequence.offset() - offset + add.length();
                    text = text + add;
                    add = null;
                    continue;
                }
                if (add.startsWith(tokenText)) {
                    sequence.moveNext();
                    len = sequence.offset() - offset;
                    text = text + add.substring(0, tokenText.length());
                    add = add.substring(tokenText.length());
                    added = true;
                    continue;
                }
                if (sequence.token().id() == JavaTokenId.WHITESPACE && ((Object)sequence.token().text()).toString().indexOf(10) < 0) {
                    if (sequence.moveNext()) continue;
                    text = text + add;
                    add = null;
                    continue;
                }
                if (!added) {
                    text = text + add;
                }
                add = null;
            }
            doc.atomicLock();
            try {
                position = doc.createPosition(offset);
                Position semiPosition = semiPos > -1 ? doc.createPosition(semiPos) : null;
                doc.remove(offset, len);
                doc.insertString(position.getOffset(), text, null);
                if (semiPosition != null) {
                    doc.insertString(semiPosition.getOffset(), ";", null);
                }
            }
            catch (BadLocationException e) {
            }
            finally {
                doc.atomicUnlock();
            }
            position = null;
            if (this.isAbstract && text.length() > 3) {
                try {
                    JavaSource js = JavaSource.forDocument((Document)doc);
                    final int off = offset + 4;
                    js.runModificationTask((CancellableTask)new CancellableTask<WorkingCopy>(){

                        public void cancel() {
                        }

                        public void run(WorkingCopy copy) throws IOException {
                            copy.toPhase(JavaSource.Phase.RESOLVED);
                            TreePath path = copy.getTreeUtilities().pathFor(off);
                            while (path.getLeaf() != path.getCompilationUnit()) {
                                Tree tree = path.getLeaf();
                                Tree parentTree = path.getParentPath().getLeaf();
                                if (parentTree.getKind() == Tree.Kind.NEW_CLASS && tree.getKind() == Tree.Kind.CLASS) {
                                    GeneratorUtils.generateAllAbstractMethodImplementations(copy, path);
                                    break;
                                }
                                path = path.getParentPath();
                            }
                        }
                    }).commit();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (!this.params.isEmpty() && text.length() > 1 && (ctm = CodeTemplateManager.get((Document)doc)) != null) {
                StringBuilder sb = new StringBuilder();
                Iterator<ParamDesc> it = this.params.iterator();
                while (it.hasNext()) {
                    ParamDesc paramDesc = it.next();
                    sb.append("${");
                    sb.append(paramDesc.name);
                    sb.append(" named instanceof=");
                    sb.append(paramDesc.fullTypeName);
                    sb.append("}");
                    if (!it.hasNext()) continue;
                    sb.append(", ");
                }
                if (position != null) {
                    offset = position.getOffset();
                }
                c.setCaretPosition(offset + 1);
                ctm.createTemporary(sb.toString()).insert(c);
                Completion.get().showToolTip();
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Modifier mod : this.modifiers) {
                sb.append(mod.toString());
                sb.append(' ');
            }
            sb.append(this.simpleName);
            sb.append('(');
            Iterator<ParamDesc> it = this.params.iterator();
            while (it.hasNext()) {
                ParamDesc paramDesc = it.next();
                sb.append(paramDesc.typeName);
                sb.append(' ');
                sb.append(paramDesc.name);
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(')');
            return sb.toString();
        }
    }

    private static class DefaultConstructorItem
    extends JavaCompletionItem {
        private static final String CONSTRUCTOR = "org/netbeans/modules/java/editor/resources/new_constructor_16.png";
        private static final String CONSTRUCTOR_COLOR = "<font color=#b28b00>";
        private static ImageIcon icon;
        private String simpleName;
        private boolean isAbstract;
        private String sortText;
        private String leftText;

        private DefaultConstructorItem(TypeElement elem, int substitutionOffset) {
            super(substitutionOffset);
            this.simpleName = elem.getSimpleName().toString();
            this.isAbstract = elem.getModifiers().contains((Object)Modifier.ABSTRACT);
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        public int getSortPriority() {
            return 650;
        }

        public CharSequence getSortText() {
            if (this.sortText == null) {
                this.sortText = this.simpleName + "#0#";
            }
            return this.sortText;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                this.leftText = CONSTRUCTOR_COLOR + this.simpleName + "()" + JavaCompletionItem.COLOR_END;
            }
            return this.leftText;
        }

        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = new ImageIcon(org.openide.util.Utilities.loadImage((String)CONSTRUCTOR));
            }
            return icon;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void substituteText(JTextComponent c, int offset, int len, String toAdd) {
            String add;
            TokenSequence<JavaTokenId> sequence;
            int semiPos;
            offset += len;
            len = 0;
            int n = semiPos = toAdd != null && toAdd.endsWith(";") ? JavaCompletionItem.findPositionForSemicolon(c) : -2;
            if (semiPos > -2) {
                String string = toAdd = toAdd.length() > 1 ? toAdd.substring(0, toAdd.length() - 1) : null;
            }
            if ((sequence = Utilities.getJavaTokenSequence(c, offset)) != null) {
                sequence.movePrevious();
                if (sequence.token().id() == JavaTokenId.THIS || sequence.token().id() == JavaTokenId.SUPER) {
                    this.isAbstract = false;
                    if (toAdd == null) {
                        toAdd = ";";
                    }
                }
                sequence.moveNext();
            }
            String string = add = this.isAbstract ? "() {}" : "()";
            if (toAdd != null && !add.startsWith(toAdd)) {
                add = add + toAdd;
            }
            BaseDocument doc = (BaseDocument)c.getDocument();
            String text = "";
            if (sequence == null) {
                text = text + add;
                add = null;
            }
            boolean added = false;
            while (add != null && add.length() > 0) {
                String tokenText = ((Object)sequence.token().text()).toString();
                if (tokenText.startsWith(add)) {
                    len = sequence.offset() - offset + add.length();
                    text = text + add;
                    add = null;
                    continue;
                }
                if (add.startsWith(tokenText)) {
                    sequence.moveNext();
                    len = sequence.offset() - offset;
                    text = text + add.substring(0, tokenText.length());
                    add = add.substring(tokenText.length());
                    added = true;
                    continue;
                }
                if (sequence.token().id() == JavaTokenId.WHITESPACE && ((Object)sequence.token().text()).toString().indexOf(10) < 0) {
                    if (sequence.moveNext()) continue;
                    text = text + add;
                    add = null;
                    continue;
                }
                if (!added) {
                    text = text + add;
                }
                add = null;
            }
            doc.atomicLock();
            try {
                Position position = doc.createPosition(offset);
                Position semiPosition = semiPos > -1 ? doc.createPosition(semiPos) : null;
                doc.remove(offset, len);
                doc.insertString(position.getOffset(), text, null);
                if (semiPosition != null) {
                    doc.insertString(position.getOffset(), ";", null);
                }
            }
            catch (BadLocationException e) {
            }
            finally {
                doc.atomicUnlock();
            }
            if (this.isAbstract && text.length() > 3) {
                try {
                    JavaSource js = JavaSource.forDocument((Document)c.getDocument());
                    final int off = c.getSelectionEnd() - text.length() + 4;
                    js.runModificationTask((CancellableTask)new CancellableTask<WorkingCopy>(){

                        public void cancel() {
                        }

                        public void run(WorkingCopy copy) throws IOException {
                            copy.toPhase(JavaSource.Phase.RESOLVED);
                            TreePath path = copy.getTreeUtilities().pathFor(off);
                            while (path.getLeaf() != path.getCompilationUnit()) {
                                Tree tree = path.getLeaf();
                                Tree parentTree = path.getParentPath().getLeaf();
                                if (parentTree.getKind() == Tree.Kind.NEW_CLASS && tree.getKind() == Tree.Kind.CLASS) {
                                    GeneratorUtils.generateAllAbstractMethodImplementations(copy, path);
                                    break;
                                }
                                path = path.getParentPath();
                            }
                        }
                    }).commit();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
        }

        public String toString() {
            return this.simpleName + "()";
        }
    }

    private static class EnumItem
    extends ClassItem {
        private static final String ENUM = "org/netbeans/modules/editor/resources/completion/enum.png";
        private static ImageIcon icon;

        private EnumItem(TypeElement elem, DeclaredType type, int dim, int substitutionOffset, boolean displayPkgName, boolean isDeprecated, boolean smartType) {
            super(elem, type, dim, substitutionOffset, displayPkgName, isDeprecated, smartType);
        }

        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = new ImageIcon(org.openide.util.Utilities.loadImage((String)ENUM));
            }
            return icon;
        }
    }

    private static class FieldItem
    extends JavaCompletionItem {
        private static final String FIELD_PUBLIC = "org/netbeans/modules/editor/resources/completion/field_16.png";
        private static final String FIELD_PROTECTED = "org/netbeans/modules/editor/resources/completion/field_protected_16.png";
        private static final String FIELD_PACKAGE = "org/netbeans/modules/editor/resources/completion/field_package_private_16.png";
        private static final String FIELD_PRIVATE = "org/netbeans/modules/editor/resources/completion/field_private_16.png";
        private static final String FIELD_ST_PUBLIC = "org/netbeans/modules/editor/resources/completion/field_static_16.png";
        private static final String FIELD_ST_PROTECTED = "org/netbeans/modules/editor/resources/completion/field_static_protected_16.png";
        private static final String FIELD_ST_PACKAGE = "org/netbeans/modules/editor/resources/completion/field_static_package_private_16.png";
        private static final String FIELD_ST_PRIVATE = "org/netbeans/modules/editor/resources/completion/field_static_private_16.png";
        private static final String FIELD_COLOR = "<font color=#008618>";
        private static ImageIcon[][] icon = new ImageIcon[2][4];
        private ElementHandle<VariableElement> elementHandle;
        private boolean isInherited;
        private boolean isDeprecated;
        private boolean smartType;
        private String simpleName;
        private Set<Modifier> modifiers;
        private String typeName;
        private String leftText;
        private String rightText;

        private FieldItem(VariableElement elem, TypeMirror type, int substitutionOffset, boolean isInherited, boolean isDeprecated, boolean smartType) {
            super(substitutionOffset);
            this.elementHandle = ElementHandle.create((Element)elem);
            this.isInherited = isInherited;
            this.isDeprecated = isDeprecated;
            this.smartType = smartType;
            this.simpleName = elem.getSimpleName().toString();
            this.modifiers = elem.getModifiers();
            this.typeName = ((Object)Utilities.getTypeName(type, false)).toString();
        }

        public int getSortPriority() {
            return this.smartType ? 300 - SMART_TYPE : 300;
        }

        public CharSequence getSortText() {
            return this.simpleName;
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        public CompletionTask createDocumentationTask() {
            return JavaCompletionProvider.createDocTask(this.elementHandle);
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder sb = new StringBuilder();
                sb.append(FIELD_COLOR);
                if (!this.isInherited) {
                    sb.append(JavaCompletionItem.BOLD);
                }
                if (this.isDeprecated) {
                    sb.append(JavaCompletionItem.STRIKE);
                }
                sb.append(this.simpleName);
                if (this.isDeprecated) {
                    sb.append(JavaCompletionItem.STRIKE_END);
                }
                if (!this.isInherited) {
                    sb.append(JavaCompletionItem.BOLD_END);
                }
                sb.append(JavaCompletionItem.COLOR_END);
                this.leftText = sb.toString();
            }
            return this.leftText;
        }

        protected String getRightHtmlText() {
            if (this.rightText == null) {
                this.rightText = JavaCompletionItem.escape(this.typeName);
            }
            return this.rightText;
        }

        protected ImageIcon getIcon() {
            int level = JavaCompletionItem.getProtectionLevel(this.modifiers);
            boolean isStatic = this.modifiers.contains((Object)Modifier.STATIC);
            ImageIcon cachedIcon = icon[isStatic ? 1 : 0][level];
            if (cachedIcon != null) {
                return cachedIcon;
            }
            String iconPath = FIELD_PUBLIC;
            if (isStatic) {
                switch (level) {
                    case 0: {
                        iconPath = FIELD_ST_PRIVATE;
                        break;
                    }
                    case 1: {
                        iconPath = FIELD_ST_PACKAGE;
                        break;
                    }
                    case 2: {
                        iconPath = FIELD_ST_PROTECTED;
                        break;
                    }
                    case 3: {
                        iconPath = FIELD_ST_PUBLIC;
                    }
                }
            } else {
                switch (level) {
                    case 0: {
                        iconPath = FIELD_PRIVATE;
                        break;
                    }
                    case 1: {
                        iconPath = FIELD_PACKAGE;
                        break;
                    }
                    case 2: {
                        iconPath = FIELD_PROTECTED;
                        break;
                    }
                    case 3: {
                        iconPath = FIELD_PUBLIC;
                    }
                }
            }
            ImageIcon newIcon = new ImageIcon(org.openide.util.Utilities.loadImage((String)iconPath));
            FieldItem.icon[isStatic ? 1 : 0][level] = newIcon;
            return newIcon;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Modifier mod : this.modifiers) {
                sb.append(mod.toString());
                sb.append(' ');
            }
            sb.append(this.typeName);
            sb.append(' ');
            sb.append(this.simpleName);
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InitializeAllConstructorItem
    extends JavaCompletionItem {
        private static final String CONSTRUCTOR_PUBLIC = "org/netbeans/modules/java/editor/resources/new_constructor_16.png";
        private static final String CONSTRUCTOR_COLOR = "<font color=#b28b00>";
        private static final String PARAMETER_NAME_COLOR = "<font color=#b200b2>";
        private static ImageIcon icon;
        private List<ElementHandle<VariableElement>> fieldHandles = new ArrayList<ElementHandle<VariableElement>>();
        private String simpleName;
        private List<ParamDesc> params = new ArrayList<ParamDesc>();
        private String sortText;
        private String leftText;

        private InitializeAllConstructorItem(Iterable<? extends VariableElement> fields, TypeElement parent, int substitutionOffset) {
            super(substitutionOffset);
            for (VariableElement variableElement : fields) {
                this.fieldHandles.add((ElementHandle<VariableElement>)ElementHandle.create((Element)variableElement));
                this.params.add(new ParamDesc(null, ((Object)Utilities.getTypeName(variableElement.asType(), false)).toString(), variableElement.getSimpleName().toString()));
            }
            this.simpleName = parent.getSimpleName().toString();
        }

        public int getSortPriority() {
            return 400;
        }

        public CharSequence getSortText() {
            if (this.sortText == null) {
                StringBuilder sortParams = new StringBuilder();
                sortParams.append('(');
                int cnt = 0;
                Iterator<ParamDesc> it = this.params.iterator();
                while (it.hasNext()) {
                    ParamDesc paramDesc = it.next();
                    sortParams.append(paramDesc.typeName);
                    if (it.hasNext()) {
                        sortParams.append(',');
                    }
                    ++cnt;
                }
                sortParams.append(')');
                this.sortText = this.simpleName + "#" + (cnt < 10 ? "0" : "") + cnt + "#" + sortParams.toString();
            }
            return this.sortText;
        }

        @Override
        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder lText = new StringBuilder();
                lText.append(CONSTRUCTOR_COLOR);
                lText.append(this.simpleName);
                lText.append(JavaCompletionItem.COLOR_END);
                lText.append('(');
                Iterator<ParamDesc> it = this.params.iterator();
                while (it.hasNext()) {
                    ParamDesc paramDesc = it.next();
                    lText.append(JavaCompletionItem.escape(paramDesc.typeName));
                    lText.append(' ');
                    lText.append(PARAMETER_NAME_COLOR);
                    lText.append(paramDesc.name);
                    lText.append(JavaCompletionItem.COLOR_END);
                    if (!it.hasNext()) continue;
                    lText.append(", ");
                }
                lText.append(')');
                lText.append(" - generate");
                this.leftText = lText.toString();
            }
            return this.leftText;
        }

        @Override
        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = new ImageIcon(org.openide.util.Utilities.loadImage((String)CONSTRUCTOR_PUBLIC));
            }
            return icon;
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void substituteText(JTextComponent c, final int offset, int len, String toAdd) {
            BaseDocument doc = (BaseDocument)c.getDocument();
            if (len > 0) {
                doc.atomicLock();
                try {
                    doc.remove(offset, len);
                }
                catch (BadLocationException e) {
                }
                finally {
                    doc.atomicUnlock();
                }
            }
            try {
                JavaSource js = JavaSource.forDocument((Document)c.getDocument());
                js.runModificationTask((CancellableTask)new CancellableTask<WorkingCopy>(){

                    public void cancel() {
                    }

                    public void run(WorkingCopy copy) throws IOException {
                        copy.toPhase(JavaSource.Phase.PARSED);
                        TreePath tp = copy.getTreeUtilities().pathFor(offset);
                        if (tp.getLeaf().getKind() == Tree.Kind.CLASS) {
                            ArrayList<VariableElement> fieldElements = new ArrayList<VariableElement>();
                            for (ElementHandle handle : InitializeAllConstructorItem.this.fieldHandles) {
                                fieldElements.add((VariableElement)handle.resolve((CompilationInfo)copy));
                            }
                            int idx = 0;
                            for (Tree tree : ((ClassTree)tp.getLeaf()).getMembers()) {
                                if (copy.getTrees().getSourcePositions().getStartPosition(tp.getCompilationUnit(), tree) >= (long)offset) break;
                                ++idx;
                            }
                            GeneratorUtils.generateConstructor(copy, tp, fieldElements, null, idx);
                        }
                    }
                }).commit();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("public ");
            sb.append(this.simpleName);
            sb.append('(');
            Iterator<ParamDesc> it = this.params.iterator();
            while (it.hasNext()) {
                ParamDesc paramDesc = it.next();
                sb.append(paramDesc.typeName);
                sb.append(' ');
                sb.append(paramDesc.name);
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(')');
            sb.append(" - generate");
            return sb.toString();
        }

        @Override
        public boolean instantSubstitution(JTextComponent component) {
            return false;
        }
    }

    private static class InterfaceItem
    extends ClassItem {
        private static final String INTERFACE = "org/netbeans/modules/editor/resources/completion/interface.png";
        private static final String INTERFACE_COLOR = "<font color=#404040>";
        private static ImageIcon icon;

        private InterfaceItem(TypeElement elem, DeclaredType type, int dim, int substitutionOffset, boolean displayPkgName, boolean isDeprecated, boolean smartType) {
            super(elem, type, dim, substitutionOffset, displayPkgName, isDeprecated, smartType);
        }

        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = new ImageIcon(org.openide.util.Utilities.loadImage((String)INTERFACE));
            }
            return icon;
        }

        protected String getColor() {
            return INTERFACE_COLOR;
        }
    }

    private static class KeywordItem
    extends JavaCompletionItem {
        private static final String JAVA_KEYWORD = "org/netbeans/modules/java/editor/resources/javakw_16.png";
        private static final String KEYWORD_COLOR = "<font color=#000099>";
        private static ImageIcon icon;
        private String kwd;
        private int dim;
        private String postfix;
        private boolean smartType;
        private String leftText;

        private KeywordItem(String kwd, int dim, String postfix, int substitutionOffset, boolean smartType) {
            super(substitutionOffset);
            this.kwd = kwd;
            this.dim = dim;
            this.postfix = postfix;
            this.smartType = smartType;
        }

        public int getSortPriority() {
            return this.smartType ? 600 - SMART_TYPE : 600;
        }

        public CharSequence getSortText() {
            return this.kwd;
        }

        public CharSequence getInsertPrefix() {
            return this.kwd;
        }

        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = new ImageIcon(org.openide.util.Utilities.loadImage((String)JAVA_KEYWORD));
            }
            return icon;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder sb = new StringBuilder();
                sb.append(KEYWORD_COLOR);
                sb.append(JavaCompletionItem.BOLD);
                sb.append(this.kwd);
                for (int i = 0; i < this.dim; ++i) {
                    sb.append("[]");
                }
                sb.append(JavaCompletionItem.BOLD_END);
                sb.append(JavaCompletionItem.COLOR_END);
                this.leftText = sb.toString();
            }
            return this.leftText;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void substituteText(JTextComponent c, int offset, int len, String toAdd) {
            CodeTemplateManager ctm;
            int semiPos;
            if (this.dim == 0) {
                super.substituteText(c, offset, len, toAdd != null ? toAdd : this.postfix);
                return;
            }
            BaseDocument doc = (BaseDocument)c.getDocument();
            StringBuilder text = new StringBuilder();
            int n = semiPos = toAdd != null && toAdd.endsWith(";") ? JavaCompletionItem.findPositionForSemicolon(c) : -2;
            if (semiPos > -2) {
                String string = toAdd = toAdd.length() > 1 ? toAdd.substring(0, toAdd.length() - 1) : null;
            }
            if (toAdd != null && !toAdd.equals("\n")) {
                TokenSequence<JavaTokenId> sequence = Utilities.getJavaTokenSequence(c, offset + len);
                if (sequence == null) {
                    text.append(toAdd);
                    toAdd = null;
                }
                boolean added = false;
                while (toAdd != null && toAdd.length() > 0) {
                    String tokenText = ((Object)sequence.token().text()).toString();
                    if (tokenText.startsWith(toAdd)) {
                        len = sequence.offset() - offset + toAdd.length();
                        text.append(toAdd);
                        toAdd = null;
                        continue;
                    }
                    if (toAdd.startsWith(tokenText)) {
                        sequence.moveNext();
                        len = sequence.offset() - offset;
                        text.append(toAdd.substring(0, tokenText.length()));
                        toAdd = toAdd.substring(tokenText.length());
                        added = true;
                        continue;
                    }
                    if (sequence.token().id() == JavaTokenId.WHITESPACE && ((Object)sequence.token().text()).toString().indexOf(10) < 0) {
                        if (sequence.moveNext()) continue;
                        text.append(toAdd);
                        toAdd = null;
                        continue;
                    }
                    if (!added) {
                        text.append(toAdd);
                    }
                    toAdd = null;
                }
            }
            StringBuilder sb = new StringBuilder();
            int cnt = 1;
            sb.append(this.kwd);
            for (int i = 0; i < this.dim; ++i) {
                sb.append("[${PAR");
                sb.append(cnt++);
                sb.append(" instanceof=\"int\" default=\"\"}]");
            }
            doc.atomicLock();
            try {
                Position semiPosition;
                Position position = semiPosition = semiPos > -1 ? doc.createPosition(semiPos) : null;
                if (len > 0) {
                    doc.remove(offset, len);
                }
                if (semiPosition != null) {
                    doc.insertString(semiPosition.getOffset(), ";", null);
                }
            }
            catch (BadLocationException e) {
            }
            finally {
                doc.atomicUnlock();
            }
            if ((ctm = CodeTemplateManager.get((Document)doc)) != null) {
                ctm.createTemporary(sb.append((CharSequence)text).toString()).insert(c);
            }
        }

        public String toString() {
            return this.kwd;
        }
    }

    private static class MethodItem
    extends JavaCompletionItem {
        private static final String METHOD_PUBLIC = "org/netbeans/modules/editor/resources/completion/method_16.png";
        private static final String METHOD_PROTECTED = "org/netbeans/modules/editor/resources/completion/method_protected_16.png";
        private static final String METHOD_PACKAGE = "org/netbeans/modules/editor/resources/completion/method_package_private_16.png";
        private static final String METHOD_PRIVATE = "org/netbeans/modules/editor/resources/completion/method_private_16.png";
        private static final String METHOD_ST_PUBLIC = "org/netbeans/modules/editor/resources/completion/method_static_16.png";
        private static final String METHOD_ST_PROTECTED = "org/netbeans/modules/editor/resources/completion/method_static_protected_16.png";
        private static final String METHOD_ST_PRIVATE = "org/netbeans/modules/editor/resources/completion/method_static_private_16.png";
        private static final String METHOD_ST_PACKAGE = "org/netbeans/modules/editor/resources/completion/method_static_package_private_16.png";
        private static final String METHOD_COLOR = "<font color=#000000>";
        private static final String PARAMETER_NAME_COLOR = "<font color=#a06001>";
        private static ImageIcon[][] icon = new ImageIcon[2][4];
        protected ElementHandle<ExecutableElement> elementHandle;
        private boolean isInherited;
        private boolean isDeprecated;
        private boolean inImport;
        private boolean smartType;
        private String simpleName;
        protected Set<Modifier> modifiers;
        private List<ParamDesc> params;
        private String typeName;
        private boolean isPrimitive;
        private String sortText;
        private String leftText;
        private String rightText;

        private MethodItem(ExecutableElement elem, ExecutableType type, int substitutionOffset, boolean isInherited, boolean isDeprecated, boolean inImport, boolean smartType) {
            super(substitutionOffset);
            this.elementHandle = ElementHandle.create((Element)elem);
            this.isInherited = isInherited;
            this.isDeprecated = isDeprecated;
            this.inImport = inImport;
            this.smartType = smartType;
            this.simpleName = elem.getSimpleName().toString();
            this.modifiers = elem.getModifiers();
            this.params = new ArrayList<ParamDesc>();
            Iterator<? extends VariableElement> it = elem.getParameters().iterator();
            Iterator<? extends TypeMirror> tIt = type.getParameterTypes().iterator();
            while (it.hasNext() && tIt.hasNext()) {
                TypeMirror tm = tIt.next();
                this.params.add(new ParamDesc(((Object)tm).toString(), ((Object)Utilities.getTypeName(tm, false, elem.isVarArgs() && !tIt.hasNext())).toString(), it.next().getSimpleName().toString()));
            }
            TypeMirror retType = type.getReturnType();
            this.typeName = ((Object)Utilities.getTypeName(retType, false)).toString();
            this.isPrimitive = retType.getKind().isPrimitive() || retType.getKind() == TypeKind.VOID;
        }

        public int getSortPriority() {
            return this.smartType ? 500 - SMART_TYPE : 500;
        }

        public CharSequence getSortText() {
            if (this.sortText == null) {
                StringBuilder sortParams = new StringBuilder();
                sortParams.append('(');
                int cnt = 0;
                Iterator<ParamDesc> it = this.params.iterator();
                while (it.hasNext()) {
                    ParamDesc param = it.next();
                    sortParams.append(param.typeName);
                    if (it.hasNext()) {
                        sortParams.append(',');
                    }
                    ++cnt;
                }
                sortParams.append(')');
                this.sortText = this.simpleName + "#" + (cnt < 10 ? "0" : "") + cnt + "#" + sortParams.toString();
            }
            return this.sortText;
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder lText = new StringBuilder();
                lText.append(METHOD_COLOR);
                if (!this.isInherited) {
                    lText.append(JavaCompletionItem.BOLD);
                }
                if (this.isDeprecated) {
                    lText.append(JavaCompletionItem.STRIKE);
                }
                lText.append(this.simpleName);
                if (this.isDeprecated) {
                    lText.append(JavaCompletionItem.STRIKE_END);
                }
                if (!this.isInherited) {
                    lText.append(JavaCompletionItem.BOLD_END);
                }
                lText.append(JavaCompletionItem.COLOR_END);
                lText.append('(');
                Iterator<ParamDesc> it = this.params.iterator();
                while (it.hasNext()) {
                    ParamDesc paramDesc = it.next();
                    lText.append(JavaCompletionItem.escape(paramDesc.typeName));
                    lText.append(' ');
                    lText.append(PARAMETER_NAME_COLOR);
                    lText.append(paramDesc.name);
                    lText.append(JavaCompletionItem.COLOR_END);
                    if (!it.hasNext()) continue;
                    lText.append(", ");
                }
                lText.append(')');
                return lText.toString();
            }
            return this.leftText;
        }

        protected String getRightHtmlText() {
            if (this.rightText == null) {
                this.rightText = JavaCompletionItem.escape(this.typeName);
            }
            return this.rightText;
        }

        public CompletionTask createDocumentationTask() {
            return JavaCompletionProvider.createDocTask(this.elementHandle);
        }

        protected ImageIcon getIcon() {
            int level = JavaCompletionItem.getProtectionLevel(this.modifiers);
            boolean isStatic = this.modifiers.contains((Object)Modifier.STATIC);
            ImageIcon cachedIcon = icon[isStatic ? 1 : 0][level];
            if (cachedIcon != null) {
                return cachedIcon;
            }
            String iconPath = METHOD_PUBLIC;
            if (isStatic) {
                switch (level) {
                    case 0: {
                        iconPath = METHOD_ST_PRIVATE;
                        break;
                    }
                    case 1: {
                        iconPath = METHOD_ST_PACKAGE;
                        break;
                    }
                    case 2: {
                        iconPath = METHOD_ST_PROTECTED;
                        break;
                    }
                    case 3: {
                        iconPath = METHOD_ST_PUBLIC;
                    }
                }
            } else {
                switch (level) {
                    case 0: {
                        iconPath = METHOD_PRIVATE;
                        break;
                    }
                    case 1: {
                        iconPath = METHOD_PACKAGE;
                        break;
                    }
                    case 2: {
                        iconPath = METHOD_PROTECTED;
                        break;
                    }
                    case 3: {
                        iconPath = METHOD_PUBLIC;
                    }
                }
            }
            ImageIcon newIcon = new ImageIcon(org.openide.util.Utilities.loadImage((String)iconPath));
            MethodItem.icon[isStatic ? 1 : 0][level] = newIcon;
            return newIcon;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void substituteText(final JTextComponent c, int offset, int len, String toAdd) {
            String add;
            if (toAdd == null && this.isPrimitive) {
                try {
                    final String[] ret = new String[1];
                    JavaSource js = JavaSource.forDocument((Document)c.getDocument());
                    js.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                        public void cancel() {
                        }

                        public void run(CompilationController controller) throws Exception {
                            controller.toPhase(JavaSource.Phase.PARSED);
                            TreePath tp = controller.getTreeUtilities().pathFor(c.getSelectionEnd());
                            Tree tree = tp.getLeaf();
                            if (tree.getKind() == Tree.Kind.IDENTIFIER || tree.getKind() == Tree.Kind.PRIMITIVE_TYPE) {
                                tp = tp.getParentPath();
                            }
                            if (tp.getLeaf().getKind() == Tree.Kind.MEMBER_SELECT || tp.getLeaf().getKind() == Tree.Kind.METHOD_INVOCATION && ((MethodInvocationTree)tp.getLeaf()).getMethodSelect() == tree) {
                                tp = tp.getParentPath();
                            }
                            if (tp.getLeaf().getKind() == Tree.Kind.EXPRESSION_STATEMENT || tp.getLeaf().getKind() == Tree.Kind.BLOCK) {
                                ret[0] = ";";
                            }
                        }
                    }, true);
                    toAdd = ret[0];
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            String string = add = this.inImport ? ";" : "()";
            if (toAdd != null && !add.startsWith(toAdd)) {
                add = add + toAdd;
            }
            if (this.inImport || this.params.isEmpty()) {
                super.substituteText(c, offset, len, add);
            } else {
                CodeTemplateManager ctm;
                TokenSequence<JavaTokenId> sequence;
                int semiPos;
                BaseDocument doc = (BaseDocument)c.getDocument();
                String text = "";
                int n = semiPos = add.endsWith(";") ? JavaCompletionItem.findPositionForSemicolon(c) : -2;
                if (semiPos > -2) {
                    String string2 = add = add.length() > 1 ? add.substring(0, add.length() - 1) : null;
                }
                if ((sequence = Utilities.getJavaTokenSequence(c, offset + len)) == null) {
                    text = text + add;
                    add = null;
                }
                boolean added = false;
                while (add != null && add.length() > 0) {
                    String tokenText = ((Object)sequence.token().text()).toString();
                    if (tokenText.startsWith(add)) {
                        len = sequence.offset() - offset + add.length();
                        text = text + add;
                        add = null;
                        continue;
                    }
                    if (add.startsWith(tokenText)) {
                        sequence.moveNext();
                        len = sequence.offset() - offset;
                        text = text + add.substring(0, tokenText.length());
                        add = add.substring(tokenText.length());
                        added = true;
                        continue;
                    }
                    if (sequence.token().id() == JavaTokenId.WHITESPACE && ((Object)sequence.token().text()).toString().indexOf(10) < 0) {
                        if (sequence.moveNext()) continue;
                        text = text + add;
                        add = null;
                        continue;
                    }
                    if (!added) {
                        text = text + add;
                    }
                    add = null;
                }
                doc.atomicLock();
                try {
                    Position semiPosition;
                    Position position = semiPosition = semiPos > -1 ? doc.createPosition(semiPos) : null;
                    if (len > 0) {
                        doc.remove(offset, len);
                    }
                    if (semiPosition != null) {
                        doc.insertString(semiPosition.getOffset(), ";", null);
                    }
                }
                catch (BadLocationException e) {
                }
                finally {
                    doc.atomicUnlock();
                }
                if ((ctm = CodeTemplateManager.get((Document)doc)) != null) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(this.getInsertPrefix());
                    sb.append("(");
                    if (text.length() > 1) {
                        Iterator<ParamDesc> it = this.params.iterator();
                        while (it.hasNext()) {
                            ParamDesc paramDesc = it.next();
                            sb.append("${");
                            sb.append(paramDesc.name);
                            sb.append(" named instanceof=");
                            sb.append(paramDesc.fullTypeName);
                            sb.append("}");
                            if (!it.hasNext()) continue;
                            sb.append(", ");
                        }
                        sb.append(")");
                        if (text.length() > 2) {
                            sb.append(text.substring(2));
                        }
                    }
                    ctm.createTemporary(sb.toString()).insert(c);
                    Completion.get().showToolTip();
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Modifier mod : this.modifiers) {
                sb.append(mod.toString());
                sb.append(' ');
            }
            sb.append(this.typeName);
            sb.append(' ');
            sb.append(this.simpleName);
            sb.append('(');
            Iterator<ParamDesc> it = this.params.iterator();
            while (it.hasNext()) {
                ParamDesc paramDesc = it.next();
                sb.append(paramDesc.typeName);
                sb.append(' ');
                sb.append(paramDesc.name);
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(')');
            return sb.toString();
        }
    }

    private static class OverrideMethodItem
    extends MethodItem {
        private static final String IMPL_BADGE_PATH = "org/netbeans/modules/java/editor/resources/implement_badge.png";
        private static final String OVRD_BADGE_PATH = "org/netbeans/modules/java/editor/resources/override_badge.png";
        private static ImageIcon implementBadge = new ImageIcon(org.openide.util.Utilities.loadImage((String)"org/netbeans/modules/java/editor/resources/implement_badge.png"));
        private static ImageIcon overrideBadge = new ImageIcon(org.openide.util.Utilities.loadImage((String)"org/netbeans/modules/java/editor/resources/override_badge.png"));
        private static ImageIcon[][] merged_icon = new ImageIcon[2][4];
        private boolean implement;
        private String leftText;

        private OverrideMethodItem(ExecutableElement elem, ExecutableType type, int substitutionOffset, boolean implement) {
            super(elem, type, substitutionOffset, false, false, false, false);
            this.implement = implement;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                this.leftText = super.getLeftHtmlText() + (this.implement ? " - implement" : " - override");
            }
            return this.leftText;
        }

        protected ImageIcon getIcon() {
            int level;
            ImageIcon merged = merged_icon[this.implement ? 0 : 1][level = JavaCompletionItem.getProtectionLevel(this.modifiers)];
            if (merged != null) {
                return merged;
            }
            ImageIcon superIcon = super.getIcon();
            merged = new ImageIcon(org.openide.util.Utilities.mergeImages((Image)superIcon.getImage(), (Image)(this.implement ? implementBadge.getImage() : overrideBadge.getImage()), (int)8, (int)8));
            OverrideMethodItem.merged_icon[this.implement ? 0 : 1][level] = merged;
            return merged;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void substituteText(JTextComponent c, final int offset, int len, String toAdd) {
            BaseDocument doc = (BaseDocument)c.getDocument();
            if (len > 0) {
                doc.atomicLock();
                try {
                    doc.remove(offset, len);
                }
                catch (BadLocationException e) {
                }
                finally {
                    doc.atomicUnlock();
                }
            }
            try {
                JavaSource js = JavaSource.forDocument((Document)doc);
                js.runModificationTask((CancellableTask)new CancellableTask<WorkingCopy>(){

                    public void cancel() {
                    }

                    public void run(WorkingCopy copy) throws IOException {
                        copy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        ExecutableElement ee = (ExecutableElement)OverrideMethodItem.this.elementHandle.resolve((CompilationInfo)copy);
                        if (ee == null) {
                            return;
                        }
                        TreePath tp = copy.getTreeUtilities().pathFor(offset);
                        if (tp.getLeaf().getKind() == Tree.Kind.CLASS) {
                            if (Utilities.isInMethod(tp)) {
                                copy.toPhase(JavaSource.Phase.RESOLVED);
                            }
                            int idx = 0;
                            for (Tree tree : ((ClassTree)tp.getLeaf()).getMembers()) {
                                if (copy.getTrees().getSourcePositions().getStartPosition(tp.getCompilationUnit(), tree) >= (long)offset) break;
                                ++idx;
                            }
                            if (OverrideMethodItem.this.implement) {
                                GeneratorUtils.generateAbstractMethodImplementation(copy, tp, ee, idx);
                            } else {
                                GeneratorUtils.generateMethodOverride(copy, tp, ee, idx);
                            }
                        }
                    }
                }).commit();
            }
            catch (IOException ex) {
                Logger.getLogger("global").log(Level.WARNING, null, ex);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            sb.append(" - ");
            sb.append(this.implement ? "implement" : "override");
            return sb.toString();
        }

        public boolean instantSubstitution(JTextComponent component) {
            return false;
        }
    }

    private static class PackageItem
    extends JavaCompletionItem {
        private static final String PACKAGE = "org/netbeans/modules/java/editor/resources/package.gif";
        private static final String PACKAGE_COLOR = "<font color=#005600>";
        private static ImageIcon icon;
        private boolean isDeprecated;
        private String simpleName;
        private String sortText;
        private String leftText;

        private PackageItem(String pkgFQN, int substitutionOffset, boolean isDeprecated) {
            super(substitutionOffset);
            this.isDeprecated = isDeprecated;
            int idx = pkgFQN.lastIndexOf(46);
            this.simpleName = idx < 0 ? pkgFQN : pkgFQN.substring(idx + 1);
            this.sortText = this.simpleName + "#" + pkgFQN;
        }

        public int getSortPriority() {
            return 900;
        }

        public CharSequence getSortText() {
            return this.sortText;
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = new ImageIcon(org.openide.util.Utilities.loadImage((String)PACKAGE));
            }
            return icon;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder sb = new StringBuilder();
                sb.append(PACKAGE_COLOR);
                if (this.isDeprecated) {
                    sb.append(JavaCompletionItem.STRIKE);
                }
                sb.append(this.simpleName);
                if (this.isDeprecated) {
                    sb.append(JavaCompletionItem.STRIKE_END);
                }
                sb.append(JavaCompletionItem.COLOR_END);
                this.leftText = sb.toString();
            }
            return this.leftText;
        }

        public String toString() {
            return this.simpleName;
        }
    }

    private static class ParamDesc {
        private String fullTypeName;
        private String typeName;
        private String name;

        public ParamDesc(String fullTypeName, String typeName, String name) {
            this.fullTypeName = fullTypeName;
            this.typeName = typeName;
            this.name = name;
        }
    }

    private static class StaticMemberItem
    extends JavaCompletionItem {
        private static final String FIELD_ST_PUBLIC = "org/netbeans/modules/editor/resources/completion/field_static_16.png";
        private static final String FIELD_ST_PROTECTED = "org/netbeans/modules/editor/resources/completion/field_static_protected_16.png";
        private static final String FIELD_ST_PACKAGE = "org/netbeans/modules/editor/resources/completion/field_static_package_private_16.png";
        private static final String FIELD_COLOR = "<font color=#0000b2>";
        private static final String METHOD_ST_PUBLIC = "org/netbeans/modules/editor/resources/completion/method_static_16.png";
        private static final String METHOD_ST_PROTECTED = "org/netbeans/modules/editor/resources/completion/method_static_protected_16.png";
        private static final String METHOD_ST_PACKAGE = "org/netbeans/modules/editor/resources/completion/method_static_package_private_16.png";
        private static final String METHOD_COLOR = "<font color=#7c0000>";
        private static final String PARAMETER_NAME_COLOR = "<font color=#b200b2>";
        private static ImageIcon[][] icon = new ImageIcon[2][3];
        private TypeMirrorHandle<DeclaredType> typeHandle;
        private ElementHandle<Element> memberElementHandle;
        private boolean isDeprecated;
        private String typeName;
        private String memberName;
        private String memberTypeName;
        private Set<Modifier> modifiers;
        private List<ParamDesc> params;
        private String sortText;
        private String leftText;
        private String rightText;

        private StaticMemberItem(DeclaredType type, Element memberElem, TypeMirror memberType, int substitutionOffset, boolean isDeprecated) {
            super(substitutionOffset);
            this.typeHandle = TypeMirrorHandle.create((TypeMirror)type);
            this.memberElementHandle = ElementHandle.create((Element)memberElem);
            this.isDeprecated = isDeprecated;
            this.typeName = ((Object)Utilities.getTypeName(type, false)).toString();
            this.memberName = memberElem.getSimpleName().toString();
            this.memberTypeName = ((Object)Utilities.getTypeName(memberElem.getKind().isField() ? memberType : ((ExecutableType)memberType).getReturnType(), false)).toString();
            this.modifiers = memberElem.getModifiers();
            if (!memberElem.getKind().isField()) {
                this.params = new ArrayList<ParamDesc>();
                Iterator<? extends VariableElement> it = ((ExecutableElement)memberElem).getParameters().iterator();
                Iterator<? extends TypeMirror> tIt = ((ExecutableType)memberType).getParameterTypes().iterator();
                while (it.hasNext() && tIt.hasNext()) {
                    TypeMirror tm = tIt.next();
                    this.params.add(new ParamDesc(((Object)tm).toString(), ((Object)Utilities.getTypeName(tm, false, ((ExecutableElement)memberElem).isVarArgs() && !tIt.hasNext())).toString(), it.next().getSimpleName().toString()));
                }
            }
        }

        public int getSortPriority() {
            return (this.params == null ? 700 : 750) - SMART_TYPE;
        }

        public CharSequence getSortText() {
            if (this.sortText == null) {
                if (this.params == null) {
                    this.sortText = this.memberName + "#" + this.typeName;
                } else {
                    StringBuilder sortParams = new StringBuilder();
                    sortParams.append('(');
                    int cnt = 0;
                    Iterator<ParamDesc> it = this.params.iterator();
                    while (it.hasNext()) {
                        ParamDesc paramDesc = it.next();
                        sortParams.append(paramDesc.typeName);
                        if (it.hasNext()) {
                            sortParams.append(',');
                        }
                        ++cnt;
                    }
                    sortParams.append(')');
                    this.sortText = this.memberName + "#" + (cnt < 10 ? "0" : "") + cnt + "#" + sortParams.toString() + "#" + this.typeName;
                }
            }
            return this.sortText;
        }

        public CharSequence getInsertPrefix() {
            return this.typeName + "." + this.memberName;
        }

        public CompletionTask createDocumentationTask() {
            return JavaCompletionProvider.createDocTask(this.memberElementHandle);
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder lText = new StringBuilder();
                lText.append(this.memberElementHandle.getKind().isField() ? FIELD_COLOR : METHOD_COLOR);
                lText.append(JavaCompletionItem.escape(this.typeName));
                lText.append('.');
                if (this.isDeprecated) {
                    lText.append(JavaCompletionItem.STRIKE);
                }
                lText.append(this.memberName);
                if (this.isDeprecated) {
                    lText.append(JavaCompletionItem.STRIKE_END);
                }
                lText.append(JavaCompletionItem.COLOR_END);
                if (this.params != null) {
                    lText.append('(');
                    Iterator<ParamDesc> it = this.params.iterator();
                    while (it.hasNext()) {
                        ParamDesc paramDesc = it.next();
                        lText.append(JavaCompletionItem.escape(paramDesc.typeName));
                        lText.append(' ');
                        lText.append(PARAMETER_NAME_COLOR);
                        lText.append(paramDesc.name);
                        lText.append(JavaCompletionItem.COLOR_END);
                        if (!it.hasNext()) continue;
                        lText.append(", ");
                    }
                    lText.append(')');
                }
                this.leftText = lText.toString();
            }
            return this.leftText;
        }

        protected String getRightHtmlText() {
            if (this.rightText == null) {
                this.rightText = JavaCompletionItem.escape(this.memberTypeName);
            }
            return this.rightText;
        }

        protected ImageIcon getIcon() {
            int level = JavaCompletionItem.getProtectionLevel(this.modifiers);
            boolean isField = this.memberElementHandle.getKind().isField();
            ImageIcon cachedIcon = icon[isField ? 0 : 1][level - 1];
            if (cachedIcon != null) {
                return cachedIcon;
            }
            String iconPath = null;
            if (isField) {
                switch (level) {
                    case 1: {
                        iconPath = FIELD_ST_PACKAGE;
                        break;
                    }
                    case 2: {
                        iconPath = FIELD_ST_PROTECTED;
                        break;
                    }
                    case 3: {
                        iconPath = FIELD_ST_PUBLIC;
                    }
                }
            } else {
                switch (level) {
                    case 1: {
                        iconPath = METHOD_ST_PACKAGE;
                        break;
                    }
                    case 2: {
                        iconPath = METHOD_ST_PROTECTED;
                        break;
                    }
                    case 3: {
                        iconPath = METHOD_ST_PUBLIC;
                    }
                }
            }
            if (iconPath == null) {
                return null;
            }
            ImageIcon newIcon = new ImageIcon(org.openide.util.Utilities.loadImage((String)iconPath));
            StaticMemberItem.icon[isField ? 0 : 1][level - 1] = newIcon;
            return newIcon;
        }

        protected void substituteText(final JTextComponent c, final int offset, int len, String toAdd) {
            int semiPos;
            final BaseDocument doc = (BaseDocument)c.getDocument();
            final StringBuilder text = new StringBuilder();
            int n = semiPos = toAdd != null && toAdd.endsWith(";") ? JavaCompletionItem.findPositionForSemicolon(c) : -2;
            if (semiPos > -2) {
                String string = toAdd = toAdd.length() > 1 ? toAdd.substring(0, toAdd.length() - 1) : null;
            }
            if (toAdd != null && !toAdd.equals("\n")) {
                TokenSequence<JavaTokenId> sequence = Utilities.getJavaTokenSequence(c, offset + len);
                if (sequence == null) {
                    text.append(toAdd);
                    toAdd = null;
                }
                boolean added = false;
                while (toAdd != null && toAdd.length() > 0) {
                    String tokenText = ((Object)sequence.token().text()).toString();
                    if (tokenText.startsWith(toAdd)) {
                        len = sequence.offset() - offset + toAdd.length();
                        text.append(toAdd);
                        toAdd = null;
                        continue;
                    }
                    if (toAdd.startsWith(tokenText)) {
                        sequence.moveNext();
                        len = sequence.offset() - offset;
                        text.append(toAdd.substring(0, tokenText.length()));
                        toAdd = toAdd.substring(tokenText.length());
                        added = true;
                        continue;
                    }
                    if (sequence.token().id() == JavaTokenId.WHITESPACE && ((Object)sequence.token().text()).toString().indexOf(10) < 0) {
                        if (sequence.moveNext()) continue;
                        text.append(toAdd);
                        toAdd = null;
                        continue;
                    }
                    if (!added) {
                        text.append(toAdd);
                    }
                    toAdd = null;
                }
            }
            final int finalLen = len;
            JavaSource js = JavaSource.forDocument((Document)doc);
            try {
                js.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run(CompilationController controller) throws IOException {
                        CodeTemplateManager ctm;
                        controller.toPhase(JavaSource.Phase.RESOLVED);
                        DeclaredType type = (DeclaredType)StaticMemberItem.this.typeHandle.resolve((CompilationInfo)controller);
                        StringBuilder sb = new StringBuilder();
                        int cnt = 1;
                        sb.append("${PAR#");
                        sb.append(cnt++);
                        sb.append(" type=\"");
                        sb.append(((TypeElement)type.asElement()).getQualifiedName());
                        sb.append("\" editable=false}");
                        Iterator<? extends TypeMirror> tas = type.getTypeArguments().iterator();
                        if (tas.hasNext()) {
                            sb.append('<');
                            while (tas.hasNext()) {
                                TypeMirror ta = tas.next();
                                sb.append("${PAR#");
                                sb.append(cnt++);
                                if (ta.getKind() == TypeKind.TYPEVAR) {
                                    sb.append(" type=\"");
                                    ta = ((TypeVariable)ta).getUpperBound();
                                    sb.append(Utilities.getTypeName(ta, true));
                                    sb.append("\"}");
                                } else if (ta.getKind() == TypeKind.WILDCARD) {
                                    sb.append(" type=\"");
                                    TypeMirror bound = ((WildcardType)ta).getExtendsBound();
                                    if (bound == null) {
                                        bound = ((WildcardType)ta).getSuperBound();
                                    }
                                    sb.append(bound != null ? Utilities.getTypeName(bound, true) : "java.lang.Object");
                                    sb.append("\"}");
                                } else if (ta.getKind() == TypeKind.ERROR) {
                                    sb.append(" default=\"\"}");
                                } else {
                                    sb.append(" type=\"");
                                    sb.append(Utilities.getTypeName(ta, true));
                                    sb.append("\" editable=false}");
                                }
                                if (!tas.hasNext()) continue;
                                sb.append(", ");
                            }
                            sb.append('>');
                        }
                        sb.append('.');
                        sb.append(StaticMemberItem.this.memberName);
                        if (StaticMemberItem.this.params != null) {
                            sb.append("(");
                            Iterator it = StaticMemberItem.this.params.iterator();
                            while (it.hasNext()) {
                                ParamDesc paramDesc = (ParamDesc)it.next();
                                sb.append("${");
                                sb.append(paramDesc.name);
                                sb.append(" named instanceof=");
                                sb.append(paramDesc.fullTypeName);
                                sb.append("}");
                                if (!it.hasNext()) continue;
                                sb.append(", ");
                            }
                            sb.append(")");
                        }
                        sb.append((CharSequence)text);
                        doc.atomicLock();
                        try {
                            Position semiPosition;
                            Position position = semiPosition = semiPos > -1 ? doc.createPosition(semiPos) : null;
                            if (finalLen > 0) {
                                doc.remove(offset, finalLen);
                            }
                            if (semiPosition != null) {
                                doc.insertString(semiPosition.getOffset(), ";", null);
                            }
                        }
                        catch (BadLocationException e) {
                        }
                        finally {
                            doc.atomicUnlock();
                        }
                        if ((ctm = CodeTemplateManager.get((Document)doc)) != null) {
                            ctm.createTemporary(sb.toString()).insert(c);
                        }
                    }
                }, true);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Modifier mod : this.modifiers) {
                sb.append(mod.toString());
                sb.append(' ');
            }
            sb.append(this.memberTypeName);
            sb.append(' ');
            sb.append(this.typeName);
            sb.append('.');
            sb.append(this.memberName);
            if (this.params != null) {
                sb.append('(');
                Iterator<ParamDesc> it = this.params.iterator();
                while (it.hasNext()) {
                    ParamDesc paramDesc = it.next();
                    sb.append(paramDesc.typeName);
                    sb.append(' ');
                    sb.append(paramDesc.name);
                    if (!it.hasNext()) continue;
                    sb.append(", ");
                }
                sb.append(')');
            }
            return sb.toString();
        }
    }

    private static class TypeParameterItem
    extends JavaCompletionItem {
        private static final String TYPE_PARAMETER_COLOR = "<font color=#000000>";
        private String simpleName;
        private String leftText;

        private TypeParameterItem(TypeParameterElement elem, int substitutionOffset) {
            super(substitutionOffset);
            this.simpleName = elem.getSimpleName().toString();
        }

        public int getSortPriority() {
            return 700;
        }

        public CharSequence getSortText() {
            return this.simpleName;
        }

        public CharSequence getInsertPrefix() {
            return this.simpleName;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                this.leftText = TYPE_PARAMETER_COLOR + this.simpleName + JavaCompletionItem.COLOR_END;
            }
            return this.leftText;
        }

        public String toString() {
            return this.simpleName;
        }
    }

    private static class VariableItem
    extends JavaCompletionItem {
        private static final String LOCAL_VARIABLE = "org/netbeans/modules/editor/resources/completion/localVariable.gif";
        private static final String PARAMETER_COLOR = "<font color=#00007c>";
        private static ImageIcon icon;
        private String varName;
        private boolean smartType;
        private String typeName;
        private String leftText;
        private String rightText;

        private VariableItem(TypeMirror type, String varName, int substitutionOffset, boolean smartType) {
            super(substitutionOffset);
            this.varName = varName;
            this.smartType = smartType;
            this.typeName = type != null ? ((Object)Utilities.getTypeName(type, false)).toString() : null;
        }

        public int getSortPriority() {
            return this.smartType ? 200 - SMART_TYPE : 200;
        }

        public CharSequence getSortText() {
            return this.varName;
        }

        public CharSequence getInsertPrefix() {
            return this.varName;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                this.leftText = "<font color=#00007c><b>" + this.varName + JavaCompletionItem.BOLD_END + JavaCompletionItem.COLOR_END;
            }
            return this.leftText;
        }

        protected String getRightHtmlText() {
            if (this.rightText == null) {
                this.rightText = JavaCompletionItem.escape(this.typeName);
            }
            return this.rightText;
        }

        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = new ImageIcon(org.openide.util.Utilities.loadImage((String)LOCAL_VARIABLE));
            }
            return icon;
        }

        public String toString() {
            return (this.typeName != null ? this.typeName + " " : "") + this.varName;
        }
    }
}

