/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.ext.ExtSettingsDefaults;
import org.netbeans.editor.ext.java.JavaTokenContext;
import org.netbeans.modules.editor.java.JavaKit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    private static final String CAPTURED_WILDCARD = "<captured wildcard>";
    private static final String ERROR = "<error>";
    private static final String UNKNOWN = "<unknown>";
    private static boolean caseSensitive = true;
    private static SettingsChangeListener settingsListener = new SettingsListener();
    private static boolean inited;

    public static boolean startsWith(String theString, String prefix) {
        if (theString == null || theString.length() == 0 || ERROR.equals(theString)) {
            return false;
        }
        if (prefix == null || prefix.length() == 0) {
            return true;
        }
        return Utilities.isCaseSensitive() ? theString.startsWith(prefix) : theString.toLowerCase().startsWith(prefix.toLowerCase());
    }

    public static boolean isCaseSensitive() {
        Utilities.lazyInit();
        return caseSensitive;
    }

    public static void setCaseSensitive(boolean b) {
        Utilities.lazyInit();
        caseSensitive = b;
    }

    private static void lazyInit() {
        if (!inited) {
            inited = true;
            Settings.addSettingsChangeListener((SettingsChangeListener)settingsListener);
            Utilities.setCaseSensitive(SettingsUtil.getBoolean(JavaKit.class, (String)"completion-case-sensitive", (Boolean)ExtSettingsDefaults.defaultCompletionCaseSensitive));
        }
    }

    public static int getImportanceLevel(String fqn) {
        int weight = 50;
        if (fqn.startsWith("java.lang") || fqn.startsWith("java.util")) {
            weight -= 10;
        } else if (fqn.startsWith("org.omg") || fqn.startsWith("org.apache")) {
            weight += 10;
        } else if (fqn.startsWith("com.sun") || fqn.startsWith("com.ibm") || fqn.startsWith("com.apple")) {
            weight += 20;
        } else if (fqn.startsWith("sun") || fqn.startsWith("sunw") || fqn.startsWith("netscape")) {
            weight += 30;
        }
        return weight;
    }

    public static TreePath getPathElementOfKind(Tree.Kind kind, TreePath path) {
        return Utilities.getPathElementOfKind(EnumSet.of(kind), path);
    }

    public static TreePath getPathElementOfKind(EnumSet<Tree.Kind> kinds, TreePath path) {
        while (path != null) {
            if (kinds.contains((Object)path.getLeaf().getKind())) {
                return path;
            }
            path = path.getParentPath();
        }
        return null;
    }

    public static boolean isJavaContext(JTextComponent component, int offset) {
        TokenSequence<JavaTokenId> ts = Utilities.getJavaTokenSequence(component, offset);
        if (ts == null) {
            return false;
        }
        switch ((JavaTokenId)ts.token().id()) {
            case DOUBLE_LITERAL: {
                if (ts.token().text().charAt(0) == '.') break;
            }
            case CHAR_LITERAL: 
            case FLOAT_LITERAL: 
            case FLOAT_LITERAL_INVALID: 
            case INT_LITERAL: 
            case INVALID_COMMENT_END: 
            case JAVADOC_COMMENT: 
            case LONG_LITERAL: 
            case STRING_LITERAL: 
            case LINE_COMMENT: 
            case BLOCK_COMMENT: {
                return false;
            }
        }
        return true;
    }

    public static TokenSequence<JavaTokenId> getJavaTokenSequence(JTextComponent component, int offset) {
        TokenHierarchy hierarchy = TokenHierarchy.get((Document)component.getDocument());
        if (hierarchy != null) {
            for (TokenSequence ts = hierarchy.tokenSequence(); ts != null && ts.moveNext(); ts = ts.embedded()) {
                ts.move(offset);
                if (!ts.moveNext()) {
                    ts.movePrevious();
                }
                if (ts.language() != JavaTokenId.language()) continue;
                return ts;
            }
        }
        return null;
    }

    public static CharSequence getTypeName(TypeMirror type, boolean fqn) {
        return Utilities.getTypeName(type, fqn, false);
    }

    public static CharSequence getTypeName(TypeMirror type, boolean fqn, boolean varArg) {
        if (type == null) {
            return "";
        }
        return (CharSequence)new TypeNameVisitor(varArg).visit(type, fqn);
    }

    public static CharSequence getElementName(Element el, boolean fqn) {
        if (el == null || el.asType().getKind() == TypeKind.NONE) {
            return "";
        }
        return (CharSequence)new ElementNameVisitor().visit(el, fqn);
    }

    public static Collection<? extends Element> getForwardReferences(TreePath path, int pos, SourcePositions sourcePositions, Trees trees) {
        HashSet<Element> refs = new HashSet<Element>();
        while (path != null) {
            switch (path.getLeaf().getKind()) {
                case BLOCK: 
                case CLASS: {
                    return refs;
                }
                case VARIABLE: {
                    refs.add(trees.getElement(path));
                    TreePath parent = path.getParentPath();
                    if (parent.getLeaf().getKind() == Tree.Kind.CLASS) {
                        boolean isStatic = ((VariableTree)path.getLeaf()).getModifiers().getFlags().contains((Object)Modifier.STATIC);
                        for (Tree tree : ((ClassTree)parent.getLeaf()).getMembers()) {
                            if (tree.getKind() != Tree.Kind.VARIABLE || sourcePositions.getStartPosition(path.getCompilationUnit(), tree) < (long)pos || !isStatic && ((VariableTree)tree).getModifiers().getFlags().contains((Object)Modifier.STATIC)) continue;
                            refs.add(trees.getElement(new TreePath(parent, tree)));
                        }
                    }
                    return refs;
                }
                case ENHANCED_FOR_LOOP: {
                    EnhancedForLoopTree efl = (EnhancedForLoopTree)path.getLeaf();
                    if (sourcePositions.getEndPosition(path.getCompilationUnit(), efl.getExpression()) < (long)pos) break;
                    refs.add(trees.getElement(new TreePath(path, efl.getVariable())));
                }
            }
            path = path.getParentPath();
        }
        return refs;
    }

    public static List<String> varNamesSuggestions(TypeMirror type, String prefix, Types types, Elements elements, Iterable<? extends Element> locals, boolean isConst) {
        ArrayList<String> result = new ArrayList<String>();
        if (type == null) {
            return result;
        }
        List<String> vnct = Utilities.varNamesForType(type, types, elements);
        if (isConst) {
            ArrayList<String> ls = new ArrayList<String>(vnct.size());
            for (String s : vnct) {
                ls.add(Utilities.getConstName(s));
            }
            vnct = ls;
        }
        String p = prefix;
        while (p != null && p.length() > 0) {
            ArrayList<String> l = new ArrayList<String>();
            for (String name : vnct) {
                if (!Utilities.startsWith(name, p)) continue;
                l.add(name);
            }
            if (l.isEmpty()) {
                p = Utilities.nextName(p);
                continue;
            }
            vnct = l;
            prefix = prefix.substring(0, prefix.length() - p.length());
            p = null;
        }
        for (String name : vnct) {
            boolean isPrimitive = type.getKind().isPrimitive();
            if (prefix != null && prefix.length() > 0) {
                name = isConst ? prefix.toUpperCase() + '_' + name : prefix + Character.toUpperCase(name.charAt(0)) + name.substring(1);
            }
            int cnt = 1;
            while (Utilities.isClashing(name, locals)) {
                if (isPrimitive) {
                    char c = name.charAt(0);
                    c = (char)(c + '\u0001');
                    name = Character.toString(c);
                    if (c != 'z') continue;
                    isPrimitive = false;
                    continue;
                }
                name = name + cnt++;
            }
            result.add(name);
        }
        return result;
    }

    public static boolean isInMethod(TreePath tp) {
        while (tp != null) {
            if (tp.getLeaf().getKind() == Tree.Kind.METHOD) {
                return true;
            }
            tp = tp.getParentPath();
        }
        return false;
    }

    private static List<String> varNamesForType(TypeMirror type, Types types, Elements elements) {
        switch (type.getKind()) {
            case ARRAY: {
                DeclaredType iterable = types.getDeclaredType(elements.getTypeElement("java.lang.Iterable"), new TypeMirror[0]);
                TypeMirror ct = ((ArrayType)type).getComponentType();
                if (ct.getKind() == TypeKind.ARRAY && types.isSubtype(ct, iterable)) {
                    return Utilities.varNamesForType(ct, types, elements);
                }
                ArrayList<String> vnct = new ArrayList<String>();
                for (String name : Utilities.varNamesForType(ct, types, elements)) {
                    vnct.add(name.endsWith("s") ? name + "es" : name + "s");
                }
                return vnct;
            }
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: {
                return Collections.singletonList(((Object)type).toString().substring(0, 1));
            }
            case TYPEVAR: {
                return Collections.singletonList(((Object)type).toString().toLowerCase());
            }
            case ERROR: {
                String tn = ((ErrorType)type).asElement().getSimpleName().toString();
                if (tn.toUpperCase().contentEquals(tn)) {
                    return Collections.singletonList(tn.toLowerCase());
                }
                StringBuilder sb = new StringBuilder();
                ArrayList<String> al = new ArrayList<String>();
                if ("Iterator".equals(tn)) {
                    al.add("it");
                }
                while ((tn = Utilities.nextName(tn)).length() > 0) {
                    al.add(tn);
                    sb.append(tn.charAt(0));
                }
                if (sb.length() > 0) {
                    al.add(sb.toString());
                }
                return al;
            }
            case DECLARED: {
                List<? extends TypeMirror> tas;
                DeclaredType iterable = types.getDeclaredType(elements.getTypeElement("java.lang.Iterable"), new TypeMirror[0]);
                String tn = ((DeclaredType)type).asElement().getSimpleName().toString();
                if (tn.toUpperCase().contentEquals(tn)) {
                    return Collections.singletonList(tn.toLowerCase());
                }
                StringBuilder sb = new StringBuilder();
                ArrayList<String> al = new ArrayList<String>();
                if ("Iterator".equals(tn)) {
                    al.add("it");
                }
                while ((tn = Utilities.nextName(tn)).length() > 0) {
                    al.add(tn);
                    sb.append(tn.charAt(0));
                }
                if (types.isSubtype(type, iterable) && (tas = ((DeclaredType)type).getTypeArguments()).size() > 0) {
                    TypeMirror et = tas.get(0);
                    if (et.getKind() == TypeKind.ARRAY || et.getKind() != TypeKind.WILDCARD && types.isSubtype(et, iterable)) {
                        al.addAll(Utilities.varNamesForType(et, types, elements));
                    } else {
                        for (String name : Utilities.varNamesForType(et, types, elements)) {
                            al.add(name.endsWith("s") ? name + "es" : name + "s");
                        }
                    }
                }
                if (sb.length() > 0) {
                    al.add(sb.toString());
                }
                return al;
            }
            case WILDCARD: {
                TypeMirror bound = ((WildcardType)type).getExtendsBound();
                if (bound == null) {
                    bound = ((WildcardType)type).getSuperBound();
                }
                if (bound == null) break;
                return Utilities.varNamesForType(bound, types, elements);
            }
        }
        return Collections.emptyList();
    }

    private static String getConstName(String s) {
        StringBuilder sb = new StringBuilder();
        boolean prevUpper = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isUpperCase(c)) {
                if (!prevUpper) {
                    sb.append('_');
                }
                sb.append(c);
                prevUpper = true;
                continue;
            }
            sb.append(Character.toUpperCase(c));
            prevUpper = false;
        }
        return sb.toString();
    }

    private static String nextName(CharSequence name) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (!Character.isUpperCase(c)) continue;
            char lc = Character.toLowerCase(c);
            sb.append(lc);
            sb.append(name.subSequence(i + 1, name.length()));
            break;
        }
        return sb.toString();
    }

    private static boolean isClashing(String varName, Iterable<? extends Element> locals) {
        if (JavaTokenContext.getKeyword((String)varName) != null) {
            return true;
        }
        for (Element element : locals) {
            if (element.getKind() != ElementKind.LOCAL_VARIABLE && element.getKind() != ElementKind.PARAMETER && element.getKind() != ElementKind.EXCEPTION_PARAMETER || !varName.contentEquals(element.getSimpleName())) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ElementNameVisitor
    extends SimpleElementVisitor6<StringBuilder, Boolean> {
        private ElementNameVisitor() {
            super(new StringBuilder());
        }

        @Override
        public StringBuilder visitPackage(PackageElement e, Boolean p) {
            return ((StringBuilder)this.DEFAULT_VALUE).append((p != false ? e.getQualifiedName() : e.getSimpleName()).toString());
        }

        @Override
        public StringBuilder visitType(TypeElement e, Boolean p) {
            return ((StringBuilder)this.DEFAULT_VALUE).append((p != false ? e.getQualifiedName() : e.getSimpleName()).toString());
        }
    }

    private static class SettingsListener
    implements SettingsChangeListener {
        private SettingsListener() {
        }

        public void settingsChange(SettingsChangeEvent evt) {
            Utilities.setCaseSensitive(SettingsUtil.getBoolean(JavaKit.class, (String)"completion-case-sensitive", (Boolean)ExtSettingsDefaults.defaultCompletionCaseSensitive));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeNameVisitor
    extends SimpleTypeVisitor6<StringBuilder, Boolean> {
        private boolean varArg;

        private TypeNameVisitor(boolean varArg) {
            super(new StringBuilder());
            this.varArg = varArg;
        }

        @Override
        public StringBuilder defaultAction(TypeMirror t, Boolean p) {
            return ((StringBuilder)this.DEFAULT_VALUE).append(t);
        }

        @Override
        public StringBuilder visitDeclared(DeclaredType t, Boolean p) {
            Element e = t.asElement();
            if (e instanceof TypeElement) {
                TypeElement te = (TypeElement)e;
                ((StringBuilder)this.DEFAULT_VALUE).append((p != false ? te.getQualifiedName() : te.getSimpleName()).toString());
                Iterator<? extends TypeMirror> it = t.getTypeArguments().iterator();
                if (it.hasNext()) {
                    ((StringBuilder)this.DEFAULT_VALUE).append("<");
                    while (it.hasNext()) {
                        this.visit(it.next(), p);
                        if (!it.hasNext()) continue;
                        ((StringBuilder)this.DEFAULT_VALUE).append(", ");
                    }
                    ((StringBuilder)this.DEFAULT_VALUE).append(">");
                }
                return (StringBuilder)this.DEFAULT_VALUE;
            }
            return ((StringBuilder)this.DEFAULT_VALUE).append(Utilities.UNKNOWN);
        }

        @Override
        public StringBuilder visitArray(ArrayType t, Boolean p) {
            boolean isVarArg = this.varArg;
            this.varArg = false;
            this.visit(t.getComponentType(), p);
            return ((StringBuilder)this.DEFAULT_VALUE).append(isVarArg ? "..." : "[]");
        }

        @Override
        public StringBuilder visitTypeVariable(TypeVariable t, Boolean p) {
            String name;
            Element e = t.asElement();
            if (e != null && !Utilities.CAPTURED_WILDCARD.equals(name = e.getSimpleName().toString())) {
                return ((StringBuilder)this.DEFAULT_VALUE).append(name);
            }
            ((StringBuilder)this.DEFAULT_VALUE).append("?");
            TypeMirror bound = t.getLowerBound();
            if (bound != null && bound.getKind() != TypeKind.NULL) {
                ((StringBuilder)this.DEFAULT_VALUE).append(" super ");
                this.visit(bound, p);
            } else {
                bound = t.getUpperBound();
                if (bound != null && bound.getKind() != TypeKind.NULL) {
                    ((StringBuilder)this.DEFAULT_VALUE).append(" extends ");
                    if (bound.getKind() == TypeKind.TYPEVAR) {
                        bound = ((TypeVariable)bound).getLowerBound();
                    }
                    this.visit(bound, p);
                }
            }
            return (StringBuilder)this.DEFAULT_VALUE;
        }

        @Override
        public StringBuilder visitWildcard(WildcardType t, Boolean p) {
            ((StringBuilder)this.DEFAULT_VALUE).append("?");
            TypeMirror bound = t.getSuperBound();
            if (bound == null) {
                bound = t.getExtendsBound();
                if (bound != null) {
                    ((StringBuilder)this.DEFAULT_VALUE).append(" extends ");
                    if (bound.getKind() == TypeKind.WILDCARD) {
                        bound = ((WildcardType)bound).getSuperBound();
                    }
                    this.visit(bound, p);
                } else {
                    bound = SourceUtils.getBound((WildcardType)t);
                    if (bound != null) {
                        ((StringBuilder)this.DEFAULT_VALUE).append(" extends ");
                        this.visit(bound, p);
                    } else {
                        ((StringBuilder)this.DEFAULT_VALUE).append(p != false ? " extends java.lang.Object" : " extends Object");
                    }
                }
            } else {
                ((StringBuilder)this.DEFAULT_VALUE).append(" super ");
                this.visit(bound, p);
            }
            return (StringBuilder)this.DEFAULT_VALUE;
        }

        @Override
        public StringBuilder visitError(ErrorType t, Boolean p) {
            Element e = t.asElement();
            if (e instanceof TypeElement) {
                TypeElement te = (TypeElement)e;
                return ((StringBuilder)this.DEFAULT_VALUE).append((p != false ? te.getQualifiedName() : te.getSimpleName()).toString());
            }
            return (StringBuilder)this.DEFAULT_VALUE;
        }
    }
}

