/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.codegen;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.awt.Dialog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.editor.codegen.CodeGenerator;
import org.netbeans.modules.java.editor.codegen.ConstructorGenerator;
import org.netbeans.modules.java.editor.codegen.ui.DelegatePanel;
import org.netbeans.modules.java.editor.codegen.ui.ElementNode;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegateMethodGenerator
implements CodeGenerator {
    private ElementNode.Description description;

    private DelegateMethodGenerator(ElementNode.Description description) {
        this.description = description;
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(DelegateMethodGenerator.class, (String)"LBL_delegate_method");
    }

    @Override
    public void invoke(JTextComponent component) {
        JavaSource js;
        final DelegatePanel panel = new DelegatePanel(component, this.description);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)panel, NbBundle.getMessage(ConstructorGenerator.class, (String)"LBL_generate_delegate"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION && (js = JavaSource.forDocument((Document)component.getDocument())) != null) {
            try {
                final int caretOffset = component.getCaretPosition();
                js.runModificationTask((CancellableTask)new CancellableTask<WorkingCopy>(){

                    public void cancel() {
                    }

                    public void run(WorkingCopy copy) throws IOException {
                        ElementHandle<? extends Element> handle;
                        copy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        TreePath path = copy.getTreeUtilities().pathFor(caretOffset);
                        path = Utilities.getPathElementOfKind(Tree.Kind.CLASS, path);
                        int idx = 0;
                        SourcePositions sourcePositions = copy.getTrees().getSourcePositions();
                        for (Tree tree : ((ClassTree)path.getLeaf()).getMembers()) {
                            if (sourcePositions.getStartPosition(path.getCompilationUnit(), tree) >= (long)caretOffset) break;
                            ++idx;
                        }
                        VariableElement variableElement = (handle = panel.getDelegateField()) != null ? (VariableElement)handle.resolve((CompilationInfo)copy) : null;
                        ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>();
                        for (ElementHandle<? extends Element> elementHandle : panel.getDelegateMethods()) {
                            methods.add((ExecutableElement)elementHandle.resolve((CompilationInfo)copy));
                        }
                        DelegateMethodGenerator.generateDelegatingMethods(copy, path, variableElement, methods, idx);
                    }
                }).commit();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public static ElementNode.Description getAvailableMethods(JTextComponent component, final ElementHandle<? extends Element> elementHandle) {
        JavaSource js;
        if (elementHandle.getKind().isField() && (js = JavaSource.forDocument((Document)component.getDocument())) != null) {
            try {
                final int caretOffset = component.getCaretPosition();
                final ElementNode.Description[] description = new ElementNode.Description[1];
                js.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController controller) throws IOException {
                        VariableElement field = (VariableElement)elementHandle.resolve((CompilationInfo)controller);
                        if (field.asType().getKind() == TypeKind.DECLARED) {
                            DeclaredType type = (DeclaredType)field.asType();
                            Trees trees = controller.getTrees();
                            Scope scope = controller.getTreeUtilities().scopeFor(caretOffset);
                            LinkedHashMap<Element, ArrayList<ElementNode.Description>> map = new LinkedHashMap<Element, ArrayList<ElementNode.Description>>();
                            for (ExecutableElement method : ElementFilter.methodsIn(controller.getElements().getAllMembers((TypeElement)type.asElement()))) {
                                if (!trees.isAccessible(scope, method, type)) continue;
                                ArrayList<ElementNode.Description> descriptions = (ArrayList<ElementNode.Description>)map.get(method.getEnclosingElement());
                                if (descriptions == null) {
                                    descriptions = new ArrayList<ElementNode.Description>();
                                    map.put(method.getEnclosingElement(), descriptions);
                                }
                                descriptions.add(ElementNode.Description.create(method, null, true, false));
                            }
                            ArrayList<ElementNode.Description> descriptions = new ArrayList<ElementNode.Description>();
                            for (Map.Entry entry : map.entrySet()) {
                                descriptions.add(ElementNode.Description.create((Element)entry.getKey(), (List)entry.getValue(), false, false));
                            }
                            if (!descriptions.isEmpty()) {
                                Collections.reverse(descriptions);
                            }
                            description[0] = ElementNode.Description.create(descriptions);
                        }
                    }
                }, true);
                return description[0];
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    private static void generateDelegatingMethods(WorkingCopy wc, TreePath path, VariableElement delegate, Iterable<? extends ExecutableElement> methods, int index) {
        assert (path.getLeaf().getKind() == Tree.Kind.CLASS);
        TypeElement te = (TypeElement)wc.getTrees().getElement(path);
        if (te != null) {
            TreeMaker make = wc.getTreeMaker();
            ClassTree nue = (ClassTree)path.getLeaf();
            for (ExecutableElement executableElement : methods) {
                nue = make.insertClassMember(nue, index, (Tree)DelegateMethodGenerator.createDelegatingMethod(wc, delegate, executableElement, (DeclaredType)te.asType()));
            }
            wc.rewrite(path.getLeaf(), (Tree)nue);
        }
    }

    private static MethodTree createDelegatingMethod(WorkingCopy wc, VariableElement delegate, ExecutableElement method, DeclaredType type) {
        TreeMaker make = wc.getTreeMaker();
        ExecutableType methodType = (ExecutableType)wc.getTypes().asMemberOf((DeclaredType)delegate.asType(), method);
        EnumSet<Modifier> mods = EnumSet.copyOf(method.getModifiers());
        mods.remove((Object)Modifier.ABSTRACT);
        ArrayList<VariableTree> params = new ArrayList<VariableTree>();
        ArrayList<IdentifierTree> args = new ArrayList<IdentifierTree>();
        Iterator<? extends VariableElement> it = method.getParameters().iterator();
        Iterator<? extends TypeMirror> tIt = methodType.getParameterTypes().iterator();
        while (it.hasNext() && tIt.hasNext()) {
            VariableElement ve = it.next();
            params.add(make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)ve.getSimpleName(), make.Type(tIt.next()), null));
            args.add(make.Identifier((CharSequence)ve.getSimpleName()));
        }
        MethodInvocationTree exp = make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.MemberSelect((ExpressionTree)make.Identifier((CharSequence)delegate.getSimpleName()), (CharSequence)method.getSimpleName()), args);
        StatementTree stmt = method.getReturnType().getKind() == TypeKind.VOID ? make.ExpressionStatement((ExpressionTree)exp) : make.Return((ExpressionTree)exp);
        BlockTree body = make.Block(Collections.singletonList(stmt), false);
        ArrayList<ExpressionTree> throwsClause = new ArrayList<ExpressionTree>();
        for (TypeMirror typeMirror : methodType.getThrownTypes()) {
            throwsClause.add((ExpressionTree)wc.getTreeMaker().Type(typeMirror));
        }
        return make.Method(make.Modifiers(mods), (CharSequence)method.getSimpleName(), make.Type(methodType.getReturnType()), Collections.emptyList(), params, throwsClause, body, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements CodeGenerator.Factory {
        Factory() {
        }

        @Override
        public Iterable<? extends CodeGenerator> create(CompilationController controller, TreePath path) throws IOException {
            TypeElement cls;
            if ((path = Utilities.getPathElementOfKind(Tree.Kind.CLASS, path)) == null) {
                return Collections.emptySet();
            }
            controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            Elements elements = controller.getElements();
            TypeElement typeElement = (TypeElement)controller.getTrees().getElement(path);
            if (!typeElement.getKind().isClass()) {
                return Collections.emptySet();
            }
            Trees trees = controller.getTrees();
            LinkedHashMap<Element, ArrayList<ElementNode.Description>> map = new LinkedHashMap<Element, ArrayList<ElementNode.Description>>();
            for (Scope scope = trees.getScope(path); scope != null && (cls = scope.getEnclosingClass()) != null; scope = scope.getEnclosingScope()) {
                DeclaredType type = (DeclaredType)cls.asType();
                for (VariableElement field : ElementFilter.fieldsIn(elements.getAllMembers(cls))) {
                    if (field.asType().getKind().isPrimitive() || !trees.isAccessible(scope, field, type)) continue;
                    ArrayList<ElementNode.Description> descriptions = (ArrayList<ElementNode.Description>)map.get(field.getEnclosingElement());
                    if (descriptions == null) {
                        descriptions = new ArrayList<ElementNode.Description>();
                        map.put(field.getEnclosingElement(), descriptions);
                    }
                    descriptions.add(ElementNode.Description.create(field, null, false, false));
                }
            }
            ArrayList<ElementNode.Description> descriptions = new ArrayList<ElementNode.Description>();
            for (Map.Entry entry : map.entrySet()) {
                descriptions.add(ElementNode.Description.create((Element)entry.getKey(), (List)entry.getValue(), false, false));
            }
            if (descriptions.isEmpty()) {
                return Collections.emptySet();
            }
            Collections.reverse(descriptions);
            return Collections.singleton(new DelegateMethodGenerator(ElementNode.Description.create(descriptions)));
        }
    }
}

