/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.codegen;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.awt.Dialog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.editor.codegen.CodeGenerator;
import org.netbeans.modules.java.editor.codegen.ConstructorGenerator;
import org.netbeans.modules.java.editor.codegen.ui.ElementNode;
import org.netbeans.modules.java.editor.codegen.ui.EqualsHashCodePanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EqualsHashCodeGenerator
implements CodeGenerator {
    ElementNode.Description description;

    private EqualsHashCodeGenerator(ElementNode.Description description) {
        this.description = description;
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(EqualsHashCodeGenerator.class, (String)"LBL_equals_and_hashcode");
    }

    @Override
    public void invoke(JTextComponent component) {
        JavaSource js;
        final EqualsHashCodePanel panel = new EqualsHashCodePanel(this.description);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)panel, NbBundle.getMessage(ConstructorGenerator.class, (String)"LBL_generate_equals_and_hashcode"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION && (js = JavaSource.forDocument((Document)component.getDocument())) != null) {
            try {
                final int caretOffset = component.getCaretPosition();
                js.runModificationTask((CancellableTask)new CancellableTask<WorkingCopy>(){

                    public void cancel() {
                    }

                    public void run(WorkingCopy copy) throws IOException {
                        copy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        TreePath path = copy.getTreeUtilities().pathFor(caretOffset);
                        path = Utilities.getPathElementOfKind(Tree.Kind.CLASS, path);
                        int idx = 0;
                        SourcePositions sourcePositions = copy.getTrees().getSourcePositions();
                        for (Tree tree : ((ClassTree)path.getLeaf()).getMembers()) {
                            if (sourcePositions.getStartPosition(path.getCompilationUnit(), tree) >= (long)caretOffset) break;
                            ++idx;
                        }
                        ArrayList<VariableElement> equalsElements = new ArrayList<VariableElement>();
                        for (ElementHandle<? extends Element> elementHandle : panel.getEqualsVariables()) {
                            equalsElements.add((VariableElement)elementHandle.resolve((CompilationInfo)copy));
                        }
                        ArrayList<VariableElement> arrayList = new ArrayList<VariableElement>();
                        for (ElementHandle<? extends Element> elementHandle : panel.getHashCodeVariables()) {
                            arrayList.add((VariableElement)elementHandle.resolve((CompilationInfo)copy));
                        }
                        EqualsHashCodeGenerator.generateEqualsAndHashCode(copy, path, equalsElements, arrayList, idx);
                    }
                }).commit();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static void generateEqualsAndHashCode(WorkingCopy wc, TreePath path, Iterable<? extends VariableElement> equalsFields, Iterable<? extends VariableElement> hashCodeFields, int index) {
        assert (path.getLeaf().getKind() == Tree.Kind.CLASS);
        TypeElement te = (TypeElement)wc.getTrees().getElement(path);
        if (te != null) {
            TreeMaker make = wc.getTreeMaker();
            ClassTree nue = (ClassTree)path.getLeaf();
            nue = make.insertClassMember(nue, index, (Tree)EqualsHashCodeGenerator.createHashCodeMethod(wc, hashCodeFields, (DeclaredType)te.asType()));
            nue = make.insertClassMember(nue, index, (Tree)EqualsHashCodeGenerator.createEqualsMethod(wc, equalsFields, (DeclaredType)te.asType()));
            wc.rewrite(path.getLeaf(), (Tree)nue);
        }
    }

    private static MethodTree createEqualsMethod(WorkingCopy wc, Iterable<? extends VariableElement> equalsFields, DeclaredType type) {
        TreeMaker make = wc.getTreeMaker();
        EnumSet<Modifier> mods = EnumSet.of(Modifier.PUBLIC);
        List<VariableTree> params = Collections.singletonList(make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)"obj", make.Type(wc.getElements().getTypeElement("java.lang.Object").asType()), null));
        ArrayList<StatementTree> statements = new ArrayList<StatementTree>();
        statements.add(make.If((ExpressionTree)make.Binary(Tree.Kind.EQUAL_TO, (ExpressionTree)make.Identifier((CharSequence)"obj"), (ExpressionTree)make.Identifier((CharSequence)"null")), (StatementTree)make.Return((ExpressionTree)make.Identifier((CharSequence)"false")), null));
        statements.add(make.If((ExpressionTree)make.Binary(Tree.Kind.NOT_EQUAL_TO, (ExpressionTree)make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.Identifier((CharSequence)"getClass"), Collections.emptyList()), (ExpressionTree)make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.MemberSelect((ExpressionTree)make.Identifier((CharSequence)"obj"), (CharSequence)"getClass"), Collections.emptyList())), (StatementTree)make.Return((ExpressionTree)make.Identifier((CharSequence)"false")), null));
        statements.add(make.Variable(make.Modifiers(EnumSet.of(Modifier.FINAL)), (CharSequence)"other", make.Type((TypeMirror)type), (ExpressionTree)make.TypeCast(make.Type((TypeMirror)type), (ExpressionTree)make.Identifier((CharSequence)"obj"))));
        for (VariableElement variableElement : equalsFields) {
            if (variableElement.asType().getKind().isPrimitive()) {
                statements.add(make.If((ExpressionTree)make.Binary(Tree.Kind.NOT_EQUAL_TO, (ExpressionTree)make.MemberSelect((ExpressionTree)make.Identifier((CharSequence)"this"), (CharSequence)variableElement.getSimpleName()), (ExpressionTree)make.MemberSelect((ExpressionTree)make.Identifier((CharSequence)"other"), (CharSequence)variableElement.getSimpleName())), (StatementTree)make.Return((ExpressionTree)make.Identifier((CharSequence)"false")), null));
                continue;
            }
            BinaryTree exp1 = make.Binary(Tree.Kind.NOT_EQUAL_TO, (ExpressionTree)make.MemberSelect((ExpressionTree)make.Identifier((CharSequence)"this"), (CharSequence)variableElement.getSimpleName()), (ExpressionTree)make.MemberSelect((ExpressionTree)make.Identifier((CharSequence)"other"), (CharSequence)variableElement.getSimpleName()));
            BinaryTree exp2 = make.Binary(Tree.Kind.EQUAL_TO, (ExpressionTree)make.MemberSelect((ExpressionTree)make.Identifier((CharSequence)"this"), (CharSequence)variableElement.getSimpleName()), (ExpressionTree)make.Identifier((CharSequence)"null"));
            UnaryTree exp3 = make.Unary(Tree.Kind.LOGICAL_COMPLEMENT, (ExpressionTree)make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.MemberSelect((ExpressionTree)make.MemberSelect((ExpressionTree)make.Identifier((CharSequence)"this"), (CharSequence)variableElement.getSimpleName()), (CharSequence)"equals"), Collections.singletonList(make.MemberSelect((ExpressionTree)make.Identifier((CharSequence)"other"), (CharSequence)variableElement.getSimpleName()))));
            statements.add(make.If((ExpressionTree)make.Binary(Tree.Kind.CONDITIONAL_AND, (ExpressionTree)exp1, (ExpressionTree)make.Parenthesized((ExpressionTree)make.Binary(Tree.Kind.CONDITIONAL_OR, (ExpressionTree)exp2, (ExpressionTree)exp3))), (StatementTree)make.Return((ExpressionTree)make.Identifier((CharSequence)"false")), null));
        }
        statements.add(make.Return((ExpressionTree)make.Identifier((CharSequence)"true")));
        BlockTree body = make.Block(statements, false);
        return make.Method(make.Modifiers(mods), (CharSequence)"equals", (Tree)make.PrimitiveType(TypeKind.BOOLEAN), Collections.emptyList(), params, Collections.emptyList(), body, null);
    }

    private static MethodTree createHashCodeMethod(WorkingCopy wc, Iterable<? extends VariableElement> hashCodeFields, DeclaredType type) {
        TreeMaker make = wc.getTreeMaker();
        EnumSet<Modifier> mods = EnumSet.of(Modifier.PUBLIC);
        int startNumber = EqualsHashCodeGenerator.generatePrimeNumber(2, 10);
        int multiplyNumber = EqualsHashCodeGenerator.generatePrimeNumber(10, 100);
        ArrayList<StatementTree> statements = new ArrayList<StatementTree>();
        statements.add(make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)"hash", (Tree)make.PrimitiveType(TypeKind.INT), (ExpressionTree)make.Literal((Object)startNumber)));
        for (VariableElement variableElement : hashCodeFields) {
            ExpressionTree variableRead;
            switch (variableElement.asType().getKind()) {
                case BYTE: 
                case CHAR: 
                case SHORT: 
                case INT: {
                    variableRead = make.MemberSelect((ExpressionTree)make.Identifier((CharSequence)"this"), (CharSequence)variableElement.getSimpleName());
                    break;
                }
                case LONG: {
                    variableRead = make.TypeCast((Tree)make.PrimitiveType(TypeKind.INT), (ExpressionTree)make.Parenthesized((ExpressionTree)make.Binary(Tree.Kind.XOR, (ExpressionTree)make.MemberSelect((ExpressionTree)make.Identifier((CharSequence)"this"), (CharSequence)variableElement.getSimpleName()), (ExpressionTree)make.Parenthesized((ExpressionTree)make.Binary(Tree.Kind.UNSIGNED_RIGHT_SHIFT, (ExpressionTree)make.MemberSelect((ExpressionTree)make.Identifier((CharSequence)"this"), (CharSequence)variableElement.getSimpleName()), (ExpressionTree)make.Literal((Object)32))))));
                    break;
                }
                case FLOAT: {
                    variableRead = make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.MemberSelect((ExpressionTree)make.Identifier((CharSequence)"Float"), (CharSequence)"floatToIntBits"), Collections.singletonList(make.MemberSelect((ExpressionTree)make.Identifier((CharSequence)"this"), (CharSequence)variableElement.getSimpleName())));
                    break;
                }
                case DOUBLE: {
                    MethodInvocationTree et = make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.MemberSelect((ExpressionTree)make.Identifier((CharSequence)"Double"), (CharSequence)"doubleToLongBits"), Collections.singletonList(make.MemberSelect((ExpressionTree)make.Identifier((CharSequence)"this"), (CharSequence)variableElement.getSimpleName())));
                    variableRead = make.TypeCast((Tree)make.PrimitiveType(TypeKind.INT), (ExpressionTree)make.Parenthesized((ExpressionTree)make.Binary(Tree.Kind.XOR, (ExpressionTree)et, (ExpressionTree)make.Parenthesized((ExpressionTree)make.Binary(Tree.Kind.UNSIGNED_RIGHT_SHIFT, (ExpressionTree)et, (ExpressionTree)make.Literal((Object)32))))));
                    break;
                }
                case BOOLEAN: {
                    variableRead = make.ConditionalExpression((ExpressionTree)make.MemberSelect((ExpressionTree)make.Identifier((CharSequence)"this"), (CharSequence)variableElement.getSimpleName()), (ExpressionTree)make.Literal((Object)1), (ExpressionTree)make.Literal((Object)0));
                    break;
                }
                default: {
                    variableRead = make.ConditionalExpression((ExpressionTree)make.Binary(Tree.Kind.NOT_EQUAL_TO, (ExpressionTree)make.MemberSelect((ExpressionTree)make.Identifier((CharSequence)"this"), (CharSequence)variableElement.getSimpleName()), (ExpressionTree)make.Identifier((CharSequence)"null")), (ExpressionTree)make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.MemberSelect((ExpressionTree)make.MemberSelect((ExpressionTree)make.Identifier((CharSequence)"this"), (CharSequence)variableElement.getSimpleName()), (CharSequence)"hashCode"), Collections.emptyList()), (ExpressionTree)make.Literal((Object)0));
                }
            }
            statements.add(make.ExpressionStatement((ExpressionTree)make.Assignment((ExpressionTree)make.Identifier((CharSequence)"hash"), (ExpressionTree)make.Binary(Tree.Kind.PLUS, (ExpressionTree)make.Binary(Tree.Kind.MULTIPLY, (ExpressionTree)make.Literal((Object)multiplyNumber), (ExpressionTree)make.Identifier((CharSequence)"hash")), variableRead))));
        }
        statements.add(make.Return((ExpressionTree)make.Identifier((CharSequence)"hash")));
        BlockTree body = make.Block(statements, false);
        return make.Method(make.Modifiers(mods), (CharSequence)"hashCode", (Tree)make.PrimitiveType(TypeKind.INT), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), body, null);
    }

    private static boolean isPrimeNumber(int n) {
        int squareRoot = (int)Math.sqrt(n) + 1;
        if (n % 2 == 0) {
            return false;
        }
        for (int cntr = 3; cntr < squareRoot; ++cntr) {
            if (n % cntr != 0) continue;
            return false;
        }
        return true;
    }

    private static int generatePrimeNumber(int lowerLimit, int higherLimit) {
        Random r = new Random(System.currentTimeMillis());
        int proposed = r.nextInt(higherLimit - lowerLimit) + lowerLimit;
        while (!EqualsHashCodeGenerator.isPrimeNumber(proposed)) {
            ++proposed;
        }
        if (proposed > higherLimit) {
            --proposed;
            while (!EqualsHashCodeGenerator.isPrimeNumber(proposed)) {
                --proposed;
            }
        }
        return proposed;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements CodeGenerator.Factory {
        Factory() {
        }

        @Override
        public Iterable<? extends CodeGenerator> create(CompilationController controller, TreePath path) throws IOException {
            if ((path = Utilities.getPathElementOfKind(Tree.Kind.CLASS, path)) == null) {
                return Collections.emptySet();
            }
            controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            TypeElement typeElement = (TypeElement)controller.getTrees().getElement(path);
            if (typeElement.getKind() != ElementKind.CLASS) {
                return Collections.emptySet();
            }
            ArrayList<ElementNode.Description> descriptions = new ArrayList<ElementNode.Description>();
            for (VariableElement variableElement : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
                descriptions.add(ElementNode.Description.create(variableElement, null, true, false));
            }
            if (descriptions.isEmpty()) {
                return Collections.emptySet();
            }
            return Collections.singleton(new EqualsHashCodeGenerator(ElementNode.Description.create(typeElement, descriptions, false, false)));
        }
    }
}

