/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.codegen;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.awt.Dialog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.editor.codegen.CodeGenerator;
import org.netbeans.modules.java.editor.codegen.ConstructorGenerator;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.editor.codegen.ui.ElementNode;
import org.netbeans.modules.java.editor.codegen.ui.ImplementOverridePanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ImplementOverrideMethodGenerator
implements CodeGenerator {
    private ElementNode.Description description;
    private boolean isImplement;

    private ImplementOverrideMethodGenerator(ElementNode.Description description, boolean isImplement) {
        this.description = description;
        this.isImplement = isImplement;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ImplementOverrideMethodGenerator.class, (String)(this.isImplement ? "LBL_implement_method" : "LBL_override_method"));
    }

    public void invoke(JTextComponent component) {
        JavaSource js;
        final ImplementOverridePanel panel = new ImplementOverridePanel(this.description, this.isImplement);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)panel, NbBundle.getMessage(ConstructorGenerator.class, (String)(this.isImplement ? "LBL_generate_implement" : "LBL_generate_override")));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION && (js = JavaSource.forDocument((Document)component.getDocument())) != null) {
            try {
                final int caretOffset = component.getCaretPosition();
                js.runModificationTask((CancellableTask)new CancellableTask<WorkingCopy>(){

                    public void cancel() {
                    }

                    public void run(WorkingCopy copy) throws IOException {
                        copy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        TreePath path = copy.getTreeUtilities().pathFor(caretOffset);
                        path = Utilities.getPathElementOfKind(Tree.Kind.CLASS, path);
                        int idx = 0;
                        SourcePositions sourcePositions = copy.getTrees().getSourcePositions();
                        for (Tree tree : ((ClassTree)path.getLeaf()).getMembers()) {
                            if (sourcePositions.getStartPosition(path.getCompilationUnit(), tree) >= (long)caretOffset) break;
                            ++idx;
                        }
                        ArrayList<ExecutableElement> methodElements = new ArrayList<ExecutableElement>();
                        for (ElementHandle<? extends Element> elementHandle : panel.getSelectedMethods()) {
                            methodElements.add((ExecutableElement)elementHandle.resolve((CompilationInfo)copy));
                        }
                        if (ImplementOverrideMethodGenerator.this.isImplement) {
                            GeneratorUtils.generateAbstractMethodImplementations(copy, path, methodElements, idx);
                        } else {
                            GeneratorUtils.generateMethodOverrides(copy, path, methodElements, idx);
                        }
                    }
                }).commit();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements CodeGenerator.Factory {
        Factory() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Iterable<? extends CodeGenerator> create(CompilationController controller, TreePath path) throws IOException {
            ArrayList<ImplementOverrideMethodGenerator> ret = new ArrayList<ImplementOverrideMethodGenerator>();
            if ((path = Utilities.getPathElementOfKind(Tree.Kind.CLASS, path)) == null) {
                return ret;
            }
            controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            TypeElement typeElement = (TypeElement)controller.getTrees().getElement(path);
            if (!typeElement.getKind().isClass()) {
                return Collections.emptySet();
            }
            LinkedHashMap map = new LinkedHashMap();
            for (ExecutableElement executableElement : GeneratorUtils.findUndefs((CompilationInfo)controller, typeElement)) {
                void var8_11;
                List list = (List)map.get(executableElement.getEnclosingElement());
                if (list == null) {
                    ArrayList arrayList = new ArrayList();
                    map.put(executableElement.getEnclosingElement(), arrayList);
                }
                var8_11.add(ElementNode.Description.create(executableElement, null, true, false));
            }
            ArrayList<ElementNode.Description> implementDescriptions = new ArrayList<ElementNode.Description>();
            for (Map.Entry entry : map.entrySet()) {
                implementDescriptions.add(ElementNode.Description.create((Element)entry.getKey(), (List)entry.getValue(), false, false));
            }
            if (!implementDescriptions.isEmpty()) {
                ret.add(new ImplementOverrideMethodGenerator(ElementNode.Description.create(implementDescriptions), true));
            }
            map = new LinkedHashMap();
            for (ExecutableElement executableElement : GeneratorUtils.findOverridable((CompilationInfo)controller, typeElement)) {
                ArrayList<ElementNode.Description> descriptions = (ArrayList<ElementNode.Description>)map.get(executableElement.getEnclosingElement());
                if (descriptions == null) {
                    descriptions = new ArrayList<ElementNode.Description>();
                    map.put(executableElement.getEnclosingElement(), descriptions);
                }
                descriptions.add(ElementNode.Description.create(executableElement, null, true, false));
            }
            ArrayList<ElementNode.Description> arrayList = new ArrayList<ElementNode.Description>();
            for (Map.Entry entry : map.entrySet()) {
                arrayList.add(ElementNode.Description.create((Element)entry.getKey(), (List)entry.getValue(), false, false));
            }
            if (!arrayList.isEmpty()) {
                ret.add(new ImplementOverrideMethodGenerator(ElementNode.Description.create(arrayList), false));
            }
            return ret;
        }
    }
}

