/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.imports;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.Tree;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.UiUtils;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.editor.overridden.PopupUtil;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportClassPanel
extends JPanel {
    private JavaSource javaSource;
    private DefaultListModel model;
    public JLabel jLabel1;
    public JList jList1;
    public JScrollPane jScrollPane1;

    public ImportClassPanel(List<TypeElement> priviledged, List<TypeElement> denied, Font font, JavaSource javaSource) {
        this.javaSource = javaSource;
        this.createModel(priviledged, denied);
        this.initComponents();
        this.setBackground(this.jList1.getBackground());
        if (this.model.size() > 0) {
            int modelSize;
            this.jList1.setModel(this.model);
            this.setFocusable(false);
            this.setNextFocusableComponent(this.jList1);
            this.jScrollPane1.setBackground(this.jList1.getBackground());
            this.setBackground(this.jList1.getBackground());
            if (font != null) {
                this.jList1.setFont(font);
            }
            if ((modelSize = this.jList1.getModel().getSize()) > 0) {
                this.jList1.setSelectedIndex(0);
            }
            this.jList1.setVisibleRowCount(modelSize > 8 ? 8 : modelSize);
            this.jList1.setCellRenderer(new Renderer(this.jList1));
            this.jList1.grabFocus();
        } else {
            this.remove(this.jScrollPane1);
            JLabel nothingFoundJL = new JLabel("<No Classes Found>");
            if (font != null) {
                nothingFoundJL.setFont(font);
            }
            nothingFoundJL.setBorder(BorderFactory.createEmptyBorder(2, 4, 4, 4));
            nothingFoundJL.setEnabled(false);
            nothingFoundJL.setBackground(this.jList1.getBackground());
            this.add(nothingFoundJL);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jLabel1 = new JLabel();
        this.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder(2, 4, 4, 4));
        this.jList1.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                ImportClassPanel.this.listKeyReleased(evt);
            }
        });
        this.jList1.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                ImportClassPanel.this.listMouseReleased(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        this.add((Component)this.jScrollPane1, "Center");
        this.jLabel1.setText("Type to import:");
        this.jLabel1.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.jLabel1.setOpaque(true);
        this.add((Component)this.jLabel1, "First");
    }

    private void listMouseReleased(MouseEvent evt) {
        this.importClass(this.getSelected());
    }

    private void listKeyReleased(KeyEvent evt) {
        KeyStroke ks = KeyStroke.getKeyStrokeForEvent(evt);
        if (ks.getKeyCode() == 10 || ks.getKeyCode() == 32) {
            this.importClass(this.getSelected());
        }
    }

    public String getSelected() {
        TypeDescription typeDescription = (TypeDescription)this.jList1.getSelectedValue();
        return typeDescription == null ? null : typeDescription.qualifiedName;
    }

    private void createModel(List<TypeElement> priviledged, List<TypeElement> denied) {
        ArrayList<TypeDescription> l = new ArrayList<TypeDescription>(priviledged.size());
        for (TypeElement typeElement : priviledged) {
            l.add(new TypeDescription(typeElement, false));
        }
        ArrayList ld = new ArrayList(priviledged.size());
        for (TypeElement typeElement : denied) {
            l.add(new TypeDescription(typeElement, true));
        }
        Collections.sort(l);
        this.model = new DefaultListModel();
        for (TypeDescription td : l) {
            this.model.addElement(td);
        }
    }

    private void importClass(final String fqn) {
        PopupUtil.hidePopup();
        if (fqn != null) {
            CancellableTask<WorkingCopy> task = new CancellableTask<WorkingCopy>(){

                public void run(WorkingCopy wc) throws IOException {
                    wc.toPhase(JavaSource.Phase.RESOLVED);
                    TreeMaker make = wc.getTreeMaker();
                    CompilationUnitTree cut = wc.getCompilationUnit();
                    ArrayList<? extends ImportTree> imports = new ArrayList<ImportTree>(cut.getImports());
                    ImportTree njuImport = make.Import((Tree)make.Identifier((CharSequence)fqn), false);
                    ListIterator<ImportTree> it = imports.listIterator();
                    while (it.hasNext()) {
                        ImportTree item = (ImportTree)it.next();
                        if (!item.isStatic() && item.getQualifiedIdentifier().toString().compareTo(fqn) <= 0) continue;
                        it.set(njuImport);
                        it.add(item);
                        break;
                    }
                    CompilationUnitTree cutCopy = imports.contains(njuImport) ? make.CompilationUnit(cut.getPackageName(), imports, cut.getTypeDecls(), cut.getSourceFile()) : make.addCompUnitImport(cut, njuImport);
                    wc.rewrite((Tree)cut, (Tree)cutCopy);
                }

                public void cancel() {
                }
            };
            try {
                this.javaSource.runModificationTask((CancellableTask)task).commit();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
    }

    private static class Renderer
    extends DefaultListCellRenderer {
        private static int DARKER_COLOR_COMPONENT;
        private static int LIGHTER_COLOR_COMPONENT;
        private Color denidedColor = new Color(128, 128, 128);
        private Color fgColor;
        private Color bgColor;
        private Color bgColorDarker;
        private Color bgSelectionColor;
        private Color fgSelectionColor;

        public Renderer(JList list) {
            this.setFont(list.getFont());
            this.fgColor = list.getForeground();
            this.bgColor = list.getBackground();
            this.bgColorDarker = new Color(Math.abs(this.bgColor.getRed() - DARKER_COLOR_COMPONENT), Math.abs(this.bgColor.getGreen() - DARKER_COLOR_COMPONENT), Math.abs(this.bgColor.getBlue() - DARKER_COLOR_COMPONENT));
            this.bgSelectionColor = list.getSelectionBackground();
            this.fgSelectionColor = list.getSelectionForeground();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            if (isSelected) {
                this.setForeground(this.fgSelectionColor);
                this.setBackground(this.bgSelectionColor);
            } else {
                this.setForeground(this.fgColor);
                this.setBackground(index % 2 == 0 ? this.bgColor : this.bgColorDarker);
            }
            if (value instanceof TypeDescription) {
                TypeDescription td = (TypeDescription)value;
                this.setText(td.qualifiedName);
                if (td.isDenied) {
                    this.setForeground(this.denidedColor);
                }
                this.setIcon(UiUtils.getElementIcon((ElementKind)td.kind, null));
            } else {
                this.setText(value.toString());
            }
            return this;
        }

        static {
            LIGHTER_COLOR_COMPONENT = DARKER_COLOR_COMPONENT = 5;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeDescription
    implements Comparable<TypeDescription> {
        private boolean isDenied;
        private final ElementKind kind;
        private final String qualifiedName;

        public TypeDescription(TypeElement typeElement, boolean isDenied) {
            this.isDenied = isDenied;
            this.kind = typeElement.getKind();
            this.qualifiedName = typeElement.getQualifiedName().toString();
        }

        @Override
        public int compareTo(TypeDescription o) {
            if (this.isDenied && !o.isDenied) {
                return 1;
            }
            if (!this.isDenied && o.isDenied) {
                return -1;
            }
            return this.qualifiedName.compareTo(o.qualifiedName);
        }
    }
}

