/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.options;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.java.editor.options.CodeFoldingEditor;
import org.openide.util.NbBundle;

public class CodeFoldingEditorPanel
extends JPanel {
    CodeFoldingEditor foldingEditor;
    private JCheckBox enableFoldingCB;
    private JCheckBox importCB;
    private JCheckBox initialCommentCB;
    private JCheckBox innerCB;
    private JLabel jLabel1;
    private JCheckBox javadocCB;
    private JCheckBox methodCB;

    public CodeFoldingEditorPanel(CodeFoldingEditor foldingEditor) {
        this.foldingEditor = foldingEditor;
        this.initComponents();
        this.initAccessibility();
    }

    private void initAccessibility() {
        this.enableFoldingCB.setMnemonic(this.getBundleString("CFEP_UseCF_Mnemonic").charAt(0));
        this.methodCB.setMnemonic(this.getBundleString("CFEP_Method_Mnemonic").charAt(0));
        this.innerCB.setMnemonic(this.getBundleString("CFEP_InnerClass_Mnemonic").charAt(0));
        this.importCB.setMnemonic(this.getBundleString("CFEP_Import_Mnemonic").charAt(0));
        this.javadocCB.setMnemonic(this.getBundleString("CFEP_Javadoc_Mnemonic").charAt(0));
        this.initialCommentCB.setMnemonic(this.getBundleString("CFEP_InitialComment_Mnemonic").charAt(0));
    }

    private void initComponents() {
        this.enableFoldingCB = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.methodCB = new JCheckBox();
        this.innerCB = new JCheckBox();
        this.importCB = new JCheckBox();
        this.javadocCB = new JCheckBox();
        this.initialCommentCB = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.enableFoldingCB.setText(this.getBundleString("CFEP_UseCF"));
        this.enableFoldingCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                CodeFoldingEditorPanel.this.checkBoxChange(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 12, 0);
        this.add((Component)this.enableFoldingCB, gridBagConstraints);
        this.jLabel1.setText(this.getBundleString("CFEP_CollapsedByDefault"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 11);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.methodCB.setText(this.getBundleString("CFEP_Method"));
        this.methodCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                CodeFoldingEditorPanel.this.methodCBItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 24, 0, 0);
        this.add((Component)this.methodCB, gridBagConstraints);
        this.innerCB.setText(this.getBundleString("CFEP_InnerClass"));
        this.innerCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                CodeFoldingEditorPanel.this.innerCBItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 24, 0, 0);
        this.add((Component)this.innerCB, gridBagConstraints);
        this.importCB.setText(this.getBundleString("CFEP_Import"));
        this.importCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                CodeFoldingEditorPanel.this.importCBItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 24, 0, 0);
        this.add((Component)this.importCB, gridBagConstraints);
        this.javadocCB.setText(this.getBundleString("CFEP_Javadoc"));
        this.javadocCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                CodeFoldingEditorPanel.this.javadocCBItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(0, 24, 0, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.javadocCB, gridBagConstraints);
        this.initialCommentCB.setText(this.getBundleString("CFEP_InitialComment"));
        this.initialCommentCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                CodeFoldingEditorPanel.this.initialCommentCBItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(0, 24, 0, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.initialCommentCB, gridBagConstraints);
    }

    private void initialCommentCBItemStateChanged(ItemEvent evt) {
        this.notifyEditor();
    }

    private void javadocCBItemStateChanged(ItemEvent evt) {
        this.notifyEditor();
    }

    private void importCBItemStateChanged(ItemEvent evt) {
        this.notifyEditor();
    }

    private void innerCBItemStateChanged(ItemEvent evt) {
        this.notifyEditor();
    }

    private void methodCBItemStateChanged(ItemEvent evt) {
        this.notifyEditor();
    }

    private void checkBoxChange(ItemEvent evt) {
        this.setCBoxesEnabled(evt.getStateChange() == 1);
        this.notifyEditor();
    }

    private void notifyEditor() {
        if (this.foldingEditor != null) {
            this.foldingEditor.customEditorChange();
        }
    }

    private void setCBoxesEnabled(boolean selected) {
        this.methodCB.setEnabled(selected);
        this.innerCB.setEnabled(selected);
        this.importCB.setEnabled(selected);
        this.javadocCB.setEnabled(selected);
        this.initialCommentCB.setEnabled(selected);
    }

    public void setValue(Map m) {
        Boolean val = (Boolean)m.get("code-folding-enable");
        if (!val.booleanValue()) {
            this.setCBoxesEnabled(false);
        }
        this.enableFoldingCB.setSelected(val);
        val = (Boolean)m.get("code-folding-collapse-method");
        this.methodCB.setSelected(val);
        val = (Boolean)m.get("code-folding-collapse-innerclass");
        this.innerCB.setSelected(val);
        val = (Boolean)m.get("code-folding-collapse-import");
        this.importCB.setSelected(val);
        val = (Boolean)m.get("code-folding-collapse-javadoc");
        this.javadocCB.setSelected(val);
        val = (Boolean)m.get("code-folding-collapse-initial-comment");
        this.initialCommentCB.setSelected(val);
    }

    public Map getValue() {
        HashMap<String, Boolean> ret = new HashMap<String, Boolean>(10);
        ret.put("code-folding-enable", this.enableFoldingCB.isSelected());
        ret.put("code-folding-collapse-method", this.methodCB.isSelected());
        ret.put("code-folding-collapse-innerclass", this.innerCB.isSelected());
        ret.put("code-folding-collapse-import", this.importCB.isSelected());
        ret.put("code-folding-collapse-javadoc", this.javadocCB.isSelected());
        ret.put("code-folding-collapse-initial-comment", this.initialCommentCB.isSelected());
        return ret;
    }

    private String getBundleString(String s) {
        return NbBundle.getMessage(CodeFoldingEditorPanel.class, (String)s);
    }
}

