/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.overridden;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.Annotations;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ImplementationProvider;
import org.netbeans.editor.JumpList;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.java.editor.overridden.AnnotationsHolder;
import org.netbeans.modules.java.editor.overridden.IsOverriddenAnnotation;
import org.netbeans.modules.java.editor.overridden.IsOverriddenAnnotationHandler;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

public final class IsOverriddenAnnotationAction
extends AbstractAction {
    public IsOverriddenAnnotationAction() {
        this.setEnabled(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.invokeDefaultAction((JTextComponent)e.getSource())) {
            Action a;
            int nextAction;
            Action[] actions = ImplementationProvider.getDefault().getGlyphGutterActions((JTextComponent)e.getSource());
            if (actions == null) {
                return;
            }
            for (nextAction = 0; nextAction < actions.length && actions[nextAction] != this; ++nextAction) {
            }
            if (actions.length > ++nextAction && (a = actions[nextAction]) != null && a.isEnabled()) {
                a.actionPerformed(e);
            }
        }
    }

    private FileObject getFile(JTextComponent component) {
        Document doc = component.getDocument();
        DataObject od = (DataObject)doc.getProperty("stream");
        if (od == null) {
            return null;
        }
        return od.getPrimaryFile();
    }

    private IsOverriddenAnnotation findAnnotation(JTextComponent component, AnnotationDesc desc, int offset) {
        FileObject file = this.getFile(component);
        if (file == null) {
            if (ErrorManager.getDefault().isLoggable(16)) {
                ErrorManager.getDefault().log(16, "component=" + component + " does not have a file specified in the document.");
            }
            return null;
        }
        AnnotationsHolder ah = AnnotationsHolder.get(file);
        if (ah == null) {
            IsOverriddenAnnotationHandler.LOG.log(Level.INFO, "component=" + component + " does not have attached a IsOverriddenAnnotationHandler");
            return null;
        }
        for (IsOverriddenAnnotation a : ah.getAnnotations()) {
            if (a.getPosition().getOffset() != offset || !desc.getShortDescription().equals(a.getShortDescription())) continue;
            return a;
        }
        return null;
    }

    boolean invokeDefaultAction(final JTextComponent comp) {
        final Document doc = comp.getDocument();
        if (doc instanceof BaseDocument) {
            final int currentPosition = comp.getCaretPosition();
            final Annotations annotations = ((BaseDocument)doc).getAnnotations();
            final IsOverriddenAnnotation[] annotation = new IsOverriddenAnnotation[1];
            final Point[] p = new Point[1];
            doc.render(new Runnable(){

                public void run() {
                    try {
                        int line = Utilities.getLineOffset((BaseDocument)((BaseDocument)doc), (int)currentPosition);
                        int startOffset = Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)doc), (int)line);
                        AnnotationDesc desc = annotations.getActiveAnnotation(line);
                        p[0] = comp.modelToView(startOffset).getLocation();
                        annotation[0] = IsOverriddenAnnotationAction.this.findAnnotation(comp, desc, startOffset);
                    }
                    catch (BadLocationException ex) {
                        ErrorManager.getDefault().notify((Throwable)ex);
                    }
                }
            });
            if (annotation[0] == null) {
                return false;
            }
            JumpList.checkAddEntry((JTextComponent)comp, (int)currentPosition);
            annotation[0].mouseClicked(comp, p[0]);
            return true;
        }
        return false;
    }
}

