/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.overridden;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.timers.TimesCollector;
import org.netbeans.modules.java.editor.overridden.AnnotationType;
import org.netbeans.modules.java.editor.overridden.AnnotationsHolder;
import org.netbeans.modules.java.editor.overridden.ElementDescription;
import org.netbeans.modules.java.editor.overridden.IsOverriddenAnnotation;
import org.netbeans.modules.java.editor.overridden.IsOverriddenVisitor;
import org.netbeans.modules.java.editor.overridden.ReverseSourceRootsLookup;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.NbDocument;
import org.openide.util.RequestProcessor;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsOverriddenAnnotationHandler
implements CancellableTask<CompilationInfo> {
    private static final boolean enableReverseLookups = Boolean.getBoolean("org.netbeans.java.editor.enableReverseLookups");
    static final Logger LOG = Logger.getLogger(IsOverriddenAnnotationHandler.class.getName());
    private FileObject file;
    private IsOverriddenVisitor visitor;
    private static final ClassPath EMPTY = ClassPathSupport.createClassPath((URL[])new URL[0]);
    private boolean canceled;

    IsOverriddenAnnotationHandler(FileObject file) {
        this.file = file;
        TimesCollector.getDefault().reportReference(file, IsOverriddenAnnotationHandler.class.getName(), "[M] IsOverriddenAnnotationHandler", (Object)this);
    }

    public StyledDocument getDocument() {
        try {
            DataObject d = DataObject.find((FileObject)this.file);
            EditorCookie ec = (EditorCookie)d.getCookie(EditorCookie.class);
            if (ec == null) {
                return null;
            }
            return ec.getDocument();
        }
        catch (IOException e) {
            LOG.log(Level.INFO, "Cannot find DataObject for file: " + FileUtil.getFileDisplayName((FileObject)this.file), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(CompilationInfo info) {
        this.resume();
        StyledDocument doc = this.getDocument();
        if (doc == null) {
            LOG.log(Level.INFO, "Cannot get document!");
            return;
        }
        long startTime = System.currentTimeMillis();
        try {
            List<IsOverriddenAnnotation> annotations = this.process(info, doc);
            if (annotations == null) {
                return;
            }
            this.newAnnotations(annotations);
        }
        finally {
            IsOverriddenAnnotationHandler isOverriddenAnnotationHandler = this;
            synchronized (isOverriddenAnnotationHandler) {
                this.visitor = null;
            }
            TimesCollector.getDefault().reportTime(this.file, "is-overridden", "Overridden in", System.currentTimeMillis() - startTime);
        }
    }

    private FileObject findSourceRoot() {
        ClassPath cp = ClassPath.getClassPath((FileObject)this.file, (String)"classpath/source");
        if (cp != null) {
            for (FileObject root : cp.getRoots()) {
                if (!FileUtil.isParentOf((FileObject)root, (FileObject)this.file)) continue;
                return root;
            }
        }
        return null;
    }

    private synchronized Set<FileObject> findReverseSourceRoots(final FileObject thisSourceRoot, final FileObject thisFile) {
        final Object o = new Object();
        final HashSet<FileObject> reverseSourceRoots = new HashSet<FileObject>();
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                long startTime = System.currentTimeMillis();
                HashSet<FileObject> reverseSourceRootsInt = new HashSet<FileObject>(ReverseSourceRootsLookup.reverseSourceRootsLookup(thisSourceRoot));
                long endTime = System.currentTimeMillis();
                TimesCollector.getDefault().reportTime(thisFile, "findReverseSourceRoots", "Find Reverse Source Roots", endTime - startTime);
                Object object = o;
                synchronized (object) {
                    reverseSourceRoots.addAll(reverseSourceRootsInt);
                }
                IsOverriddenAnnotationHandler.this.wakeUp();
            }
        });
        try {
            this.wait();
        }
        catch (InterruptedException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        return reverseSourceRoots;
    }

    public static AnnotationType detectOverrides(CompilationInfo info, TypeElement type, ExecutableElement ee, List<ElementDescription> result) {
        HashMap<Name, List<ExecutableElement>> name2Method = new HashMap<Name, List<ExecutableElement>>();
        IsOverriddenAnnotationHandler.sortOutMethods(info, name2Method, type, false);
        List lee = (List)name2Method.get(ee.getSimpleName());
        if (lee == null || lee.isEmpty()) {
            return null;
        }
        HashSet<ExecutableElement> seenMethods = new HashSet<ExecutableElement>();
        for (ExecutableElement overridee : lee) {
            if (!info.getElements().overrides(ee, overridee, SourceUtils.getEnclosingTypeElement((Element)ee)) || !seenMethods.add(overridee)) continue;
            result.add(new ElementDescription(info, overridee));
        }
        if (!result.isEmpty()) {
            for (ElementDescription ed : result) {
                if (ed.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
                return AnnotationType.OVERRIDES;
            }
            return AnnotationType.IMPLEMENTS;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<IsOverriddenAnnotation> process(CompilationInfo info, StyledDocument doc) {
        Set<FileObject> reverseSourceRoots;
        IsOverriddenVisitor v;
        IsOverriddenAnnotationHandler isOverriddenAnnotationHandler = this;
        synchronized (isOverriddenAnnotationHandler) {
            if (this.isCanceled()) {
                return null;
            }
            v = this.visitor = new IsOverriddenVisitor(doc, info);
        }
        CompilationUnitTree unit = info.getCompilationUnit();
        long startTime1 = System.currentTimeMillis();
        v.scan(unit, null);
        long endTime1 = System.currentTimeMillis();
        TimesCollector.getDefault().reportTime(this.file, "overridden-scanner", "Overridden Scanner", endTime1 - startTime1);
        if (enableReverseLookups) {
            FileObject thisSourceRoot = this.findSourceRoot();
            if (thisSourceRoot == null) {
                return null;
            }
            reverseSourceRoots = this.findReverseSourceRoots(thisSourceRoot, info.getFileObject());
            reverseSourceRoots.add(thisSourceRoot);
        } else {
            reverseSourceRoots = null;
        }
        LOG.log(Level.FINE, "reverseSourceRoots: {0}", reverseSourceRoots);
        ArrayList<IsOverriddenAnnotation> annotations = new ArrayList<IsOverriddenAnnotation>();
        for (ElementHandle<TypeElement> td : v.type2Declaration.keySet()) {
            Tree t;
            if (this.isCanceled()) {
                return null;
            }
            LOG.log(Level.FINE, "type: {0}", td.getQualifiedName());
            HashMap<Name, List<ExecutableElement>> name2Method = new HashMap<Name, List<ExecutableElement>>();
            TypeElement resolvedType = (TypeElement)td.resolve(info);
            if (resolvedType == null) continue;
            IsOverriddenAnnotationHandler.sortOutMethods(info, name2Method, resolvedType, false);
            for (ElementHandle<ExecutableElement> methodHandle : v.type2Declaration.get(td)) {
                int position;
                Position pos;
                List lee;
                if (this.isCanceled()) {
                    return null;
                }
                ExecutableElement ee = (ExecutableElement)methodHandle.resolve(info);
                if (ee == null) continue;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "method: {0}", ee.toString());
                }
                if ((lee = (List)name2Method.get(ee.getSimpleName())) == null || lee.isEmpty()) continue;
                HashSet<ExecutableElement> seenMethods = new HashSet<ExecutableElement>();
                ArrayList<ElementDescription> overrides = new ArrayList<ElementDescription>();
                for (ExecutableElement overridee : lee) {
                    if (!info.getElements().overrides(ee, overridee, SourceUtils.getEnclosingTypeElement((Element)ee)) || !seenMethods.add(overridee)) continue;
                    overrides.add(new ElementDescription(info, overridee));
                }
                if (overrides.isEmpty() || (pos = IsOverriddenAnnotationHandler.getPosition(doc, position = (int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), v.declaration2Tree.get(methodHandle)))) == null) continue;
                StringBuffer tooltip = new StringBuffer();
                boolean wasOverrides = false;
                boolean newline = false;
                for (ElementDescription ed : overrides) {
                    if (newline) {
                        tooltip.append("\n");
                    }
                    newline = true;
                    if (ed.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                        tooltip.append("Implements: " + ed.getDisplayName());
                        continue;
                    }
                    tooltip.append("Overrides: " + ed.getDisplayName());
                    wasOverrides = true;
                }
                annotations.add(new IsOverriddenAnnotation(doc, pos, wasOverrides ? AnnotationType.OVERRIDES : AnnotationType.IMPLEMENTS, tooltip.toString(), overrides));
            }
            if (!enableReverseLookups) continue;
            String typeOverridden = null;
            AnnotationType typeType = null;
            TypeElement resolved = (TypeElement)td.resolve(info);
            if (resolved == null) {
                Logger.getLogger("global").log(Level.SEVERE, "IsOverriddenAnnotationHandler: resolved == null!");
                continue;
            }
            if (resolved.getKind().isInterface()) {
                typeOverridden = "Has Implementations";
                typeType = AnnotationType.HAS_IMPLEMENTATION;
            }
            if (resolved.getKind().isClass()) {
                typeOverridden = "Is Overridden:";
                typeType = AnnotationType.IS_OVERRIDDEN;
            }
            HashMap<ElementHandle<ExecutableElement>, List<ElementDescription>> overriding = new HashMap<ElementHandle<ExecutableElement>, List<ElementDescription>>();
            ArrayList<ElementDescription> overridingClasses = new ArrayList<ElementDescription>();
            long startTime = System.currentTimeMillis();
            long[] classIndexTime = new long[1];
            Map<FileObject, Set<ElementHandle<TypeElement>>> users = this.computeUsers(reverseSourceRoots, (ElementHandle<TypeElement>)ElementHandle.create((Element)resolved), classIndexTime);
            long endTime = System.currentTimeMillis();
            if (users == null) {
                return null;
            }
            TimesCollector.getDefault().reportTime(this.file, "overridden-users-classindex", "Overridden Users Class Index", classIndexTime[0]);
            TimesCollector.getDefault().reportTime(this.file, "overridden-users", "Overridden Users", endTime - startTime);
            for (Map.Entry<FileObject, Set<ElementHandle<TypeElement>>> data : users.entrySet()) {
                if (this.isCanceled()) {
                    return null;
                }
                this.findOverriddenAnnotations(data.getKey(), data.getValue(), td, v.type2Declaration.get(td), overriding, overridingClasses);
            }
            if (!overridingClasses.isEmpty() && (t = (Tree)v.declaration2Class.get(td)) != null) {
                Position pos = IsOverriddenAnnotationHandler.getPosition(doc, (int)info.getTrees().getSourcePositions().getStartPosition(unit, t));
                if (pos == null) continue;
                annotations.add(new IsOverriddenAnnotation(doc, pos, typeType, typeOverridden.toString(), overridingClasses));
            }
            for (ElementHandle original : overriding.keySet()) {
                if (this.isCanceled()) {
                    return null;
                }
                Position pos = IsOverriddenAnnotationHandler.getPosition(doc, (int)info.getTrees().getSourcePositions().getStartPosition(unit, v.declaration2Tree.get(original)));
                if (pos == null) continue;
                Set<Modifier> mods = ((ExecutableElement)original.resolve(info)).getModifiers();
                String tooltip = null;
                tooltip = mods.contains((Object)Modifier.ABSTRACT) ? "Has Implementations" : "Is Overridden";
                IsOverriddenAnnotation ann = new IsOverriddenAnnotation(doc, pos, mods.contains((Object)Modifier.ABSTRACT) ? AnnotationType.HAS_IMPLEMENTATION : AnnotationType.IS_OVERRIDDEN, tooltip, (List)overriding.get(original));
                annotations.add(ann);
            }
        }
        if (this.isCanceled()) {
            return null;
        }
        return annotations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ElementHandle<TypeElement>> computeUsers(FileObject source, Set<ElementHandle<TypeElement>> base, long[] classIndexCumulative) {
        ClasspathInfo cpinfo = ClasspathInfo.create((ClassPath)EMPTY, (ClassPath)EMPTY, (ClassPath)ClassPathSupport.createClassPath((FileObject[])new FileObject[]{source}));
        long startTime = System.currentTimeMillis();
        try {
            LinkedList<ElementHandle<TypeElement>> l = new LinkedList<ElementHandle<TypeElement>>(base);
            HashSet<ElementHandle<TypeElement>> result = new HashSet<ElementHandle<TypeElement>>();
            while (!l.isEmpty()) {
                ElementHandle eh = (ElementHandle)l.remove(0);
                result.add(eh);
                l.addAll(cpinfo.getClassIndex().getElements(eh, Collections.singleton(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
            }
            HashSet<ElementHandle<TypeElement>> hashSet = result;
            return hashSet;
        }
        finally {
            classIndexCumulative[0] = classIndexCumulative[0] + (System.currentTimeMillis() - startTime);
        }
    }

    private Map<FileObject, Set<ElementHandle<TypeElement>>> computeUsers(Set<FileObject> sources, ElementHandle<TypeElement> base, long[] classIndexCumulative) {
        HashMap edges = new HashMap();
        HashMap dependsOn = new HashMap();
        for (FileObject source : sources) {
            edges.put(source, new ArrayList());
        }
        for (FileObject source : sources) {
            ArrayList<FileObject> deps = new ArrayList<FileObject>();
            dependsOn.put(source, deps);
            for (ClassPath.Entry entry : ClassPath.getClassPath((FileObject)source, (String)"classpath/compile").entries()) {
                for (FileObject s : SourceForBinaryQuery.findSourceRoots((URL)entry.getURL()).getRoots()) {
                    Collection targets = (Collection)edges.get(s);
                    if (targets != null) {
                        targets.add(source);
                    }
                    deps.add(s);
                }
            }
        }
        ArrayList<FileObject> sourceRoots = new ArrayList<FileObject>(sources);
        try {
            Utilities.topologicalSort(sourceRoots, edges);
        }
        catch (TopologicalSortException ex) {
            LOG.log(Level.WARNING, "internal error", ex);
            return null;
        }
        HashMap<FileObject, Set<ElementHandle<TypeElement>>> result = new HashMap<FileObject, Set<ElementHandle<TypeElement>>>();
        for (FileObject file : sourceRoots) {
            HashSet<ElementHandle<TypeElement>> baseTypes = new HashSet<ElementHandle<TypeElement>>();
            baseTypes.add(base);
            for (FileObject dep : (Collection)dependsOn.get(file)) {
                Set depTypes = (Set)result.get(dep);
                if (depTypes == null) continue;
                baseTypes.addAll(depTypes);
            }
            Set<ElementHandle<TypeElement>> types = this.computeUsers(file, baseTypes, classIndexCumulative);
            types.removeAll(baseTypes);
            result.put(file, types);
        }
        return result;
    }

    private void findOverriddenAnnotations(FileObject sourceRoot, final Set<ElementHandle<TypeElement>> users, final ElementHandle<TypeElement> originalType, final List<ElementHandle<ExecutableElement>> methods, final Map<ElementHandle<ExecutableElement>, List<ElementDescription>> overriding, final List<ElementDescription> overridingClasses) {
        ClasspathInfo cpinfo = ClasspathInfo.create((FileObject)sourceRoot);
        if (!users.isEmpty()) {
            JavaSource js = JavaSource.create((ClasspathInfo)cpinfo, (FileObject[])new FileObject[0]);
            try {
                js.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                    public void cancel() {
                        this.cancel();
                    }

                    public void run(CompilationController controller) throws Exception {
                        HashSet<Element> seenElements = new HashSet<Element>();
                        for (ElementHandle typeHandle : users) {
                            if (IsOverriddenAnnotationHandler.this.isCanceled()) {
                                return;
                            }
                            TypeElement type = (TypeElement)typeHandle.resolve((CompilationInfo)controller);
                            Element resolvedOriginalType = originalType.resolve((CompilationInfo)controller);
                            if (!seenElements.add(resolvedOriginalType) || !controller.getTypes().isSubtype(type.asType(), resolvedOriginalType.asType())) continue;
                            overridingClasses.add(new ElementDescription((CompilationInfo)controller, type));
                            for (ElementHandle originalMethodHandle : methods) {
                                ExecutableElement originalMethod = (ExecutableElement)originalMethodHandle.resolve((CompilationInfo)controller);
                                if (originalMethod != null) {
                                    ExecutableElement overrider = IsOverriddenAnnotationHandler.this.getImplementationOf((CompilationInfo)controller, originalMethod, type);
                                    if (overrider == null) continue;
                                    ArrayList<ElementDescription> overriddingMethods = (ArrayList<ElementDescription>)overriding.get(originalMethodHandle);
                                    if (overriddingMethods == null) {
                                        overriddingMethods = new ArrayList<ElementDescription>();
                                        overriding.put(originalMethodHandle, overriddingMethods);
                                    }
                                    overriddingMethods.add(new ElementDescription((CompilationInfo)controller, overrider));
                                    continue;
                                }
                                Logger.getLogger("global").log(Level.SEVERE, "IsOverriddenAnnotationHandler: originalMethod == null!");
                            }
                        }
                    }
                }, true);
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    private ExecutableElement getImplementationOf(CompilationInfo info, ExecutableElement overridee, TypeElement implementor) {
        for (ExecutableElement overrider : ElementFilter.methodsIn(implementor.getEnclosedElements())) {
            if (!info.getElements().overrides(overrider, overridee, implementor)) continue;
            return overrider;
        }
        return null;
    }

    public synchronized void cancel() {
        this.canceled = true;
        if (this.visitor != null) {
            this.visitor.cancel();
        }
        this.wakeUp();
    }

    private synchronized void resume() {
        this.canceled = false;
    }

    private synchronized void wakeUp() {
        this.notifyAll();
    }

    private synchronized boolean isCanceled() {
        return this.canceled;
    }

    private void newAnnotations(List<IsOverriddenAnnotation> as) {
        AnnotationsHolder a = AnnotationsHolder.get(this.file);
        if (a != null) {
            a.setNewAnnotations(as);
        }
    }

    private static void sortOutMethods(CompilationInfo info, Map<Name, List<ExecutableElement>> where, Element td, boolean current) {
        if (current) {
            HashMap<Name, ArrayList<ExecutableElement>> newlyAdded = new HashMap<Name, ArrayList<ExecutableElement>>();
            block0: for (ExecutableElement executableElement : ElementFilter.methodsIn(td.getEnclosedElements())) {
                ArrayList<ExecutableElement> lee;
                Name name = executableElement.getSimpleName();
                List<ExecutableElement> alreadySeen = where.get(name);
                if (alreadySeen != null) {
                    for (ExecutableElement seen : alreadySeen) {
                        if (!info.getElements().overrides(seen, executableElement, (TypeElement)seen.getEnclosingElement())) continue;
                        continue block0;
                    }
                }
                if ((lee = (ArrayList<ExecutableElement>)newlyAdded.get(name)) == null) {
                    lee = new ArrayList<ExecutableElement>();
                    newlyAdded.put(name, lee);
                }
                lee.add(executableElement);
            }
            for (Map.Entry entry : newlyAdded.entrySet()) {
                List<ExecutableElement> lee = where.get(entry.getKey());
                if (lee == null) {
                    where.put((Name)entry.getKey(), (List<ExecutableElement>)entry.getValue());
                    continue;
                }
                lee.addAll((Collection)entry.getValue());
            }
        }
        for (TypeMirror typeMirror : info.getTypes().directSupertypes(td.asType())) {
            if (typeMirror.getKind() != TypeKind.DECLARED) continue;
            IsOverriddenAnnotationHandler.sortOutMethods(info, where, ((DeclaredType)typeMirror).asElement(), true);
        }
    }

    private static Position getPosition(final StyledDocument doc, final int offset) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Impl
        implements Runnable {
            private Position pos;

            Impl() {
            }

            @Override
            public void run() {
                if (offset < 0 || offset >= doc.getLength()) {
                    return;
                }
                try {
                    this.pos = doc.createPosition(offset - NbDocument.findLineColumn((StyledDocument)doc, (int)offset));
                }
                catch (BadLocationException ex) {
                    LOG.log(Level.FINE, null, ex);
                }
            }
        }
        Impl i = new Impl();
        doc.render(i);
        return i.pos;
    }
}

