/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.rename;

import com.sun.source.util.TreePath;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.util.ElementFilter;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.highlights.spi.Highlight;
import org.netbeans.modules.java.editor.rename.InstantRenamePerformer;
import org.netbeans.modules.java.editor.semantic.ColoringAttributes;
import org.netbeans.modules.java.editor.semantic.FindLocalUsagesQuery;
import org.netbeans.modules.refactoring.api.ui.RefactoringActionsFactory;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstantRenameAction
extends BaseAction {
    private static final Set<ElementKind> LOCAL_CLASS_PARENTS = EnumSet.of(ElementKind.CONSTRUCTOR, ElementKind.INSTANCE_INIT, ElementKind.METHOD, ElementKind.STATIC_INIT);

    public InstantRenameAction() {
        super("in-place-refactoring", 14);
    }

    public void actionPerformed(ActionEvent evt, JTextComponent target) {
        try {
            final int caret = target.getCaretPosition();
            String ident = Utilities.getIdentifier((BaseDocument)Utilities.getDocument((JTextComponent)target), (int)caret);
            if (ident == null) {
                Utilities.setStatusBoldText((JTextComponent)target, (String)"Cannot perform instant rename here.");
                return;
            }
            DataObject od = (DataObject)target.getDocument().getProperty("stream");
            JavaSource js = JavaSource.forFileObject((FileObject)od.getPrimaryFile());
            final boolean[] wasResolved = new boolean[1];
            final Set[] changePoints = new Set[1];
            js.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController controller) throws Exception {
                    if (controller.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        return;
                    }
                    changePoints[0] = InstantRenameAction.computeChangePoints((CompilationInfo)controller, caret, wasResolved);
                }
            }, true);
            if (wasResolved[0]) {
                if (changePoints[0] != null) {
                    this.doInstantRename(changePoints[0], target, caret, ident);
                } else {
                    this.doFullRename((EditorCookie)od.getCookie(EditorCookie.class), od.getNodeDelegate());
                }
            } else {
                Utilities.setStatusBoldText((JTextComponent)target, (String)"Cannot perform instant rename here.");
            }
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
        }
    }

    protected Class getShortDescriptionBundleClass() {
        return InstantRenameAction.class;
    }

    private void doInstantRename(Set<Highlight> changePoints, JTextComponent target, int caret, String ident) throws BadLocationException {
        InstantRenamePerformer.performInstantRename(target, changePoints, caret);
    }

    private void doFullRename(EditorCookie ec, Node n) {
        InstanceContent ic = new InstanceContent();
        ic.add((Object)ec);
        ic.add((Object)n);
        AbstractLookup actionContext = new AbstractLookup((AbstractLookup.Content)ic);
        Action a = RefactoringActionsFactory.renameAction().createContextAwareInstance((Lookup)actionContext);
        a.actionPerformed(RefactoringActionsFactory.DEFAULT_EVENT);
    }

    static Set<Highlight> computeChangePoints(CompilationInfo info, final int caret, final boolean[] wasResolved) throws IOException {
        TreePath path = info.getTreeUtilities().pathFor(caret);
        Element el = info.getTrees().getElement(path);
        if (el == null) {
            wasResolved[0] = false;
            return null;
        }
        final Highlight name = org.netbeans.modules.java.editor.semantic.Utilities.createHighlight(info.getCompilationUnit(), info.getTrees().getSourcePositions(), info.getDocument(), path, EnumSet.of(ColoringAttributes.MARK_OCCURRENCES), null);
        info.getDocument().render(new Runnable(){

            public void run() {
                wasResolved[0] = name.getStart() <= caret && caret <= name.getEnd();
            }
        });
        if (!wasResolved[0]) {
            return null;
        }
        if (el.getKind() == ElementKind.CONSTRUCTOR) {
            el = el.getEnclosingElement();
        }
        if (InstantRenameAction.allowInstantRename(el)) {
            HashSet<Highlight> points = new HashSet<Highlight>(new FindLocalUsagesQuery().findUsages(el, info, info.getDocument()));
            if (el.getKind().isClass()) {
                for (ExecutableElement c : ElementFilter.constructorsIn(el.getEnclosedElements())) {
                    Highlight h;
                    TreePath t = info.getTrees().getPath(c);
                    if (t == null || (h = org.netbeans.modules.java.editor.semantic.Utilities.createHighlight(info.getCompilationUnit(), info.getTrees().getSourcePositions(), info.getDocument(), t, EnumSet.of(ColoringAttributes.MARK_OCCURRENCES), null)) == null) continue;
                    points.add(h);
                }
            }
            return points;
        }
        return null;
    }

    private static boolean allowInstantRename(Element e) {
        if (org.netbeans.modules.java.editor.semantic.Utilities.isPrivateElement(e)) {
            return true;
        }
        if (e.getKind() == ElementKind.CLASS) {
            Element enclosing = e.getEnclosingElement();
            return LOCAL_CLASS_PARENTS.contains((Object)enclosing.getKind());
        }
        return false;
    }
}

