/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.semantic;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.modules.java.editor.semantic.ColoringAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ColoringManager {
    private static final Map<ColoringAttributes, String> type2Coloring;
    private static final List<ColoringAttributes> attributesInOrder;
    private static final Font ITALIC;
    private static final Font BOLD;

    public static Coloring getColoring(Collection<ColoringAttributes> colorings) {
        FontColorSettings fcs = (FontColorSettings)MimeLookup.getLookup((MimePath)MimePath.get((String)"text/x-java")).lookup(FontColorSettings.class);
        Coloring c = new Coloring(null, 0, null, null);
        for (ColoringAttributes type : attributesInOrder) {
            int fontMode;
            String key;
            if (!colorings.contains((Object)type) || (key = type2Coloring.get((Object)type)) == null) continue;
            AttributeSet colors = fcs.getTokenFontColors(key);
            if (colors == null) {
                Logger.getLogger(ColoringManager.class.getName()).log(Level.SEVERE, "no colors for: {0}", key);
                continue;
            }
            Color foreColor = (Color)colors.getAttribute(StyleConstants.Foreground);
            Color backColor = (Color)colors.getAttribute(StyleConstants.Background);
            Color strikeThroughColor = (Color)colors.getAttribute(StyleConstants.StrikeThrough);
            Color underlineColor = (Color)colors.getAttribute(StyleConstants.Underline);
            Color waveUnderlineColor = (Color)colors.getAttribute(EditorStyleConstants.WaveUnderlineColor);
            boolean isBold = colors.getAttribute(StyleConstants.Bold) == Boolean.TRUE;
            boolean isItalic = colors.getAttribute(StyleConstants.Italic) == Boolean.TRUE;
            Font font = c.getFont();
            int n = fontMode = font != null ? c.getFontMode() : 0;
            if (foreColor == null) {
                foreColor = c.getForeColor();
            }
            if (backColor == null) {
                backColor = c.getBackColor();
            }
            if (isBold) {
                font = font != null ? font.deriveFont(font.isItalic() ? 3 : 1) : BOLD;
                fontMode |= 2;
            }
            if (isItalic) {
                font = font != null ? font.deriveFont(font.isBold() ? 3 : 2) : ITALIC;
                fontMode |= 2;
            }
            if (underlineColor == null) {
                underlineColor = c.getUnderlineColor();
            }
            if (strikeThroughColor == null) {
                strikeThroughColor = c.getStrikeThroughColor();
            }
            if (waveUnderlineColor == null) {
                waveUnderlineColor = c.getWaveUnderlineColor();
            }
            c = new Coloring(font, fontMode, foreColor, backColor, underlineColor, strikeThroughColor, waveUnderlineColor);
        }
        return c;
    }

    static {
        attributesInOrder = new ArrayList<ColoringAttributes>(Arrays.asList(ColoringAttributes.UNUSED, ColoringAttributes.UNDEFINED, ColoringAttributes.DEPRECATED, ColoringAttributes.ABSTRACT, ColoringAttributes.STATIC, ColoringAttributes.PRIVATE, ColoringAttributes.PACKAGE_PRIVATE, ColoringAttributes.PROTECTED, ColoringAttributes.PUBLIC, ColoringAttributes.FIELD, ColoringAttributes.LOCAL_VARIABLE, ColoringAttributes.PARAMETER, ColoringAttributes.METHOD, ColoringAttributes.CONSTRUCTOR, ColoringAttributes.CLASS, ColoringAttributes.INTERFACE, ColoringAttributes.ANNOTATION_TYPE, ColoringAttributes.ENUM, ColoringAttributes.TYPE_PARAMETER_DECLARATION, ColoringAttributes.TYPE_PARAMETER_USE, ColoringAttributes.MARK_OCCURRENCES));
        ITALIC = SettingsDefaults.defaultFont.deriveFont(2);
        BOLD = SettingsDefaults.defaultFont.deriveFont(1);
        Collections.reverse(attributesInOrder);
        type2Coloring = new HashMap<ColoringAttributes, String>();
        type2Coloring.put(ColoringAttributes.UNUSED, "mod-unused");
        type2Coloring.put(ColoringAttributes.ABSTRACT, "mod-abstract");
        type2Coloring.put(ColoringAttributes.FIELD, "mod-field");
        type2Coloring.put(ColoringAttributes.LOCAL_VARIABLE, "mod-local-variable");
        type2Coloring.put(ColoringAttributes.PARAMETER, "mod-parameter");
        type2Coloring.put(ColoringAttributes.METHOD, "mod-method");
        type2Coloring.put(ColoringAttributes.CONSTRUCTOR, "mod-constructor");
        type2Coloring.put(ColoringAttributes.CLASS, "mod-class");
        type2Coloring.put(ColoringAttributes.INTERFACE, "mod-interface");
        type2Coloring.put(ColoringAttributes.ANNOTATION_TYPE, "mod-annotation-type");
        type2Coloring.put(ColoringAttributes.ENUM, "mod-enum");
        type2Coloring.put(ColoringAttributes.DEPRECATED, "mod-deprecated");
        type2Coloring.put(ColoringAttributes.STATIC, "mod-static");
        type2Coloring.put(ColoringAttributes.PRIVATE, "mod-private");
        type2Coloring.put(ColoringAttributes.PACKAGE_PRIVATE, "mod-package-private");
        type2Coloring.put(ColoringAttributes.PROTECTED, "mod-protected");
        type2Coloring.put(ColoringAttributes.PUBLIC, "mod-public");
        type2Coloring.put(ColoringAttributes.TYPE_PARAMETER_DECLARATION, "mod-type-parameter-declaration");
        type2Coloring.put(ColoringAttributes.TYPE_PARAMETER_USE, "mod-type-parameter-use");
        type2Coloring.put(ColoringAttributes.UNDEFINED, "mod-use");
        type2Coloring.put(ColoringAttributes.MARK_OCCURRENCES, "mark-occurrences");
    }
}

