/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.semantic;

import java.awt.Color;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.modules.editor.errorstripe.privatespi.Mark;
import org.netbeans.modules.editor.errorstripe.privatespi.Status;
import org.netbeans.modules.editor.highlights.spi.Highlight;
import org.netbeans.modules.java.editor.semantic.ColoringAttributes;
import org.netbeans.modules.java.editor.semantic.ColoringManager;
import org.openide.text.NbDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HighlightImpl
implements Mark,
Highlight {
    private Document doc;
    private Position start;
    private Position start2;
    private Position end;
    private Position end2;
    private Collection<ColoringAttributes> colorings;
    private Color esColor;
    Collection<ColoringAttributes> coloringsAttributesOrder = Arrays.asList(ColoringAttributes.STATIC, ColoringAttributes.ABSTRACT, ColoringAttributes.PUBLIC, ColoringAttributes.PROTECTED, ColoringAttributes.PACKAGE_PRIVATE, ColoringAttributes.PRIVATE, ColoringAttributes.DEPRECATED, ColoringAttributes.FIELD, ColoringAttributes.LOCAL_VARIABLE, ColoringAttributes.PARAMETER, ColoringAttributes.METHOD, ColoringAttributes.CONSTRUCTOR, ColoringAttributes.CLASS, ColoringAttributes.INTERFACE, ColoringAttributes.ANNOTATION_TYPE, ColoringAttributes.ENUM, ColoringAttributes.UNUSED, ColoringAttributes.TYPE_PARAMETER_DECLARATION, ColoringAttributes.TYPE_PARAMETER_USE, ColoringAttributes.UNDEFINED, ColoringAttributes.MARK_OCCURRENCES);

    public HighlightImpl(Document doc, Position start, Position end, Collection<ColoringAttributes> colorings) {
        this(doc, start, end, colorings, null);
    }

    public HighlightImpl(Document doc, Position start, Position end, Collection<ColoringAttributes> colorings, Color esColor) {
        this.doc = doc;
        this.start = start;
        this.end = end;
        this.colorings = colorings;
        this.esColor = esColor;
    }

    public HighlightImpl(Document doc, int start, int end, Collection<ColoringAttributes> colorings, Color esColor) throws BadLocationException {
        this.doc = doc;
        this.start = NbDocument.createPosition((Document)doc, (int)start, (Position.Bias)Position.Bias.Forward);
        this.start = NbDocument.createPosition((Document)doc, (int)start, (Position.Bias)Position.Bias.Backward);
        this.end = NbDocument.createPosition((Document)doc, (int)end, (Position.Bias)Position.Bias.Backward);
        this.end2 = NbDocument.createPosition((Document)doc, (int)end, (Position.Bias)Position.Bias.Forward);
        this.colorings = colorings;
        this.esColor = esColor;
    }

    public int getEnd() {
        int endPos = this.end.getOffset();
        if (this.end2 == null) {
            return endPos;
        }
        int endPos2 = this.end2.getOffset();
        if (endPos == endPos2) {
            return endPos;
        }
        try {
            String added = this.doc.getText(endPos, endPos2 - endPos);
            int newEndPos = endPos;
            for (char c : added.toCharArray()) {
                if (!Character.isJavaIdentifierPart(c)) continue;
                ++newEndPos;
            }
            if (newEndPos != endPos) {
                this.end = NbDocument.createPosition((Document)this.doc, (int)newEndPos, (Position.Bias)Position.Bias.Backward);
                this.end2 = NbDocument.createPosition((Document)this.doc, (int)newEndPos, (Position.Bias)Position.Bias.Forward);
            }
            return newEndPos;
        }
        catch (BadLocationException e) {
            Logger.getLogger("global").log(Level.FINE, e.getMessage(), e);
            return endPos;
        }
    }

    public int getStart() {
        int startPos = this.start.getOffset();
        if (this.start2 == null) {
            return startPos;
        }
        int startPos2 = this.start2.getOffset();
        if (startPos == startPos2) {
            return startPos;
        }
        try {
            String added = this.doc.getText(startPos, startPos2 - startPos);
            int newStartPos = startPos;
            for (char c : added.toCharArray()) {
                if (!Character.isJavaIdentifierPart(c)) continue;
                ++newStartPos;
            }
            if (newStartPos != startPos) {
                this.start = NbDocument.createPosition((Document)this.doc, (int)newStartPos, (Position.Bias)Position.Bias.Forward);
                this.start2 = NbDocument.createPosition((Document)this.doc, (int)newStartPos, (Position.Bias)Position.Bias.Backward);
            }
            return newStartPos;
        }
        catch (BadLocationException e) {
            Logger.getLogger("global").log(Level.FINE, e.getMessage(), e);
            return startPos;
        }
    }

    public Coloring getColoring() {
        return ColoringManager.getColoring(this.colorings);
    }

    public String toString() {
        return "Highlight: [" + this.colorings + ", " + this.start.getOffset() + "-" + this.end.getOffset() + "]";
    }

    public int getType() {
        return 1;
    }

    public Status getStatus() {
        return Status.STATUS_OK;
    }

    public int getPriority() {
        return 1000;
    }

    public Color getEnhancedColor() {
        return this.esColor;
    }

    public int[] getAssignedLines() {
        int line = NbDocument.findLineNumber((StyledDocument)((StyledDocument)this.doc), (int)this.start.getOffset());
        return new int[]{line, line};
    }

    public String getShortDescription() {
        return "...";
    }

    public String getHighlightTestData() {
        int lineStart = NbDocument.findLineNumber((StyledDocument)((StyledDocument)this.doc), (int)this.start.getOffset());
        int columnStart = NbDocument.findLineColumn((StyledDocument)((StyledDocument)this.doc), (int)this.start.getOffset());
        int lineEnd = NbDocument.findLineNumber((StyledDocument)((StyledDocument)this.doc), (int)this.end.getOffset());
        int columnEnd = NbDocument.findLineColumn((StyledDocument)((StyledDocument)this.doc), (int)this.end.getOffset());
        return this.coloringsToString() + ", " + lineStart + ":" + columnStart + "-" + lineEnd + ":" + columnEnd;
    }

    private String coloringsToString() {
        StringBuffer result = new StringBuffer();
        boolean first = true;
        result.append("[");
        for (ColoringAttributes attribute : this.coloringsAttributesOrder) {
            if (!this.colorings.contains((Object)attribute)) continue;
            if (!first) {
                result.append(", ");
            }
            first = false;
            result.append(attribute.name());
        }
        result.append("]");
        return result.toString();
    }

    public static HighlightImpl parse(StyledDocument doc, String line) throws ParseException, BadLocationException {
        MessageFormat f = new MessageFormat("[{0}], {1,number,integer}:{2,number,integer}-{3,number,integer}:{4,number,integer}");
        Object[] args = f.parse(line);
        String attributesString = (String)args[0];
        int lineStart = ((Long)args[1]).intValue();
        int columnStart = ((Long)args[2]).intValue();
        int lineEnd = ((Long)args[3]).intValue();
        int columnEnd = ((Long)args[4]).intValue();
        String[] attrElements = attributesString.split(",");
        ArrayList<ColoringAttributes> attributes = new ArrayList<ColoringAttributes>();
        for (String a : attrElements) {
            a = a.trim();
            attributes.add(ColoringAttributes.valueOf(a));
        }
        if (attributes.contains(null)) {
            throw new NullPointerException();
        }
        int offsetStart = NbDocument.findLineOffset((StyledDocument)doc, (int)lineStart) + columnStart;
        int offsetEnd = NbDocument.findLineOffset((StyledDocument)doc, (int)lineEnd) + columnEnd;
        return new HighlightImpl((Document)doc, doc.createPosition(offsetStart), doc.createPosition(offsetEnd), attributes, null);
    }
}

