/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.semantic;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.swing.text.Document;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.timers.TimesCollector;
import org.netbeans.modules.editor.highlights.spi.Highlight;
import org.netbeans.modules.editor.highlights.spi.Highlighter;
import org.netbeans.modules.java.editor.options.MarkOccurencesSettings;
import org.netbeans.modules.java.editor.semantic.ColoringAttributes;
import org.netbeans.modules.java.editor.semantic.FindLocalUsagesQuery;
import org.netbeans.modules.java.editor.semantic.MarkOccurrencesHighlighterFactory;
import org.netbeans.modules.java.editor.semantic.MethodExitDetector;
import org.netbeans.modules.java.editor.semantic.OccurrencesMarkProvider;
import org.netbeans.modules.java.editor.semantic.Utilities;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkOccurrencesHighlighter
implements CancellableTask<CompilationInfo> {
    private FileObject file;
    public static final Color ES_COLOR = new Color(175, 172, 102);
    private static final Set<Tree.Kind> TYPE_PATH_ELEMENT = EnumSet.of(Tree.Kind.IDENTIFIER, Tree.Kind.PRIMITIVE_TYPE, Tree.Kind.PARAMETERIZED_TYPE, Tree.Kind.MEMBER_SELECT);
    private boolean canceled;
    private MethodExitDetector exitDetector;
    private FindLocalUsagesQuery localUsages;

    MarkOccurrencesHighlighter(FileObject file) {
        this.file = file;
    }

    public Document getDocument() {
        try {
            DataObject d = DataObject.find((FileObject)this.file);
            EditorCookie ec = (EditorCookie)d.getCookie(EditorCookie.class);
            if (ec == null) {
                return null;
            }
            return ec.getDocument();
        }
        catch (IOException e) {
            Logger.getLogger(MarkOccurrencesHighlighter.class.getName()).log(Level.INFO, "SemanticHighlighter: Cannot find DataObject for file: " + FileUtil.getFileDisplayName((FileObject)this.file), e);
            return null;
        }
    }

    public void run(CompilationInfo info) {
        this.resume();
        Document doc = this.getDocument();
        if (doc == null) {
            Logger.getLogger(MarkOccurrencesHighlighter.class.getName()).log(Level.INFO, "SemanticHighlighter: Cannot get document!");
            return;
        }
        Preferences node = MarkOccurencesSettings.getCurrentNode();
        if (!node.getBoolean(MarkOccurencesSettings.ON_OFF, true)) {
            Highlighter.getDefault().setHighlights(this.file, "occurrences", Collections.emptySet());
            OccurrencesMarkProvider.get(doc).setOccurrences(Collections.<Highlight>emptySet());
            return;
        }
        long start = System.currentTimeMillis();
        int caretPosition = MarkOccurrencesHighlighterFactory.getLastPosition((FileObject)this.file);
        if (this.isCancelled()) {
            return;
        }
        Set<Object> highlights = this.processImpl(info, node, doc, caretPosition);
        if (this.isCancelled()) {
            return;
        }
        TimesCollector.getDefault().reportTime(((DataObject)doc.getProperty("stream")).getPrimaryFile(), "occurrences", "Occurrences", System.currentTimeMillis() - start);
        if (highlights == null) {
            if (node.getBoolean(MarkOccurencesSettings.KEEP_MARKS, true)) {
                return;
            }
            highlights = Collections.emptySet();
        }
        Highlighter.getDefault().setHighlights(this.file, "occurrences", highlights);
        OccurrencesMarkProvider.get(doc).setOccurrences(highlights);
    }

    private boolean isIn(CompilationUnitTree cu, SourcePositions sp, Tree tree, int position) {
        return sp.getStartPosition(cu, tree) <= (long)position && (long)position <= sp.getEndPosition(cu, tree);
    }

    private boolean isIn(int caretPosition, int[] span) {
        return span[0] <= caretPosition && caretPosition <= span[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<Highlight> processImpl(CompilationInfo info, Preferences node, Document doc, int caretPosition) {
        CompilationUnitTree cu = info.getCompilationUnit();
        TreePath tp = info.getTreeUtilities().pathFor(caretPosition);
        TreePath typePath = MarkOccurrencesHighlighter.findTypePath(tp);
        if (this.isCancelled()) {
            return null;
        }
        if (typePath != null && typePath.getParentPath().getLeaf().getKind() == Tree.Kind.METHOD) {
            MethodTree decl = (MethodTree)typePath.getParentPath().getLeaf();
            Tree type = decl.getReturnType();
            if (node.getBoolean(MarkOccurencesSettings.EXIT, true) && this.isIn(cu, info.getTrees().getSourcePositions(), type, caretPosition)) {
                MethodExitDetector med = new MethodExitDetector();
                this.setExitDetector(med);
                try {
                    Set<Highlight> set = med.process(info, doc, decl, null);
                    return set;
                }
                finally {
                    this.setExitDetector(null);
                }
            }
            for (ExpressionTree expressionTree : decl.getThrows()) {
                if (!node.getBoolean(MarkOccurencesSettings.EXCEPTIONS, true) || !this.isIn(cu, info.getTrees().getSourcePositions(), expressionTree, caretPosition)) continue;
                MethodExitDetector med = new MethodExitDetector();
                this.setExitDetector(med);
                try {
                    Set<Highlight> set = med.process(info, doc, decl, Collections.singletonList(expressionTree));
                    return set;
                }
                finally {
                    this.setExitDetector(null);
                }
            }
        }
        if (this.isCancelled()) {
            return null;
        }
        if (node.getBoolean(MarkOccurencesSettings.IMPLEMENTS, true)) {
            int bodyStart;
            if (typePath != null && typePath.getParentPath().getLeaf().getKind() == Tree.Kind.CLASS) {
                boolean bl;
                ClassTree ctree = (ClassTree)typePath.getParentPath().getLeaf();
                int bodyStart2 = Utilities.findBodyStart(ctree, cu, info.getTrees().getSourcePositions(), doc);
                boolean isExtends = ctree.getExtendsClause() == typePath.getLeaf();
                boolean bl2 = false;
                for (Tree tree : ctree.getImplementsClause()) {
                    if (tree != typePath.getLeaf()) continue;
                    bl = true;
                    break;
                }
                if (isExtends && node.getBoolean(MarkOccurencesSettings.OVERRIDES, true) || bl && node.getBoolean(MarkOccurencesSettings.IMPLEMENTS, true)) {
                    Element superType = info.getTrees().getElement(typePath);
                    Element element = info.getTrees().getElement(typePath.getParentPath());
                    if (MarkOccurrencesHighlighter.isClass(superType) && MarkOccurrencesHighlighter.isClass(element)) {
                        return this.detectMethodsForClass(info, doc, typePath.getParentPath(), (TypeElement)superType, (TypeElement)element);
                    }
                }
            }
            if (this.isCancelled()) {
                return null;
            }
            TokenSequence ts = info.getTokenHierarchy().tokenSequence(JavaTokenId.language());
            if (ts != null && tp.getLeaf().getKind() == Tree.Kind.CLASS && caretPosition < (bodyStart = Utilities.findBodyStart(tp.getLeaf(), cu, info.getTrees().getSourcePositions(), doc))) {
                ts.move(caretPosition);
                if (ts.moveNext()) {
                    List<? extends Tree> superClasses;
                    Element thisType;
                    Tree superClass;
                    if (node.getBoolean(MarkOccurencesSettings.OVERRIDES, true) && ts.token().id() == JavaTokenId.EXTENDS && (superClass = ((ClassTree)tp.getLeaf()).getExtendsClause()) != null) {
                        Element element = info.getTrees().getElement(new TreePath(tp, superClass));
                        thisType = info.getTrees().getElement(tp);
                        if (MarkOccurrencesHighlighter.isClass(element) && MarkOccurrencesHighlighter.isClass(thisType)) {
                            return this.detectMethodsForClass(info, doc, tp, (TypeElement)element, (TypeElement)thisType);
                        }
                    }
                    if (node.getBoolean(MarkOccurencesSettings.IMPLEMENTS, true) && ts.token().id() == JavaTokenId.IMPLEMENTS && (superClasses = ((ClassTree)tp.getLeaf()).getImplementsClause()) != null) {
                        ArrayList<TypeElement> set = new ArrayList<TypeElement>();
                        for (Tree tree : superClasses) {
                            Element superType;
                            if (tree == null || !MarkOccurrencesHighlighter.isClass(superType = info.getTrees().getElement(new TreePath(tp, tree)))) continue;
                            set.add((TypeElement)superType);
                        }
                        thisType = info.getTrees().getElement(tp);
                        if (!set.isEmpty() && MarkOccurrencesHighlighter.isClass(thisType)) {
                            return this.detectMethodsForClass(info, doc, tp, set, (TypeElement)thisType);
                        }
                    }
                }
            }
        }
        if (this.isCancelled()) {
            return null;
        }
        Tree tree = tp.getLeaf();
        if (node.getBoolean(MarkOccurencesSettings.BREAK_CONTINUE, true) && (tree.getKind() == Tree.Kind.BREAK || tree.getKind() == Tree.Kind.CONTINUE)) {
            return this.detectBreakOrContinueTarget(info, doc, tp);
        }
        Element el = info.getTrees().getElement(tp);
        if (el != null && (tree.getKind() != Tree.Kind.CLASS || this.isIn(caretPosition, Utilities.findIdentifierSpan(tp, cu, info.getTrees().getSourcePositions(), doc))) && !Utilities.isKeyword(tree) && (tree.getKind() != Tree.Kind.METHOD || this.isIn(caretPosition, Utilities.findIdentifierSpan(tp, cu, info.getTrees().getSourcePositions(), doc))) && MarkOccurrencesHighlighter.isEnabled(node, el)) {
            FindLocalUsagesQuery fluq = new FindLocalUsagesQuery();
            this.setLocalUsages(fluq);
            try {
                Set<Highlight> set = fluq.findUsages(el, info, doc);
                return set;
            }
            finally {
                this.setLocalUsages(null);
            }
        }
        return null;
    }

    private static TreePath findTypePath(TreePath tp) {
        if (!TYPE_PATH_ELEMENT.contains((Object)tp.getLeaf().getKind())) {
            return null;
        }
        while (TYPE_PATH_ELEMENT.contains((Object)tp.getParentPath().getLeaf().getKind())) {
            tp = tp.getParentPath();
        }
        return tp;
    }

    private static boolean isClass(Element el) {
        return el != null && (el.getKind().isClass() || el.getKind().isInterface());
    }

    private static boolean isEnabled(Preferences node, Element el) {
        switch (el.getKind()) {
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: 
            case TYPE_PARAMETER: {
                return node.getBoolean(MarkOccurencesSettings.TYPES, true);
            }
            case CONSTRUCTOR: 
            case METHOD: {
                return node.getBoolean(MarkOccurencesSettings.METHODS, true);
            }
            case ENUM_CONSTANT: {
                return node.getBoolean(MarkOccurencesSettings.CONSTANTS, true);
            }
            case FIELD: {
                if (el.getModifiers().containsAll(EnumSet.of(Modifier.STATIC, Modifier.FINAL))) {
                    return node.getBoolean(MarkOccurencesSettings.CONSTANTS, true);
                }
                return node.getBoolean(MarkOccurencesSettings.FIELDS, true);
            }
            case LOCAL_VARIABLE: 
            case PARAMETER: 
            case EXCEPTION_PARAMETER: {
                return node.getBoolean(MarkOccurencesSettings.LOCAL_VARIABLES, true);
            }
        }
        Logger.getLogger(MarkOccurrencesHighlighter.class.getName()).log(Level.INFO, "Unknow element type: {0}.", (Object)el.getKind());
        return true;
    }

    private final synchronized void setExitDetector(MethodExitDetector detector) {
        this.exitDetector = detector;
    }

    private final synchronized void setLocalUsages(FindLocalUsagesQuery localUsages) {
        this.localUsages = localUsages;
    }

    public final synchronized void cancel() {
        this.canceled = true;
        if (this.exitDetector != null) {
            this.exitDetector.cancel();
        }
        if (this.localUsages != null) {
            this.localUsages.cancel();
        }
    }

    protected final synchronized boolean isCancelled() {
        return this.canceled;
    }

    protected final synchronized void resume() {
        this.canceled = false;
    }

    private Set<Highlight> detectMethodsForClass(CompilationInfo info, Document document, TreePath clazz, TypeElement superType, TypeElement thisType) {
        return this.detectMethodsForClass(info, document, clazz, Collections.singletonList(superType), thisType);
    }

    private Set<Highlight> detectMethodsForClass(CompilationInfo info, Document document, TreePath clazz, List<TypeElement> superTypes, TypeElement thisType) {
        HashSet<Highlight> highlights = new HashSet<Highlight>();
        ClassTree clazzTree = (ClassTree)clazz.getLeaf();
        TypeElement jlObject = info.getElements().getTypeElement("java.lang.Object");
        block0: for (Tree tree : clazzTree.getMembers()) {
            if (this.isCancelled()) {
                return null;
            }
            if (tree.getKind() != Tree.Kind.METHOD) continue;
            TreePath path = new TreePath(clazz, tree);
            Element el = info.getTrees().getElement(path);
            if (el.getKind() != ElementKind.METHOD) continue;
            for (TypeElement superType : superTypes) {
                for (ExecutableElement ee : ElementFilter.methodsIn(info.getElements().getAllMembers(superType))) {
                    if (!info.getElements().overrides((ExecutableElement)el, ee, thisType) || !superType.getKind().isClass() && ((Object)ee.getEnclosingElement()).equals(jlObject)) continue;
                    highlights.add(Utilities.createHighlight(info.getCompilationUnit(), info.getTrees().getSourcePositions(), document, path, EnumSet.of(ColoringAttributes.MARK_OCCURRENCES), ES_COLOR));
                    continue block0;
                }
            }
        }
        return highlights;
    }

    private Set<Highlight> detectBreakOrContinueTarget(CompilationInfo info, Document document, TreePath breakOrContinue) {
        HashSet<Highlight> result = new HashSet<Highlight>();
        StatementTree target = info.getTreeUtilities().getBreakContinueTarget(info, breakOrContinue);
        if (target == null) {
            return null;
        }
        TokenSequence ts = info.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        ts.move((int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), target));
        if (ts.moveNext()) {
            result.add(Utilities.createHighlight(info.getCompilationUnit(), info.getTrees().getSourcePositions(), document, ts.offset(), ts.offset() + ts.token().length(), EnumSet.of(ColoringAttributes.MARK_OCCURRENCES), ES_COLOR));
        }
        StatementTree statement = target.getKind() == Tree.Kind.LABELED_STATEMENT ? ((LabeledStatementTree)target).getStatement() : target;
        StatementTree block = null;
        switch (statement.getKind()) {
            case SWITCH: {
                block = statement;
                break;
            }
            case WHILE_LOOP: {
                if (((WhileLoopTree)statement).getStatement().getKind() != Tree.Kind.BLOCK) break;
                block = ((WhileLoopTree)statement).getStatement();
                break;
            }
            case FOR_LOOP: {
                if (((ForLoopTree)statement).getStatement().getKind() != Tree.Kind.BLOCK) break;
                block = ((ForLoopTree)statement).getStatement();
                break;
            }
            case DO_WHILE_LOOP: {
                if (((DoWhileLoopTree)statement).getStatement().getKind() != Tree.Kind.BLOCK) break;
                block = ((DoWhileLoopTree)statement).getStatement();
            }
        }
        if (block != null) {
            ts.move((int)info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), block));
            if (ts.movePrevious() && ts.token().id() == JavaTokenId.RBRACE) {
                result.add(Utilities.createHighlight(info.getCompilationUnit(), info.getTrees().getSourcePositions(), document, ts.offset(), ts.offset() + ts.token().length(), EnumSet.of(ColoringAttributes.MARK_OCCURRENCES), ES_COLOR));
            }
        }
        return result;
    }
}

