/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.semantic;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.netbeans.api.timers.TimesCollector;
import org.netbeans.modules.editor.highlights.spi.Highlight;
import org.netbeans.modules.editor.highlights.spi.Highlighter;
import org.netbeans.modules.java.editor.semantic.ColoringAttributes;
import org.netbeans.modules.java.editor.semantic.OccurrencesMarkProvider;
import org.netbeans.modules.java.editor.semantic.RemoveUnusedImportFix;
import org.netbeans.modules.java.editor.semantic.ScanningCancellableTask;
import org.netbeans.modules.java.editor.semantic.Utilities;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticHighlighter
extends ScanningCancellableTask<CompilationInfo> {
    private FileObject file;
    static ErrorDescriptionSetter ERROR_DESCRIPTION_SETTER = new ErrorDescriptionSetter(){

        @Override
        public void setErrors(Document doc, List<ErrorDescription> errors) {
            HintsController.setErrors((Document)doc, (String)"semantic-highlighter", errors);
        }
    };

    SemanticHighlighter(FileObject file) {
        this.file = file;
    }

    public Document getDocument() {
        try {
            DataObject d = DataObject.find((FileObject)this.file);
            EditorCookie ec = (EditorCookie)d.getCookie(EditorCookie.class);
            if (ec == null) {
                return null;
            }
            return ec.getDocument();
        }
        catch (IOException e) {
            Logger.getLogger(SemanticHighlighter.class.getName()).log(Level.INFO, "SemanticHighlighter: Cannot find DataObject for file: " + FileUtil.getFileDisplayName((FileObject)this.file), e);
            return null;
        }
    }

    @Override
    public void run(CompilationInfo info) {
        this.resume();
        Document doc = this.getDocument();
        if (doc == null) {
            Logger.getLogger(SemanticHighlighter.class.getName()).log(Level.INFO, "SemanticHighlighter: Cannot get document!");
            return;
        }
        Set<Highlight> highlights = this.process(info, doc);
        if (this.isCancelled()) {
            return;
        }
        Highlighter.getDefault().setHighlights(this.file, "semantic", highlights);
        OccurrencesMarkProvider.get(doc).setSematic(highlights);
    }

    private void removeImport(Document doc, int start, int end) {
        try {
            boolean wasNewLine;
            int len = doc.getLength();
            while (start > 0 && "\t ".indexOf(doc.getText(start - 1, 1).charAt(0)) != -1) {
                --start;
            }
            boolean bl = wasNewLine = start == 0 || "\n".equals(doc.getText(start - 1, 1));
            while (end < len && "\t ".indexOf(doc.getText(end, 1).charAt(0)) != -1) {
                ++end;
            }
            if (wasNewLine && "\n".equals(doc.getText(end, 1))) {
                ++end;
            }
            doc.remove(start, end - start);
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    Set<Highlight> process(CompilationInfo info, Document doc) {
        DetectorVisitor v = new DetectorVisitor(info, doc);
        long start = System.currentTimeMillis();
        HashSet<Highlight> result = new HashSet<Highlight>();
        ArrayList<ErrorDescription> errors = new ArrayList<ErrorDescription>();
        CompilationUnitTree cu = info.getCompilationUnit();
        this.scan(v, (Tree)cu, null);
        if (this.isCancelled()) {
            return Collections.emptySet();
        }
        ArrayList<TreePathHandle> allUnusedImports = new ArrayList<TreePathHandle>();
        RemoveUnusedImportFix removeAllUnusedImports = RemoveUnusedImportFix.create(this.file, allUnusedImports);
        for (Element el : v.type2Highlight.keySet()) {
            if (this.isCancelled()) {
                return Collections.emptySet();
            }
            TreePath tree = (TreePath)v.type2Highlight.get(el);
            if (el == null || el.getSimpleName() == null) continue;
            Highlight h = Utilities.createHighlight(cu, info.getTrees().getSourcePositions(), doc, tree, EnumSet.of(ColoringAttributes.UNUSED), Color.GRAY);
            if (h != null) {
                result.add(h);
            }
            long startPos = info.getTrees().getSourcePositions().getStartPosition(cu, tree.getLeaf());
            int line = (int)info.getCompilationUnit().getLineMap().getLineNumber(startPos);
            TreePathHandle handle = TreePathHandle.create((TreePath)tree, (CompilationInfo)info);
            RemoveUnusedImportFix removeImport = RemoveUnusedImportFix.create(this.file, handle);
            allUnusedImports.add(handle);
            errors.add(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.VERIFIER, (String)"Unused import", (LazyFixList)new FixAllImportsFixList(removeImport, removeAllUnusedImports, allUnusedImports), (Document)doc, (int)line));
        }
        for (Element decl : v.type2Uses.keySet()) {
            if (this.isCancelled()) {
                return Collections.emptySet();
            }
            List uses = (List)v.type2Uses.get(decl);
            for (Use u : uses) {
                if (u.spec == null) continue;
                if (u.type.contains((Object)UseTypes.Element) && Utilities.isPrivateElement(decl)) {
                    if ((decl.getKind().isField() || SemanticHighlighter.isLocalVariableClosure(decl)) && !this.hasAllTypes(uses, EnumSet.of(UseTypes.READ, UseTypes.WRITE))) {
                        u.spec.add(ColoringAttributes.UNUSED);
                    }
                    if (!(decl.getKind() != ElementKind.CONSTRUCTOR && decl.getKind() != ElementKind.METHOD || this.hasAllTypes(uses, EnumSet.of(UseTypes.EXECUTE)))) {
                        u.spec.add(ColoringAttributes.UNUSED);
                    }
                    if ((decl.getKind().isClass() || decl.getKind().isInterface()) && !this.hasAllTypes(uses, EnumSet.of(UseTypes.CLASS_USE))) {
                        u.spec.add(ColoringAttributes.UNUSED);
                    }
                }
                EnumSet<ColoringAttributes> c = EnumSet.copyOf(u.spec);
                Highlight h = Utilities.createHighlight(cu, info.getTrees().getSourcePositions(), doc, u.tree, c, null);
                if (h == null) continue;
                result.add(h);
            }
        }
        if (this.isCancelled()) {
            return Collections.emptySet();
        }
        ERROR_DESCRIPTION_SETTER.setErrors(doc, errors);
        TimesCollector.getDefault().reportTime(((DataObject)doc.getProperty("stream")).getPrimaryFile(), "semantic", "Semantic", System.currentTimeMillis() - start);
        return result;
    }

    private boolean hasAllTypes(List<Use> uses, Collection<UseTypes> types) {
        EnumSet<UseTypes> e = EnumSet.copyOf(types);
        for (Use u : uses) {
            if (types.isEmpty()) {
                return true;
            }
            types.removeAll(u.type);
        }
        return types.isEmpty();
    }

    private static boolean isLocalVariableClosure(Element el) {
        return el.getKind() == ElementKind.PARAMETER || el.getKind() == ElementKind.LOCAL_VARIABLE || el.getKind() == ElementKind.EXCEPTION_PARAMETER;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DetectorVisitor
    extends CancellableTreePathScanner<Void, EnumSet<UseTypes>> {
        private CompilationInfo info;
        private Document doc;
        private Map<Element, List<Use>> type2Uses;
        private Map<Element, TreePath> type2Highlight;
        private SourcePositions sourcePositions;
        private static final Set<Tree.Kind> LITERALS = EnumSet.of(Tree.Kind.BOOLEAN_LITERAL, new Tree.Kind[]{Tree.Kind.CHAR_LITERAL, Tree.Kind.DOUBLE_LITERAL, Tree.Kind.FLOAT_LITERAL, Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL, Tree.Kind.STRING_LITERAL});

        private DetectorVisitor(CompilationInfo info, Document doc) {
            this.info = info;
            this.doc = doc;
            this.type2Uses = new HashMap<Element, List<Use>>();
            this.type2Highlight = new HashMap<Element, TreePath>();
        }

        private Highlight createHighlight(CompilationUnitTree cu, SourcePositions sp, TreePath tree, Collection<ColoringAttributes> c, Color es) {
            return Utilities.createHighlight(cu, sp, this.doc, tree, c, es);
        }

        public Void visitAssignment(AssignmentTree tree, EnumSet<UseTypes> d) {
            this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree.getVariable()), EnumSet.of(UseTypes.WRITE));
            ExpressionTree expr = tree.getExpression();
            if (expr instanceof IdentifierTree) {
                TreePath tp = new TreePath(this.getCurrentPath(), expr);
                this.resolveType(tp);
                this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.READ));
            }
            this.scan(tree.getVariable(), EnumSet.of(UseTypes.WRITE));
            this.scan(tree.getExpression(), null);
            return (Void)super.visitAssignment(tree, null);
        }

        public Void visitCompoundAssignment(CompoundAssignmentTree tree, EnumSet<UseTypes> d) {
            this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree.getVariable()), EnumSet.of(UseTypes.WRITE));
            ExpressionTree expr = tree.getExpression();
            if (expr instanceof IdentifierTree) {
                TreePath tp = new TreePath(this.getCurrentPath(), expr);
                this.resolveType(tp);
                this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.READ));
            }
            this.scan(tree.getVariable(), EnumSet.of(UseTypes.WRITE));
            this.scan(tree.getExpression(), null);
            return (Void)super.visitCompoundAssignment(tree, null);
        }

        public Void visitReturn(ReturnTree tree, EnumSet<UseTypes> d) {
            if (tree.getExpression() instanceof IdentifierTree) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree.getExpression()), EnumSet.of(UseTypes.READ));
            }
            super.visitReturn(tree, null);
            return null;
        }

        public Void visitMemberSelect(MemberSelectTree tree, EnumSet<UseTypes> d) {
            Element el;
            ExpressionTree expr = tree.getExpression();
            if (expr instanceof IdentifierTree) {
                TreePath tp = new TreePath(this.getCurrentPath(), expr);
                this.resolveType(tp);
                this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.READ));
            }
            if ((el = this.info.getTrees().getElement(this.getCurrentPath())) != null && el.getKind().isField()) {
                this.handlePossibleIdentifier(this.getCurrentPath(), EnumSet.of(UseTypes.READ));
            }
            super.visitMemberSelect(tree, null);
            return null;
        }

        private void addModifiers(Element decl, Collection<ColoringAttributes> c) {
            if (decl.getModifiers().contains((Object)Modifier.STATIC)) {
                c.add(ColoringAttributes.STATIC);
            }
            if (decl.getModifiers().contains((Object)Modifier.ABSTRACT) && !decl.getKind().isInterface()) {
                c.add(ColoringAttributes.ABSTRACT);
            }
            boolean accessModifier = false;
            if (decl.getModifiers().contains((Object)Modifier.PUBLIC)) {
                c.add(ColoringAttributes.PUBLIC);
                accessModifier = true;
            }
            if (decl.getModifiers().contains((Object)Modifier.PROTECTED)) {
                c.add(ColoringAttributes.PROTECTED);
                accessModifier = true;
            }
            if (decl.getModifiers().contains((Object)Modifier.PRIVATE)) {
                c.add(ColoringAttributes.PRIVATE);
                accessModifier = true;
            }
            if (!accessModifier && !SemanticHighlighter.isLocalVariableClosure(decl)) {
                c.add(ColoringAttributes.PACKAGE_PRIVATE);
            }
            if (this.info.getElements().isDeprecated(decl)) {
                c.add(ColoringAttributes.DEPRECATED);
            }
        }

        private Collection<ColoringAttributes> getMethodColoring(ExecutableElement mdecl) {
            ArrayList<ColoringAttributes> c = new ArrayList<ColoringAttributes>();
            this.addModifiers(mdecl, c);
            if (mdecl.getKind() == ElementKind.CONSTRUCTOR) {
                c.add(ColoringAttributes.CONSTRUCTOR);
            } else {
                c.add(ColoringAttributes.METHOD);
            }
            return c;
        }

        private Collection<ColoringAttributes> getVariableColoring(Element decl) {
            ArrayList<ColoringAttributes> c = new ArrayList<ColoringAttributes>();
            this.addModifiers(decl, c);
            if (decl.getKind().isField()) {
                c.add(ColoringAttributes.FIELD);
                return c;
            }
            if (decl.getKind() == ElementKind.LOCAL_VARIABLE || decl.getKind() == ElementKind.EXCEPTION_PARAMETER) {
                c.add(ColoringAttributes.LOCAL_VARIABLE);
                return c;
            }
            if (decl.getKind() == ElementKind.PARAMETER) {
                c.add(ColoringAttributes.PARAMETER);
                return c;
            }
            assert (false);
            return null;
        }

        private void handlePossibleIdentifier(TreePath expr, Collection<UseTypes> type) {
            this.handlePossibleIdentifier(expr, type, null, false);
        }

        private void handlePossibleIdentifier(TreePath expr, Collection<UseTypes> type, Element decl, boolean providesDecl) {
            if (Utilities.isKeyword(expr.getLeaf())) {
                return;
            }
            if (expr.getLeaf().getKind() == Tree.Kind.PRIMITIVE_TYPE) {
                return;
            }
            if (LITERALS.contains((Object)expr.getLeaf().getKind())) {
                return;
            }
            decl = !providesDecl ? this.info.getTrees().getElement(expr) : decl;
            Collection<ColoringAttributes> c = null;
            if (decl != null && (decl.getKind().isField() || SemanticHighlighter.isLocalVariableClosure(decl))) {
                c = this.getVariableColoring(decl);
            }
            if (decl != null && decl instanceof ExecutableElement) {
                c = this.getMethodColoring((ExecutableElement)decl);
            }
            if (decl != null && (decl.getKind().isClass() || decl.getKind().isInterface())) {
                if (type.contains((Object)UseTypes.READ)) {
                    type.remove((Object)UseTypes.READ);
                    type.add(UseTypes.CLASS_USE);
                }
                c = new ArrayList<ColoringAttributes>();
                this.addModifiers(decl, c);
                switch (decl.getKind()) {
                    case CLASS: {
                        c.add(ColoringAttributes.CLASS);
                        break;
                    }
                    case INTERFACE: {
                        c.add(ColoringAttributes.INTERFACE);
                        break;
                    }
                    case ANNOTATION_TYPE: {
                        c.add(ColoringAttributes.ANNOTATION_TYPE);
                        break;
                    }
                    case ENUM: {
                        c.add(ColoringAttributes.ENUM);
                    }
                }
            }
            if (c != null) {
                this.addUse(decl, type, expr, c);
            }
        }

        private void addUse(Element decl, Collection<UseTypes> useTypes, TreePath t, Collection<ColoringAttributes> c) {
            List<Use> uses = this.type2Uses.get(decl);
            if (uses == null) {
                uses = new ArrayList<Use>();
                this.type2Uses.put(decl, uses);
            }
            Use u = new Use(useTypes, t, c);
            uses.add(u);
        }

        public Void visitTypeCast(TypeCastTree tree, EnumSet<UseTypes> d) {
            this.resolveType(new TreePath(this.getCurrentPath(), tree.getType()));
            ExpressionTree expr = tree.getExpression();
            if (expr instanceof IdentifierTree) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), expr), EnumSet.of(UseTypes.READ));
            }
            super.visitTypeCast(tree, d);
            return null;
        }

        public Void visitInstanceOf(InstanceOfTree tree, EnumSet<UseTypes> d) {
            ExpressionTree expr = tree.getExpression();
            if (expr instanceof IdentifierTree) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), expr), EnumSet.of(UseTypes.READ));
            }
            TreePath tp = new TreePath(this.getCurrentPath(), tree.getType());
            this.resolveType(tp);
            this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.CLASS_USE));
            super.visitInstanceOf(tree, null);
            return null;
        }

        public Void visitCompilationUnit(CompilationUnitTree tree, EnumSet<UseTypes> d) {
            this.scan(tree.getPackageAnnotations(), d);
            this.scan(tree.getImports(), d);
            this.scan(tree.getTypeDecls(), d);
            return null;
        }

        public Void visitMethodInvocation(MethodInvocationTree tree, EnumSet<UseTypes> d) {
            String ident;
            ExpressionTree possibleIdent = tree.getMethodSelect();
            boolean handled = false;
            if (possibleIdent.getKind() == Tree.Kind.IDENTIFIER && ("super".equals(ident = ((IdentifierTree)possibleIdent).getName().toString()) || "this".equals(ident))) {
                Element element = this.info.getTrees().getElement(this.getCurrentPath());
                this.addUse(element, EnumSet.of(UseTypes.EXECUTE), null, null);
                handled = true;
            }
            if (!handled) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), possibleIdent), EnumSet.of(UseTypes.EXECUTE));
            }
            for (ExpressionTree expressionTree : tree.getArguments()) {
                if (!(expressionTree instanceof IdentifierTree)) continue;
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), expressionTree), EnumSet.of(UseTypes.READ));
            }
            for (Tree tree2 : tree.getTypeArguments()) {
                if (!(tree2 instanceof IdentifierTree)) continue;
                this.resolveType(new TreePath(this.getCurrentPath(), tree2));
            }
            super.visitMethodInvocation(tree, null);
            return null;
        }

        public Void visitIdentifier(IdentifierTree tree, EnumSet<UseTypes> d) {
            if (d != null) {
                this.handlePossibleIdentifier(this.getCurrentPath(), d);
            }
            super.visitIdentifier(tree, null);
            return null;
        }

        public Void visitMethod(MethodTree tree, EnumSet<UseTypes> d) {
            Element element;
            this.handlePossibleIdentifier(this.getCurrentPath(), EnumSet.of(UseTypes.Element));
            for (ExpressionTree expressionTree : tree.getThrows()) {
                TreePath tp = new TreePath(this.getCurrentPath(), expressionTree);
                this.resolveType(tp);
                this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.CLASS_USE));
            }
            if (tree.getReturnType() != null) {
                this.resolveType(new TreePath(this.getCurrentPath(), tree.getReturnType()));
            }
            EnumSet<UseTypes> paramsUseTypes = (element = this.info.getTrees().getElement(this.getCurrentPath())) != null && element.getModifiers().contains((Object)Modifier.ABSTRACT) ? EnumSet.of(UseTypes.WRITE, UseTypes.READ) : EnumSet.of(UseTypes.WRITE);
            this.scan(tree.getModifiers(), null);
            this.scan(tree.getReturnType(), EnumSet.of(UseTypes.CLASS_USE));
            this.scan(tree.getTypeParameters(), null);
            this.scan(tree.getParameters(), paramsUseTypes);
            this.scan(tree.getThrows(), null);
            this.scan(tree.getBody(), null);
            return null;
        }

        public Void visitExpressionStatement(ExpressionStatementTree tree, EnumSet<UseTypes> d) {
            super.visitExpressionStatement(tree, null);
            return null;
        }

        public Void visitParenthesized(ParenthesizedTree tree, EnumSet<UseTypes> d) {
            ExpressionTree expr = tree.getExpression();
            if (expr instanceof IdentifierTree) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), expr), EnumSet.of(UseTypes.READ));
            }
            super.visitParenthesized(tree, null);
            return null;
        }

        public Void visitEnhancedForLoop(EnhancedForLoopTree tree, EnumSet<UseTypes> d) {
            this.scan(tree.getVariable(), EnumSet.of(UseTypes.WRITE));
            if (tree.getExpression().getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree.getExpression()), EnumSet.of(UseTypes.READ));
            }
            this.scan(tree.getExpression(), null);
            this.scan(tree.getStatement(), null);
            return null;
        }

        public Void visitImport(ImportTree tree, EnumSet<UseTypes> d) {
            Element decl;
            if (!tree.isStatic() && (decl = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), tree.getQualifiedIdentifier()))) != null && decl.asType().getKind() != TypeKind.ERROR) {
                this.type2Highlight.put(decl, this.getCurrentPath());
            }
            super.visitImport(tree, null);
            return null;
        }

        private String getSimple(String fqn) {
            int lastDot = fqn.lastIndexOf(46);
            if (lastDot != -1) {
                return fqn.substring(lastDot + 1);
            }
            return fqn;
        }

        public Void visitVariable(VariableTree tree, EnumSet<UseTypes> d) {
            TreePath type = new TreePath(this.getCurrentPath(), tree.getType());
            if (type.getLeaf() instanceof ArrayTypeTree) {
                type = new TreePath(type, ((ArrayTypeTree)type.getLeaf()).getType());
            }
            this.resolveType(type);
            if (type.getLeaf().getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(type, EnumSet.of(UseTypes.CLASS_USE));
            }
            EnumSet<UseTypes> uses = null;
            boolean isParameter = false;
            if (tree.getInitializer() != null) {
                uses = EnumSet.of(UseTypes.Element, UseTypes.WRITE);
                if (tree.getInitializer().getKind() == Tree.Kind.IDENTIFIER) {
                    this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree.getInitializer()), EnumSet.of(UseTypes.READ));
                }
            } else {
                Element e = this.info.getTrees().getElement(this.getCurrentPath());
                uses = e != null && e.getKind() == ElementKind.FIELD ? EnumSet.of(UseTypes.Element, UseTypes.WRITE) : EnumSet.of(UseTypes.Element);
            }
            if (d != null) {
                HashSet<UseTypes> ut = new HashSet<UseTypes>();
                ut.addAll(uses);
                ut.addAll(d);
                uses = EnumSet.copyOf(ut);
            }
            this.handlePossibleIdentifier(this.getCurrentPath(), uses);
            super.visitVariable(tree, null);
            return null;
        }

        private boolean isParameter(VariableTree var, MethodTree decl) {
            for (VariableTree variableTree : decl.getParameters()) {
                if (var != variableTree) continue;
                return true;
            }
            return false;
        }

        public Void visitAnnotation(AnnotationTree tree, EnumSet<UseTypes> d) {
            TreePath tp = new TreePath(this.getCurrentPath(), tree.getAnnotationType());
            this.resolveType(tp);
            this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.CLASS_USE));
            super.visitAnnotation(tree, EnumSet.noneOf(UseTypes.class));
            return null;
        }

        public Void visitNewClass(NewClassTree tree, EnumSet<UseTypes> d) {
            ExpressionTree ident = tree.getIdentifier();
            TreePath tp = ident.getKind() == Tree.Kind.PARAMETERIZED_TYPE ? new TreePath(new TreePath(this.getCurrentPath(), ident), ((ParameterizedTypeTree)((Object)ident)).getType()) : new TreePath(this.getCurrentPath(), ident);
            this.resolveType(tp);
            this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.EXECUTE), this.info.getTrees().getElement(this.getCurrentPath()), true);
            Element clazz = this.info.getTrees().getElement(tp);
            if (clazz != null) {
                this.addUse(clazz, EnumSet.of(UseTypes.CLASS_USE), null, null);
            }
            for (ExpressionTree expressionTree : tree.getArguments()) {
                if (!(expressionTree instanceof IdentifierTree)) continue;
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), expressionTree), EnumSet.of(UseTypes.READ));
            }
            super.visitNewClass(tree, null);
            return null;
        }

        public Void visitParameterizedType(ParameterizedTypeTree tree, EnumSet<UseTypes> d) {
            if (this.getCurrentPath().getParentPath().getLeaf().getKind() != Tree.Kind.NEW_CLASS) {
                TreePath tp = new TreePath(this.getCurrentPath(), tree.getType());
                this.resolveType(tp);
                this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.CLASS_USE));
            }
            for (Tree tree2 : tree.getTypeArguments()) {
                TreePath tp = new TreePath(this.getCurrentPath(), tree2);
                this.resolveType(tp);
                this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.CLASS_USE));
            }
            super.visitParameterizedType(tree, null);
            return null;
        }

        public Void visitBinary(BinaryTree tree, EnumSet<UseTypes> d) {
            TreePath tp;
            ExpressionTree left = tree.getLeftOperand();
            ExpressionTree right = tree.getRightOperand();
            if (left instanceof IdentifierTree) {
                tp = new TreePath(this.getCurrentPath(), left);
                this.resolveType(tp);
                this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.READ));
            }
            if (right instanceof IdentifierTree) {
                tp = new TreePath(this.getCurrentPath(), right);
                this.resolveType(tp);
                this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.READ));
            }
            super.visitBinary(tree, null);
            return null;
        }

        public Void visitClass(ClassTree tree, EnumSet<UseTypes> d) {
            Tree extnds = tree.getExtendsClause();
            if (extnds != null) {
                TreePath tp = new TreePath(this.getCurrentPath(), extnds);
                this.resolveType(tp);
                this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.CLASS_USE));
            }
            for (Tree tree2 : tree.getImplementsClause()) {
                TreePath tp = new TreePath(this.getCurrentPath(), tree2);
                this.resolveType(tp);
                this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.CLASS_USE));
            }
            for (TypeParameterTree typeParameterTree : tree.getTypeParameters()) {
                for (Tree tree3 : typeParameterTree.getBounds()) {
                    TreePath tp = new TreePath(new TreePath(this.getCurrentPath(), typeParameterTree), tree3);
                    this.resolveType(tp);
                    this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.CLASS_USE));
                }
            }
            this.handlePossibleIdentifier(this.getCurrentPath(), EnumSet.of(UseTypes.Element));
            super.visitClass(tree, null);
            return null;
        }

        public Void visitUnary(UnaryTree tree, EnumSet<UseTypes> d) {
            if (tree.getExpression() instanceof IdentifierTree) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree.getExpression()), EnumSet.of(UseTypes.READ));
            }
            super.visitUnary(tree, d);
            return null;
        }

        public Void visitArrayAccess(ArrayAccessTree tree, EnumSet<UseTypes> d) {
            if (tree.getExpression() != null && tree.getExpression().getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree.getExpression()), EnumSet.of(UseTypes.READ));
            }
            if (tree.getIndex() instanceof IdentifierTree) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree.getIndex()), EnumSet.of(UseTypes.READ));
            }
            super.visitArrayAccess(tree, null);
            return null;
        }

        public Void visitNewArray(NewArrayTree tree, EnumSet<UseTypes> d) {
            if (tree.getType() != null) {
                this.resolveType(new TreePath(this.getCurrentPath(), tree.getType()));
            }
            this.scan(tree.getType(), null);
            this.scan(tree.getDimensions(), EnumSet.of(UseTypes.READ));
            this.scan(tree.getInitializers(), EnumSet.of(UseTypes.READ));
            return null;
        }

        public Void visitCatch(CatchTree tree, EnumSet<UseTypes> d) {
            this.scan(tree.getParameter(), EnumSet.of(UseTypes.WRITE));
            this.scan(tree.getBlock(), null);
            return null;
        }

        public Void visitConditionalExpression(ConditionalExpressionTree node, EnumSet<UseTypes> p) {
            return (Void)super.visitConditionalExpression(node, EnumSet.of(UseTypes.READ));
        }

        public Void visitAssert(AssertTree tree, EnumSet<UseTypes> p) {
            if (tree.getCondition().getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree.getCondition()), EnumSet.of(UseTypes.READ));
            }
            if (tree.getDetail() != null && tree.getDetail().getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree.getDetail()), EnumSet.of(UseTypes.READ));
            }
            return (Void)super.visitAssert(tree, null);
        }

        public Void visitCase(CaseTree tree, EnumSet<UseTypes> p) {
            if (tree.getExpression() != null && tree.getExpression().getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree.getExpression()), EnumSet.of(UseTypes.READ));
            }
            return (Void)super.visitCase(tree, null);
        }

        public Void visitThrow(ThrowTree tree, EnumSet<UseTypes> p) {
            if (tree.getExpression() != null && tree.getExpression().getKind() == Tree.Kind.IDENTIFIER) {
                this.handlePossibleIdentifier(new TreePath(this.getCurrentPath(), tree.getExpression()), EnumSet.of(UseTypes.READ));
            }
            return (Void)super.visitThrow(tree, p);
        }

        public Void visitTypeParameter(TypeParameterTree tree, EnumSet<UseTypes> p) {
            for (Tree tree2 : tree.getBounds()) {
                if (tree2.getKind() != Tree.Kind.IDENTIFIER) continue;
                TreePath tp = new TreePath(this.getCurrentPath(), tree2);
                this.handlePossibleIdentifier(tp, EnumSet.of(UseTypes.CLASS_USE));
                this.resolveType(tp);
            }
            return (Void)super.visitTypeParameter(tree, p);
        }

        private void resolveType(TreePath type) {
            FirstIdentTypeVisitor v = new FirstIdentTypeVisitor();
            v.scan(type, null);
            if (v.first == null) {
                return;
            }
            Element decl = this.info.getTrees().getElement(v.first);
            if (decl == null) {
                return;
            }
            this.type2Highlight.remove(decl);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class FirstIdentTypeVisitor
        extends TreePathScanner<Void, Void> {
            private TreePath first = null;

            private FirstIdentTypeVisitor() {
            }

            @Override
            public Void visitIdentifier(IdentifierTree tree, Void d) {
                if (this.first == null) {
                    this.first = this.getCurrentPath();
                }
                return (Void)super.visitIdentifier(tree, null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ErrorDescriptionSetter {
        public void setErrors(Document var1, List<ErrorDescription> var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FixAllImportsFixList
    implements LazyFixList {
        private Fix removeImport;
        private Fix removeAllUnusedImports;
        private List<TreePathHandle> allUnusedImports;
        private List<Fix> fixes;

        public FixAllImportsFixList(Fix removeImport, Fix removeAllUnusedImports, List<TreePathHandle> allUnusedImports) {
            this.removeImport = removeImport;
            this.removeAllUnusedImports = removeAllUnusedImports;
            this.allUnusedImports = allUnusedImports;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
        }

        public boolean probablyContainsFixes() {
            return true;
        }

        public synchronized List<Fix> getFixes() {
            if (this.fixes != null) {
                return this.fixes;
            }
            this.fixes = this.allUnusedImports.size() > 1 ? Arrays.asList(this.removeImport, this.removeAllUnusedImports) : Collections.singletonList(this.removeImport);
            return this.fixes;
        }

        public boolean isComputed() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Use {
        private Collection<UseTypes> type;
        private TreePath tree;
        private Collection<ColoringAttributes> spec;

        public Use(Collection<UseTypes> type, TreePath tree, Collection<ColoringAttributes> spec) {
            this.type = type;
            this.tree = tree;
            this.spec = spec;
        }

        public String toString() {
            return "Use: " + this.type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum UseTypes {
        READ,
        WRITE,
        EXECUTE,
        Element,
        CLASS_USE;

    }
}

