/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.File;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.util.NbBundle;

public class CVS
extends VersioningSystem
implements VersioningListener,
PreferenceChangeListener {
    public CVS() {
        this.putProperty("String VCS.DisplayName", NbBundle.getMessage(CVS.class, (String)"CTL_CVS_DisplayName"));
        this.putProperty("String VCS.MenuLabel", NbBundle.getMessage(CVS.class, (String)"CTL_CVS_MainMenu"));
        CvsVersioningSystem.getInstance().addVersioningListener(this);
        CvsVersioningSystem.getInstance().getStatusCache().addVersioningListener(this);
        CvsModuleConfig.getDefault().getPreferences().addPreferenceChangeListener(this);
    }

    public File getTopmostManagedAncestor(File file) {
        return CvsVersioningSystem.getInstance().getTopmostManagedParent(file);
    }

    public VCSAnnotator getVCSAnnotator() {
        return CvsVersioningSystem.getInstance().getVCSAnnotator();
    }

    public VCSInterceptor getVCSInterceptor() {
        return CvsVersioningSystem.getInstance().getVCSInterceptor();
    }

    public void getOriginalFile(File workingCopy, File originalFile) {
        CvsVersioningSystem.getInstance().getOriginalFile(workingCopy, originalFile);
    }

    public void versioningEvent(VersioningEvent event) {
        if (event.getId() == FileStatusCache.EVENT_FILE_STATUS_CHANGED) {
            File file = (File)event.getParams()[0];
            this.fireStatusChanged(file);
        } else if (event.getId() == CvsVersioningSystem.EVENT_REFRESH_ANNOTATIONS) {
            this.fireStatusChanged(null);
        } else if (event.getId() == CvsVersioningSystem.EVENT_VERSIONED_FILES_CHANGED) {
            this.fireVersionedFilesChanged();
        }
    }

    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().startsWith("commitExclusions")) {
            this.fireStatusChanged(null);
        } else if (evt.getKey().startsWith("textAnnotationsVisible")) {
            this.fireAnnotationsChanged(null);
        } else if (evt.getKey().startsWith("annotationsFormat")) {
            this.fireAnnotationsChanged(null);
        }
    }
}

