/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.lib.cvsclient.admin.AdminHandler;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.admin.StandardAdminHandler;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CvsLiteAdminHandler
implements AdminHandler {
    static final String INVALID_METADATA_MARKER = "invalid-metadata";
    private static final String INVALID_METADATA_MARKER_PATH = "CVS/invalid-metadata";
    private StandardAdminHandler stdHandler = new StandardAdminHandler();

    private void checkForInvalidMetadata(File dir) {
        File marker = new File(dir, INVALID_METADATA_MARKER_PATH);
        if (marker.exists()) {
            Utils.deleteRecursively((File)marker.getParentFile());
        }
    }

    public void updateAdminData(String localDirectory, String repositoryPath, Entry entry, GlobalOptions globalOptions) throws IOException {
        this.checkForInvalidMetadata(new File(localDirectory));
        this.stdHandler.updateAdminData(localDirectory, repositoryPath, entry, globalOptions);
    }

    public Entry getEntry(File file) throws IOException {
        this.checkForInvalidMetadata(file.getParentFile());
        return this.stdHandler.getEntry(file);
    }

    public boolean exists(File file) {
        if (file.exists()) {
            return true;
        }
        if ("CVS".equals(file.getName())) {
            file = file.getParentFile();
        }
        return false;
    }

    public Iterator<Entry> getEntries(File directory) throws IOException {
        this.checkForInvalidMetadata(directory);
        if (new File(directory, "CVS").isDirectory()) {
            return this.stdHandler.getEntries(directory);
        }
        directory = FileUtil.normalizeFile((File)directory);
        return this.stdHandler.getEntries(directory);
    }

    public Entry[] getEntriesAsArray(File directory) throws IOException {
        this.checkForInvalidMetadata(directory);
        ArrayList<Entry> entries = new ArrayList<Entry>();
        Iterator<Entry> i = this.getEntries(directory);
        while (i.hasNext()) {
            entries.add(i.next());
        }
        return entries.toArray(new Entry[entries.size()]);
    }

    public void setEntry(File file, Entry entry) throws IOException {
        this.checkForInvalidMetadata(file.getParentFile());
        File adminDir = new File(file.getParentFile(), "CVS");
        this.createAdminDirs(adminDir);
        this.stdHandler.setEntry(file, entry);
    }

    private void createAdminDirs(File adminDir) throws IOException {
        if (!adminDir.exists() && adminDir.getParentFile() != null && adminDir.getParentFile().getParentFile() != null) {
            this.createAdminDirs(new File(adminDir.getParentFile().getParentFile(), "CVS"));
        }
    }

    public String getRepositoryForDirectory(String directory, String repository) throws IOException {
        this.checkForInvalidMetadata(new File(directory));
        File dirFile = new File(directory);
        if (dirFile.exists()) {
            return this.stdHandler.getRepositoryForDirectory(directory, repository);
        }
        return this.stdHandler.getRepositoryForDirectory(directory, repository);
    }

    public void removeEntry(File file) throws IOException {
        File parent = file.getParentFile();
        this.checkForInvalidMetadata(parent);
        this.stdHandler.removeEntry(file);
    }

    public Set getAllFiles(File directory) throws IOException {
        this.checkForInvalidMetadata(directory);
        return this.stdHandler.getAllFiles(directory);
    }

    public String getStickyTagForDirectory(File directory) {
        this.checkForInvalidMetadata(directory);
        return this.stdHandler.getStickyTagForDirectory(directory);
    }
}

