/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.modules.versioning.util.FileCollection;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CvsModuleConfig {
    public static final String PROP_IGNORED_FILEPATTERNS = "ignoredFilePatterns";
    public static final String PROP_COMMIT_EXCLUSIONS = "commitExclusions";
    public static final String PROP_SEARCHHISTORY_FETCHTAGS = "searchHistory.fetchTags";
    public static final String PROP_EXCLUDE_NEW_FILES = "excludeNewFiles";
    public static final String ROOTS_CONFIG = "rootsConfig";
    public static final String PROP_ANNOTATIONS_VISIBLE = "textAnnotationsVisible";
    public static final String PROP_ANNOTATIONS_FORMAT = "annotationsFormat";
    private static final String PROP_WRAP_COMMIT_MESSAGE_LENGTH = "wrapCommitMessageLength";
    public static final String DEFAULT_ANNOTATIONS_FORMAT = "[{status}; {tag}]";
    private static final String FIELD_SEPARATOR = "<~>";
    private static final CvsModuleConfig INSTANCE = new CvsModuleConfig();
    private FileCollection excludedFiles = new FileCollection();
    private Map<String, RootSettings> rootsMap;

    public static CvsModuleConfig getDefault() {
        return INSTANCE;
    }

    public CvsModuleConfig() {
        this.excludedFiles.load(this.getPreferences(), PROP_COMMIT_EXCLUSIONS);
    }

    public int getWrapCommitMessagelength() {
        return this.getPreferences().getInt(PROP_WRAP_COMMIT_MESSAGE_LENGTH, 0);
    }

    public void setWrapCommitMessagelength(int length) {
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        this.getPreferences().putInt(PROP_WRAP_COMMIT_MESSAGE_LENGTH, length);
    }

    public Pattern[] getIgnoredFilePatterns() {
        return this.getDefaultFilePatterns();
    }

    public boolean isExcludedFromCommit(File file) {
        return this.excludedFiles.contains(file);
    }

    public void addExclusion(File file) {
        this.excludedFiles.add(file);
        this.excludedFiles.save(this.getPreferences(), PROP_COMMIT_EXCLUSIONS);
    }

    public void removeExclusion(File file) {
        this.excludedFiles.remove(file);
        this.excludedFiles.save(this.getPreferences(), PROP_COMMIT_EXCLUSIONS);
    }

    public synchronized boolean hasExtSettingsFor(CVSRoot root) {
        String rootString;
        assert ("ext".equals(root.getMethod()));
        Map<String, RootSettings> rootsMap = this.getRootsMap();
        RootSettings rootSettings = rootsMap.get(rootString = root.toString());
        if (rootSettings != null) {
            ExtSettings extSettings = rootSettings.extSettings;
            return extSettings != null;
        }
        return false;
    }

    public synchronized ExtSettings getExtSettingsFor(CVSRoot root) {
        ExtSettings extSettings;
        String rootString;
        assert ("ext".equals(root.getMethod()));
        Map<String, RootSettings> rootsMap = this.getRootsMap();
        RootSettings rootSettings = rootsMap.get(rootString = root.toString());
        if (rootSettings != null && (extSettings = rootSettings.extSettings) != null) {
            if (!extSettings.extUseInternalSsh && extSettings.extCommand == null) {
                extSettings.extCommand = System.getenv("CVS_RSH");
            }
            return extSettings;
        }
        ExtSettings defaults = new ExtSettings();
        defaults.extRememberPassword = false;
        defaults.extCommand = System.getenv("CVS_RSH");
        defaults.extUseInternalSsh = true;
        defaults.extPassword = null;
        return defaults;
    }

    public synchronized void setExtSettingsFor(CVSRoot root, ExtSettings extSettings) {
        String key;
        assert ("ext".equals(root.getMethod()));
        Map<String, RootSettings> map = this.getRootsMap();
        RootSettings settings = map.get(key = root.toString());
        if (settings == null) {
            settings = new RootSettings();
        }
        settings.extSettings = extSettings;
        map.put(key, settings);
        this.storeRootsMap();
    }

    private Map<String, RootSettings> getRootsMap() {
        if (this.rootsMap == null) {
            this.rootsMap = this.loadRootsMap();
        }
        return this.rootsMap;
    }

    private Map<String, RootSettings> loadRootsMap() {
        List smap = Utils.getStringList((Preferences)this.getPreferences(), (String)"cvsRootSettings");
        HashMap<String, RootSettings> map = new HashMap<String, RootSettings>(smap.size());
        for (String s : smap) {
            ExtSettings es;
            RootSettings rs;
            String[] fields = s.split(FIELD_SEPARATOR);
            if (fields.length >= 8) {
                rs = new RootSettings();
                map.put(fields[0], rs);
                if (fields.length < 11) continue;
                es = new ExtSettings();
                rs.extSettings = es;
                es.extUseInternalSsh = Boolean.valueOf(fields[8]);
                es.extRememberPassword = Boolean.valueOf(fields[9]);
                es.extCommand = fields[10];
                if (fields.length < 12) continue;
                es.extPassword = fields[11];
                continue;
            }
            if (fields.length < 4) continue;
            rs = new RootSettings();
            map.put(fields[0], rs);
            es = new ExtSettings();
            rs.extSettings = es;
            es.extUseInternalSsh = Boolean.valueOf(fields[1]);
            es.extRememberPassword = Boolean.valueOf(fields[2]);
            es.extCommand = fields[3];
            if (fields.length < 5) continue;
            es.extPassword = fields[4];
        }
        return map;
    }

    private void storeRootsMap() {
        ArrayList<String> smap = new ArrayList<String>();
        for (Map.Entry<String, RootSettings> entry : this.rootsMap.entrySet()) {
            StringBuffer es = new StringBuffer(100);
            es.append(entry.getKey());
            RootSettings settings = entry.getValue();
            if (settings.extSettings != null) {
                es.append(FIELD_SEPARATOR);
                es.append(((RootSettings)settings).extSettings.extUseInternalSsh);
                es.append(FIELD_SEPARATOR);
                es.append(((RootSettings)settings).extSettings.extRememberPassword);
                es.append(FIELD_SEPARATOR);
                es.append(((RootSettings)settings).extSettings.extCommand);
                if (((RootSettings)settings).extSettings.extRememberPassword) {
                    es.append(FIELD_SEPARATOR);
                    es.append(((RootSettings)settings).extSettings.extPassword);
                }
            }
            smap.add(es.toString());
        }
        Utils.put((Preferences)this.getPreferences(), (String)"cvsRootSettings", smap);
    }

    public Preferences getPreferences() {
        return NbPreferences.forModule(CvsModuleConfig.class);
    }

    private Pattern[] getDefaultFilePatterns() {
        return new Pattern[]{Pattern.compile("cvslog\\..*"), Pattern.compile("\\.make\\.state"), Pattern.compile("\\.nse_depinfo"), Pattern.compile(".*~"), Pattern.compile("#.*"), Pattern.compile("\\.#.*"), Pattern.compile(",.*"), Pattern.compile("_\\$.*"), Pattern.compile(".*\\$"), Pattern.compile(".*\\.old"), Pattern.compile(".*\\.bak"), Pattern.compile(".*\\.BAK"), Pattern.compile(".*\\.orig"), Pattern.compile(".*\\.rej"), Pattern.compile(".*\\.del-.*"), Pattern.compile(".*\\.a"), Pattern.compile(".*\\.olb"), Pattern.compile(".*\\.o"), Pattern.compile(".*\\.obj"), Pattern.compile(".*\\.so"), Pattern.compile(".*\\.exe"), Pattern.compile(".*\\.Z"), Pattern.compile(".*\\.elc"), Pattern.compile(".*\\.ln")};
    }

    public static final class ExtSettings {
        public boolean extUseInternalSsh;
        public boolean extRememberPassword;
        public String extPassword;
        public String extCommand;
    }

    private static final class RootSettings {
        private ExtSettings extSettings;

        private RootSettings() {
        }
    }
}

