/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.netbeans.lib.cvsclient.admin.AdminHandler;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.admin.StandardAdminHandler;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FilesystemHandler
extends VCSInterceptor {
    private final FileStatusCache cache;
    private static Thread ignoredThread;

    public FilesystemHandler(CvsVersioningSystem cvs) {
        this.cache = cvs.getStatusCache();
    }

    public boolean beforeDelete(File file) {
        if (FilesystemHandler.ignoringEvents()) {
            return false;
        }
        return Utils.isPartOfCVSMetadata(file) || file.isDirectory() && this.hasMetadata(file);
    }

    public void doDelete(File file) throws IOException {
        if (file.isDirectory() && this.hasMetadata(file)) {
            new File(file, "CVS/.nb-removed").createNewFile();
            this.cache.refresh(file, 0, true);
            return;
        }
        if (!Utils.isPartOfCVSMetadata(file) && !file.delete()) {
            throw new IOException("Failed to delete file: " + file.getAbsolutePath());
        }
    }

    public void afterDelete(final File file) {
        if (FilesystemHandler.ignoringEvents()) {
            return;
        }
        org.netbeans.modules.versioning.util.Utils.post((Runnable)new Runnable(){

            public void run() {
                FilesystemHandler.this.fileDeletedImpl(file);
            }
        });
    }

    public boolean beforeMove(File from, File to) {
        File destDir = to.getParentFile();
        if (from != null && destDir != null && from.isDirectory()) {
            FileInformation info = this.cache.getStatus(from);
            return (info.getStatus() & 0xFFFFFFFE) != 0;
        }
        return false;
    }

    public void doMove(File from, File to) throws IOException {
        ArrayList<File> affectedFiles = new ArrayList<File>();
        this.moveRecursively(affectedFiles, from, to);
        this.cvsRemoveRecursively(from);
        this.refresh(affectedFiles);
    }

    private void moveRecursively(List<File> affectedFiles, File from, File to) throws IOException {
        File[] files = from.listFiles();
        if (files != null) {
            for (File file : files) {
                File toFile;
                String fileName = file.getName();
                if (file.isDirectory()) {
                    if (fileName.equals("CVS")) {
                        new File(file, ".nb-removed").createNewFile();
                        continue;
                    }
                    toFile = new File(to, fileName);
                    this.moveRecursively(affectedFiles, file, toFile);
                    affectedFiles.add(file);
                    affectedFiles.add(toFile);
                    continue;
                }
                to.mkdirs();
                toFile = new File(to, fileName);
                file.renameTo(toFile);
                affectedFiles.add(file);
                affectedFiles.add(toFile);
            }
        }
    }

    private void cvsRemoveRecursively(File dir) {
        File[] files;
        StandardAdminHandler sah = new StandardAdminHandler();
        Entry[] entries = null;
        try {
            entries = sah.getEntriesAsArray(dir);
        }
        catch (IOException e) {
            // empty catch block
        }
        if (entries != null) {
            for (Entry entry : entries) {
                if (entry == null || entry.isDirectory() || entry.isUserFileToBeRemoved()) continue;
                File file = new File(dir, entry.getName());
                this.cvsRemoveLocally((AdminHandler)sah, file, entry);
            }
        }
        for (File file : files = dir.listFiles()) {
            if (!file.isDirectory()) continue;
            this.cvsRemoveRecursively(file);
        }
    }

    public void afterMove(final File from, final File to) {
        if (FilesystemHandler.ignoringEvents()) {
            return;
        }
        org.netbeans.modules.versioning.util.Utils.post((Runnable)new Runnable(){

            public void run() {
                FilesystemHandler.this.fileDeletedImpl(from);
                FilesystemHandler.this.fileCreatedImpl(to);
            }
        });
    }

    public boolean beforeCreate(File file, boolean isDirectory) {
        if (FilesystemHandler.ignoringEvents()) {
            return false;
        }
        if (file.getName().equals("CVS")) {
            if (file.isDirectory()) {
                File f = new File(file, "invalid-metadata");
                try {
                    f.createNewFile();
                }
                catch (IOException e) {
                    ErrorManager.getDefault().log(65536, "Unable to create marker: " + f.getAbsolutePath());
                }
            }
            return true;
        }
        return false;
    }

    public void doCreate(File file, boolean isDirectory) throws IOException {
        file.mkdir();
        File f = new File(file, "invalid-metadata");
        try {
            f.createNewFile();
        }
        catch (IOException e) {
            ErrorManager.getDefault().log(65536, "Unable to create marker: " + f.getAbsolutePath());
        }
    }

    public void afterCreate(final File file) {
        if (FilesystemHandler.ignoringEvents()) {
            return;
        }
        org.netbeans.modules.versioning.util.Utils.post((Runnable)new Runnable(){

            public void run() {
                FilesystemHandler.this.fileCreatedImpl(file);
            }
        });
    }

    public void afterChange(final File file) {
        if (FilesystemHandler.ignoringEvents()) {
            return;
        }
        org.netbeans.modules.versioning.util.Utils.post((Runnable)new Runnable(){

            public void run() {
                FilesystemHandler.this.cache.refreshCached(file, 0);
                if (file.getName().equals(".cvsignore")) {
                    FilesystemHandler.this.cache.directoryContentChanged(file.getParentFile());
                }
            }
        });
    }

    private void fileCreatedImpl(File file) {
        if (file == null) {
            return;
        }
        int status = this.cache.refresh(file, 0).getStatus();
        if ((status & 0xFFFFFFFE) == 0) {
            return;
        }
        if (status == 256) {
            StandardAdminHandler sah = new StandardAdminHandler();
            Entry entry = null;
            try {
                entry = sah.getEntry(file);
            }
            catch (IOException e) {
                // empty catch block
            }
            if (entry != null && !entry.isDirectory() && entry.isUserFileToBeRemoved()) {
                this.cvsUndoRemoveLocally((AdminHandler)sah, file, entry);
            }
            this.cache.refresh(file, 0);
        }
        if (file.getName().equals(".cvsignore")) {
            this.cache.directoryContentChanged(file.getParentFile());
        }
        if (file.isDirectory()) {
            this.cache.directoryContentChanged(file);
        }
    }

    private void fileDeletedImpl(File file) {
        if (file == null) {
            return;
        }
        StandardAdminHandler sah = new StandardAdminHandler();
        Entry entry = null;
        try {
            entry = sah.getEntry(file);
        }
        catch (IOException e) {
            // empty catch block
        }
        if (entry != null && !entry.isDirectory() && !entry.isUserFileToBeRemoved()) {
            this.cvsRemoveLocally((AdminHandler)sah, file, entry);
        }
        this.cache.refresh(file, 0);
        if (file.getName().equals(".cvsignore")) {
            this.cache.directoryContentChanged(file.getParentFile());
        }
    }

    private void cvsRemoveLocally(AdminHandler ah, File file, Entry entry) {
        try {
            if (entry.isNewUserFile()) {
                ah.removeEntry(file);
            } else {
                entry.setRevision("-" + entry.getRevision());
                entry.setConflict("dummy timestamp");
                ah.setEntry(file, entry);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void cvsUndoRemoveLocally(AdminHandler ah, File file, Entry entry) {
        entry.setRevision(entry.getRevision().substring(1));
        entry.setConflict(Entry.getLastModifiedDateFormatter().format(new Date(System.currentTimeMillis() - 1000L)));
        try {
            ah.setEntry(file, entry);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void refresh(List<File> files) {
        for (File file : files) {
            this.cache.refresh(file, 0, true);
        }
    }

    private boolean hasMetadata(File file) {
        return new File(file, "CVS/Repository").canRead();
    }

    static void ignoreEvents(boolean ignore) {
        ignoredThread = ignore ? Thread.currentThread() : null;
    }

    private static boolean ignoringEvents() {
        return ignoredThread == Thread.currentThread();
    }
}

