/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.commit;

import java.awt.Dialog;
import java.awt.event.WindowListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import org.netbeans.lib.cvsclient.command.KeywordSubstitutionOptions;
import org.netbeans.lib.cvsclient.command.add.AddCommand;
import org.netbeans.lib.cvsclient.command.commit.CommitCommand;
import org.netbeans.lib.cvsclient.command.remove.RemoveCommand;
import org.netbeans.modules.versioning.system.cvss.CvsFileNode;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.executor.RemoveExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.actions.AbstractSystemAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.add.AddExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitOptions;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitSettings;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.netbeans.modules.versioning.util.DialogBoundsPreserver;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitAction
extends AbstractSystemAction {
    static final String RECENT_COMMIT_MESSAGES = "commitAction.commitMessage";

    public CommitAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    @Override
    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_MenuItem_Commit";
    }

    @Override
    protected boolean enable(Node[] nodes) {
        return CvsVersioningSystem.getInstance().getFileTableModel(Utils.getCurrentContext(nodes), 6612).getNodes().length > 0;
    }

    public static void invokeCommit(String contentTitle, Context context, String runningName) {
        ResourceBundle loc = NbBundle.getBundle(CommitAction.class);
        if (CvsVersioningSystem.getInstance().getFileTableModel(context, 6612).getNodes().length == 0) {
            JOptionPane.showMessageDialog(null, loc.getString("MSG_NoFilesToCommit_Prompt"), loc.getString("MSG_NoFilesToCommit_Title"), 1);
            return;
        }
        CommitCommand cmd = new CommitCommand();
        cmd.setDisplayName(NbBundle.getMessage(CommitAction.class, (String)"BK0001"));
        final CommitSettings settings = new CommitSettings();
        final JButton commit = new JButton(loc.getString("CTL_CommitForm_Action_Commit"));
        commit.setToolTipText(NbBundle.getMessage(CommitAction.class, (String)"TT_CommitDialog_Action_Commit"));
        commit.setEnabled(false);
        JButton cancel = new JButton(loc.getString("CTL_CommitForm_Action_Cancel"));
        cancel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommitAction.class, (String)"ACSD_CommitDialog_Action_Cancel"));
        DialogDescriptor descriptor = new DialogDescriptor((Object)settings, MessageFormat.format(loc.getString("CTL_CommitDialog_Title"), contentTitle), true, new Object[]{commit, cancel}, (Object)commit, 0, null, null);
        descriptor.setClosingOptions(null);
        descriptor.setHelpCtx(new HelpCtx(CommitSettings.class));
        settings.addVersioningListener(new VersioningListener(){

            public void versioningEvent(VersioningEvent event) {
                CommitAction.refreshCommitDialog(settings, commit);
            }
        });
        CommitAction.setupNodes(settings, context);
        settings.putClientProperty("contentTitle", contentTitle);
        settings.putClientProperty("DialogDescriptor", descriptor);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.addWindowListener((WindowListener)new DialogBoundsPreserver(CvsModuleConfig.getDefault().getPreferences(), "svn.commit.dialog"));
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommitAction.class, (String)"ACSD_CommitDialog"));
        dialog.setVisible(true);
        if (descriptor.getValue() != commit) {
            return;
        }
        CommitAction.saveExclusions(settings);
        cmd.setMessage(settings.getCommitMessage());
        org.netbeans.modules.versioning.util.Utils.insert((Preferences)CvsModuleConfig.getDefault().getPreferences(), (String)RECENT_COMMIT_MESSAGES, (String)cmd.getMessage(), (int)20);
        if (runningName == null) {
            runningName = NbBundle.getMessage(CommitAction.class, (String)"BK0002");
        }
        ExecutorGroup group = new ExecutorGroup(runningName);
        CommitAction.addCommit(group, settings);
        group.execute();
    }

    private static void saveExclusions(CommitSettings settings) {
        CommitSettings.CommitFile[] files = settings.getCommitFiles();
        for (int i = 0; i < files.length; ++i) {
            CommitSettings.CommitFile file = files[i];
            if (file.getOptions() == CommitOptions.EXCLUDE) {
                CvsModuleConfig.getDefault().addExclusion(file.getNode().getFile());
                continue;
            }
            CvsModuleConfig.getDefault().removeExclusion(file.getNode().getFile());
        }
    }

    private static void setupNodes(CommitSettings settings, Context context) {
        CvsFileNode[] filesToCommit = CvsVersioningSystem.getInstance().getFileTableModel(context, 6612).getNodes();
        settings.setNodes(filesToCommit);
    }

    private static void refreshCommitDialog(CommitSettings settings, JButton commit) {
        String errorLabel;
        String msg;
        ResourceBundle loc = NbBundle.getBundle(CommitAction.class);
        CommitSettings.CommitFile[] files = settings.getCommitFiles();
        HashSet<String> stickyTags = new HashSet<String>();
        boolean conflicts = false;
        for (int i = 0; i < files.length; ++i) {
            CommitSettings.CommitFile file = files[i];
            if (file.getOptions() == CommitOptions.EXCLUDE) continue;
            stickyTags.add(Utils.getSticky(file.getNode().getFile()));
            int status = file.getNode().getInformation().getStatus();
            if ((status & 0x6A0) != 0 || status == 64) {
                commit.setEnabled(false);
                msg = status == 64 ? loc.getString("MSG_CommitForm_ErrorConflicts") : loc.getString("MSG_CommitForm_ErrorRemoteChanges");
                settings.setErrorLabel("<html><font color=\"#002080\">" + msg + "</font></html>");
                conflicts = true;
            }
            stickyTags.add(Utils.getSticky(file.getNode().getFile()));
        }
        if (stickyTags.size() > 1) {
            settings.setColumns(new String[]{"name", "sticky", "status", "action", "path"});
        } else {
            settings.setColumns(new String[]{"name", "status", "action", "path"});
        }
        String contentTitle = (String)settings.getClientProperty("contentTitle");
        DialogDescriptor dd = (DialogDescriptor)settings.getClientProperty("DialogDescriptor");
        if (stickyTags.size() <= 1) {
            String stickyTag;
            String string = stickyTag = stickyTags.size() == 0 ? null : (String)stickyTags.iterator().next();
            if (stickyTag == null) {
                dd.setTitle(MessageFormat.format(loc.getString("CTL_CommitDialog_Title"), contentTitle));
                errorLabel = "";
            } else {
                stickyTag = stickyTag.substring(1);
                dd.setTitle(MessageFormat.format(loc.getString("CTL_CommitDialog_Title_Branch"), contentTitle, stickyTag));
                String msg2 = MessageFormat.format(loc.getString("MSG_CommitForm_InfoBranch"), stickyTag);
                errorLabel = "<html><font color=\"#002080\">" + msg2 + "</font></html>";
            }
        } else {
            dd.setTitle(MessageFormat.format(loc.getString("CTL_CommitDialog_Title_Branches"), contentTitle));
            msg = loc.getString("MSG_CommitForm_ErrorMultipleBranches");
            errorLabel = "<html><font color=\"#CC0000\">" + msg + "</font></html>";
        }
        if (!conflicts) {
            settings.setErrorLabel(errorLabel);
            commit.setEnabled(true);
        }
    }

    @Override
    public void performCvsAction(Node[] nodes) {
        CommitAction.invokeCommit(this.getContextDisplayName(nodes), this.getContext(nodes), this.getRunningName(nodes));
    }

    protected boolean asynchronous() {
        return false;
    }

    public static void addCommit(ExecutorGroup group, CommitSettings settings) {
        FileStatusCache cache = CvsVersioningSystem.getInstance().getStatusCache();
        CommitSettings.CommitFile[] files = settings.getCommitFiles();
        ArrayList<File> commitBucket = new ArrayList<File>();
        ArrayList<File> addDefaultBucket = new ArrayList<File>();
        ArrayList<File> addKkvBucket = new ArrayList<File>();
        ArrayList<File> addKkvlBucket = new ArrayList<File>();
        ArrayList<File> addKkBucket = new ArrayList<File>();
        ArrayList<File> addKoBucket = new ArrayList<File>();
        ArrayList<File> addKbBucket = new ArrayList<File>();
        ArrayList<File> addKvBucket = new ArrayList<File>();
        ArrayList<File> removeBucket = new ArrayList<File>();
        for (int i = 0; i < files.length; ++i) {
            int status;
            CommitSettings.CommitFile file = files[i];
            if (file.getOptions() == CommitOptions.EXCLUDE) continue;
            if (file.getOptions() == CommitOptions.ADD_TEXT) {
                addDefaultBucket.add(file.getNode().getFile());
            } else if (file.getOptions() == CommitOptions.ADD_BINARY) {
                addKbBucket.add(file.getNode().getFile());
            } else if (file.getOptions() == CommitOptions.COMMIT_REMOVE && (status = cache.getStatus(file.getNode().getFile()).getStatus()) == 2048) {
                removeBucket.add(file.getNode().getFile());
            }
            commitBucket.add(file.getNode().getFile());
        }
        group.addExecutors(CommitAction.createAdd(addDefaultBucket, null));
        group.addExecutors(CommitAction.createAdd(addKkvBucket, KeywordSubstitutionOptions.DEFAULT));
        group.addExecutors(CommitAction.createAdd(addKkvlBucket, KeywordSubstitutionOptions.DEFAULT_LOCKER));
        group.addExecutors(CommitAction.createAdd(addKkBucket, KeywordSubstitutionOptions.ONLY_KEYWORDS));
        group.addExecutors(CommitAction.createAdd(addKoBucket, KeywordSubstitutionOptions.OLD_VALUES));
        group.addExecutors(CommitAction.createAdd(addKbBucket, KeywordSubstitutionOptions.BINARY));
        group.addExecutors(CommitAction.createAdd(addKvBucket, KeywordSubstitutionOptions.ONLY_VALUES));
        group.addExecutors(CommitAction.createRemove(removeBucket));
        group.addExecutors(CommitAction.createCommit(commitBucket, settings.getCommitMessage()));
    }

    private static ExecutorSupport[] createCommit(List<File> bucket, String message) {
        if (bucket.size() == 0) {
            return null;
        }
        CommitCommand cmd = new CommitCommand();
        cmd.setFiles(bucket.toArray(new File[bucket.size()]));
        cmd.setMessage(org.netbeans.modules.versioning.util.Utils.wordWrap((String)message, (int)CvsModuleConfig.getDefault().getWrapCommitMessagelength()));
        return CommitExecutor.splitCommand(cmd, CvsVersioningSystem.getInstance(), null);
    }

    private static ExecutorSupport[] createRemove(List<File> bucket) {
        if (bucket.size() == 0) {
            return null;
        }
        RemoveCommand cmd = new RemoveCommand();
        cmd.setFiles(bucket.toArray(new File[bucket.size()]));
        return RemoveExecutor.splitCommand(cmd, CvsVersioningSystem.getInstance(), null);
    }

    private static ExecutorSupport[] createAdd(List<File> bucket, KeywordSubstitutionOptions option) {
        if (bucket.size() == 0) {
            return null;
        }
        AddCommand cmd = new AddCommand();
        cmd.setFiles(bucket.toArray(new File[bucket.size()]));
        cmd.setKeywordSubst(option);
        return AddExecutor.splitCommand(cmd, CvsVersioningSystem.getInstance(), null);
    }
}

