/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.commit;

import java.awt.Component;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.versioning.system.cvss.CvsFileNode;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitOptions;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitSettings;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitTableModel;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.netbeans.modules.versioning.util.FilePathCellRenderer;
import org.netbeans.modules.versioning.util.TableSorter;
import org.openide.util.NbBundle;

class CommitTable
implements AncestorListener,
TableModelListener {
    private CommitTableModel tableModel = new CommitTableModel();
    private JTable table;
    private JComponent component;
    private TableSorter sorter;
    private String[] columns;

    public CommitTable(JLabel label) {
        this.tableModel.addTableModelListener(this);
        this.sorter = new TableSorter((TableModel)this.tableModel);
        this.table = new JTable((TableModel)this.sorter);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setDefaultRenderer(String.class, new CommitStringsCellRenderer());
        this.table.setDefaultEditor(CommitOptions.class, new CommitOptionsCellEditor());
        this.table.getTableHeader().setReorderingAllowed(true);
        this.sorter.setTableHeader(this.table.getTableHeader());
        int height = new JLabel((String)"FONTSIZE").getPreferredSize().height * 6 / 5;
        this.table.setRowHeight(height);
        this.table.addAncestorListener(this);
        this.component = new JScrollPane(this.table, 22, 31);
        label.setLabelFor(this.table);
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommitTable.class, (String)"ACSD_CommitTable"));
    }

    public void ancestorAdded(AncestorEvent event) {
        this.setDefaultColumnSizes();
    }

    private void setDefaultColumnSizes() {
        block12: {
            TableColumnModel columnModel;
            int width;
            block11: {
                width = this.table.getWidth();
                columnModel = this.table.getColumnModel();
                if (this.columns == null || columnModel == null) {
                    return;
                }
                if (columnModel.getColumnCount() != this.columns.length) {
                    return;
                }
                if (this.columns.length != 4) break block11;
                for (int i = 0; i < this.columns.length; ++i) {
                    String col = this.columns[i];
                    this.sorter.setColumnComparator(i, null);
                    this.sorter.setSortingStatus(i, 0);
                    if (col.equals("name")) {
                        this.sorter.setColumnComparator(i, (Comparator)new FileNameComparator());
                        columnModel.getColumn(i).setPreferredWidth(width * 30 / 100);
                        continue;
                    }
                    if (col.equals("status")) {
                        this.sorter.setColumnComparator(i, (Comparator)new StatusComparator());
                        this.sorter.setSortingStatus(i, 1);
                        columnModel.getColumn(i).setPreferredWidth(width * 15 / 100);
                        continue;
                    }
                    if (col.equals("action")) {
                        columnModel.getColumn(i).setPreferredWidth(width * 15 / 100);
                        continue;
                    }
                    columnModel.getColumn(i).setPreferredWidth(width * 40 / 100);
                }
                break block12;
            }
            if (this.columns.length != 5) break block12;
            for (int i = 0; i < this.columns.length; ++i) {
                String col = this.columns[i];
                this.sorter.setColumnComparator(i, null);
                this.sorter.setSortingStatus(i, 0);
                if (col.equals("name")) {
                    this.sorter.setColumnComparator(i, (Comparator)new FileNameComparator());
                    columnModel.getColumn(i).setPreferredWidth(width * 25 / 100);
                    continue;
                }
                if (col.equals("sticky")) {
                    columnModel.getColumn(i).setPreferredWidth(width * 15 / 100);
                    continue;
                }
                if (col.equals("status")) {
                    this.sorter.setColumnComparator(i, (Comparator)new StatusComparator());
                    this.sorter.setSortingStatus(i, 1);
                    columnModel.getColumn(i).setPreferredWidth(width * 15 / 100);
                    continue;
                }
                if (col.equals("action")) {
                    columnModel.getColumn(i).setPreferredWidth(width * 15 / 100);
                    continue;
                }
                columnModel.getColumn(i).setPreferredWidth(width * 30 / 100);
            }
        }
    }

    public void ancestorMoved(AncestorEvent event) {
    }

    public void ancestorRemoved(AncestorEvent event) {
    }

    void setColumns(String[] cols) {
        if (Arrays.equals(this.columns, cols)) {
            return;
        }
        this.columns = cols;
        this.tableModel.setColumns(cols);
        this.setDefaultColumnSizes();
    }

    void setNodes(CvsFileNode[] nodes) {
        this.tableModel.setNodes(nodes);
    }

    public CommitSettings.CommitFile[] getCommitFiles() {
        return this.tableModel.getCommitFiles();
    }

    public JComponent getComponent() {
        return this.component;
    }

    void dataChanged() {
        int idx = this.table.getSelectedRow();
        this.tableModel.fireTableDataChanged();
        if (idx != -1) {
            this.table.getSelectionModel().addSelectionInterval(idx, idx);
        }
    }

    TableModel getTableModel() {
        return this.tableModel;
    }

    public void tableChanged(TableModelEvent e) {
        this.table.repaint();
    }

    private class CommitOptionsCellEditor
    extends DefaultCellEditor {
        private final Object[] addOptions;
        private final Object[] commitOptions;
        private final Object[] removeOptions;

        public CommitOptionsCellEditor() {
            super(new JComboBox());
            this.addOptions = new Object[]{CommitOptions.ADD_TEXT, CommitOptions.ADD_BINARY, CommitOptions.EXCLUDE};
            this.commitOptions = new Object[]{CommitOptions.COMMIT, CommitOptions.EXCLUDE};
            this.removeOptions = new Object[]{CommitOptions.COMMIT_REMOVE, CommitOptions.EXCLUDE};
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            int fileStatus = CommitTable.this.tableModel.getCommitFile(CommitTable.this.sorter.modelIndex(row)).getNode().getInformation().getStatus();
            JComboBox combo = (JComboBox)this.editorComponent;
            if (fileStatus == 2048 || fileStatus == 256) {
                combo.setModel(new DefaultComboBoxModel<Object>(this.removeOptions));
            } else if ((fileStatus & 0xFF8) == 0) {
                combo.setModel(new DefaultComboBoxModel<Object>(this.addOptions));
            } else {
                combo.setModel(new DefaultComboBoxModel<Object>(this.commitOptions));
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    private static class CommitStringsCellRenderer
    extends DefaultTableCellRenderer {
        private FilePathCellRenderer pathRenderer = new FilePathCellRenderer();

        private CommitStringsCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int col = table.convertColumnIndexToModel(column);
            if (col == 0) {
                TableSorter sorter = (TableSorter)table.getModel();
                CommitTableModel model = (CommitTableModel)sorter.getTableModel();
                CommitSettings.CommitFile commitFile = model.getCommitFile(sorter.modelIndex(row));
                if (!isSelected) {
                    value = "<html>" + CvsVersioningSystem.getInstance().getAnnotator().annotateNameHtml(commitFile.getNode().getFile().getName(), commitFile.getNode().getInformation(), null);
                }
                if (commitFile.getOptions() == CommitOptions.EXCLUDE) {
                    value = "<html><s>" + value + "</s></html>";
                }
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            if (col == 3) {
                return this.pathRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private class FileNameComparator
    implements Comparator {
        private FileNameComparator() {
        }

        public int compare(Object o1, Object o2) {
            Integer row1 = (Integer)o1;
            Integer row2 = (Integer)o2;
            return CommitTable.this.tableModel.getCommitFile(row1).getNode().getName().compareToIgnoreCase(CommitTable.this.tableModel.getCommitFile(row2).getNode().getName());
        }
    }

    private class StatusComparator
    extends Utils.ByImportanceComparator {
        private StatusComparator() {
        }

        public int compare(Object o1, Object o2) {
            Integer row1 = (Integer)o1;
            Integer row2 = (Integer)o2;
            return super.compare(CommitTable.this.tableModel.getCommitFile(row1).getNode().getInformation(), CommitTable.this.tableModel.getCommitFile(row2).getNode().getInformation());
        }
    }
}

