/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.commit;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public class ExcludeFromCommitAction
extends AbstractAction
implements Presenter.Menu {
    private final VCSContext ctx;
    private final int status;

    public ExcludeFromCommitAction(VCSContext ctx) {
        this.ctx = ctx;
        this.putValue("Name", NbBundle.getBundle(ExcludeFromCommitAction.class).getString("CTL_MenuItem_ExcludeFromCommit"));
        this.status = this.getActionStatus();
        if (this.status == 1) {
            this.putValue("BooleanState.Selected", Boolean.FALSE);
        } else if (this.status == 2) {
            this.putValue("BooleanState.Selected", Boolean.TRUE);
        }
        this.setEnabled(this.status != -1);
    }

    public JMenuItem getMenuPresenter() {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(this);
        if (this.status != -1) {
            item.setSelected(this.status == 2);
        }
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        return item;
    }

    private int getActionStatus() {
        CvsModuleConfig config = CvsModuleConfig.getDefault();
        Set files = this.ctx.getRootFiles();
        int status = -1;
        for (File file : files) {
            if (config.isExcludedFromCommit(file)) {
                if (status == 1) {
                    return -1;
                }
                status = 2;
                continue;
            }
            if (status == 2) {
                return -1;
            }
            status = 1;
        }
        return status;
    }

    public void actionPerformed(ActionEvent e) {
        CvsModuleConfig config = CvsModuleConfig.getDefault();
        Set files = this.ctx.getRootFiles();
        for (File file : files) {
            if (this.status == 1) {
                config.addExclusion(file);
                continue;
            }
            if (this.status != 2) continue;
            config.removeExclusion(file);
        }
    }
}

