/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.diff;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.diff.Difference;
import org.netbeans.modules.diff.builtin.visualizer.TextDiffVisualizer;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.ui.actions.AbstractSystemAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffSetupSource;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.Setup;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.util.AccessibleJFileChooser;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.spi.diff.DiffProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class ExportDiffAction
extends AbstractSystemAction {
    private static final int enabledForStatus = 6548;

    public ExportDiffAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_MenuItem_ExportDiff";
    }

    public String getName() {
        String setupName;
        TopComponent activated = TopComponent.getRegistry().getActivated();
        if (activated instanceof DiffSetupSource && (setupName = ((DiffSetupSource)activated).getSetupDisplayName()) != null) {
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)(this.getBaseName(this.getActivatedNodes()) + "_Context"), (Object)setupName);
        }
        return super.getName();
    }

    protected int getFileEnabledStatus() {
        return 6548;
    }

    public boolean enable(Node[] nodes) {
        TopComponent activated = TopComponent.getRegistry().getActivated();
        if (activated instanceof DiffSetupSource) {
            return true;
        }
        return super.enable(nodes) && Lookup.getDefault().lookup(DiffProvider.class) != null;
    }

    public void performCvsAction(Node[] nodes) {
        boolean noop;
        TopComponent activated = TopComponent.getRegistry().getActivated();
        if (activated instanceof DiffSetupSource) {
            noop = ((DiffSetupSource)activated).getSetups().isEmpty();
        } else {
            Context context = this.getContext(nodes);
            File[] files = DiffExecutor.getModifiedFiles(context, 6612);
            boolean bl = noop = files.length == 0;
        }
        if (noop) {
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ExportDiffAction.class, (String)"BK3001"), 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
            return;
        }
        AccessibleJFileChooser chooser = new AccessibleJFileChooser(NbBundle.getMessage(ExportDiffAction.class, (String)"ACSD_Export"));
        chooser.setDialogTitle(NbBundle.getMessage(ExportDiffAction.class, (String)"CTL_Export_Title"));
        chooser.setMultiSelectionEnabled(false);
        FileFilter[] old = chooser.getChoosableFileFilters();
        for (int i = 0; i < old.length; ++i) {
            FileFilter fileFilter = old[i];
            chooser.removeChoosableFileFilter(fileFilter);
        }
        chooser.setCurrentDirectory(new File(CvsModuleConfig.getDefault().getPreferences().get("ExportDiff.saveFolder", System.getProperty("user.home"))));
        chooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.getName().endsWith("diff") || f.getName().endsWith("patch") || f.isDirectory();
            }

            public String getDescription() {
                return NbBundle.getMessage(ExportDiffAction.class, (String)"BK3002");
            }
        });
        chooser.setDialogType(1);
        chooser.setApproveButtonMnemonic(NbBundle.getMessage(ExportDiffAction.class, (String)"MNE_Export_ExportAction").charAt(0));
        chooser.setApproveButtonText(NbBundle.getMessage(ExportDiffAction.class, (String)"CTL_Export_ExportAction"));
        DialogDescriptor dd = new DialogDescriptor((Object)chooser, NbBundle.getMessage(ExportDiffAction.class, (String)"CTL_Export_Title"));
        dd.setOptions(new Object[0]);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        chooser.addActionListener(new ActionListener((JFileChooser)chooser, nodes, dialog){
            final /* synthetic */ JFileChooser val$chooser;
            final /* synthetic */ Node[] val$nodes;
            final /* synthetic */ Dialog val$dialog;
            {
                this.val$chooser = jFileChooser;
                this.val$nodes = nodeArray;
                this.val$dialog = dialog;
            }

            public void actionPerformed(ActionEvent e) {
                String state = e.getActionCommand();
                if (state.equals("ApproveSelection")) {
                    File destination = this.val$chooser.getSelectedFile();
                    String name = destination.getName();
                    boolean requiredExt = false;
                    requiredExt |= name.endsWith(".diff");
                    requiredExt |= name.endsWith(".dif");
                    if (!(requiredExt |= name.endsWith(".patch"))) {
                        File parent = destination.getParentFile();
                        destination = new File(parent, name + ".patch");
                    }
                    if (destination.exists()) {
                        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ExportDiffAction.class, (String)"BK3005", (Object)destination.getAbsolutePath()));
                        nd.setOptionType(0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                        if (!nd.getValue().equals(NotifyDescriptor.OK_OPTION)) {
                            return;
                        }
                    }
                    CvsModuleConfig.getDefault().getPreferences().put("ExportDiff.saveFolder", destination.getParent());
                    final File out = destination;
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            ExportDiffAction.this.async(val$nodes, out);
                        }
                    });
                }
                this.val$dialog.dispose();
            }
        });
        dialog.setVisible(true);
    }

    protected boolean asynchronous() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void async(Node[] nodes, File destination) {
        boolean success = false;
        OutputStream out = null;
        int exportedFiles = 0;
        ExecutorGroup group = new ExecutorGroup(this.getRunningName(nodes));
        try {
            File root;
            Collection<Setup> setups;
            TopComponent activated = TopComponent.getRegistry().getActivated();
            if (activated instanceof DiffSetupSource) {
                setups = ((DiffSetupSource)activated).getSetups();
                ArrayList<File> setupFiles = new ArrayList<File>(setups.size());
                for (Setup setup : setups) {
                    setupFiles.add(setup.getBaseFile());
                }
                root = ExportDiffAction.getCommonParent(setupFiles.toArray(new File[setupFiles.size()]));
            } else {
                Context context = this.getContext(nodes);
                File[] files = DiffExecutor.getModifiedFiles(context, 6612);
                root = ExportDiffAction.getCommonParent(context.getRootFiles());
                setups = new ArrayList<Setup>(files.length);
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    Setup setup = new Setup(file, 0);
                    setups.add(setup);
                }
            }
            if (root == null) {
                NotifyDescriptor nd = new NotifyDescriptor((Object)NbBundle.getMessage(ExportDiffAction.class, (String)"MSG_BadSelection_Prompt"), NbBundle.getMessage(ExportDiffAction.class, (String)"MSG_BadSelection_Title"), -1, 0, null, null);
                DialogDisplayer.getDefault().notify(nd);
                return;
            }
            String sep = System.getProperty("line.separator");
            out = new BufferedOutputStream(new FileOutputStream(destination));
            out.write(("# This patch file was generated by NetBeans IDE" + sep).getBytes("utf8"));
            out.write(("# Following Index: paths are relative to: " + root.getAbsolutePath() + sep).getBytes("utf8"));
            out.write(("# This patch can be applied using context Tools: Patch action on respective folder." + sep).getBytes("utf8"));
            out.write(("# It uses platform neutral UTF-8 encoding and \\n newlines." + sep).getBytes("utf8"));
            out.write(("# Above lines and this line are ignored by the patching process." + sep).getBytes("utf8"));
            Iterator<Setup> it = setups.iterator();
            int i = 0;
            while (it.hasNext()) {
                Setup setup = it.next();
                File file = setup.getBaseFile();
                group.progress(file.getName());
                String index = "Index: ";
                String rootPath = root.getAbsolutePath();
                String filePath = file.getAbsolutePath();
                if (filePath.startsWith(rootPath)) {
                    index = index + filePath.substring(rootPath.length() + 1).replace(File.separatorChar, '/') + sep;
                    out.write(index.getBytes("utf8"));
                }
                this.exportDiff(group, setup, out);
                ++i;
            }
            exportedFiles = i;
            success = true;
        }
        catch (IOException ex) {
            ErrorManager.getDefault().annotate((Throwable)ex, NbBundle.getMessage(ExportDiffAction.class, (String)"BK3003"));
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            ErrorManager.getDefault().notify(256, (Throwable)ex);
        }
        finally {
            group.executed();
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException alreadyClsoed) {}
            }
            if (success) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ExportDiffAction.class, (String)"BK3004", (Object)new Integer(exportedFiles)));
                if (exportedFiles == 0) {
                    destination.delete();
                }
            } else {
                destination.delete();
            }
        }
    }

    private static File getCommonParent(File[] files) {
        File root = files[0];
        if (root.isFile()) {
            root = root.getParentFile();
        }
        for (int i = 1; i < files.length; ++i) {
            if ((root = Utils.getCommonParent((File)root, (File)files[i])) != null) continue;
            return null;
        }
        return root;
    }

    private void exportDiff(ExecutorGroup group, Setup setup, OutputStream out) throws IOException {
        int i;
        Reader r2;
        setup.initSources(group);
        DiffProvider diff = (DiffProvider)Lookup.getDefault().lookup(DiffProvider.class);
        Reader r1 = setup.getFirstSource().createReader();
        if (r1 == null) {
            r1 = new StringReader("");
        }
        if ((r2 = setup.getSecondSource().createReader()) == null) {
            r2 = new StringReader("");
        }
        Difference[] differences = diff.computeDiff(r1, r2);
        File file = setup.getBaseFile();
        String name = file.getAbsolutePath();
        r1 = setup.getFirstSource().createReader();
        if (r1 == null) {
            r1 = new StringReader("");
        }
        if ((r2 = setup.getSecondSource().createReader()) == null) {
            r2 = new StringReader("");
        }
        TextDiffVisualizer.TextDiffInfo info = new TextDiffVisualizer.TextDiffInfo(name + " " + setup.getFirstSource().getTitle(), name + " " + setup.getSecondSource().getTitle(), null, null, r1, r2, differences);
        info.setContextMode(true, 3);
        InputStream is = TextDiffVisualizer.differenceToContextDiffText((TextDiffVisualizer.TextDiffInfo)info);
        while ((i = is.read()) != -1) {
            out.write(i);
        }
    }
}

