/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.log;

import java.io.File;
import java.util.Calendar;
import java.util.Date;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.versioning.system.cvss.ui.actions.AbstractSystemAction;
import org.netbeans.modules.versioning.system.cvss.ui.history.SearchHistoryTopComponent;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class SearchHistoryAction
extends AbstractSystemAction {
    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_MenuItem_SearchHistory";
    }

    protected int getFileEnabledStatus() {
        return 4088;
    }

    protected int getDirectoryEnabledStatus() {
        return -8;
    }

    protected boolean asynchronous() {
        return false;
    }

    public void performCvsAction(Node[] nodes) {
        String title = NbBundle.getMessage(SearchHistoryAction.class, (String)"CTL_SearchHistory_Title", (Object)this.getContextDisplayName(nodes));
        this.openHistory(this.getContext(nodes), title);
    }

    private void openHistory(final Context context, final String title) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SearchHistoryTopComponent tc = new SearchHistoryTopComponent(context);
                tc.setDisplayName(title);
                tc.open();
                tc.requestActive();
                File[] files = context.getFiles();
                if (files.length == 1 && files[0].isFile() || files.length > 1 && org.netbeans.modules.versioning.util.Utils.shareCommonDataObject((File[])files)) {
                    tc.search();
                }
            }
        });
    }

    public static void openSearch(String title, String commitMessage, String username, Date date) {
        SearchHistoryAction.openSearch(SearchHistoryAction.getDefaultContext(), title, commitMessage, username, date);
    }

    public static void openSearch(Context context, String title, String commitMessage, String username, Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, 1);
        Date to = c.getTime();
        c.setTime(date);
        c.add(5, -1);
        Date from = c.getTime();
        if (commitMessage != null && commitMessage.indexOf(10) != -1) {
            commitMessage = commitMessage.substring(0, commitMessage.indexOf(10));
        }
        SearchHistoryTopComponent tc = new SearchHistoryTopComponent(context, commitMessage, username, from, to);
        String tcTitle = NbBundle.getMessage(SearchHistoryAction.class, (String)"CTL_SearchHistory_Title", (Object)title);
        tc.setDisplayName(tcTitle);
        tc.open();
        tc.requestActive();
        tc.search();
    }

    private static Context getDefaultContext() {
        Project[] projects = OpenProjects.getDefault().getOpenProjects();
        return Utils.getProjectsContext(projects);
    }
}

