/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.project;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.UpdateExecutor;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.windows.WindowManager;

public final class UpdateWithDependenciesAction
extends SystemAction {
    public UpdateWithDependenciesAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public void actionPerformed(ActionEvent ev) {
        this.setEnabled(false);
        final Node[] nodes = WindowManager.getDefault().getRegistry().getActivatedNodes();
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                UpdateWithDependenciesAction.this.async(nodes);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void async(Node[] nodes) {
        ExecutorGroup group = new ExecutorGroup(NbBundle.getMessage(UpdateWithDependenciesAction.class, (String)"BK2001"));
        try {
            group.progress(NbBundle.getMessage(UpdateWithDependenciesAction.class, (String)"BK2002"));
            HashSet projects = new HashSet();
            LinkedHashSet contexts = new LinkedHashSet();
            for (int i = 0; i < nodes.length; ++i) {
                Node node = nodes[i];
                Project project = (Project)node.getLookup().lookup(Project.class);
                UpdateWithDependenciesAction.addUpdateContexts(contexts, project, projects);
            }
            if (contexts.size() > 0) {
                Context context = new Context(new HashSet(), new HashSet(), new HashSet());
                for (Context cx : contexts) {
                    context = context.union(cx);
                }
                UpdateCommand updateCommand = new UpdateCommand();
                updateCommand.setBuildDirectories(true);
                updateCommand.setPruneDirectories(true);
                updateCommand.setFiles(context.getFiles());
                GlobalOptions gtx = CvsVersioningSystem.createGlobalOptions();
                gtx.setExclusions(context.getExclusions().toArray(new File[0]));
                group.addExecutors(UpdateExecutor.splitCommand(updateCommand, CvsVersioningSystem.getInstance(), gtx, org.netbeans.modules.versioning.util.Utils.getContextDisplayName((VCSContext)VCSContext.forNodes((Node[])nodes))));
                group.execute();
            }
        }
        finally {
            this.setEnabled(true);
        }
    }

    public boolean isEnabled() {
        Node[] nodes = WindowManager.getDefault().getRegistry().getActivatedNodes();
        for (int i = 0; i < nodes.length; ++i) {
            Node node = nodes[i];
            if (Utils.isVersionedProject(node)) continue;
            return false;
        }
        return nodes.length > 0;
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        return NbBundle.getMessage(UpdateWithDependenciesAction.class, (String)"CTL_MenuItem_UpdateWithDependencies");
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    private static void addUpdateContexts(Collection contexts, Project project, Set updatedProjects) {
        if (updatedProjects.contains(project)) {
            return;
        }
        updatedProjects.add(project);
        Context ctx = UpdateWithDependenciesAction.createProjectContext(project);
        if (ctx.getFiles().length > 0) {
            contexts.add(ctx);
        }
        SubprojectProvider deps = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
        for (Project subProject : deps.getSubprojects()) {
            UpdateWithDependenciesAction.addUpdateContexts(contexts, subProject, updatedProjects);
        }
    }

    private static Context createProjectContext(Project project) {
        HashSet files = new HashSet();
        HashSet roots = new HashSet();
        HashSet excludes = new HashSet();
        Utils.addProjectFiles(files, roots, excludes, project);
        Iterator it = files.iterator();
        while (it.hasNext()) {
            File file = (File)it.next();
            File probe = null;
            if (file.isDirectory()) {
                probe = new File(file, "CVS/Repository");
            }
            if (file.isFile()) {
                probe = new File(file.getParentFile(), "CVS/Repository");
            }
            if (probe != null && probe.isFile()) continue;
            it.remove();
        }
        return new Context(files, roots, excludes);
    }
}

