/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.update;

import java.awt.BorderLayout;
import java.awt.Component;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import org.netbeans.lib.cvsclient.command.DefaultFileInfoContainer;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.UpdateResultNode;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.UpdateResultsTable;
import org.netbeans.modules.versioning.util.NoContentPanel;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UpdateResults
extends JComponent {
    private final List<DefaultFileInfoContainer> updates;

    public UpdateResults(List<DefaultFileInfoContainer> output, String cvsRoot, String contextDisplayName) {
        this.updates = this.filter(output);
        String time = DateFormat.getTimeInstance().format(new Date());
        this.setName(NbBundle.getMessage(UpdateResults.class, (String)"CTL_UpdateResults_Title", (Object)cvsRoot, (Object)contextDisplayName, (Object)time));
        this.setLayout(new BorderLayout());
        if (this.updates.size() == 0) {
            this.add((Component)new NoContentPanel(NbBundle.getMessage(UpdateResults.class, (String)"MSG_NoFilesUpdated")));
        } else {
            UpdateResultsTable urt = new UpdateResultsTable();
            urt.setTableModel(this.createNodes());
            this.add(urt.getComponent());
        }
    }

    private List<DefaultFileInfoContainer> filter(List<DefaultFileInfoContainer> l) {
        ArrayList<DefaultFileInfoContainer> list = new ArrayList<DefaultFileInfoContainer>(l.size());
        for (DefaultFileInfoContainer update : l) {
            if ("UPGYC".indexOf(update.getType()) == -1) continue;
            list.add(update);
        }
        return list;
    }

    private UpdateResultNode[] createNodes() {
        UpdateResultNode[] nodes = new UpdateResultNode[this.updates.size()];
        int idx = 0;
        for (DefaultFileInfoContainer info : this.updates) {
            nodes[idx++] = new UpdateResultNode(info);
        }
        return nodes;
    }
}

