/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.history;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffSetupSource;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.Setup;
import org.netbeans.modules.versioning.system.cvss.ui.history.DiffResultsView;
import org.netbeans.modules.versioning.system.cvss.ui.history.Divider;
import org.netbeans.modules.versioning.system.cvss.ui.history.SearchCriteriaPanel;
import org.netbeans.modules.versioning.system.cvss.ui.history.SearchExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.history.SummaryView;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.netbeans.modules.versioning.util.DelegatingUndoRedo;
import org.netbeans.modules.versioning.util.NoContentPanel;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SearchHistoryPanel
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener,
ActionListener,
DiffSetupSource {
    private final File[] roots;
    private final SearchCriteriaPanel criteria;
    private final DelegatingUndoRedo undoRedo = new DelegatingUndoRedo();
    private Divider divider;
    private RequestProcessor.Task currentSearchTask;
    private boolean criteriaVisible;
    private boolean searchInProgress;
    private List results;
    private List<Object> dispResults;
    private SummaryView summaryView;
    private DiffResultsView diffView;
    private AbstractAction nextAction;
    private AbstractAction prevAction;
    private Map<File, Project> fileProjects = new HashMap<File, Project>(100);
    private ExplorerManager explorerManager;
    private final Project NULL_PROJECT = new Project(){

        public FileObject getProjectDirectory() {
            return null;
        }

        public Lookup getLookup() {
            return null;
        }
    };
    private static final Comparator revisionsComparator = new ByRemotePathRevisionNumberComparator(){

        public int compare(Object o1, Object o2) {
            return super.compare(((DispRevision)o1).getRevision(), ((DispRevision)o2).getRevision());
        }
    };
    private JButton bNext;
    private JButton bPrev;
    private JButton bSearch;
    private ButtonGroup buttonGroup1;
    private JPanel jPanel1;
    private JSeparator jSeparator2;
    private JToolBar jToolBar1;
    private JPanel resultsPanel;
    private JPanel searchCriteriaPanel;
    private JToggleButton tbDiff;
    private JToggleButton tbSummary;

    public SearchHistoryPanel(File[] roots, SearchCriteriaPanel criteria) {
        this.roots = roots;
        this.criteria = criteria;
        this.criteriaVisible = true;
        this.explorerManager = new ExplorerManager();
        this.initComponents();
        this.setupComponents();
        this.refreshComponents(true);
    }

    private void setupComponents() {
        this.remove(this.jPanel1);
        this.divider = new Divider(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.divider, gridBagConstraints);
        this.searchCriteriaPanel.add(this.criteria);
        AbstractAction searchAction = new AbstractAction(NbBundle.getMessage(SearchHistoryPanel.class, (String)"CTL_Search")){
            {
                this.putValue("ShortDescription", NbBundle.getMessage(SearchHistoryPanel.class, (String)"TT_Search"));
            }

            public void actionPerformed(ActionEvent e) {
                SearchHistoryPanel.this.search();
            }
        };
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "search");
        this.getActionMap().put("search", searchAction);
        this.bSearch.setAction(searchAction);
        Mnemonics.setLocalizedText((AbstractButton)this.bSearch, (String)NbBundle.getMessage(SearchHistoryPanel.class, (String)"CTL_Search"));
        Dimension d1 = this.tbSummary.getPreferredSize();
        Dimension d2 = this.tbDiff.getPreferredSize();
        if (d1.width > d2.width) {
            this.tbDiff.setPreferredSize(d1);
        }
        this.nextAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/diff-next.png"))){
            {
                this.putValue("ShortDescription", ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/diff/Bundle").getString("CTL_DiffPanel_Next_Tooltip"));
            }

            public void actionPerformed(ActionEvent e) {
                SearchHistoryPanel.this.diffView.onNextButton();
            }
        };
        this.prevAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/diff-prev.png"))){
            {
                this.putValue("ShortDescription", ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/diff/Bundle").getString("CTL_DiffPanel_Prev_Tooltip"));
            }

            public void actionPerformed(ActionEvent e) {
                SearchHistoryPanel.this.diffView.onPrevButton();
            }
        };
        this.bNext.setAction(this.nextAction);
        this.bPrev.setAction(this.prevAction);
        this.getActionMap().put("jumpNext", this.nextAction);
        this.getActionMap().put("jumpPrev", this.prevAction);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getID() == 1) {
            this.criteriaVisible = !this.criteriaVisible;
            this.refreshComponents(false);
        }
    }

    void setSearchCriteriaVisible(boolean visible) {
        this.criteriaVisible = visible;
        this.refreshComponents(false);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedNodes".equals(evt.getPropertyName())) {
            TopComponent tc = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this);
            if (tc == null) {
                return;
            }
            tc.setActivatedNodes((Node[])evt.getNewValue());
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void removeNotify() {
        this.explorerManager.removePropertyChangeListener((PropertyChangeListener)this);
        super.removeNotify();
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    final void refreshComponents(boolean refreshResults) {
        if (refreshResults) {
            this.resultsPanel.removeAll();
            if (this.results == null) {
                if (this.searchInProgress) {
                    this.resultsPanel.add((Component)new NoContentPanel(NbBundle.getMessage(SearchHistoryPanel.class, (String)"LBL_SearchHistory_Searching")));
                } else {
                    this.resultsPanel.add((Component)new NoContentPanel(NbBundle.getMessage(SearchHistoryPanel.class, (String)"LBL_SearchHistory_NoResults")));
                }
                this.undoRedo.setDiffView(null);
            } else if (this.tbSummary.isSelected()) {
                this.undoRedo.setDiffView(null);
                if (this.summaryView == null) {
                    this.summaryView = new SummaryView(this, this.dispResults);
                }
                this.resultsPanel.add(this.summaryView.getComponent());
            } else {
                if (this.diffView == null) {
                    this.diffView = new DiffResultsView(this, this.dispResults);
                }
                this.undoRedo.setDiffView(this.diffView.getCurrentDiffComponent());
                this.resultsPanel.add(this.diffView.getComponent());
            }
            this.resultsPanel.revalidate();
            this.resultsPanel.repaint();
        }
        this.nextAction.setEnabled(!this.tbSummary.isSelected() && this.diffView != null && this.diffView.isNextEnabled());
        this.prevAction.setEnabled(!this.tbSummary.isSelected() && this.diffView != null && this.diffView.isPrevEnabled());
        this.divider.setArrowDirection(this.criteriaVisible ? 1 : 0);
        this.searchCriteriaPanel.setVisible(this.criteriaVisible);
        this.bSearch.setVisible(this.criteriaVisible);
        this.revalidate();
        this.repaint();
    }

    public void setResults(List newResults) {
        this.setResults(newResults, false);
    }

    private void setResults(List newResults, boolean searching) {
        if (newResults != null) {
            this.dispResults = this.createDisplayList(newResults);
        }
        this.results = newResults;
        this.searchInProgress = searching;
        this.summaryView = null;
        this.diffView = null;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SearchHistoryPanel.this.refreshComponents(true);
            }
        });
    }

    List getDispResults() {
        return this.dispResults;
    }

    Project getProject(File file) {
        Project p = this.fileProjects.get(file);
        if (p == null) {
            p = Utils.getProject(file);
            if (p == null) {
                p = this.NULL_PROJECT;
            }
            this.fileProjects.put(file, p);
        }
        if (p == this.NULL_PROJECT) {
            p = null;
        }
        return p;
    }

    public File[] getRoots() {
        return this.roots;
    }

    public SearchCriteriaPanel getCriteria() {
        return this.criteria;
    }

    private synchronized void search() {
        if (this.currentSearchTask != null) {
            this.currentSearchTask.cancel();
        }
        this.setResults(null, true);
        SearchExecutor currentSearch = new SearchExecutor(this);
        this.currentSearchTask = RequestProcessor.getDefault().create((Runnable)currentSearch);
        this.currentSearchTask.schedule(0);
    }

    private List<Object> createDisplayList(List<LogInformation.Revision> inputList) {
        ArrayList<Object> dispResults = new ArrayList<Object>();
        if (inputList.isEmpty()) {
            return dispResults;
        }
        ArrayList<LogInformation.Revision> list = new ArrayList<LogInformation.Revision>(inputList);
        Collections.sort(list, new ByRemotePathRevisionNumberComparator());
        ArrayList<DispRevision> rs = new ArrayList<DispRevision>(list.size());
        HashSet<String> addedBranchNumbers = new HashSet<String>(10);
        for (LogInformation.Revision revision : list) {
            String branchNumber = this.getBranchName(revision);
            if (branchNumber != null && addedBranchNumbers.add(branchNumber)) {
                List symNames = revision.getLogInfoHeader().getSymNamesForRevision(Utils.createBranchRevisionNumber(branchNumber));
                String branchName = null;
                if (symNames.size() > 0) {
                    branchName = ((LogInformation.SymName)symNames.get(0)).getName();
                }
                LogInformation.Revision aRev = new LogInformation.Revision(revision.getLogInfoHeader());
                aRev.setNumber(branchNumber);
                rs.add(new DispRevision(branchNumber, branchName, aRev));
            }
            List allTtags = revision.getLogInfoHeader().getAllSymbolicNames();
            ArrayList<String> revisionTags = new ArrayList<String>(2);
            ArrayList<String> revisionBranches = new ArrayList<String>(2);
            String aBranch = revision.getNumber() + ".0.";
            for (LogInformation.SymName name : allTtags) {
                String nameRevision = name.getRevision();
                if (revision.getNumber().equals(nameRevision)) {
                    revisionTags.add(name.getName());
                }
                if (!nameRevision.startsWith(aBranch)) continue;
                int idx = nameRevision.lastIndexOf(46);
                revisionBranches.add(name.getName() + " (" + nameRevision.substring(0, idx - 1) + nameRevision.substring(idx + 1) + ")");
            }
            rs.add(new DispRevision(revision, revisionTags, revisionBranches));
        }
        ResultsContainer currentContainer = null;
        currentContainer = new ResultsContainer(((DispRevision)rs.get(0)).getRevision().getLogInfoHeader());
        currentContainer.add(this.createLocalRevision(((DispRevision)rs.get(0)).getRevision().getLogInfoHeader()));
        dispResults.add(currentContainer);
        for (DispRevision revision : rs) {
            DispRevision parent;
            if (currentContainer.getHeader() != revision.getRevision().getLogInfoHeader()) {
                this.getProject(currentContainer.getHeader().getFile());
                if (currentContainer.getRevisions().size() < 1) {
                    dispResults.remove(currentContainer);
                    if (currentContainer.getRevisions().size() == 1) {
                        dispResults.add(currentContainer.getRevisions().get(0));
                    }
                }
                currentContainer = new ResultsContainer(revision.getRevision().getLogInfoHeader());
                currentContainer.add(this.createLocalRevision(revision.getRevision().getLogInfoHeader()));
                dispResults.add(currentContainer);
            }
            if ((parent = SearchHistoryPanel.getParentRevision(rs, revision)) != null) {
                parent.addRevision(revision);
                continue;
            }
            currentContainer.add(revision);
        }
        if (currentContainer.getRevisions().size() < 1) {
            dispResults.remove(currentContainer);
            if (currentContainer.getRevisions().size() == 1) {
                dispResults.add(currentContainer.getRevisions().get(0));
            }
        }
        return dispResults;
    }

    private DispRevision createLocalRevision(LogInformation logInfo) {
        LogInformation.Revision currentRevision = new LogInformation.Revision(logInfo);
        currentRevision.setNumber("");
        return new DispRevision(currentRevision, null, null);
    }

    private String getBranchName(LogInformation.Revision rev) {
        String number = rev.getNumber();
        int idx = number.lastIndexOf(46, number.lastIndexOf(46) - 1);
        return idx == -1 ? null : number.substring(0, number.lastIndexOf(46));
    }

    private static DispRevision getParentRevision(List results, DispRevision revision) {
        LogInformation.Revision parentRev;
        int index;
        String number = revision.getRevision().getNumber();
        do {
            int idx;
            if ((idx = number.lastIndexOf(46)) == -1) {
                return null;
            }
            number = number.substring(0, idx);
            parentRev = new LogInformation.Revision(revision.getRevision().getLogInfoHeader());
            parentRev.setNumber(number);
        } while ((index = Collections.binarySearch(results, new DispRevision(parentRev, null, null), revisionsComparator)) < 0);
        return (DispRevision)results.get(index);
    }

    void executeSearch() {
        this.search();
    }

    void showDiff(DispRevision revision) {
        this.tbDiff.setSelected(true);
        this.refreshComponents(true);
        this.diffView.select(revision);
    }

    public void showDiff(ResultsContainer container) {
        this.tbDiff.setSelected(true);
        this.refreshComponents(true);
        this.diffView.select(container);
    }

    @Override
    public Collection<Setup> getSetups() {
        if (this.dispResults == null) {
            return Collections.emptySet();
        }
        List<Object> selectedItems = this.dispResults;
        selectedItems = this.tbSummary.isSelected() ? this.summaryView.getSelection() : this.diffView.getSelection();
        if (selectedItems.size() == 0) {
            for (Object o : this.dispResults) {
                if (!(o instanceof ResultsContainer)) continue;
                selectedItems.add(o);
            }
        }
        ArrayList<Setup> setups = new ArrayList<Setup>(selectedItems.size());
        HashSet<LogInformation> includedFiles = new HashSet<LogInformation>();
        for (Object item : selectedItems) {
            if (!(item instanceof ResultsContainer)) continue;
            ResultsContainer entry = (ResultsContainer)item;
            File file = entry.getHeader().getFile();
            boolean atomicRange = true;
            String prev = null;
            List<DispRevision> revisions = entry.getRevisions();
            for (DispRevision revision : revisions) {
                String rev = revision.getRevision().getNumber();
                if ("".equals(rev)) continue;
                if (prev != null && !rev.equals(Utils.previousRevision(prev))) {
                    atomicRange = false;
                    break;
                }
                prev = rev;
            }
            if (!atomicRange) continue;
            String eldest = entry.getEldestRevision();
            String newest = entry.getNewestRevision();
            Setup setup = new Setup(file, eldest, newest);
            includedFiles.add(entry.getHeader());
            setups.add(setup);
        }
        for (int i = 0; i < selectedItems.size(); ++i) {
            String r1;
            DispRevision rev1;
            LogInformation header;
            Object item;
            item = selectedItems.get(i);
            if (!(item instanceof DispRevision) || includedFiles.contains(header = (rev1 = (DispRevision)item).getRevision().getLogInfoHeader())) continue;
            String r2 = r1 = rev1.getRevision().getNumber();
            for (int j = i + 1; j < selectedItems.size(); ++j) {
                DispRevision rev2;
                Object item2 = selectedItems.get(j);
                if (!(item2 instanceof DispRevision) || !header.equals((rev2 = (DispRevision)item2).getRevision().getLogInfoHeader())) continue;
                r2 = rev2.getRevision().getNumber();
            }
            if (r2 == null) continue;
            if (SearchHistoryPanel.compareRevisions(r1, r2) > 0) {
                String tmp = r2;
                r2 = r1;
                r1 = tmp;
            }
            if (Utils.previousRevision(r1) != null) {
                r1 = Utils.previousRevision(r1);
            }
            Setup setup = new Setup(header.getFile(), r1, r2);
            includedFiles.add(header);
            setups.add(setup);
        }
        return setups;
    }

    @Override
    public String getSetupDisplayName() {
        return null;
    }

    DelegatingUndoRedo getUndoRedo() {
        return this.undoRedo;
    }

    public static int compareRevisionsTrunkFirst(String r1, String r2) {
        int n2;
        int n1;
        StringTokenizer st1 = new StringTokenizer(r1, ".");
        StringTokenizer st2 = new StringTokenizer(r2, ".");
        do {
            if (!st1.hasMoreTokens()) {
                return st2.hasMoreTokens() ? -1 : 0;
            }
            if (st2.hasMoreTokens()) continue;
            return st1.hasMoreTokens() ? 1 : 0;
        } while ((n1 = Integer.parseInt(st1.nextToken())) == (n2 = Integer.parseInt(st2.nextToken())));
        return n2 - n1;
    }

    public static int compareRevisions(String r1, String r2) {
        int n2;
        int n1;
        if (r1.equals(r2)) {
            return 0;
        }
        if (r1.equals("")) {
            return 1;
        }
        if (r2.equals("")) {
            return -1;
        }
        StringTokenizer st1 = new StringTokenizer(r1, ".");
        StringTokenizer st2 = new StringTokenizer(r2, ".");
        do {
            if (!st1.hasMoreTokens()) {
                return -1;
            }
            if (st2.hasMoreTokens()) continue;
            return 1;
        } while ((n1 = Integer.parseInt(st1.nextToken())) == (n2 = Integer.parseInt(st2.nextToken())));
        return n1 - n2;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.searchCriteriaPanel = new JPanel();
        this.bSearch = new JButton();
        this.jPanel1 = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.tbSummary = new JToggleButton();
        this.tbDiff = new JToggleButton();
        this.jSeparator2 = new JSeparator();
        this.bNext = new JButton();
        this.bPrev = new JButton();
        this.resultsPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 0, 8));
        this.searchCriteriaPanel.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.searchCriteriaPanel, gridBagConstraints);
        this.bSearch.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("TT_Search"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.bSearch, gridBagConstraints);
        this.jPanel1.setPreferredSize(new Dimension(10, 6));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.buttonGroup1.add(this.tbSummary);
        this.tbSummary.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.tbSummary, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("CTL_ShowSummary"));
        this.tbSummary.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("TT_Summary"));
        this.tbSummary.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchHistoryPanel.this.onViewToggle(evt);
            }
        });
        this.jToolBar1.add(this.tbSummary);
        this.buttonGroup1.add(this.tbDiff);
        Mnemonics.setLocalizedText((AbstractButton)this.tbDiff, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("CTL_ShowDiff"));
        this.tbDiff.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("TT_ShowDiff"));
        this.tbDiff.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchHistoryPanel.this.onViewToggle(evt);
            }
        });
        this.jToolBar1.add(this.tbDiff);
        this.jSeparator2.setOrientation(1);
        this.jSeparator2.setMaximumSize(new Dimension(2, Short.MAX_VALUE));
        this.jToolBar1.add(this.jSeparator2);
        this.bNext.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/diff-next.png")));
        this.jToolBar1.add(this.bNext);
        this.bNext.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("ACSN_NextDifference"));
        this.bPrev.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/diff-prev.png")));
        this.jToolBar1.add(this.bPrev);
        this.bPrev.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/history/Bundle").getString("ACSN_PrevDifference"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jToolBar1, gridBagConstraints);
        this.resultsPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 8, 0);
        this.add((Component)this.resultsPanel, gridBagConstraints);
    }

    private void onViewToggle(ActionEvent evt) {
        this.refreshComponents(true);
    }

    private static class ByRemotePathRevisionNumberComparator
    implements Comparator {
        private ByRemotePathRevisionNumberComparator() {
        }

        public int compare(Object o1, Object o2) {
            LogInformation.Revision r1 = (LogInformation.Revision)o1;
            LogInformation.Revision r2 = (LogInformation.Revision)o2;
            int namec = r1.getLogInfoHeader().getFile().getName().compareToIgnoreCase(r2.getLogInfoHeader().getFile().getName());
            if (namec != 0) {
                return namec;
            }
            namec = r1.getLogInfoHeader().getRepositoryFilename().compareToIgnoreCase(r2.getLogInfoHeader().getRepositoryFilename());
            if (namec != 0) {
                return namec;
            }
            return SearchHistoryPanel.compareRevisionsTrunkFirst(r1.getNumber(), r2.getNumber());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DispRevision {
        private final LogInformation.Revision revision;
        private String name;
        private List children;
        private String path;
        private int indentation;
        private final String branchNumber;
        private final String branchName;
        private final int hashCode;
        private final List<String> tags;
        private final List<String> branches;

        public DispRevision(String branchNumber, String branchName, LogInformation.Revision revision) {
            this.branchNumber = branchNumber;
            this.branchName = branchName;
            this.revision = revision;
            this.hashCode = branchNumber.hashCode();
            this.tags = null;
            this.branches = null;
        }

        public DispRevision(LogInformation.Revision revision, List<String> tags, List<String> branches) {
            block2: {
                this.revision = revision;
                this.tags = tags == null ? null : Collections.unmodifiableList(tags);
                this.branches = branches == null ? null : Collections.unmodifiableList(branches);
                this.hashCode = revision.hashCode();
                this.branchNumber = null;
                this.branchName = null;
                File file = revision.getLogInfoHeader().getFile();
                try {
                    this.name = CvsVersioningSystem.getInstance().getAdminHandler().getRepositoryForDirectory(file.getParentFile().getAbsolutePath(), "") + "/" + file.getName();
                }
                catch (Exception e) {
                    this.name = revision.getLogInfoHeader().getRepositoryFilename();
                    if (!this.name.endsWith(",v")) break block2;
                    this.name = this.name.substring(0, this.name.lastIndexOf(",v"));
                }
            }
            this.path = this.name.substring(0, this.name.lastIndexOf(47));
        }

        public List<String> getTags() {
            return this.tags;
        }

        public List<String> getBranches() {
            return this.branches;
        }

        public String getBranchName() {
            return this.branchName;
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public LogInformation.Revision getRevision() {
            return this.revision;
        }

        public void addRevision(DispRevision revision) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.add(revision);
        }

        public List getChildren() {
            return this.children;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DispRevision)) {
                return false;
            }
            if (this.branchNumber != null) {
                return this.branchNumber.equals(((DispRevision)o).branchNumber);
            }
            return this.revision.equals(((DispRevision)o).revision);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public int getIndentation() {
            return this.indentation;
        }

        public void setIndentation(int indentation) {
            this.indentation = indentation;
        }

        public String toString() {
            StringBuffer indent = new StringBuffer("  ");
            for (int i = 0; i < this.getIndentation(); ++i) {
                indent.append("  ");
            }
            StringBuffer text = new StringBuffer();
            text.append(indent).append(this.getRevision().getNumber()).append("\t").append(this.getRevision().getDateString()).append(" ").append(this.getRevision().getAuthor());
            text.append("\n");
            text.append(this.getRevision().getMessage());
            return text.toString();
        }

        public boolean isBranchRoot() {
            return this.branchNumber != null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ResultsContainer {
        private List<DispRevision> revisions;
        private String name;
        private String path;
        private final LogInformation header;

        public ResultsContainer(LogInformation header) {
            block2: {
                this.revisions = new ArrayList<DispRevision>(2);
                this.header = header;
                File file = header.getFile();
                try {
                    this.name = CvsVersioningSystem.getInstance().getAdminHandler().getRepositoryForDirectory(file.getParentFile().getAbsolutePath(), "") + "/" + file.getName();
                }
                catch (Exception e) {
                    this.name = header.getRepositoryFilename();
                    if (!this.name.endsWith(",v")) break block2;
                    this.name = this.name.substring(0, this.name.lastIndexOf(",v"));
                }
            }
            this.path = this.name.substring(0, this.name.lastIndexOf(47));
            this.name = this.name.substring(this.path.length() + 1);
        }

        public LogInformation getHeader() {
            return this.header;
        }

        public void add(DispRevision revision) {
            this.revisions.add(this.revisions.size(), revision);
        }

        public String getName() {
            return this.name;
        }

        public List<DispRevision> getRevisions() {
            return this.revisions;
        }

        public String getEldestRevision() {
            DispRevision rev = this.revisions.get(this.revisions.size() - 1);
            String revNumber = Utils.previousRevision(rev.getRevision().getNumber());
            return revNumber != null ? revNumber : rev.getRevision().getNumber();
        }

        public String getNewestRevision() {
            String newest = this.revisions.get(0).getRevision().getNumber();
            if ("".equals(newest)) {
                newest = this.revisions.get(1).getRevision().getNumber();
            }
            return newest;
        }

        public String getPath() {
            return this.path;
        }

        public File getFile() {
            return this.header.getFile();
        }

        public String toString() {
            return this.getName() + "    " + this.getPath();
        }
    }
}

