/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.history;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.ui.actions.log.SearchHistoryAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.GetCleanAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.UpdateExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.history.SearchHistoryPanel;
import org.netbeans.modules.versioning.system.cvss.ui.history.TooltipWindow;
import org.netbeans.modules.versioning.system.cvss.ui.history.ViewRevisionAction;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SummaryView
implements MouseListener,
ComponentListener,
MouseMotionListener {
    private static final double DARKEN_FACTOR = 0.95;
    private final SearchHistoryPanel master;
    private JList resultsList;
    private JScrollPane scrollPane;
    private final List dispResults;
    private String message;
    private AttributeSet searchHiliteAttrs;

    public SummaryView(SearchHistoryPanel master, List results) {
        this.master = master;
        this.dispResults = SummaryView.expandResults(results);
        FontColorSettings fcs = (FontColorSettings)MimeLookup.getLookup((MimePath)MimePath.get((String)"text/x-java")).lookup(FontColorSettings.class);
        this.searchHiliteAttrs = fcs.getFontColors("highlight-search");
        this.message = master.getCriteria().getCommitMessage();
        this.resultsList = new JList(new SummaryListModel());
        this.resultsList.setFixedCellHeight(-1);
        this.resultsList.addMouseListener(this);
        this.resultsList.addMouseMotionListener(this);
        this.resultsList.setCellRenderer(new SummaryCellRenderer());
        this.resultsList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SummaryView.class, (String)"ACSN_SummaryView_List"));
        this.resultsList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SummaryView.class, (String)"ACSD_SummaryView_List"));
        this.scrollPane = new JScrollPane(this.resultsList, 22, 31);
        master.addComponentListener(this);
    }

    @Override
    public void componentResized(ComponentEvent e) {
        int[] selection = this.resultsList.getSelectedIndices();
        this.resultsList.setModel(new SummaryListModel());
        this.resultsList.setSelectedIndices(selection);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    private static List expandResults(List results) {
        ArrayList newResults = new ArrayList(results.size());
        for (Object o : results) {
            if (o instanceof SearchHistoryPanel.ResultsContainer) {
                newResults.add(o);
                SearchHistoryPanel.ResultsContainer container = (SearchHistoryPanel.ResultsContainer)o;
                for (SearchHistoryPanel.DispRevision revision : container.getRevisions()) {
                    if (revision.getRevision().getNumber() == "" || revision.isBranchRoot()) continue;
                    newResults.add(revision);
                }
                for (SearchHistoryPanel.DispRevision revision : container.getRevisions()) {
                    SummaryView.addResults(newResults, revision, 1);
                }
                continue;
            }
            SearchHistoryPanel.DispRevision revision = (SearchHistoryPanel.DispRevision)o;
            if (revision.getRevision().getNumber() != "" && !revision.isBranchRoot()) {
                newResults.add(revision);
            }
            SummaryView.addResults(newResults, revision, 0);
        }
        return newResults;
    }

    private static void addResults(ArrayList newResults, SearchHistoryPanel.DispRevision dispRevision, int indentation) {
        dispRevision.setIndentation(indentation);
        List children = dispRevision.getChildren();
        if (children != null) {
            for (SearchHistoryPanel.DispRevision revision : children) {
                if (revision.isBranchRoot()) continue;
                newResults.add(revision);
            }
            for (SearchHistoryPanel.DispRevision revision : children) {
                SummaryView.addResults(newResults, revision, indentation + 1);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int idx = this.resultsList.locationToIndex(e.getPoint());
        if (idx == -1) {
            return;
        }
        Rectangle rect = this.resultsList.getCellBounds(idx, idx);
        Point p = new Point(e.getX() - rect.x, e.getY() - rect.y);
        Rectangle diffBounds = (Rectangle)this.resultsList.getClientProperty("Summary-Diff-" + idx);
        if (diffBounds != null && diffBounds.contains(p)) {
            this.diffPrevious(idx);
        }
        if ((diffBounds = (Rectangle)this.resultsList.getClientProperty("Summary-Acp-" + idx)) != null && diffBounds.contains(p)) {
            this.associatedChangesInProject(idx);
        }
        if ((diffBounds = (Rectangle)this.resultsList.getClientProperty("Summary-Acop-" + idx)) != null && diffBounds.contains(p)) {
            this.associatedChangesInOpenProjects(idx);
        }
        if ((diffBounds = (Rectangle)this.resultsList.getClientProperty("Summary-tagsLink-" + idx)) != null && diffBounds.contains(p)) {
            this.showAlltags(e.getPoint(), idx);
        }
    }

    public static void showAllTags(Window w, Point p, SearchHistoryPanel.DispRevision drev) {
        final JTextPane tp = new JTextPane();
        tp.setBackground(SummaryView.darker(UIManager.getColor("List.background")));
        tp.setBorder(BorderFactory.createEmptyBorder(6, 8, 0, 0));
        tp.setEditable(false);
        Style headerStyle = tp.addStyle("headerStyle", null);
        StyleConstants.setBold(headerStyle, true);
        Style unmodifiedBranchStyle = tp.addStyle("unmodifiedBranchStyle", null);
        StyleConstants.setForeground(unmodifiedBranchStyle, Color.GRAY);
        String modifiedBranches = drev.getRevision().getBranches();
        Document doc = tp.getDocument();
        try {
            doc.insertString(doc.getLength(), NbBundle.getMessage(SummaryView.class, (String)"CTL_TagsWindow_BranchesLabel") + "\n", headerStyle);
            List<String> tags = drev.getBranches();
            for (String tag : tags) {
                if (modifiedBranches == null || modifiedBranches.indexOf(tag.substring(tag.indexOf("(") + 1, tag.indexOf(")"))) == -1) {
                    doc.insertString(doc.getLength(), tag + "\n", unmodifiedBranchStyle);
                    continue;
                }
                doc.insertString(doc.getLength(), tag + "\n", null);
            }
            if (tags.size() == 0) {
                doc.insertString(doc.getLength(), NbBundle.getMessage(SummaryView.class, (String)"CTL_TagsWindow_NoBranchesLabel") + "\n", unmodifiedBranchStyle);
            }
            doc.insertString(doc.getLength(), "\n" + NbBundle.getMessage(SummaryView.class, (String)"CTL_TagsWindow_TagsLabel") + "\n", headerStyle);
            StringBuilder sb = new StringBuilder();
            tags = drev.getTags();
            for (String tag : tags) {
                sb.append(tag);
                sb.append('\n');
            }
            doc.insertString(doc.getLength(), sb.toString(), null);
            if (tags.size() == 0) {
                doc.insertString(doc.getLength(), NbBundle.getMessage(SummaryView.class, (String)"CTL_TagsWindow_NoTagsLabel"), unmodifiedBranchStyle);
            }
        }
        catch (BadLocationException e) {
            Logger.getLogger(SummaryView.class.getName()).log(Level.WARNING, "Internal error creating tag list", e);
        }
        Dimension dim = tp.getPreferredSize();
        tp.setPreferredSize(new Dimension(dim.width * 7 / 6, dim.height));
        JScrollPane jsp = new JScrollPane(tp);
        jsp.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.BLACK));
        TooltipWindow ttw = new TooltipWindow(w, jsp);
        ttw.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                tp.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
            }
        });
        ttw.show(p);
    }

    private void showAlltags(Point p, int idx) {
        Object o = this.dispResults.get(idx);
        if (o instanceof SearchHistoryPanel.DispRevision) {
            SwingUtilities.convertPointToScreen(p, this.resultsList);
            p.x += 10;
            SummaryView.showAllTags(SwingUtilities.windowForComponent(this.scrollPane), p, (SearchHistoryPanel.DispRevision)o);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.onPopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.onPopup(e);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int idx = this.resultsList.locationToIndex(e.getPoint());
        if (idx == -1) {
            return;
        }
        Rectangle rect = this.resultsList.getCellBounds(idx, idx);
        Point p = new Point(e.getX() - rect.x, e.getY() - rect.y);
        Rectangle diffBounds = (Rectangle)this.resultsList.getClientProperty("Summary-Diff-" + idx);
        if (diffBounds != null && diffBounds.contains(p)) {
            this.resultsList.setCursor(Cursor.getPredefinedCursor(12));
            return;
        }
        diffBounds = (Rectangle)this.resultsList.getClientProperty("Summary-Acp-" + idx);
        if (diffBounds != null && diffBounds.contains(p)) {
            this.resultsList.setCursor(Cursor.getPredefinedCursor(12));
            return;
        }
        diffBounds = (Rectangle)this.resultsList.getClientProperty("Summary-Acop-" + idx);
        if (diffBounds != null && diffBounds.contains(p)) {
            this.resultsList.setCursor(Cursor.getPredefinedCursor(12));
            return;
        }
        diffBounds = (Rectangle)this.resultsList.getClientProperty("Summary-tagsLink-" + idx);
        if (diffBounds != null && diffBounds.contains(p)) {
            this.resultsList.setCursor(Cursor.getPredefinedCursor(12));
            return;
        }
        this.resultsList.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void onPopup(MouseEvent e) {
        int[] sel = this.resultsList.getSelectedIndices();
        if (sel.length == 0) {
            int idx = this.resultsList.locationToIndex(e.getPoint());
            if (idx == -1) {
                return;
            }
            this.resultsList.setSelectedIndex(idx);
            sel = new int[]{idx};
        }
        final int[] selection = sel;
        JPopupMenu menu = new JPopupMenu();
        String previousRevision = null;
        SearchHistoryPanel.ResultsContainer container = null;
        SearchHistoryPanel.DispRevision drev = null;
        Object revCon = this.dispResults.get(selection[0]);
        if (revCon instanceof SearchHistoryPanel.ResultsContainer) {
            container = (SearchHistoryPanel.ResultsContainer)this.dispResults.get(selection[0]);
        } else {
            drev = (SearchHistoryPanel.DispRevision)this.dispResults.get(selection[0]);
            previousRevision = Utils.previousRevision(drev.getRevision().getNumber().trim());
        }
        if (container != null) {
            String eldest = container.getEldestRevision();
            menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_Diff", (Object)eldest, (Object)container.getNewestRevision())){

                public void actionPerformed(ActionEvent e) {
                    SummaryView.this.diffPrevious(selection[0]);
                }
            }));
        } else if (previousRevision != null) {
            menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_DiffToPrevious", (Object)previousRevision)){
                {
                    super(x0);
                    this.setEnabled(selection.length == 1 && SummaryView.this.dispResults.get(selection[0]) instanceof SearchHistoryPanel.DispRevision);
                }

                public void actionPerformed(ActionEvent e) {
                    SummaryView.this.diffPrevious(selection[0]);
                }
            }));
        }
        menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_RollbackChange")){
            {
                super(x0);
                this.setEnabled(SummaryView.this.someRevisions(selection));
            }

            public void actionPerformed(ActionEvent e) {
                SummaryView.this.rollbackChange(selection);
            }
        }));
        if (drev != null) {
            Project prj;
            if (!"dead".equals(drev.getRevision().getState())) {
                menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_RollbackTo", (Object)drev.getRevision().getNumber())){
                    {
                        super(x0);
                        this.setEnabled(selection.length == 1 && SummaryView.this.dispResults.get(selection[0]) instanceof SearchHistoryPanel.DispRevision);
                    }

                    public void actionPerformed(ActionEvent e) {
                        SummaryView.this.rollback(selection[0]);
                    }
                }));
                menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_View", (Object)drev.getRevision().getNumber())){
                    {
                        super(x0);
                        this.setEnabled(selection.length == 1 && SummaryView.this.dispResults.get(selection[0]) instanceof SearchHistoryPanel.DispRevision);
                    }

                    public void actionPerformed(ActionEvent e) {
                        RequestProcessor.getDefault().post(new Runnable(){

                            public void run() {
                                SummaryView.this.view(selection[0]);
                            }
                        });
                    }
                }));
            }
            if ((prj = this.master.getProject(drev.getRevision().getLogInfoHeader().getFile())) != null) {
                String prjName = ProjectUtils.getInformation((Project)prj).getDisplayName();
                menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_Action_AssociateChangesInProject", (Object)prjName)){
                    {
                        super(x0);
                        this.setEnabled(selection.length == 1 && SummaryView.this.dispResults.get(selection[0]) instanceof SearchHistoryPanel.DispRevision);
                    }

                    public void actionPerformed(ActionEvent e) {
                        SummaryView.this.associatedChangesInProject(selection[0]);
                    }
                }));
            }
            menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage(SummaryView.class, (String)"CTL_Action_AssociateChangesInOpenProjects")){
                {
                    super(x0);
                    this.setEnabled(selection.length == 1 && SummaryView.this.dispResults.get(selection[0]) instanceof SearchHistoryPanel.DispRevision);
                }

                public void actionPerformed(ActionEvent e) {
                    SummaryView.this.associatedChangesInOpenProjects(selection[0]);
                }
            }));
        }
        menu.show(e.getComponent(), e.getX(), e.getY());
    }

    private boolean someRevisions(int[] selection) {
        for (int i = 0; i < selection.length; ++i) {
            Object revCon = this.dispResults.get(selection[i]);
            if (!(revCon instanceof SearchHistoryPanel.DispRevision)) continue;
            return true;
        }
        return false;
    }

    private void rollbackChange(int[] selection) {
        ArrayList<LogInformation.Revision> changes = new ArrayList<LogInformation.Revision>();
        for (int i = 0; i < selection.length; ++i) {
            int idx = selection[i];
            Object o = this.dispResults.get(idx);
            if (!(o instanceof SearchHistoryPanel.DispRevision)) continue;
            SearchHistoryPanel.DispRevision drev = (SearchHistoryPanel.DispRevision)o;
            changes.add(drev.getRevision());
        }
        SummaryView.rollbackChanges(changes.toArray(new LogInformation.Revision[changes.size()]));
    }

    private static void rollbackChange(LogInformation.Revision change, ExecutorGroup group) {
        UpdateCommand cmd = new UpdateCommand();
        cmd.setFiles(new File[]{change.getLogInfoHeader().getFile()});
        cmd.setMergeRevision1(change.getNumber());
        cmd.setMergeRevision2(Utils.previousRevision(change.getNumber()));
        group.addExecutors(UpdateExecutor.splitCommand(cmd, CvsVersioningSystem.getInstance(), null, null));
    }

    static void rollbackChanges(LogInformation.Revision[] changes) {
        ExecutorGroup group = new ExecutorGroup(NbBundle.getMessage(SummaryView.class, (String)"MSG_SummaryView_RollingBackChange"));
        for (int i = 0; i < changes.length; ++i) {
            SummaryView.rollbackChange(changes[i], group);
        }
        group.execute();
    }

    private void rollback(int idx) {
        Object o = this.dispResults.get(idx);
        if (o instanceof SearchHistoryPanel.DispRevision) {
            SearchHistoryPanel.DispRevision drev = (SearchHistoryPanel.DispRevision)o;
            String revision = drev.getRevision().getNumber().trim();
            File file = drev.getRevision().getLogInfoHeader().getFile();
            GetCleanAction.rollback(file, revision);
        }
    }

    private void view(int idx) {
        Object o = this.dispResults.get(idx);
        if (o instanceof SearchHistoryPanel.DispRevision) {
            SearchHistoryPanel.DispRevision drev = (SearchHistoryPanel.DispRevision)o;
            try {
                ViewRevisionAction.view(drev.getRevision().getLogInfoHeader().getFile(), drev.getRevision().getNumber(), null);
            }
            catch (Exception e) {
                Logger.getLogger(SummaryView.class.getName()).log(Level.INFO, e.getMessage(), e);
            }
        }
    }

    private void diffPrevious(int idx) {
        Object o = this.dispResults.get(idx);
        if (o instanceof SearchHistoryPanel.DispRevision) {
            SearchHistoryPanel.DispRevision drev = (SearchHistoryPanel.DispRevision)o;
            this.master.showDiff(drev);
        } else {
            SearchHistoryPanel.ResultsContainer container = (SearchHistoryPanel.ResultsContainer)o;
            this.master.showDiff(container);
        }
    }

    private void associatedChangesInOpenProjects(int idx) {
        Object o = this.dispResults.get(idx);
        if (o instanceof SearchHistoryPanel.DispRevision) {
            SearchHistoryPanel.DispRevision drev = (SearchHistoryPanel.DispRevision)o;
            Project[] projects = OpenProjects.getDefault().getOpenProjects();
            int n = projects.length;
            SearchHistoryAction.openSearch(n == 1 ? ProjectUtils.getInformation((Project)projects[0]).getDisplayName() : NbBundle.getMessage(SummaryView.class, (String)"CTL_FindAssociateChanges_OpenProjects_Title", (Object)Integer.toString(n)), drev.getRevision().getMessage().trim(), drev.getRevision().getAuthor(), drev.getRevision().getDate());
        }
    }

    private void associatedChangesInProject(int idx) {
        Object o = this.dispResults.get(idx);
        if (o instanceof SearchHistoryPanel.DispRevision) {
            SearchHistoryPanel.DispRevision drev = (SearchHistoryPanel.DispRevision)o;
            File file = drev.getRevision().getLogInfoHeader().getFile();
            Project project = this.master.getProject(file);
            Context context = Utils.getProjectsContext(new Project[]{this.master.getProject(file)});
            SearchHistoryAction.openSearch(context, ProjectUtils.getInformation((Project)project).getDisplayName(), drev.getRevision().getMessage().trim(), drev.getRevision().getAuthor(), drev.getRevision().getDate());
        }
    }

    public JComponent getComponent() {
        return this.scrollPane;
    }

    List<Object> getSelection() {
        ArrayList<Object> selection = new ArrayList<Object>();
        for (int i : this.resultsList.getSelectedIndices()) {
            selection.add(this.dispResults.get(i));
        }
        return selection;
    }

    public static Color darker(Color c) {
        return new Color(Math.max((int)((double)c.getRed() * 0.95), 0), Math.max((int)((double)c.getGreen() * 0.95), 0), Math.max((int)((double)c.getBlue() * 0.95), 0));
    }

    private String getBranch(SearchHistoryPanel.DispRevision revision) {
        String number = revision.getRevision().getNumber();
        int idx = number.lastIndexOf(46);
        if (idx == number.indexOf(46)) {
            return null;
        }
        int idx2 = number.lastIndexOf(46, idx - 1);
        String branchNumber = number.substring(0, idx2) + ".0" + number.substring(idx2, idx);
        List names = revision.getRevision().getLogInfoHeader().getSymNamesForRevision(branchNumber);
        if (names.size() != 1) {
            return null;
        }
        return ((LogInformation.SymName)names.get(0)).getName();
    }

    private static class HyperlinkLabel
    extends JLabel {
        public HyperlinkLabel() {
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        public void set(String text, Color foreground, Color background) {
            StringBuilder sb = new StringBuilder(100);
            if (foreground.equals(UIManager.getColor("List.foreground"))) {
                sb.append("<html><a href=\"\">");
                sb.append(text);
                sb.append("</a>");
            } else {
                sb.append("<html><a href=\"\" style=\"color:");
                sb.append("rgb(");
                sb.append(foreground.getRed());
                sb.append(",");
                sb.append(foreground.getGreen());
                sb.append(",");
                sb.append(foreground.getBlue());
                sb.append(")");
                sb.append("\">");
                sb.append(text);
                sb.append("</a>");
            }
            this.setText(sb.toString());
            this.setBackground(background);
        }
    }

    private class SummaryCellRenderer
    extends JPanel
    implements ListCellRenderer {
        private static final String FIELDS_SEPARATOR = "        ";
        private Style selectedStyle;
        private Style normalStyle;
        private Style branchStyle;
        private Style filenameStyle;
        private Style indentStyle;
        private Style noindentStyle;
        private Style hiliteStyle;
        private JTextPane textPane = new JTextPane();
        private JPanel actionsPane = new JPanel();
        private final JPanel tagsPanel;
        private final JPanel actionsPanel;
        private DateFormat defaultFormat;
        private int index;
        private final HyperlinkLabel tagsLink;
        private final HyperlinkLabel diffLink;
        private final HyperlinkLabel acpLink;
        private final HyperlinkLabel acopLink;
        private final JLabel tagsLabel;
        private final JLabel diffToLabel;
        private final JLabel findCommitInLabel;
        private final JLabel commaLabel;

        public SummaryCellRenderer() {
            this.selectedStyle = this.textPane.addStyle("selected", null);
            StyleConstants.setForeground(this.selectedStyle, UIManager.getColor("List.selectionForeground"));
            this.normalStyle = this.textPane.addStyle("normal", null);
            StyleConstants.setForeground(this.normalStyle, UIManager.getColor("List.foreground"));
            this.branchStyle = this.textPane.addStyle("normal", null);
            StyleConstants.setForeground(this.branchStyle, Color.GRAY);
            this.filenameStyle = this.textPane.addStyle("filename", this.normalStyle);
            StyleConstants.setBold(this.filenameStyle, true);
            this.indentStyle = this.textPane.addStyle("indent", null);
            StyleConstants.setLeftIndent(this.indentStyle, 50.0f);
            this.noindentStyle = this.textPane.addStyle("noindent", null);
            StyleConstants.setLeftIndent(this.noindentStyle, 0.0f);
            this.defaultFormat = DateFormat.getDateTimeInstance();
            this.hiliteStyle = this.textPane.addStyle("hilite", this.normalStyle);
            Color c = (Color)SummaryView.this.searchHiliteAttrs.getAttribute(StyleConstants.Background);
            if (c != null) {
                StyleConstants.setBackground(this.hiliteStyle, c);
            }
            if ((c = (Color)SummaryView.this.searchHiliteAttrs.getAttribute(StyleConstants.Foreground)) != null) {
                StyleConstants.setForeground(this.hiliteStyle, c);
            }
            this.setLayout(new BorderLayout());
            this.add(this.textPane);
            this.add((Component)this.actionsPane, "Last");
            this.actionsPane.setLayout(new BorderLayout());
            this.actionsPane.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            this.tagsPanel = new JPanel();
            this.tagsPanel.setLayout(new FlowLayout(3, 2, 5));
            this.actionsPanel = new JPanel();
            this.actionsPanel.setLayout(new FlowLayout(4, 2, 5));
            this.actionsPane.add((Component)this.tagsPanel, "West");
            this.actionsPane.add(this.actionsPanel);
            this.tagsLabel = new JLabel();
            this.tagsLink = new HyperlinkLabel();
            this.tagsPanel.add(this.tagsLabel);
            this.tagsLabel.setBorder(BorderFactory.createEmptyBorder(0, 48, 0, 0));
            this.tagsPanel.add(this.tagsLink);
            this.diffToLabel = new JLabel(NbBundle.getMessage(SummaryView.class, (String)"CTL_Action_DiffTo"));
            this.actionsPanel.add(this.diffToLabel);
            this.diffLink = new HyperlinkLabel();
            this.diffLink.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
            this.actionsPanel.add(this.diffLink);
            this.acopLink = new HyperlinkLabel();
            this.acpLink = new HyperlinkLabel();
            this.findCommitInLabel = new JLabel(NbBundle.getMessage(SummaryView.class, (String)"CTL_Action_FindCommitIn"));
            this.actionsPanel.add(this.findCommitInLabel);
            this.actionsPanel.add(this.acpLink);
            this.commaLabel = new JLabel(",");
            this.actionsPanel.add(this.commaLabel);
            this.actionsPanel.add(this.acopLink);
            this.textPane.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof SearchHistoryPanel.ResultsContainer) {
                this.renderContainer((SearchHistoryPanel.ResultsContainer)value, index, isSelected);
            } else {
                this.renderRevision(list, (SearchHistoryPanel.DispRevision)value, index, isSelected);
            }
            return this;
        }

        private void renderContainer(SearchHistoryPanel.ResultsContainer container, int index, boolean isSelected) {
            Style style;
            StyledDocument sd = this.textPane.getStyledDocument();
            if (isSelected) {
                this.textPane.setBackground(UIManager.getColor("List.selectionBackground"));
                this.actionsPane.setBackground(UIManager.getColor("List.selectionBackground"));
                style = this.selectedStyle;
            } else {
                Color c = UIManager.getColor("List.background");
                this.textPane.setBackground((index & 1) == 0 ? c : SummaryView.darker(c));
                this.actionsPane.setBackground((index & 1) == 0 ? c : SummaryView.darker(c));
                style = this.normalStyle;
            }
            try {
                sd.remove(0, sd.getLength());
                sd.setCharacterAttributes(0, Integer.MAX_VALUE, style, true);
                sd.insertString(0, container.getName(), null);
                sd.setCharacterAttributes(0, sd.getLength(), this.filenameStyle, false);
                sd.insertString(sd.getLength(), FIELDS_SEPARATOR + container.getPath(), null);
                sd.setCharacterAttributes(0, sd.getLength(), style, false);
                sd.setParagraphAttributes(0, sd.getLength(), this.noindentStyle, false);
            }
            catch (BadLocationException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            this.actionsPane.setVisible(false);
        }

        private void renderRevision(JList list, SearchHistoryPanel.DispRevision dispRevision, int index, boolean isSelected) {
            int width;
            Style style;
            Color backgroundColor;
            Color foregroundColor;
            StyledDocument sd = this.textPane.getStyledDocument();
            this.index = index;
            if (isSelected) {
                foregroundColor = UIManager.getColor("List.selectionForeground");
                backgroundColor = UIManager.getColor("List.selectionBackground");
                style = this.selectedStyle;
            } else {
                foregroundColor = UIManager.getColor("List.foreground");
                backgroundColor = UIManager.getColor("List.background");
                backgroundColor = (index & 1) == 0 ? backgroundColor : SummaryView.darker(backgroundColor);
                style = this.normalStyle;
            }
            this.textPane.setBackground(backgroundColor);
            this.actionsPane.setBackground(backgroundColor);
            this.tagsPanel.setBackground(backgroundColor);
            this.actionsPanel.setBackground(backgroundColor);
            LogInformation.Revision revision = dispRevision.getRevision();
            String commitMessage = revision.getMessage();
            if (commitMessage.endsWith("\n")) {
                commitMessage = commitMessage.substring(0, commitMessage.length() - 1);
            }
            int indentation = dispRevision.getIndentation();
            try {
                int idx;
                sd.remove(0, sd.getLength());
                sd.setCharacterAttributes(0, Integer.MAX_VALUE, style, true);
                if (indentation == 0) {
                    sd.insertString(0, dispRevision.getRevision().getLogInfoHeader().getFile().getName(), style);
                    sd.setCharacterAttributes(0, sd.getLength(), this.filenameStyle, false);
                    sd.insertString(sd.getLength(), FIELDS_SEPARATOR + dispRevision.getName().substring(0, dispRevision.getName().lastIndexOf(47)) + "\n", style);
                }
                StringBuilder headerMessageBuilder = new StringBuilder();
                headerMessageBuilder.append(revision.getNumber());
                headerMessageBuilder.append(FIELDS_SEPARATOR);
                headerMessageBuilder.append(this.defaultFormat.format(revision.getDate()));
                headerMessageBuilder.append(FIELDS_SEPARATOR);
                headerMessageBuilder.append(revision.getAuthor());
                String branch = SummaryView.this.getBranch(dispRevision);
                String headerMessage = headerMessageBuilder.toString();
                sd.insertString(sd.getLength(), headerMessage, style);
                if (branch != null) {
                    sd.insertString(sd.getLength(), FIELDS_SEPARATOR + branch, this.branchStyle);
                }
                if ("dead".equalsIgnoreCase(dispRevision.getRevision().getState())) {
                    sd.insertString(sd.getLength(), FIELDS_SEPARATOR + NbBundle.getMessage(SummaryView.class, (String)"MSG_SummaryView_DeadState"), style);
                }
                sd.insertString(sd.getLength(), "\n", style);
                sd.insertString(sd.getLength(), commitMessage, style);
                if (SummaryView.this.message != null && !isSelected && (idx = revision.getMessage().indexOf(SummaryView.this.message)) != -1) {
                    int len = commitMessage.length();
                    int doclen = sd.getLength();
                    sd.setCharacterAttributes(doclen - len + idx, SummaryView.this.message.length(), this.hiliteStyle, false);
                }
                if (indentation > 0) {
                    sd.setParagraphAttributes(0, sd.getLength(), this.indentStyle, false);
                } else {
                    sd.setParagraphAttributes(0, sd.getLength(), this.noindentStyle, false);
                }
            }
            catch (BadLocationException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            if (commitMessage != null && (width = SummaryView.this.master.getWidth()) > 0) {
                FontMetrics fm = list.getFontMetrics(list.getFont());
                Rectangle2D rect = fm.getStringBounds(commitMessage, this.textPane.getGraphics());
                int nlc = -1;
                int i = 0;
                while (i != -1) {
                    i = commitMessage.indexOf(10, i + 1);
                    ++nlc;
                }
                if (indentation == 0) {
                    ++nlc;
                }
                int lines = (int)(rect.getWidth() / (double)(width - 80) + 1.0);
                int ph = fm.getHeight() * (lines + nlc + 1) + 4;
                this.textPane.setPreferredSize(new Dimension(width - 50, ph));
            }
            this.actionsPane.setVisible(true);
            ArrayList<String> tags = new ArrayList<String>(dispRevision.getBranches());
            tags.addAll(dispRevision.getTags());
            if (tags.size() > 0) {
                this.tagsLabel.setVisible(true);
                String tagInfo = (String)tags.get(0);
                this.tagsLabel.setForeground(isSelected ? foregroundColor : Color.GRAY);
                if (tags.size() > 1) {
                    tagInfo = tagInfo + ",";
                    this.tagsLink.setVisible(true);
                    this.tagsLink.set("...", foregroundColor, backgroundColor);
                } else {
                    this.tagsLink.setVisible(false);
                }
                this.tagsLabel.setText(tagInfo);
            } else {
                this.tagsLabel.setVisible(false);
                this.tagsLink.setVisible(false);
            }
            String prev = Utils.previousRevision(dispRevision.getRevision().getNumber());
            if (prev != null) {
                this.diffToLabel.setVisible(true);
                this.diffLink.setVisible(true);
                this.diffToLabel.setForeground(foregroundColor);
                this.diffLink.set(prev, foregroundColor, backgroundColor);
            } else {
                this.diffToLabel.setVisible(false);
                this.diffLink.setVisible(false);
            }
            Project[] projects = OpenProjects.getDefault().getOpenProjects();
            if (projects.length > 0) {
                this.acopLink.setVisible(true);
                this.acopLink.set(NbBundle.getMessage(SummaryView.class, (String)"CTL_Action_FindCommitInOpenProjects"), foregroundColor, backgroundColor);
            } else {
                this.acopLink.setVisible(false);
            }
            Project prj = SummaryView.this.master.getProject(dispRevision.getRevision().getLogInfoHeader().getFile());
            if (prj != null) {
                String prjName = ProjectUtils.getInformation((Project)prj).getDisplayName();
                this.acpLink.setVisible(true);
                this.acpLink.set("\"" + prjName + "\"", foregroundColor, backgroundColor);
            } else {
                this.acpLink.setVisible(false);
            }
            if (this.acpLink.isVisible() || this.acopLink.isVisible()) {
                this.findCommitInLabel.setVisible(true);
                this.findCommitInLabel.setForeground(foregroundColor);
                if (this.acopLink.isVisible() && this.acopLink.isVisible()) {
                    this.commaLabel.setVisible(true);
                    this.commaLabel.setForeground(foregroundColor);
                } else {
                    this.commaLabel.setVisible(false);
                }
            } else {
                this.commaLabel.setVisible(false);
                this.findCommitInLabel.setVisible(false);
            }
        }

        protected void paintComponent(Graphics g) {
            Rectangle bounds;
            super.paintComponent(g);
            Rectangle apb = this.actionsPane.getBounds();
            Rectangle lkb = this.actionsPanel.getBounds();
            if (this.diffLink.isVisible()) {
                bounds = this.diffLink.getBounds();
                bounds.setBounds(bounds.x + lkb.x, bounds.y + apb.y + lkb.y, bounds.width, bounds.height);
                SummaryView.this.resultsList.putClientProperty("Summary-Diff-" + this.index, bounds);
            }
            if (this.acpLink.isVisible()) {
                bounds = this.acpLink.getBounds();
                bounds.setBounds(bounds.x + lkb.x, bounds.y + apb.y + lkb.y, bounds.width, bounds.height);
                SummaryView.this.resultsList.putClientProperty("Summary-Acp-" + this.index, bounds);
            }
            if (this.acopLink.isVisible()) {
                bounds = this.acopLink.getBounds();
                bounds.setBounds(bounds.x + lkb.x, bounds.y + apb.y + lkb.y, bounds.width, bounds.height);
                SummaryView.this.resultsList.putClientProperty("Summary-Acop-" + this.index, bounds);
            }
            if (this.tagsLink.isVisible()) {
                Rectangle tpb = this.tagsPanel.getBounds();
                Rectangle bounds2 = this.tagsLink.getBounds();
                bounds2.setBounds(bounds2.x + tpb.x, bounds2.y + apb.y + tpb.y, bounds2.width, bounds2.height);
                SummaryView.this.resultsList.putClientProperty("Summary-tagsLink-" + this.index, bounds2);
            }
        }
    }

    private class SummaryListModel
    extends AbstractListModel {
        private SummaryListModel() {
        }

        public int getSize() {
            return SummaryView.this.dispResults.size();
        }

        public Object getElementAt(int index) {
            return SummaryView.this.dispResults.get(index);
        }
    }
}

